/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015-2016, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "paper.h"

extern void
paper_assign(
  struct paper*const                    o_paper)
{

  memset(o_paper, 0, sizeof(*o_paper));

  (*o_paper).m_width= PAPER_DEFAULT_WIDTH;
  (*o_paper).m_height= PAPER_DEFAULT_HEIGHT;
  (*o_paper).m_margin_top= PAPER_DEFAULT_MARGIN;
  (*o_paper).m_margin_bottom= PAPER_DEFAULT_MARGIN;
  (*o_paper).m_margin_left= PAPER_DEFAULT_MARGIN;
  (*o_paper).m_margin_right= PAPER_DEFAULT_MARGIN;

  return;
}

extern void
paper_convert_to_inches(
  struct paper*const                    io_paper)
{

  (*io_paper).m_width/= POINTS_PER_INCH;
  (*io_paper).m_height/= POINTS_PER_INCH;
  (*io_paper).m_margin_top/= POINTS_PER_INCH;
  (*io_paper).m_margin_bottom/= POINTS_PER_INCH;
  (*io_paper).m_margin_left/= POINTS_PER_INCH;
  (*io_paper).m_margin_right/= POINTS_PER_INCH;

  return;
}

extern void
paper_convert_to_points(
  struct paper*const                    io_paper)
{

  (*io_paper).m_width*= POINTS_PER_INCH;
  (*io_paper).m_height*= POINTS_PER_INCH;
  (*io_paper).m_margin_top*= POINTS_PER_INCH;
  (*io_paper).m_margin_bottom*= POINTS_PER_INCH;
  (*io_paper).m_margin_left*= POINTS_PER_INCH;
  (*io_paper).m_margin_right*= POINTS_PER_INCH;

  return;
}

extern void
paper_set_from_page_setup(
  struct paper*const                    o_paper,
  GtkPageSetup const*const              i_page_setup)
{

  memset(o_paper, 0, sizeof(*o_paper));

  (*o_paper).m_width= gtk_page_setup_get_paper_width(
    (GtkPageSetup*)i_page_setup,
    GTK_UNIT_INCH);

  (*o_paper).m_height= gtk_page_setup_get_paper_height(
    (GtkPageSetup*)i_page_setup,
    GTK_UNIT_INCH);

  (*o_paper).m_margin_top= gtk_page_setup_get_top_margin(
    (GtkPageSetup*)i_page_setup,
    GTK_UNIT_INCH);

  (*o_paper).m_margin_bottom= gtk_page_setup_get_bottom_margin(
    (GtkPageSetup*)i_page_setup,
    GTK_UNIT_INCH);

  (*o_paper).m_margin_left= gtk_page_setup_get_left_margin(
    (GtkPageSetup*)i_page_setup,
    GTK_UNIT_INCH);

  (*o_paper).m_margin_right= gtk_page_setup_get_right_margin(
    (GtkPageSetup*)i_page_setup,
    GTK_UNIT_INCH);

  return;
}

extern void
paper_discharge(
  struct paper*const                    io_paper)
{

  memset(io_paper, 0, sizeof(*io_paper));

  return;
}

extern int
paper_read(
  GError**                              o_error,
  struct paper*const                    io_paper,
  struct xml *const                     i_xml)
{
  GError*                               l_error;
  int                                   l_exit;
  GList*                                l_node;
  char const*                           l_value;
  struct xml *                          l_xml;
  int                                   l_found;
  enum element_tag_type                 l_type;
  gdouble                               l_double;

  l_exit= 0;
  l_error= 0;

  l_node= (*i_xml).m_children;

  do
  {

    if (0 == l_node)
    {
      break;
    }

    l_xml= (struct xml*)(*l_node).data;

    item_common_lookup(&l_found, &l_type, (*l_xml).m_tag);
    g_strstrip((*l_xml).m_string->str);
    l_value= (*l_xml).m_string->str;
    l_double= g_ascii_strtod(l_value, 0);
    /* todo: check errno and valid ranges */

    if (l_found)
    {
      switch(l_type)
      {
        case element_tag_width:
          (*io_paper).m_width= l_double;
          break;
        case element_tag_height:
          (*io_paper).m_height= l_double;
          break;
        case element_tag_margin_top:
          (*io_paper).m_margin_top= l_double;
          break;
        case element_tag_margin_bottom:
          (*io_paper).m_margin_bottom= l_double;
          break;
        case element_tag_margin_left:
          (*io_paper).m_margin_left= l_double;
          break;
        case element_tag_margin_right:
          (*io_paper).m_margin_right= l_double;
          break;
        default:
          g_warning("Unknown element ('%s')\n", (*l_xml).m_tag);
          break;
      }
    }
    else
    {
      g_warning("Unknown element ('%s')\n", (*l_xml).m_tag);
    }

    l_node= (*l_node).next;

  }while(1);

  if (l_error)
  {
    g_propagate_error(o_error, l_error);
  }

  return l_exit;
}

extern void
paper_set_from_page_setup_pt(
  struct paper*const                    o_paper,
  GtkPageSetup const*const              i_page_setup)
{

  memset(o_paper, 0, sizeof(*o_paper));

  (*o_paper).m_width= gtk_page_setup_get_paper_width(
    (GtkPageSetup*)i_page_setup,
    GTK_UNIT_POINTS);

  (*o_paper).m_height= gtk_page_setup_get_paper_height(
    (GtkPageSetup*)i_page_setup,
    GTK_UNIT_POINTS);

  (*o_paper).m_margin_top= gtk_page_setup_get_top_margin(
    (GtkPageSetup*)i_page_setup,
    GTK_UNIT_POINTS);

  (*o_paper).m_margin_bottom= gtk_page_setup_get_bottom_margin(
    (GtkPageSetup*)i_page_setup,
    GTK_UNIT_POINTS);

  (*o_paper).m_margin_left= gtk_page_setup_get_left_margin(
    (GtkPageSetup*)i_page_setup,
    GTK_UNIT_POINTS);

  (*o_paper).m_margin_right= gtk_page_setup_get_right_margin(
    (GtkPageSetup*)i_page_setup,
    GTK_UNIT_POINTS);

  return;
}

extern int
paper_write(
  GError**                              o_error,
  FILE*const                            io_fp,
  struct paper const*const              i_paper)
{
  char                                  l_buf[G_ASCII_DTOSTR_BUF_SIZE+1];
  int                                   l_exit;

  l_exit= 0;

  fprintf(io_fp, "\t\t\t<paper>\n");
  fprintf(io_fp, "\t\t\t\t<width>%s</width>\n", g_ascii_dtostr(l_buf, sizeof(l_buf), (*i_paper).m_width));
  fprintf(io_fp, "\t\t\t\t<height>%s</height>\n", g_ascii_dtostr(l_buf, sizeof(l_buf), (*i_paper).m_height));
  fprintf(io_fp, "\t\t\t\t<margin_top>%s</margin_top>\n", g_ascii_dtostr(l_buf, sizeof(l_buf), (*i_paper).m_margin_top));
  fprintf(io_fp, "\t\t\t\t<margin_bottom>%s</margin_bottom>\n", g_ascii_dtostr(l_buf, sizeof(l_buf), (*i_paper).m_margin_bottom));
  fprintf(io_fp, "\t\t\t\t<margin_left>%s</margin_left>\n", g_ascii_dtostr(l_buf, sizeof(l_buf), (*i_paper).m_margin_left));
  fprintf(io_fp, "\t\t\t\t<margin_right>%s</margin_right>\n", g_ascii_dtostr(l_buf, sizeof(l_buf), (*i_paper).m_margin_right));
  fprintf(io_fp, "\t\t\t</paper>\n");

  return l_exit;
}
