/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2015-2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __layout_h__

#include "iwr_page.h"
#include "paper.h"

struct layout_division
{
  char*                                 m_label;
  IwrPage*                              m_page;
};

struct layout_division_cover
{
  struct layout_division                m_header;
  struct layout_division                m_footer;
};

struct layout_division_report
{
  struct layout_division                m_header;
  struct layout_division                m_detail;
  struct layout_division                m_footer;
};

struct layout_division_break
{
  char*                                 m_column;
};

struct layout_division_group
{
  struct layout_division_break          m_break;
  struct layout_division                m_header;
  struct layout_division                m_footer;
};

struct layout
{
  struct paper                          m_paper;
  double                                m_scale;
  GtkScrolledWindow*                    m_window;
  GtkLayout*                            m_layout;
  GtkGrid*                              m_grid;
  struct layout_division_cover          m_cover;
  struct layout_division_report         m_report;
  struct layout_division_break          m_page_break;
  struct layout_division_group*         m_group;
  unsigned                              m_group_slots;
};

extern void
layout_add_default_sections(
  struct layout*const                   io_layout);

extern void
layout_assign(
  struct layout*const                   o_layout);

extern int
layout_break_property(
  struct layout*const                   io_layout);

extern void
layout_delete_coverfooter(
  struct layout*const                   io_layout);

extern void
layout_delete_coverheader(
  struct layout*const                   io_layout);

extern void
layout_delete_reportdetail(
  struct layout*const                   io_layout);

extern void
layout_delete_reportfooter(
  struct layout*const                   io_layout);

extern void
layout_delete_reportheader(
  struct layout*const                   io_layout);

extern void
layout_discharge(
  struct layout*const                   io_layout);

extern void
layout_division_size_allocate_cb(
  GtkWidget*                            i_widget,
  GdkRectangle*                         i_alloc,
  gpointer                              i_user_data);

extern struct item_node*
layout_item_new(
  struct layout*const                   io_layout,
  enum item_type const                  i_type);

extern IwrPage*
layout_get_focused_page(
  struct layout*const                   io_layout);

extern GtkWidget*
layout_gui_new(
  struct layout*const                   io_layout);

extern void
layout_highlight_objects(
  struct layout*const                   io_layout,
  gboolean const                        i_state);

extern void
layout_new_coverfooter(
  struct layout*const                   io_layout);

extern void
layout_new_coverheader(
  struct layout*const                   io_layout);

extern void
layout_new_reportdetail(
  struct layout*const                   io_layout);

extern void
layout_new_reportfooter(
  struct layout*const                   io_layout);

extern void
layout_new_reportheader(
  struct layout*const                   io_layout);

extern int
layout_page_setup_property(
  struct paper*const                    io_paper);

extern void
layout_paper_changed(
  struct layout*const                   io_layout);

extern void
layout_set_horizontal_ruler_line(
  struct layout *const                  io_layout,
  gboolean const                        i_state);

extern void
layout_set_layout_size(
  struct layout*const                   io_layout);

extern void
layout_set_scale(
  struct layout *const                  io_layout,
  double const                          i_scale);

extern void
layout_set_scale_zoom_in(
  struct layout *const                  io_layout);

extern void
layout_set_scale_zoom_out(
  struct layout *const                  io_layout);

extern void
layout_set_vertical_ruler_line(
  struct layout *const                  io_layout,
  gboolean const                        i_state);

extern void
layout_size_allocate(
  struct layout*const                   io_layout,
  GdkRectangle const*const              i_alloc);

extern int
layout_write(
  GError**                              o_error,
  FILE*const                            io_fp,
  struct layout const*const             i_layout);

#define __layout_h__
#endif
