/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2015-2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "layout.h"

static double const                     SCALE_MAX= 2.50;
static double const                     SCALE_MIN= 0.25;
static double const                     SCALE_FACTOR= 0.25;

extern void
layout_division_size_allocate_cb(
  GtkWidget*                            i_widget,
  GdkRectangle*                         i_alloc,
  gpointer                              i_user_data)
{
  layout_set_layout_size((struct layout*)i_user_data);
}

extern void
layout_add_default_sections(
  struct layout*const                   io_layout)
{
  GtkWidget*                            l_widget;
  gint                                  l_row;
  struct paper                          l_paper;
  /*double                                l_paper_height;*/
  IwrPage*                              l_page;

  l_paper= (*io_layout).m_paper;
  l_row= 0;
  /*l_paper_height= l_paper.m_height;*/

/*
  l_widget= gtk_button_new_with_label("Cover.Header");
  gtk_button_set_relief(GTK_BUTTON(l_widget), GTK_RELIEF_NONE);
  gtk_widget_set_sensitive(l_widget, 0);
  l_page= IWR_PAGE(iwr_page_new());
  (*io_layout).m_cover.m_header.m_page= l_page;
  g_strlcpy((*io_layout).m_cover.m_header.m_tag, "Cover.Header", sizeof((*io_layout).m_cover.m_header.m_tag));
  iwr_page_set_section_type(l_page, section_cover_header);
  iwr_page_set_paper(l_page, &l_paper);
  gtk_grid_attach((*io_layout).m_grid, l_widget, 0, l_row++, 1, 1);
  gtk_grid_attach((*io_layout).m_grid, GTK_WIDGET(l_page), 0, l_row++, 1, 1);
*/

  l_widget= gtk_button_new_with_label("Report.Header");
  gtk_button_set_relief(GTK_BUTTON(l_widget), GTK_RELIEF_NONE);
  gtk_widget_set_sensitive(l_widget, 0);
  l_page= IWR_PAGE(iwr_page_new());
  (*io_layout).m_report.m_header.m_page= l_page;
  (*io_layout).m_report.m_header.m_label= g_strdup("Report.Header");
  iwr_page_set_section_type(l_page, section_report_header);
  l_paper.m_height= POINTS_PER_INCH * 1.5;
  iwr_page_set_paper(l_page, &l_paper);
  gtk_grid_attach((*io_layout).m_grid, l_widget, 0, l_row++, 1, 1);
  gtk_grid_attach((*io_layout).m_grid, GTK_WIDGET(l_page), 0, l_row++, 1, 1);
  g_signal_connect(l_page, "size-allocate", G_CALLBACK(layout_division_size_allocate_cb), io_layout);

  l_widget= gtk_button_new_with_label("Report.Detail");
  gtk_button_set_relief(GTK_BUTTON(l_widget), GTK_RELIEF_NONE);
  gtk_widget_set_sensitive(l_widget, 0);
  l_page= IWR_PAGE(iwr_page_new());
  (*io_layout).m_report.m_detail.m_page= l_page;
  (*io_layout).m_report.m_detail.m_label= g_strdup("Report.Detail");
  iwr_page_set_section_type(l_page, section_report_detail);
  l_paper.m_height= POINTS_PER_INCH * 1.5;
  iwr_page_set_paper(l_page, &l_paper);
  gtk_grid_attach((*io_layout).m_grid, l_widget, 0, l_row++, 1, 1);
  gtk_grid_attach((*io_layout).m_grid, GTK_WIDGET(l_page), 0, l_row++, 1, 1);
  g_signal_connect(l_page, "size-allocate", G_CALLBACK(layout_division_size_allocate_cb), io_layout);

  l_widget= gtk_button_new_with_label("Report.Footer");
  gtk_button_set_relief(GTK_BUTTON(l_widget), GTK_RELIEF_NONE);
  gtk_widget_set_sensitive(l_widget, 0);
  l_page= IWR_PAGE(iwr_page_new());
  (*io_layout).m_report.m_footer.m_page= l_page;
  (*io_layout).m_report.m_footer.m_label= g_strdup("Report.Footer");
  iwr_page_set_section_type(l_page, section_report_footer);
  l_paper.m_height= POINTS_PER_INCH * 1.0;
  iwr_page_set_paper(l_page, &l_paper);
  gtk_grid_attach((*io_layout).m_grid, l_widget, 0, l_row++, 1, 1);
  gtk_grid_attach((*io_layout).m_grid, GTK_WIDGET(l_page), 0, l_row++, 1, 1);
  g_signal_connect(l_page, "size-allocate", G_CALLBACK(layout_division_size_allocate_cb), io_layout);

/*
  l_widget= gtk_button_new_with_label("Cover.Footer");
  gtk_button_set_relief(GTK_BUTTON(l_widget), GTK_RELIEF_NONE);
  gtk_widget_set_sensitive(l_widget, 0);
  l_page= IWR_PAGE(iwr_page_new());
  (*io_layout).m_cover.m_footer.m_page= l_page;
  g_strlcpy((*io_layout).m_cover.m_footer.m_tag, "Cover.Footer", sizeof((*io_layout).m_cover.m_footer.m_tag));
  iwr_page_set_section_type(l_page, section_cover_footer);
  l_paper.m_height= l_paper_height;
  iwr_page_set_paper(l_page, &l_paper);
  gtk_grid_attach((*io_layout).m_grid, l_widget, 0, l_row++, 1, 1);
  gtk_grid_attach((*io_layout).m_grid, GTK_WIDGET(l_page), 0, l_row++, 1, 1);
*/

  layout_set_layout_size(io_layout);

  return;
}

extern void
layout_assign(
  struct layout*const                   o_layout)
{

  memset(o_layout, 0, sizeof(*o_layout));
  paper_assign(&(*o_layout).m_paper);
  paper_convert_to_points(&(*o_layout).m_paper);
  (*o_layout).m_scale= 1.0;

  return;
}

extern void
layout_delete_coverfooter(
  struct layout*const                   io_layout)
{
  gint                                  l_row;

  do
  {

    if (0 == (*io_layout).m_cover.m_footer.m_page)
    {
      break;
    }

    l_row= 0;

    if ((*io_layout).m_cover.m_header.m_page)
    {
      l_row++;
      l_row++;
    }

    if ((*io_layout).m_report.m_header.m_page)
    {
      l_row++;
      l_row++;
    }

    if ((*io_layout).m_report.m_detail.m_page)
    {
      l_row++;
      l_row++;
    }

    if ((*io_layout).m_report.m_footer.m_page)
    {
      l_row++;
      l_row++;
    }

    l_row+= 2*(*io_layout).m_group_slots;

    (*io_layout).m_cover.m_footer.m_page= 0;

    gtk_grid_remove_row((*io_layout).m_grid, l_row);
    gtk_grid_remove_row((*io_layout).m_grid, l_row);

    layout_set_layout_size(io_layout);

  }while(0);

  return;
}

extern void
layout_delete_coverheader(
  struct layout*const                   io_layout)
{

  do
  {

    if (0 == (*io_layout).m_cover.m_header.m_page)
    {
      break;
    }

    (*io_layout).m_cover.m_header.m_page= 0;

    gtk_grid_remove_row((*io_layout).m_grid, 0);
    gtk_grid_remove_row((*io_layout).m_grid, 0);

    layout_set_layout_size(io_layout);

  }while(0);

  return;
}

extern void
layout_delete_reportdetail(
  struct layout*const                   io_layout)
{
  gint                                  l_row;

  do
  {

    if (0 == (*io_layout).m_report.m_detail.m_page)
    {
      break;
    }

    l_row= 0;

    if ((*io_layout).m_cover.m_header.m_page)
    {
      l_row++;
      l_row++;
    }

    if ((*io_layout).m_report.m_header.m_page)
    {
      l_row++;
      l_row++;
    }

    l_row+= 2*(*io_layout).m_group_slots;

    (*io_layout).m_report.m_detail.m_page= 0;

    gtk_grid_remove_row((*io_layout).m_grid, l_row);
    gtk_grid_remove_row((*io_layout).m_grid, l_row);

    layout_set_layout_size(io_layout);

  }while(0);

  return;
}

extern void
layout_delete_reportfooter(
  struct layout*const                   io_layout)
{
  gint                                  l_row;

  do
  {

    if (0 == (*io_layout).m_report.m_footer.m_page)
    {
      break;
    }

    l_row= 0;

    if ((*io_layout).m_cover.m_header.m_page)
    {
      l_row++;
      l_row++;
    }

    if ((*io_layout).m_report.m_header.m_page)
    {
      l_row++;
      l_row++;
    }

    l_row+= 2*(*io_layout).m_group_slots;

    if ((*io_layout).m_report.m_detail.m_page)
    {
      l_row++;
      l_row++;
    }

    l_row+= 2*(*io_layout).m_group_slots;

    (*io_layout).m_report.m_footer.m_page= 0;

    gtk_grid_remove_row((*io_layout).m_grid, l_row);
    gtk_grid_remove_row((*io_layout).m_grid, l_row);

    layout_set_layout_size(io_layout);

  }while(0);

  return;
}

extern void
layout_delete_reportheader(
  struct layout*const                   io_layout)
{
  gint                                  l_row;

  do
  {

    if (0 == (*io_layout).m_report.m_header.m_page)
    {
      break;
    }

    l_row= 0;

    if ((*io_layout).m_cover.m_header.m_page)
    {
      l_row++;
      l_row++;
    }

    if ((*io_layout).m_cover.m_footer.m_page)
    {
      l_row++;
      l_row++;
    }

    (*io_layout).m_report.m_header.m_page= 0;

    gtk_grid_remove_row((*io_layout).m_grid, l_row);
    gtk_grid_remove_row((*io_layout).m_grid, l_row);

    layout_set_layout_size(io_layout);

  }while(0);

  return;
}

static void
layout_division_break_discharge(
  struct layout_division_break*const    io_break)
{

  g_free((*io_break).m_column);
  memset(io_break, 0, sizeof(*io_break));

  return;
}

static void
layout_division_discharge(
  struct layout_division*const          io_div)
{

  g_free((*io_div).m_label);
  memset(io_div, 0, sizeof(*io_div));

  return;
}


extern void
layout_discharge(
  struct layout*const                   io_layout)
{
  unsigned                              l_slot;

  paper_discharge(&(*io_layout).m_paper);

  layout_division_discharge(&(*io_layout).m_cover.m_header);
  layout_division_discharge(&(*io_layout).m_cover.m_footer);
  layout_division_discharge(&(*io_layout).m_report.m_header);
  layout_division_discharge(&(*io_layout).m_report.m_detail);
  layout_division_discharge(&(*io_layout).m_report.m_footer);
  layout_division_break_discharge(&(*io_layout).m_page_break);

  for (l_slot= 0; (*io_layout).m_group_slots > l_slot; l_slot++)
  {
    layout_division_break_discharge(&(*io_layout).m_group[l_slot].m_break);
    layout_division_discharge(&(*io_layout).m_group[l_slot].m_header);
    layout_division_discharge(&(*io_layout).m_group[l_slot].m_footer);
  }

  gtk_widget_destroy(GTK_WIDGET((*io_layout).m_window));

  memset(io_layout, 0, sizeof(*io_layout));

  return;
}

extern IwrPage*
layout_get_focused_page(
  struct layout*const                   io_layout)
{
  IwrPage*                              l_page;
  gboolean                              l_focus;
  unsigned                              l_slot;

  l_page= 0;

  do
  {

    l_page= (*io_layout).m_cover.m_header.m_page;

    if (l_page)
    {

      l_focus= gtk_widget_has_focus(GTK_WIDGET(l_page));

      if (l_focus)
      {
        break;
      }

    }

    l_page= (*io_layout).m_cover.m_footer.m_page;

    if (l_page)
    {

      l_focus= gtk_widget_has_focus(GTK_WIDGET(l_page));

      if (l_focus)
      {
        break;
      }

    }

    l_page= (*io_layout).m_report.m_header.m_page;

    if (l_page)
    {

      l_focus= gtk_widget_has_focus(GTK_WIDGET(l_page));

      if (l_focus)
      {
        break;
      }

    }

    l_page= (*io_layout).m_report.m_detail.m_page;

    if (l_page)
    {

      l_focus= gtk_widget_has_focus(GTK_WIDGET(l_page));

      if (l_focus)
      {
        break;
      }

    }

    l_page= (*io_layout).m_report.m_footer.m_page;

    if (l_page)
    {

      l_focus= gtk_widget_has_focus(GTK_WIDGET(l_page));

      if (l_focus)
      {
        break;
      }

    }

    l_page= 0;

    for (l_slot= 0; (*io_layout).m_group_slots > l_slot; l_slot++)
    {
      l_focus= gtk_widget_has_focus(
        GTK_WIDGET((*io_layout).m_group[l_slot].m_header.m_page));

      if (l_focus)
      {
        l_page= (*io_layout).m_group[l_slot].m_header.m_page;
        break;
      }

      l_focus= gtk_widget_has_focus(
        GTK_WIDGET((*io_layout).m_group[l_slot].m_footer.m_page));

      if (l_focus)
      {
        l_page= (*io_layout).m_group[l_slot].m_footer.m_page;
        break;
      }
    }

  }while(0);

  return l_page;
}

extern struct item_node*
layout_item_new(
  struct layout*const                   io_layout,
  enum item_type const                  i_type)
{
  struct item_node*                     l_node;
  IwrPage*                              l_page;

  l_node= 0;
  l_page= layout_get_focused_page(io_layout);

  do
  {

    if (l_page)
    {
      break;
    }

    l_page= (*io_layout).m_report.m_detail.m_page;

    if (l_page)
    {
      break;
    }

    l_page= (*io_layout).m_report.m_header.m_page;

    if (l_page)
    {
      break;
    }

    l_page= (*io_layout).m_report.m_footer.m_page;

    if (l_page)
    {
      break;
    }

    l_page= (*io_layout).m_cover.m_header.m_page;

    if (l_page)
    {
      break;
    }

    if ((*io_layout).m_group_slots)
    {
      l_page= (*io_layout).m_group[0].m_header.m_page;
      break;
    }

    l_page= (*io_layout).m_cover.m_footer.m_page;

  }while(0);

  if (l_page)
  {
    gtk_widget_grab_focus(GTK_WIDGET(l_page));
    iwr_page_item_new(&l_node, l_page, i_type);
  }

  return l_node;
}

extern GtkWidget*
layout_gui_new(
  struct layout*const                   io_layout)
{

  (*io_layout).m_grid= GTK_GRID(gtk_grid_new());
  gtk_widget_set_hexpand(GTK_WIDGET((*io_layout).m_grid), 1);
  gtk_widget_set_vexpand(GTK_WIDGET((*io_layout).m_grid), 1);

  (*io_layout).m_window= GTK_SCROLLED_WINDOW(gtk_scrolled_window_new(0, 0));
  gtk_widget_set_hexpand(GTK_WIDGET((*io_layout).m_window), 1);
  gtk_widget_set_vexpand(GTK_WIDGET((*io_layout).m_window), 1);

  (*io_layout).m_layout= GTK_LAYOUT(gtk_layout_new(0, 0));

  gtk_container_add(
    GTK_CONTAINER((*io_layout).m_window),
    GTK_WIDGET((*io_layout).m_layout));

  gtk_container_add(
    GTK_CONTAINER((*io_layout).m_layout), 
    GTK_WIDGET((*io_layout).m_grid));

  return GTK_WIDGET((*io_layout).m_window);
}

extern void
layout_highlight_objects(
  struct layout*const                   io_layout,
  gboolean const                        i_state)
{
  IwrPage*                              l_page;
  unsigned                              l_slot;

  l_page= (*io_layout).m_cover.m_header.m_page;
  if (l_page)
  {
    iwr_page_set_highlight_objects(l_page, i_state);
  }

  l_page= (*io_layout).m_cover.m_footer.m_page;
  if (l_page)
  {
    iwr_page_set_highlight_objects(l_page, i_state);
  }

  l_page= (*io_layout).m_report.m_header.m_page;
  if (l_page)
  {
    iwr_page_set_highlight_objects(l_page, i_state);
  }

  l_page= (*io_layout).m_report.m_detail.m_page;
  if (l_page)
  {
    iwr_page_set_highlight_objects(l_page, i_state);
  }

  l_page= (*io_layout).m_report.m_footer.m_page;
  if (l_page)
  {
    iwr_page_set_highlight_objects(l_page, i_state);
  }

  for (l_slot= 0; (*io_layout).m_group_slots > l_slot; l_slot++)
  {
    l_page= (*io_layout).m_group[l_slot].m_header.m_page;
    iwr_page_set_highlight_objects(l_page, i_state);

    l_page= (*io_layout).m_group[l_slot].m_footer.m_page;
    iwr_page_set_highlight_objects(l_page, i_state);
  }

  return;
}

extern void
layout_new_coverfooter(
  struct layout*const                   io_layout)
{
  IwrPage*                              l_page;
  gint                                  l_row;
  GtkWidget*                            l_widget;

  do
  {

    if ((*io_layout).m_cover.m_footer.m_page)
    {
      break;
    }

    l_row= 0;

    if ((*io_layout).m_cover.m_header.m_page)
    {
      l_row++;
      l_row++;
    }

    if ((*io_layout).m_report.m_header.m_page)
    {
      l_row++;
      l_row++;
    }

    if ((*io_layout).m_report.m_detail.m_page)
    {
      l_row++;
      l_row++;
    }

    if ((*io_layout).m_report.m_footer.m_page)
    {
      l_row++;
      l_row++;
    }

    l_row+= 2*(*io_layout).m_group_slots;

    l_widget= gtk_button_new_with_label("Cover.Footer");
    gtk_button_set_relief(GTK_BUTTON(l_widget), GTK_RELIEF_NONE);
    gtk_widget_set_sensitive(l_widget, 0);
    l_page= IWR_PAGE(iwr_page_new());
    (*io_layout).m_cover.m_footer.m_page= l_page;
    (*io_layout).m_cover.m_footer.m_label= g_strdup("Cover.Footer");
    iwr_page_set_section_type(l_page, section_cover_footer);
    iwr_page_set_paper(l_page, &(*io_layout).m_paper);
    gtk_grid_attach((*io_layout).m_grid, l_widget, 0, l_row++, 1, 1);
    gtk_grid_attach((*io_layout).m_grid, GTK_WIDGET(l_page), 0, l_row++, 1, 1);

    gtk_widget_show(GTK_WIDGET(l_widget));
    gtk_widget_show(GTK_WIDGET(l_page));

    layout_set_layout_size(io_layout);

  }while(0);

  return;
}

extern void
layout_new_coverheader(
  struct layout*const                   io_layout)
{
  IwrPage*                              l_page;
  GtkWidget*                            l_widget;

  do
  {

    if ((*io_layout).m_cover.m_header.m_page)
    {
      break;
    }

    l_widget= gtk_button_new_with_label("Cover.Header");
    gtk_button_set_relief(GTK_BUTTON(l_widget), GTK_RELIEF_NONE);
    gtk_widget_set_sensitive(l_widget, 0);
    l_page= IWR_PAGE(iwr_page_new());
    (*io_layout).m_cover.m_header.m_page= l_page;
    (*io_layout).m_cover.m_header.m_label= g_strdup("Cover.Header");
    iwr_page_set_section_type(l_page, section_cover_header);
    iwr_page_set_paper(l_page, &(*io_layout).m_paper);
    gtk_grid_insert_row((*io_layout).m_grid, 0);
    gtk_grid_attach((*io_layout).m_grid, l_widget, 0, 0, 1, 1);
    gtk_grid_insert_row((*io_layout).m_grid, 1);
    gtk_grid_attach((*io_layout).m_grid, GTK_WIDGET(l_page), 0, 1, 1, 1);

    gtk_widget_show(GTK_WIDGET(l_widget));
    gtk_widget_show(GTK_WIDGET(l_page));

    layout_set_layout_size(io_layout);

  }while(0);

  return;
}

extern void
layout_new_reportdetail(
  struct layout*const                   io_layout)
{
  IwrPage*                              l_page;
  struct paper                          l_paper;
  gint                                  l_row;
  GtkWidget*                            l_widget;

  l_paper= (*io_layout).m_paper;

  do
  {

    if ((*io_layout).m_report.m_detail.m_page)
    {
      break;
    }

    l_row= 0;

    if ((*io_layout).m_cover.m_header.m_page)
    {
      l_row++;
      l_row++;
    }

    if ((*io_layout).m_report.m_header.m_page)
    {
      l_row++;
      l_row++;
    }

    l_widget= gtk_button_new_with_label("Report.Detail");
    gtk_button_set_relief(GTK_BUTTON(l_widget), GTK_RELIEF_NONE);
    gtk_widget_set_sensitive(l_widget, 0);
    l_page= IWR_PAGE(iwr_page_new());
    (*io_layout).m_report.m_detail.m_page= l_page;
    (*io_layout).m_report.m_detail.m_label= g_strdup("Report.Detail");
    iwr_page_set_section_type(l_page, section_report_detail);
    l_paper.m_height= POINTS_PER_INCH * 1.5;
    iwr_page_set_paper(l_page, &l_paper);
    gtk_grid_insert_row((*io_layout).m_grid, l_row);
    gtk_grid_attach((*io_layout).m_grid, l_widget, 0, l_row++, 1, 1);
    gtk_grid_insert_row((*io_layout).m_grid, l_row);
    gtk_grid_attach((*io_layout).m_grid, GTK_WIDGET(l_page), 0, l_row++, 1, 1);

    gtk_widget_show(GTK_WIDGET(l_widget));
    gtk_widget_show(GTK_WIDGET(l_page));

    layout_set_layout_size(io_layout);

  }while(0);

  return;
}

extern void
layout_new_reportfooter(
  struct layout*const                   io_layout)
{
  IwrPage*                              l_page;
  struct paper                          l_paper;
  gint                                  l_row;
  GtkWidget*                            l_widget;

  l_paper= (*io_layout).m_paper;

  do
  {

    if ((*io_layout).m_report.m_footer.m_page)
    {
      break;
    }

    l_row= 0;

    if ((*io_layout).m_cover.m_header.m_page)
    {
      l_row++;
      l_row++;
    }

    if ((*io_layout).m_report.m_header.m_page)
    {
      l_row++;
      l_row++;
    }

    l_row+= 2*(*io_layout).m_group_slots;

    if ((*io_layout).m_report.m_detail.m_page)
    {
      l_row++;
      l_row++;
    }

    l_row+= 2*(*io_layout).m_group_slots;

    l_widget= gtk_button_new_with_label("Report.Footer");
    gtk_button_set_relief(GTK_BUTTON(l_widget), GTK_RELIEF_NONE);
    gtk_widget_set_sensitive(l_widget, 0);
    l_page= IWR_PAGE(iwr_page_new());
    (*io_layout).m_report.m_footer.m_page= l_page;
    (*io_layout).m_report.m_footer.m_label= g_strdup("Report.Footer");
    l_paper.m_height= POINTS_PER_INCH * 1.0;
    iwr_page_set_section_type(l_page, section_report_footer);
    iwr_page_set_paper(l_page, &l_paper);
    gtk_grid_attach((*io_layout).m_grid, l_widget, 0, l_row++, 1, 1);
    gtk_grid_attach((*io_layout).m_grid, GTK_WIDGET(l_page), 0, l_row++, 1, 1);

    gtk_widget_show(GTK_WIDGET(l_widget));
    gtk_widget_show(GTK_WIDGET(l_page));

    layout_set_layout_size(io_layout);

  }while(0);

  return;
}

extern void
layout_new_reportheader(
  struct layout*const                   io_layout)
{
  IwrPage*                              l_page;
  struct paper                          l_paper;
  gint                                  l_row;
  GtkWidget*                            l_widget;

  l_paper= (*io_layout).m_paper;

  do
  {

    if ((*io_layout).m_report.m_header.m_page)
    {
      break;
    }

    l_row= 0;

    if ((*io_layout).m_cover.m_header.m_page)
    {
      l_row++;
      l_row++;
    }

    l_widget= gtk_button_new_with_label("Report.Header");
    gtk_button_set_relief(GTK_BUTTON(l_widget), GTK_RELIEF_NONE);
    gtk_widget_set_sensitive(l_widget, 0);
    l_page= IWR_PAGE(iwr_page_new());
    (*io_layout).m_report.m_header.m_page= l_page;
    (*io_layout).m_report.m_header.m_label= g_strdup("Report.Header");
    iwr_page_set_section_type(l_page, section_report_header);
    l_paper.m_height= POINTS_PER_INCH * 1.5;
    iwr_page_set_paper(l_page, &l_paper);
    gtk_grid_insert_row((*io_layout).m_grid, l_row);
    gtk_grid_attach((*io_layout).m_grid, l_widget, 0, l_row++, 1, 1);
    gtk_grid_insert_row((*io_layout).m_grid, l_row);
    gtk_grid_attach((*io_layout).m_grid, GTK_WIDGET(l_page), 0, l_row++, 1, 1);

    gtk_widget_show(GTK_WIDGET(l_widget));
    gtk_widget_show(GTK_WIDGET(l_page));

    layout_set_layout_size(io_layout);

  }while(0);

  return;
}

extern void
layout_paper_changed(
  struct layout*const                   io_layout)
{
  IwrPage*                              l_page;
  struct paper                          l_paper;
  struct paper                          l_paper2;
  unsigned                              l_slot;

  l_paper= (*io_layout).m_paper;

  l_page= (*io_layout).m_cover.m_header.m_page;
  if (l_page)
  {
    iwr_page_set_paper(l_page, &l_paper);
  }

  l_page= (*io_layout).m_cover.m_footer.m_page;
  if (l_page)
  {
    iwr_page_set_paper(l_page, &l_paper);
  }

  l_page= (*io_layout).m_report.m_header.m_page;
  if (l_page)
  {
    iwr_page_get_paper(&l_paper2, l_page);
    l_paper.m_height= l_paper2.m_height;
    iwr_page_set_paper(l_page, &l_paper);
  }

  l_page= (*io_layout).m_report.m_detail.m_page;
  if (l_page)
  {
    iwr_page_get_paper(&l_paper2, l_page);
    l_paper.m_height= l_paper2.m_height;
    iwr_page_set_paper(l_page, &l_paper);
  }

  l_page= (*io_layout).m_report.m_footer.m_page;
  if (l_page)
  {
    iwr_page_get_paper(&l_paper2, l_page);
    l_paper.m_height= l_paper2.m_height;
    iwr_page_set_paper(l_page, &l_paper);
  }

  for (l_slot= 0; (*io_layout).m_group_slots > l_slot; l_slot++)
  {
    l_page= (*io_layout).m_group[l_slot].m_header.m_page;
    iwr_page_get_paper(&l_paper2, l_page);
    l_paper.m_height= l_paper2.m_height;
    iwr_page_set_paper(l_page, &l_paper);

    l_page= (*io_layout).m_group[l_slot].m_footer.m_page;
    iwr_page_get_paper(&l_paper2, l_page);
    l_paper.m_height= l_paper2.m_height;
    iwr_page_set_paper(l_page, &l_paper);
  }

  layout_set_layout_size(io_layout);

  return;
}

extern void
layout_set_horizontal_ruler_line(
  struct layout *const                  io_layout,
  gboolean const                        i_state)
{
  IwrPage*                              l_page;
  unsigned                              l_slot;

  l_page= (*io_layout).m_cover.m_header.m_page;
  if (l_page)
  {
    iwr_page_set_horizontal_ruler_line(l_page, i_state);
  }

  l_page= (*io_layout).m_cover.m_footer.m_page;
  if (l_page)
  {
    iwr_page_set_horizontal_ruler_line(l_page, i_state);
  }

  l_page= (*io_layout).m_report.m_header.m_page;
  if (l_page)
  {
    iwr_page_set_horizontal_ruler_line(l_page, i_state);
  }

  l_page= (*io_layout).m_report.m_detail.m_page;
  if (l_page)
  {
    iwr_page_set_horizontal_ruler_line(l_page, i_state);
  }

  l_page= (*io_layout).m_report.m_footer.m_page;
  if (l_page)
  {
    iwr_page_set_horizontal_ruler_line(l_page, i_state);
  }

  for (l_slot= 0; (*io_layout).m_group_slots > l_slot; l_slot++)
  {
    l_page= (*io_layout).m_group[l_slot].m_header.m_page;
    iwr_page_set_horizontal_ruler_line(l_page, i_state);

    l_page= (*io_layout).m_group[l_slot].m_footer.m_page;
    iwr_page_set_horizontal_ruler_line(l_page, i_state);
  }

  return;
}

extern void
layout_set_layout_size(
  struct layout*const                   io_layout)
{
  unsigned                              l_count;
  double                                l_height;
  IwrPage*                              l_page;
  struct paper                          l_paper;
  unsigned                              l_slot;
  double                                l_width;

  l_height= 0.0;
  l_count= 0;

  l_page= (*io_layout).m_cover.m_header.m_page;
  if (l_page)
  {
    iwr_page_get_paper(&l_paper, l_page);
    l_height+= l_paper.m_height;
    l_count++;
  }

  l_page= (*io_layout).m_cover.m_footer.m_page;
  if (l_page)
  {
    iwr_page_get_paper(&l_paper, l_page);
    l_height+= l_paper.m_height;
    l_count++;
  }

  l_page= (*io_layout).m_report.m_header.m_page;
  if (l_page)
  {
    iwr_page_get_paper(&l_paper, l_page);
    l_height+= l_paper.m_height;
    l_count++;
  }

  l_page= (*io_layout).m_report.m_detail.m_page;
  if (l_page)
  {
    iwr_page_get_paper(&l_paper, l_page);
    l_height+= l_paper.m_height;
    l_count++;
  }

  l_page= (*io_layout).m_report.m_footer.m_page;
  if (l_page)
  {
    iwr_page_get_paper(&l_paper, l_page);
    l_height+= l_paper.m_height;
    l_count++;
  }

  for (l_slot= 0; (*io_layout).m_group_slots > l_slot; l_slot++)
  {
    l_page= (*io_layout).m_group[l_slot].m_header.m_page;
    iwr_page_get_paper(&l_paper, l_page);
    l_height+= l_paper.m_height;

    l_page= (*io_layout).m_group[l_slot].m_footer.m_page;
    iwr_page_get_paper(&l_paper, l_page);
    l_height+= l_paper.m_height;
    l_count++;
    l_count++;
  }

  l_height*= (*io_layout).m_scale;
  l_height+= 32.0 * l_count;
  l_width= (*io_layout).m_scale * (*io_layout).m_paper.m_width;

  gtk_layout_set_size((*io_layout).m_layout, l_width, l_height);

  return;
}

extern void
layout_set_scale(
  struct layout *const                  io_layout,
  double const                          i_scale)
{
  IwrPage*                              l_page;
  unsigned                              l_slot;

  (*io_layout).m_scale= i_scale;

  l_page= (*io_layout).m_cover.m_header.m_page;
  if (l_page)
  {
    iwr_page_set_scale(l_page, (*io_layout).m_scale);
  }

  l_page= (*io_layout).m_cover.m_footer.m_page;
  if (l_page)
  {
    iwr_page_set_scale(l_page, (*io_layout).m_scale);
  }

  l_page= (*io_layout).m_report.m_header.m_page;
  if (l_page)
  {
    iwr_page_set_scale(l_page, (*io_layout).m_scale);
  }

  l_page= (*io_layout).m_report.m_detail.m_page;
  if (l_page)
  {
    iwr_page_set_scale(l_page, (*io_layout).m_scale);
  }

  l_page= (*io_layout).m_report.m_footer.m_page;
  if (l_page)
  {
    iwr_page_set_scale(l_page, (*io_layout).m_scale);
  }

  for (l_slot= 0; (*io_layout).m_group_slots > l_slot; l_slot++)
  {
    l_page= (*io_layout).m_group[l_slot].m_header.m_page;
    iwr_page_set_scale(l_page, (*io_layout).m_scale);

    l_page= (*io_layout).m_group[l_slot].m_footer.m_page;
    iwr_page_set_scale(l_page, (*io_layout).m_scale);
  }

  layout_set_layout_size(io_layout);

  return;
}

extern void
layout_set_scale_zoom_in(
  struct layout *const                    io_layout)
{
  double                                  l_scale;

  do
  {

    if (SCALE_MIN >= (*io_layout).m_scale)
    {
      break;
    }

    l_scale= ((*io_layout).m_scale - SCALE_FACTOR);

    layout_set_scale(io_layout, l_scale);

  }while(0);

  return;
}

extern void
layout_set_scale_zoom_out(
  struct layout *const                    io_layout)
{
  double                                  l_scale;

  do
  {

    if (SCALE_MAX <= (*io_layout).m_scale)
    {
      break;
    }

    l_scale= ((*io_layout).m_scale + SCALE_FACTOR);

    layout_set_scale(io_layout, l_scale);

  }while(0);

  return;
}

extern void
layout_set_vertical_ruler_line(
  struct layout *const                  io_layout,
  gboolean const                        i_state)
{
  IwrPage*                              l_page;
  unsigned                              l_slot;

  l_page= (*io_layout).m_cover.m_header.m_page;
  if (l_page)
  {
    iwr_page_set_vertical_ruler_line(l_page, i_state);
  }

  l_page= (*io_layout).m_cover.m_footer.m_page;
  if (l_page)
  {
    iwr_page_set_vertical_ruler_line(l_page, i_state);
  }

  l_page= (*io_layout).m_report.m_header.m_page;
  if (l_page)
  {
    iwr_page_set_vertical_ruler_line(l_page, i_state);
  }

  l_page= (*io_layout).m_report.m_detail.m_page;
  if (l_page)
  {
    iwr_page_set_vertical_ruler_line(l_page, i_state);
  }

  l_page= (*io_layout).m_report.m_footer.m_page;
  if (l_page)
  {
    iwr_page_set_vertical_ruler_line(l_page, i_state);
  }

  for (l_slot= 0; (*io_layout).m_group_slots > l_slot; l_slot++)
  {
    l_page= (*io_layout).m_group[l_slot].m_header.m_page;
    iwr_page_set_vertical_ruler_line(l_page, i_state);

    l_page= (*io_layout).m_group[l_slot].m_footer.m_page;
    iwr_page_set_vertical_ruler_line(l_page, i_state);
  }

  return;
}

extern void
layout_size_allocate(
  struct layout*const                   io_layout,
  GdkRectangle const*const              i_alloc)
{
  guint                                 l_len_x;
  guint                                 l_len_y;
  double                                l_page_center;
  double                                l_pos_x;
  double                                l_pos_y;
  double                                l_window_center;

  gtk_layout_get_size((*io_layout).m_layout, &l_len_x, &l_len_y); 

  l_window_center= (*i_alloc).width / 2.0;
  l_page_center= l_len_x / 2.0;
  l_pos_x= (l_window_center - l_page_center);

  if (0 > l_pos_x)
  {
    l_pos_x= 0.0;
  }

  l_window_center= (*i_alloc).height / 2.0;
  l_page_center= l_len_y / 2.0;
  l_pos_y= (l_window_center - l_page_center);

  if (0 > l_pos_y)
  {
    l_pos_y= 0.0;
  }

  gtk_layout_move(
    (*io_layout).m_layout, 
    GTK_WIDGET((*io_layout).m_grid),
    l_pos_x,
    l_pos_y);

  return;
}

static int
layout_write_division(
  GError**                              o_error,
  FILE*const                            io_fp,
  struct layout_division const*         i_division)
{
  GError*                               l_error;
  int                                   l_exit;
  struct item*                          l_item;
  struct paper                          l_paper;
  char const*                           l_text;
  enum iwr_page_section_type            l_type;

  l_error= 0;
  l_exit= 0;

  do
  {

    if (0 == i_division)
    {
      break;
    }

    if (0 == (*i_division).m_page)
    {
      break;
    }

    iwr_page_get_section_type(&l_type, (*i_division).m_page);

    switch(l_type)
    {
      case section_cover_header:
        l_text= "cover_header";
        break;
      case section_cover_footer:
        l_text= "cover_footer";
        break;
      case section_report_header:
        l_text= "report_header";
        break;
      case section_report_detail:
        l_text= "report_detail";
        break;
      case section_report_footer:
        l_text= "report_footer";
        break;
      case section_group_header:
        l_text= "group_header";
        break;
      case section_group_footer:
        l_text= "group_footer";
        break;
      default:
        /* programming error */
        l_text= "unkown";
        break;
    }

    fprintf(io_fp, "\t\t<section name=\"%s\" type=\"%s\">\n", 
      (*i_division).m_label,
      l_text);

    iwr_page_get_paper(&l_paper, (*i_division).m_page); 
    paper_convert_to_inches(&l_paper);

    fprintf(io_fp, "\t\t\t<paper>\n");
    fprintf(io_fp, "\t\t\t\t<height>%lf</height>\n", l_paper.m_height);
    fprintf(io_fp, "\t\t\t</paper>\n");

    iwr_page_get_item(&l_item, (*i_division).m_page);
    l_exit= item_node_write(&l_error, io_fp, l_item);

    fprintf(io_fp, "\t\t</section>\n");

  }while(0);

  if (l_error)
  {
    g_propagate_error(o_error, l_error);
  }

  return l_exit;
}

static int
layout_write_divisions(
  GError**                              o_error,
  FILE*const                            io_fp,
  struct layout const*const             i_layout)
{
  int                                   l_exit;

  do
  {

    fprintf(io_fp, "\t<division>\n");

    l_exit= layout_write_division(o_error, io_fp, &(*i_layout).m_cover.m_header);

    if (l_exit)
    {
      break;
    }

    l_exit= layout_write_division(o_error, io_fp, &(*i_layout).m_cover.m_footer);

    if (l_exit)
    {
      break;
    }

    l_exit= layout_write_division(o_error, io_fp, &(*i_layout).m_report.m_header);

    if (l_exit)
    {
      break;
    }

    l_exit= layout_write_division(o_error, io_fp, &(*i_layout).m_report.m_detail);

    if (l_exit)
    {
      break;
    }

    l_exit= layout_write_division(o_error, io_fp, &(*i_layout).m_report.m_footer);

    if (l_exit)
    {
      break;
    }

    fprintf(io_fp, "\t</division>\n");

  }while(0);

  return l_exit;
}

static int
layout_write_group(
  GError**                              o_error,
  FILE*const                            io_fp,
  struct layout_division_group const*const i_group)
{
  int                                   l_exit;

  l_exit= 0;

  do
  {

    fprintf(io_fp, "\t\t<group name=\"%s\">\n", (*i_group).m_break.m_column);
    
    l_exit= layout_write_division(o_error, io_fp, &(*i_group).m_header);

    if (l_exit)
    {
      break;
    }

    l_exit= layout_write_division(o_error, io_fp, &(*i_group).m_footer);

    if (l_exit)
    {
      break;
    }

    fprintf(io_fp, "\t\t</group>\n");

  }while(0);

  return l_exit;
}

extern int
layout_write_groups(
  GError**                              o_error,
  FILE*const                            io_fp,
  struct layout const*const             i_layout)
{
  int                                   l_exit;
  struct layout_division_group*         l_group;
  unsigned                              l_slot;

  l_exit= 0;

  do
  {

    fprintf(io_fp, "\t<groups>\n");

    if ((*i_layout).m_page_break.m_column)
    {
      fprintf(io_fp, "\t\t<page_break>%s</page_break>\n",
        (*i_layout).m_page_break.m_column);
    }

    l_group= &(*i_layout).m_group[0];

    for (l_slot= 0; (*i_layout).m_group_slots > l_slot; l_slot++)
    {

      l_exit= layout_write_group(o_error, io_fp, l_group);

      if (l_exit)
      {
        break;
      }

      l_group++;
    }

    fprintf(io_fp, "\t</groups>\n");

  }while(0);

  return l_exit;
}

extern int
layout_write(
  GError**                              o_error,
  FILE*const                            io_fp,
  struct layout const*const             i_layout)
{
  int                                   l_exit;
  struct paper                          l_paper;

  do
  {

    l_paper= (*i_layout).m_paper;
    paper_convert_to_inches(&l_paper);
    l_exit= paper_write(o_error, io_fp, &l_paper);

    if (l_exit)
    {
      break;
    }

    l_exit= layout_write_divisions(o_error, io_fp, i_layout);

    if (l_exit)
    {
      break;
    }

    l_exit= layout_write_groups(o_error, io_fp, i_layout);

  }while(0);

  return l_exit;
}
