/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015-2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "label_paper.h"

extern void
label_paper_assign(
  struct label_paper*const              o_paper)
{

  memset(o_paper, 0, sizeof(*o_paper));
  label_paper_set_defaults(o_paper);

  return;
}

extern void
label_paper_convert_to_inches(
  struct label_paper*const              io_paper)
{

  (*io_paper).m_page_width/= POINTS_PER_INCH;
  (*io_paper).m_page_height/= POINTS_PER_INCH;
  (*io_paper).m_horizontal_pitch/= POINTS_PER_INCH;
  (*io_paper).m_vertical_pitch/=POINTS_PER_INCH;
  (*io_paper).m_label_width/= POINTS_PER_INCH;
  (*io_paper).m_label_height/= POINTS_PER_INCH;

  return;
}

extern void
label_paper_convert_to_points(
  struct label_paper*const              io_paper)
{

  (*io_paper).m_page_width*= POINTS_PER_INCH;
  (*io_paper).m_page_height*= POINTS_PER_INCH;
  (*io_paper).m_horizontal_pitch*= POINTS_PER_INCH;
  (*io_paper).m_vertical_pitch*=POINTS_PER_INCH;
  (*io_paper).m_label_width*= POINTS_PER_INCH;
  (*io_paper).m_label_height*= POINTS_PER_INCH;

  return;
}

extern void
label_paper_discharge(
  struct label_paper*const              io_paper)
{

  memset(io_paper, 0, sizeof(*io_paper));

  return;
}

extern int
label_paper_read(
  GError**                              o_error,
  struct label_paper*const              io_paper,
  struct xml *const                     i_xml)
{
  GError*                               l_error;
  int                                   l_exit;
  GList*                                l_node;
  char const*                           l_value;
  struct xml *                          l_xml;
  int                                   l_found;
  enum element_tag_type                 l_type;

  l_exit= 0;
  l_error= 0;

  l_node= (*i_xml).m_children;

  do
  {

    if (0 == l_node)
    {
      break;
    }

    l_xml= (struct xml*)(*l_node).data;

    item_common_lookup(&l_found, &l_type, (*l_xml).m_tag);
    g_strstrip((*l_xml).m_string->str);
    l_value= (*l_xml).m_string->str;

    if (l_found)
    {
      switch(l_type)
      {
        case element_tag_page_width:
          (*io_paper).m_page_width= xml_convert_double(l_value);
          break;
        case element_tag_page_height:
          (*io_paper).m_page_height= xml_convert_double(l_value);
          break;
        case element_tag_top_margin:
          (*io_paper).m_top_margin= xml_convert_double(l_value);;
          break;
        case element_tag_left_margin:
          (*io_paper).m_left_margin= xml_convert_double(l_value);;
          break;
        case element_tag_horizontal_pitch:
          (*io_paper).m_horizontal_pitch= xml_convert_double(l_value);;
          break;
        case element_tag_vertical_pitch:
          (*io_paper).m_vertical_pitch= xml_convert_double(l_value);;
          break;
        case element_tag_label_width:
          (*io_paper).m_label_width= xml_convert_double(l_value);;
          break;
        case element_tag_label_height:
          (*io_paper).m_label_height= xml_convert_double(l_value);;
          break;
        case element_tag_columns:
          (*io_paper).m_columns= xml_convert_ulong(l_value);;
          break;
        case element_tag_rows:
          (*io_paper).m_rows= xml_convert_ulong(l_value);;
          break;
        default:
          g_warning("Unknown element ('%s')\n", (*l_xml).m_tag);
          break;
      }
    }
    else
    {
      g_warning("Unknown element ('%s')\n", (*l_xml).m_tag);
    }

    l_node= (*l_node).next;

  }while(1);

  if (l_error)
  {
    g_propagate_error(o_error, l_error);
  }

  return l_exit;

}

extern void
label_paper_set_defaults(
  struct label_paper*const              o_paper)
{

  /* _mjo TODO: fixme with actual label dimensions */

  (*o_paper).m_page_width= 3.95;
  (*o_paper).m_page_height= 3.95;
  (*o_paper).m_horizontal_pitch= 3.95;
  (*o_paper).m_vertical_pitch= 3.95;
  (*o_paper).m_label_width= 3.94;
  (*o_paper).m_label_height= 3.94;
  (*o_paper).m_columns= 1;
  (*o_paper).m_rows= 1;

  return;
}

extern int
label_paper_write(
  GError**                              o_error,
  FILE*const                            io_fp,
  struct label_paper const*const        i_paper)
{
  char                                  l_buf[G_ASCII_DTOSTR_BUF_SIZE+1];
  int                                   l_exit;

  l_exit= 0;

  fprintf(io_fp, "\t\t\t<paper>\n");
  fprintf(io_fp, "\t\t\t\t<page_width>%s</page_width>\n", g_ascii_dtostr(l_buf, sizeof(l_buf), (*i_paper).m_page_width));
  fprintf(io_fp, "\t\t\t\t<page_height>%s</page_height>\n", g_ascii_dtostr(l_buf, sizeof(l_buf), (*i_paper).m_page_height));
  fprintf(io_fp, "\t\t\t\t<top_margin>%s</top_margin>\n", g_ascii_dtostr(l_buf, sizeof(l_buf), (*i_paper).m_top_margin));
  fprintf(io_fp, "\t\t\t\t<left_margin>%s</left_margin>\n", g_ascii_dtostr(l_buf, sizeof(l_buf), (*i_paper).m_left_margin));
  fprintf(io_fp, "\t\t\t\t<horizontal_pitch>%s</horizontal_pitch>\n", g_ascii_dtostr(l_buf, sizeof(l_buf), (*i_paper).m_horizontal_pitch));
  fprintf(io_fp, "\t\t\t\t<vertical_pitch>%s</vertical_pitch>\n", g_ascii_dtostr(l_buf, sizeof(l_buf), (*i_paper).m_vertical_pitch));
  fprintf(io_fp, "\t\t\t\t<label_width>%s</label_width>\n", g_ascii_dtostr(l_buf, sizeof(l_buf), (*i_paper).m_label_width));
  fprintf(io_fp, "\t\t\t\t<label_height>%s</label_height>\n", g_ascii_dtostr(l_buf, sizeof(l_buf), (*i_paper).m_label_height));
  fprintf(io_fp, "\t\t\t\t<columns>%ld</columns>\n", (*i_paper).m_columns);
  fprintf(io_fp, "\t\t\t\t<rows>%ld</rows>\n", (*i_paper).m_rows);
  fprintf(io_fp, "\t\t\t</paper>\n");

  return l_exit;
}

