/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015-2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __iwsql_dll_h__

#include <dlfcn.h>
#include "global_common.h"

#include "iwsql.h"
#include "driver_config.h"

struct iwsql_dll
{
  iwsql_handle_t                        m_sql_handle;
  void*                                 m_dll_handle;
  iwsql_connect_t                       m_connect;
  iwsql_delete_t                        m_delete;
  iwsql_exec_t                          m_exec;
  iwsql_new_t                           m_new;
  iwsql_next_t                          m_next;
  iwsql_result_t                        m_result;
};

extern void
iwsql_dll_assign(
  struct iwsql_dll*const                o_driver);

extern int
iwsql_dll_connect(
  GError**                              o_error,
  struct iwsql_dll const*const          i_driver,
  struct iwsql_aspect const*const       i_aspect);

extern void
iwsql_dll_discharge(
  struct iwsql_dll*const                io_driver);

extern int
iwsql_dll_exec(
  GError**                              o_error,
  struct iwsql_dll const*const          i_driver,
  char const*                           i_sql);

extern int
iwsql_dll_load(
  GError**                              o_error,
  struct iwsql_dll*const                o_driver,
  struct driver_module const*const      i_module);

extern void
iwsql_dll_new(
  struct iwsql_dll *const               io_driver);

extern int
iwsql_dll_next(
  GError**                              o_error,
  int*const                             o_eof,
  struct iwsql_dll *const               io_driver);

extern void
iwsql_dll_result(
  struct iwsql_attr const**             o_attr,
  unsigned*const                        o_slots,
  struct iwsql_dll const*const          i_driver);

#define  __iwsql_dll_h__
#endif
