/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015-2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __item_line_h__

#include "item_common.h"
#include "item_method.h"

struct item_line
{
  gdouble                               m_pos_x1;
  gdouble                               m_pos_y1;
  gdouble                               m_pos_x2;
  gdouble                               m_pos_y2;
  enum line_style_type                  m_style;
  gdouble                               m_thickness;
  GdkRGBA                               m_color;
  gint                                  m_double_line;
};

extern void
item_line_assign(
  struct item_line*const                o_line,
  struct item_method*const              o_method);

extern void
item_line_copy(
  struct item_line *const               o_line,
  struct item_line const*const          i_line);

extern void
item_line_discharge(
  struct item_line*const                io_line);

extern void
item_line_get_bbox(
  struct geom_rect*const                o_bbox,
  cairo_t*                              io_cr,
  double const                          i_scale,
  void const*const                      i_object);

extern void
item_line_get_position(
  double*const                          o_pos_x,
  double*const                          o_pos_y,
  struct item_line const*const          i_line);

extern void
item_line_get_rotation(
  double*const                          o_rotation,
  struct item_line const*const          i_line);

extern void
item_line_get_size(
  double*const                          o_len_x,
  double*const                          o_len_y,
  struct item_line const*const          i_line);

extern void
item_line_get_shear(
  double*const                          o_shear_x,
  double*const                          o_shear_y,
  struct item_line const*const          i_line);

extern int
item_line_in_event(
  struct item_line const*const          i_line,
  cairo_t*                              io_cr,
  struct item_in_event const*const      i_ctx);

extern void
item_line_draw(
  struct item_line*const                io_line,
  struct item_draw_context const*const  i_ctx);

extern void
item_line_move(
  struct item_line*const                io_line,
  struct geom_point const*const         i_event);

extern void
item_line_normalize(
  struct item_line*const                io_line);

extern void
item_line_set_position(
  struct item_line*const                io_line,
  double const                          i_pos_x,
  double const                          i_pos_y);

extern void
item_line_set_rotation(
  struct item_line*const                io_line,
  double                                i_rotation);

extern void
item_line_set_size(
  struct item_line*const                io_line,
  double                                i_len_x,
  double                                i_len_y);

extern void
item_line_set_shear(
  struct item_line*const                io_line,
  double const                          i_shear_x,
  double const                          i_shear_y);

extern int
item_line_property(
  struct item_line*const                io_line);

extern int
item_line_read(
  GError**                              o_error,
  struct item_line*const                io_line,
  struct xml *const                     i_element);

extern void
item_line_resize(
  struct item_line*const                io_line,
  struct item_resize_event const*const  i_ctx);

extern void
item_line_rotate(
  struct item_line*const                io_line,
  double const                          i_rotation);
  
extern void
item_line_shear(
  struct item_line*const                io_line,
  double const                          i_delta_x,
  double const                          i_delta_y);

extern int
item_line_write(
  GError**                              o_error,
  FILE*const                            io_fp,
  struct item_line const*const          io_line);

#define __item_line_h__
#endif
