/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015-2016, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "item_fbarcode.h"

extern void
item_fbarcode_assign(
  struct item_fbarcode*const            o_object,
  struct item_method*const              o_method)
{

  memset(o_object, 0, sizeof(*o_object));

  (*o_object).m_box.m_len_x= 30.0;
  (*o_object).m_box.m_len_y= 18.0;
  (*o_object).m_scale= 1.0;

  ITEM_METHOD_ASSIGN(o_method, fbarcode);

  return;
}

extern void
item_fbarcode_copy(
  struct item_fbarcode *const           o_object,
  struct item_fbarcode const*const      i_object)
{

  memcpy(o_object, i_object, sizeof(*o_object));
  (*o_object).m_table.m_query= g_strdup((*i_object).m_table.m_query);
  (*o_object).m_table.m_column= g_strdup((*i_object).m_table.m_column);
  (*o_object).m_value= 0;
  (*o_object).m_value_size= 0;

  return;
}

extern void
item_fbarcode_discharge(
  struct item_fbarcode*const            io_object)
{

  g_free((*io_object).m_table.m_query);
  g_free((*io_object).m_table.m_column);

  if ((*io_object).m_value)
  {
    g_free((*io_object).m_value);
  }

  memset(io_object, 0, sizeof(*io_object));

  return;
}

extern void
item_fbarcode_draw(
  struct item_fbarcode*const            i_object,
  struct item_draw_context const*const  i_ctx)
{
  struct symbology                      l_symbology;

  do
  {

    if (item_draw_design == (*i_ctx).m_option.m_type)
    {
      item_common_box_draw_hightlight((*i_ctx).m_cr, &(*i_object).m_box, 1.0);
      break;
    }

    if (0 == (*i_object).m_value || 0 == (*i_object).m_value_size)
    {
      break;
    }

    memset(&l_symbology, 0, sizeof(l_symbology));
    
    l_symbology.m_barcode= (*i_object).m_barcode;
    l_symbology.m_scale= (*i_object).m_scale;

    symbology_encode(
      (*i_ctx).m_cr,
      &l_symbology,
      (*i_object).m_box.m_pos_x,
      (*i_object).m_box.m_pos_y,
      (unsigned char*)(*i_object).m_value,
      (*i_object).m_value_size);

  }while(0);

  return;
}

extern void
item_fbarcode_get_bbox(
  struct geom_rect*const                o_bbox,
  cairo_t*                              io_cr,
  double const                          i_scale,
  struct item_fbarcode const*const      i_object)
{

  (*o_bbox)= (*i_object).m_box;

  return;
}

extern void
item_fbarcode_get_position(
  double*const                          o_pos_x,
  double*const                          o_pos_y,
  struct item_fbarcode const*const      i_object)
{

  (*o_pos_x)= (*i_object).m_box.m_pos_x;
  (*o_pos_y)= (*i_object).m_box.m_pos_y;

  return;
}

extern void
item_fbarcode_get_rotation(
  double*const                          o_rotation,
  struct item_fbarcode const*const      i_object)
{

  (*o_rotation)= 0.0;

  return;
}

extern void
item_fbarcode_get_size(
  double*const                          o_len_x,
  double*const                          o_len_y,
  struct item_fbarcode const*const      i_object)
{

  (*o_len_x)= (*i_object).m_box.m_len_x;
  (*o_len_y)= (*i_object).m_box.m_len_y;

  return;
}

extern void
item_fbarcode_get_shear(
  double*const                          o_shear_x,
  double*const                          o_shear_y,
  struct item_fbarcode const*const      i_object)
{

  (*o_shear_x)= 0.0;
  (*o_shear_y)= 0.0;

  return;
}

extern int
item_fbarcode_in_event(
  struct item_fbarcode const*const      i_object,
  cairo_t*                              io_cr,
  struct item_in_event const*const      i_ctx)
{
  int                                   l_hit;
  struct item_transform                 l_transform;

  memset(&l_transform, 0, sizeof(l_transform));

  l_hit= item_common_box_in_event(io_cr, &(*i_object).m_box, &l_transform, i_ctx);

  return l_hit;
}

extern void
item_fbarcode_move(
  struct item_fbarcode*const            io_object,
  struct geom_point const*const         i_event)
{

  item_common_box_move(&(*io_object).m_box, i_event);

  return;
}

extern void
item_fbarcode_normalize(
  struct item_fbarcode*const            io_object)
{

  item_common_box_normalize(&(*io_object).m_box);

  return;
}

extern void
item_fbarcode_set_position(
  struct item_fbarcode*const            io_object,
  double const                          i_pos_x,
  double const                          i_pos_y)
{

  (*io_object).m_box.m_pos_x= i_pos_x;
  (*io_object).m_box.m_pos_y= i_pos_y;

  return;
}

extern void
item_fbarcode_set_rotation(
  struct item_fbarcode*const            io_object,
  double                                i_rotation)
{

  return;
}

extern void
item_fbarcode_set_size(
  struct item_fbarcode*const            io_object,
  double                                i_len_x,
  double                                i_len_y)
{

  (*io_object).m_box.m_len_x= i_len_x;
  (*io_object).m_box.m_len_y= i_len_y;

  return;
}

extern void
item_fbarcode_set_shear(
  struct item_fbarcode*const            io_object,
  double                                i_shear_x,
  double                                i_shear_y)
{

  return;
}

extern int
item_fbarcode_read(
  GError**                              o_error,
  struct item_fbarcode*const            io_object,
  struct xml *const                     i_xml)
{
  GError*                               l_error;
  int                                   l_exit;
  int                                   l_found;
  GList*                                l_node;
  enum element_tag_type                 l_type;
  char const*                           l_value;
  struct xml*                           l_xml;

  l_error= 0;
  l_exit= 0;

  l_node= (*i_xml).m_children;

  do
  {

    if (0 == l_node)
    {
      break;
    }

    l_xml= (*l_node).data;

    item_common_lookup(&l_found, &l_type, (*l_xml).m_tag);
    g_strstrip((*l_xml).m_string->str);
    l_value= (*l_xml).m_string->str;

    if (l_found)
    {
      switch(l_type)
      {
        case element_tag_rect:
          item_common_box_read(&l_error, &(*io_object).m_box, l_xml);
          break;
        case element_tag_type:
          (*io_object).m_barcode= xml_convert_ulong(l_value);
          break;
        case element_tag_scale:
          (*io_object).m_scale= xml_convert_double(l_value);
          break;
        case element_tag_table:
          item_common_read_table(&l_error, &(*io_object).m_table, l_xml);
          break;
        default:
          break;
      }
    }

    l_node= (*l_node).next;

  }while(1);

  if (l_error)
  {
    g_propagate_error(o_error, l_error);
  }

  return l_exit;
}

extern void
item_fbarcode_resize(
  struct item_fbarcode*const            io_object,
  struct item_resize_event const*const  i_ctx)
{
  struct item_transform                 l_transform;

  memset(&l_transform, 0, sizeof(l_transform));
  item_common_box_resize(&(*io_object).m_box, i_ctx, &l_transform);

  return;
}

extern void
item_fbarcode_rotate(
  struct item_fbarcode*const            io_object,
  double const                          i_rotation)
{
  return;
}
  
extern void
item_fbarcode_shear(
  struct item_fbarcode*const            io_object,
  double const                          i_delta_x,
  double const                          i_delta_y)
{
  return;
}

extern int
item_fbarcode_write(
  GError**                              o_error,
  FILE*const                            io_fp,
  struct item_fbarcode const*const      i_object)
{
  char                                  l_buf[G_ASCII_DTOSTR_BUF_SIZE+1];
  int                                   l_exit;

  l_exit= 0;
  fprintf(io_fp, "\t\t\t<item name=\"fbarcode\">\n");
  item_common_box_write(o_error, io_fp, &(*i_object).m_box);
  fprintf(io_fp, "\t\t\t\t<type>%d</type>\n", (*i_object).m_barcode);
  fprintf(io_fp, "\t\t\t\t<scale>%s</scale>\n", g_ascii_dtostr(l_buf, sizeof(l_buf), (*i_object).m_scale));
  item_common_write_table(o_error, io_fp, &(*i_object).m_table);
  fprintf(io_fp, "\t\t\t</item>\n");

  return l_exit;
}
