/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015-2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __item_common_base_h__

#include "item_common_attr.h"
#include "geom.h"

enum event_type
{
  event_none=                           GDK_ARROW,
  event_move=                           GDK_FLEUR,
  event_resize_east=                    GDK_RIGHT_SIDE,
  event_resize_north=                   GDK_TOP_SIDE,
  event_resize_north_east=              GDK_TOP_RIGHT_CORNER,
  event_resize_north_west=              GDK_TOP_LEFT_CORNER,
  event_resize_north_south=             GDK_DOUBLE_ARROW,
  event_resize_south=                   GDK_BOTTOM_SIDE,
  event_resize_south_east=              GDK_BOTTOM_RIGHT_CORNER,
  event_resize_south_west=              GDK_BOTTOM_LEFT_CORNER,
  event_resize_west=                    GDK_LEFT_SIDE
};

enum item_draw_type
{
  item_draw_print= 0,
  item_draw_design
};

struct item_draw_options
{
  enum item_draw_type                   m_type;
  int                                   m_highlight;
};

struct item_draw_context
{
  struct item_draw_options              m_option;
  cairo_t*                              m_cr;
  double                                m_scale;
  int                                   m_selected;
};

struct item_resize_event
{
  enum event_type                       m_type;
  double                                m_delta_x;
  double                                m_delta_y;
};

struct item_in_event
{
  struct geom_point                     m_event;
  double                                m_scale;
};

extern void
item_common_cairo_dash_set(
  cairo_t *const                        io_cr,
  enum line_style_type const            i_style);

extern int
item_common_event_inside(
  struct item_in_event const*const      i_ctx,
  double const                          i_pos_x,
  double const                          i_pos_y,
  double const                          i_len_x,
  double const                          i_len_y);

#define __item_common_base_h__
#endif
