
/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include <unicode/calendar.h>
#include <unicode/datefmt.h>
#include <unicode/dcfmtsym.h>
#include <unicode/decimfmt.h>
#include <unicode/fmtable.h>
#include <unicode/locid.h>
#include <unicode/numfmt.h>
#include <unicode/rbnf.h>
#include <unicode/uclean.h>
#include <unicode/unistr.h>
#include <unicode/ustring.h>
#include <unicode/utypes.h>
#include <string>
#include "icu.h"

extern "C" int
icu_monetary_to_locale(
  char**                                o_text,
  char const*                           i_amount,
  char const*                           i_locale)
{
  int                                   l_exit= 0;
  NumberFormat*                         l_format= 0;
  StringPiece*                          l_piece;
  UErrorCode                            l_status = U_ZERO_ERROR;
  UnicodeString                         l_unistr;

  if (i_locale && i_locale[0])
  {
    Locale* l_locale= new Locale(i_locale);
    l_format=  NumberFormat::createCurrencyInstance((*l_locale), l_status);
    delete l_locale;
  }
  else
  {
    l_format= NumberFormat::createCurrencyInstance(l_status);
  }

  l_piece= new StringPiece(i_amount);
  l_unistr.remove();
  (*l_format).setMaximumFractionDigits(2);
  (*l_format).format((*l_piece), l_unistr, 0, l_status);
  delete l_piece;

  std::string l_str;
  l_unistr.toUTF8String(l_str);

  size_t l_size= l_str.length();
  (*o_text)= (char*)malloc(1+l_size);
  memset((*o_text), 0, 1+l_size);
  memcpy((*o_text), l_str.c_str(), l_size);

  delete l_format;

  return l_exit;
}
