/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2016, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "handles.h"
#include "handles.xpm"

GdkPixbuf*                              g_pixbuf_resize_ne_sw[handle_last]= {0,0};
GdkPixbuf*                              g_pixbuf_resize_nw_se[handle_last]= {0,0};
GdkPixbuf*                              g_pixbuf_resize_n_s[handle_last]= {0,0};
GdkPixbuf*                              g_pixbuf_resize_e_w[handle_last]= {0,0};

GdkPixbuf*                              g_pixbuf_rotate_nw[handle_last]= {0,0};
GdkPixbuf*                              g_pixbuf_rotate_ne[handle_last]= {0,0};
GdkPixbuf*                              g_pixbuf_rotate_se[handle_last]= {0,0};
GdkPixbuf*                              g_pixbuf_rotate_sw[handle_last]= {0,0};

GdkPixbuf*                              g_pixbuf_shear_ns[handle_last]= {0,0};
GdkPixbuf*                              g_pixbuf_shear_ew[handle_last]= {0,0};

extern void
handles_delete()
{

  g_object_unref(g_pixbuf_resize_ne_sw[handle_normal]);
  g_object_unref(g_pixbuf_resize_ne_sw[handle_highlight]);
  g_object_unref(g_pixbuf_resize_nw_se[handle_normal]);
  g_object_unref(g_pixbuf_resize_nw_se[handle_highlight]);
  g_object_unref(g_pixbuf_resize_n_s[handle_normal]);
  g_object_unref(g_pixbuf_resize_n_s[handle_highlight]);
  g_object_unref(g_pixbuf_resize_e_w[handle_normal]);
  g_object_unref(g_pixbuf_resize_e_w[handle_highlight]);
  g_object_unref(g_pixbuf_rotate_nw[handle_normal]);
  g_object_unref(g_pixbuf_rotate_nw[handle_highlight]);
  g_object_unref(g_pixbuf_rotate_ne[handle_normal]);
  g_object_unref(g_pixbuf_rotate_ne[handle_highlight]);
  g_object_unref(g_pixbuf_rotate_se[handle_normal]);
  g_object_unref(g_pixbuf_rotate_se[handle_highlight]);
  g_object_unref(g_pixbuf_rotate_sw[handle_normal]);
  g_object_unref(g_pixbuf_rotate_sw[handle_highlight]);
  g_object_unref(g_pixbuf_shear_ns[handle_normal]);
  g_object_unref(g_pixbuf_shear_ns[handle_highlight]);
  g_object_unref(g_pixbuf_shear_ew[handle_normal]);
  g_object_unref(g_pixbuf_shear_ew[handle_highlight]);

  return;
}

extern void
handles_new()
{

  g_pixbuf_resize_nw_se[handle_normal]= 
    gdk_pixbuf_new_from_xpm_data(handle_scale_normal_xpm);

  g_pixbuf_resize_ne_sw[handle_normal]= 
    gdk_pixbuf_rotate_simple(
      g_pixbuf_resize_nw_se[handle_normal],
      GDK_PIXBUF_ROTATE_CLOCKWISE);

  g_pixbuf_resize_e_w[handle_normal]= 
    gdk_pixbuf_new_from_xpm_data(handle_stretch_normal_xpm);

  g_pixbuf_resize_n_s[handle_normal]= 
    gdk_pixbuf_rotate_simple(
      g_pixbuf_resize_e_w[handle_normal], 
      GDK_PIXBUF_ROTATE_CLOCKWISE);

  g_pixbuf_rotate_nw[handle_normal]= 
    gdk_pixbuf_new_from_xpm_data(handle_rotate_normal_xpm);

  g_pixbuf_rotate_ne[handle_normal]= 
    gdk_pixbuf_rotate_simple(
      g_pixbuf_rotate_nw[handle_normal],
      GDK_PIXBUF_ROTATE_CLOCKWISE);

  g_pixbuf_rotate_se[handle_normal]= 
    gdk_pixbuf_rotate_simple(
      g_pixbuf_rotate_ne[handle_normal], 
      GDK_PIXBUF_ROTATE_CLOCKWISE);

  g_pixbuf_rotate_sw[handle_normal]= 
    gdk_pixbuf_rotate_simple(
      g_pixbuf_rotate_se[handle_normal], 
      GDK_PIXBUF_ROTATE_CLOCKWISE);

  g_pixbuf_shear_ns[handle_normal]= 
    gdk_pixbuf_new_from_xpm_data(handle_skew_normal_xpm);

  g_pixbuf_shear_ew[handle_normal]= 
    gdk_pixbuf_rotate_simple(
      g_pixbuf_shear_ns[handle_normal], 
      GDK_PIXBUF_ROTATE_CLOCKWISE);

  g_pixbuf_resize_nw_se[handle_highlight]= 
    gdk_pixbuf_new_from_xpm_data(handle_scale_highlight_xpm);

  g_pixbuf_resize_ne_sw[handle_highlight]= 
    gdk_pixbuf_rotate_simple(
      g_pixbuf_resize_nw_se[handle_highlight],
      GDK_PIXBUF_ROTATE_CLOCKWISE);

  g_pixbuf_resize_e_w[handle_highlight]= 
    gdk_pixbuf_new_from_xpm_data(handle_stretch_highlight_xpm);

  g_pixbuf_resize_n_s[handle_highlight]= 
    gdk_pixbuf_rotate_simple(
      g_pixbuf_resize_e_w[handle_highlight], 
      GDK_PIXBUF_ROTATE_CLOCKWISE);

  g_pixbuf_rotate_nw[handle_highlight]= 
    gdk_pixbuf_new_from_xpm_data(handle_rotate_highlight_xpm);

  g_pixbuf_rotate_ne[handle_highlight]= 
    gdk_pixbuf_rotate_simple(
      g_pixbuf_rotate_nw[handle_highlight], 
      GDK_PIXBUF_ROTATE_CLOCKWISE);

  g_pixbuf_rotate_se[handle_highlight]= 
    gdk_pixbuf_rotate_simple(
      g_pixbuf_rotate_ne[handle_highlight], 
      GDK_PIXBUF_ROTATE_CLOCKWISE);

  g_pixbuf_rotate_sw[handle_highlight]= 
    gdk_pixbuf_rotate_simple(
      g_pixbuf_rotate_se[handle_highlight], 
      GDK_PIXBUF_ROTATE_CLOCKWISE);

  g_pixbuf_shear_ns[handle_highlight]= 
    gdk_pixbuf_new_from_xpm_data(handle_skew_highlight_xpm);

  g_pixbuf_shear_ew[handle_highlight]= 
    gdk_pixbuf_rotate_simple(
      g_pixbuf_shear_ns[handle_highlight], 
      GDK_PIXBUF_ROTATE_CLOCKWISE);

  return;
}
