/*
License to Use

Copyright (c) 1970-2003, Wm. Randolph Franklin

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

1.  Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimers.

2.  Redistributions in binary form must reproduce the above copyright
    notice in the documentation and/or other materials provided with
    the distribution.  

The name of W. Randolph Franklin may not be used to endorse or promote
products derived from this Software without specific prior written
permission.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

http://www.ecse.rpi.edu/Homepages/wrf/Research/Short_Notes/pnpoly.html

int pnpoly(int nvert, double *vertx, double *verty, double testx, double testy)
{
  int i, j, c = 0;
  for (i = 0, j = nvert-1; i < nvert; j = i++) {
    if ( ((verty[i]>testy) != (verty[j]>testy)) &&
	 (testx < (vertx[j]-vertx[i]) * (testy-verty[i]) / (verty[j]-verty[i]) + vertx[i]) )
       c = !c;
  }
  return c;
}

http://www.faqs.org/faqs/graphics/algorithms-faq/

This article is Copyright 2003 by Joseph O'Rourke.  It may be freely 
redistributed in its entirety provided that this copyright notice is 
not removed.

Subject 2.03: How do I find if a point lies within a polygon?

    The definitive reference is "Point in Polygon Strategies" by
    Eric Haines [Gems IV]  pp. 24-46.  Now also at 
       http://www.erichaines.com/ptinpoly.
    The code in the Sedgewick book Algorithms (2nd Edition, p.354) fails
    under certain circumstances.  See 
       http://condor.informatik.Uni-Oldenburg.DE/~stueker/graphic/index.html
    for a discussion.

    The essence of the ray-crossing method is as follows.
    Think of standing inside a field with a fence representing the polygon. 
    Then walk north. If you have to jump the fence you know you are now 
    outside the poly. If you have to cross again you know you are now 
    inside again; i.e., if you were inside the field to start with, the total 
    number of fence jumps you would make will be odd, whereas if you were 
    ouside the jumps will be even.

    The code below is from Wm. Randolph Franklin <wrf@ecse.rpi.edu>
    (see URL below) with some minor modifications for speed.  It returns 
    1 for strictly interior points, 0 for strictly exterior, and 0 or 1 
    for points on the boundary.  The boundary behavior is complex but 
    determined; in particular, for a partition of a region into polygons, 
    each point is "in" exactly one polygon.  
    (See p.243 of [O'Rourke (C)] for a discussion of boundary behavior.)

    int pnpoly(int npol, float *xp, float *yp, float x, float y)
    {
      int i, j, c = 0;
      for (i = 0, j = npol-1; i < npol; j = i++) {
        if ((((yp[i]<=y) && (y<yp[j])) ||
             ((yp[j]<=y) && (y<yp[i]))) &&
            (x < (xp[j] - xp[i]) * (y - yp[i]) / (yp[j] - yp[i]) + xp[i]))

          c = !c;
      }
      return c;
    }

    The code may be further accelerated, at some loss in clarity, by
    avoiding the central computation when the inequality can be deduced,
    and by replacing the division by a multiplication for those processors
    with slow divides.  For code that distinguishes strictly interior
    points from those on the boundary, see [O'Rourke (C)] pp. 239-245.
    For a method based on winding number, see Dan Sunday,
    "Fast Winding Number Test for Point Inclusion in a Polygon,"
    http://softsurfer.com/algorithms.htm, March 2001.

Point in  Polygon
http://geomalgorithms.com/a03-_inclusion.html

*/
int pnpoly(int npol, double *xp, double *yp, double x, double y)
{
  int i, j, c = 0;
  for (i = 0, j = npol-1; i < npol; j = i++) {
    if ((((yp[i]<=y) && (y<yp[j])) ||
         ((yp[j]<=y) && (y<yp[i]))) &&
        (x < (xp[j] - xp[i]) * (y - yp[i]) / (yp[j] - yp[i]) + xp[i]))

      c = !c;
  }
  return c;
}
