/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015-2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __export_h__

#include "global_common.h"
#include "database_aspect.h"
#include "database_field.h"
#include "export_config.h"
#include "query.h"

struct exports
{
  struct exports_config                 m_config;
  GtkGrid*                              m_grid;
  GtkTreeView*                          m_tree_db;
  GtkTreeView*                          m_tree_attr;
};

extern void
export_assign(
  struct exports*const                  o_export);

extern void
export_discharge(
  struct exports *const                 io_export);

extern GtkWidget*
export_gui_new(
  struct exports *const                 io_export);

extern void
export_load_attr_from_array(
  struct exports *const                 io_export,
  char *const*                          i_fields,
  unsigned const                        i_slots);

extern int
export_page_setup_property(
  struct exports*const                  io_export);

extern void
export_reload(
  struct exports *const                 io_export,
  struct database_aspect *const         io_aspect,
  struct query const*const              i_query);

extern int
export_write(
  GError**                              o_error,
  FILE*const                            io_fp,
  struct exports const*const            i_export);

#define __export_h__
#endif
