/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015-2016, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "driver_config.h"

extern void
driver_config_assign(
  struct driver_config*const              o_config)
{

  memset(o_config, 0, sizeof(*o_config));

  return;
}

extern void
driver_config_discharge(
  struct driver_config*const              io_config)
{

  if ((*io_config).m_module)
  {
    free((*io_config).m_module);
  }

  memset(io_config, 0, sizeof(*io_config));

  return;
}

extern int
driver_config_load(
  GError**                              o_error,
  struct driver_config*const            o_config)
{
  gboolean                              l_bool;
  char const*                           l_configfile;
  GError*                               l_error;
  int                                   l_exit;
  gsize                                 l_group_count;
  gchar**                               l_groups;
  GKeyFile*                             l_key;
  struct driver_module*                 l_module;
  gsize                                 l_slot;
  char*                                 l_value;

  l_configfile= get_driver_config_filename();
  l_error= 0;
  l_exit= 0;
  l_groups= 0;
  l_key= 0;

  do
  {

    l_key= g_key_file_new();

    l_bool= g_key_file_load_from_file(l_key, l_configfile, G_KEY_FILE_NONE, &l_error);

    if (0 == l_bool)
    {
      g_prefix_error(
        &l_error, "Unable to parse drivers: file=('%s');", l_configfile);
      l_exit= -1;
      break;
    }

    l_groups= g_key_file_get_groups(l_key, &l_group_count);      

    if (0 == l_group_count)
    {
      l_error= g_error_new(
        DRIVER_CONFIG,
        DRIVER_CONFIG_EMPTY,
        "Driver config empty: file=('%s')",
        l_configfile);
      l_exit= -1;
      break;
    }

    for(l_slot= 0; l_slot < l_group_count; l_slot++)
    {
#if LONG_MAX == 2147483647L
      l_value= g_key_file_get_value(l_key, l_groups[l_slot], "driver32", 0);
#else
      l_value= g_key_file_get_value(l_key, l_groups[l_slot], "driver64", 0);
#endif
      if (0 == l_value)
      {
        continue;
      }

      (*o_config).m_module= (struct driver_module*)
        realloc(
          (*o_config).m_module, 
          (1+(*o_config).m_count)*sizeof(struct driver_module));

      l_module= &(*o_config).m_module[(*o_config).m_count];
      memset(l_module, 0, sizeof(*l_module));
      (*o_config).m_count++;

      strncpy((*l_module).m_tag, l_groups[l_slot], sizeof((*l_module).m_tag));
      strncpy((*l_module).m_dll, l_value, sizeof((*l_module).m_dll));
    }

    if (0 == (*o_config).m_count)
    {
      l_error= g_error_new(
        GENERAL,
        GENERIC,
        "Invailid driver config: file=('%s')",
        l_configfile);
      l_exit= -1;
      break;
    }

  }while(0);

  if (l_groups)
  {
    g_strfreev(l_groups);
  }

  if (l_key)
  {
    g_key_file_free(l_key);
  }

  if (l_error)
  {
    _error_log(l_error);
    g_propagate_error(o_error, l_error);
    l_exit= -1;
  }

  return l_exit;
}
