/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __cmd_h__

#include "iwr_page.h"

#define CMD_GROWBY                             100

enum cmd_type
{
  cmd_create,
  cmd_delete,
  cmd_move,
  cmd_order,
  cmd_paste,
  cmd_resize,
  cmd_rotate,
  cmd_shear
};

struct cmd_create
{
  int                                   m_is_ref;
};

struct cmd_delete
{
  int                                   m_is_ref;
  unsigned long                         m_slot;
};

struct cmd_move
{
  double                                m_pos_x;
  double                                m_pos_y;
};

struct cmd_order
{
  unsigned                              m_slot;
};

struct cmd_paste
{
  int                                   m_is_ref;
};

struct cmd_resize
{
  double                                m_len_x;
  double                                m_len_y;
};

struct cmd_rotate
{
  double                                m_rotation;
};

struct cmd_shear
{
  double                                m_shear_x;
  double                                m_shear_y;
};

union cmd_object
{
  struct cmd_create                     m_create;
  struct cmd_delete                     m_delete;
  struct cmd_move                       m_move;
  struct cmd_order                      m_order;
  struct cmd_paste                      m_paste;
  struct cmd_resize                     m_resize;
  struct cmd_rotate                     m_rotate;
  struct cmd_shear                      m_shear;
};

struct cmd_item
{
  union cmd_object                      m_object;
  struct item_node*                     m_node;
};

struct cmd_group
{
  enum cmd_type                         m_type;
  IwrPage*                              m_page;
  struct cmd_item*                      m_item;
  unsigned                              m_slots;
};

struct cmd_stack
{
  struct cmd_group*                     m_group;
  unsigned                              m_slots_allocated;
  unsigned                              m_slots_used;
};

struct cmd
{
  struct cmd_stack                      m_undo;
  struct cmd_stack                      m_redo;
};

extern void
cmd_assign(
  struct cmd*const                      o_cmd);

extern void
cmd_clear(
  struct cmd*const                      io_cmd);

extern void
cmd_discharge(
  struct cmd*const                      io_cmd);

extern char const*
cmd_get_redo_label(
  struct cmd const*const                i_cmd);

extern char const*
cmd_get_undo_label(
  struct cmd const*const                i_cmd);

extern void
cmd_push(
  struct cmd*const                      io_cmd,
  IwrPage*const                         io_page,
  enum cmd_type const                   i_type);

extern void
cmd_undo(
  struct cmd*const                      io_cmd);

extern void
cmd_redo(
  struct cmd*const                      io_cmd);

#define __cmd_h__
#endif
