/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2015, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "barsym.h"

static char const* g_bar_wide_dark= "111";
static char const* g_bar_narrow_dark= "1";
static char const* g_bar_wide_space= "000";
static char const* g_bar_narrow_space= "0";

static char const* g_encode[10]={
/* digit */ /* widths */
/*     0 */  "NNWWN",
/*     1 */  "WNNNW",
/*     2 */  "NWNNW",
/*     3 */  "WWNNN",
/*     4 */  "NNWNW",
/*     5 */  "WNWNN",
/*     6 */  "NWWNN",
/*     7 */  "NNNWW",
/*     8 */  "WNNWN",
/*     9 */  "NWNWN"
};

static void
barsym_interleaved2of5_encode(
  struct barsym*const                   io_barsym,
  char const*                           i_enc1,
  char const*                           i_enc2)

{
  char const*                           l_ptr1;
  char const*                           l_ptr2; 
  char const*                           l_bar_dark;
  char const*                           l_bar_space;

  l_ptr1= i_enc1;
  l_ptr2= i_enc2;

  do
  {

    if (0 == l_ptr1[0])
    {
      break;
    }

    l_bar_dark= ('W' == l_ptr1[0]) ? g_bar_wide_dark : g_bar_narrow_dark;
    l_bar_space= ('W' == l_ptr2[0]) ? g_bar_wide_space : g_bar_narrow_space;

    barsym_write_bar(io_barsym, l_bar_dark, 0);
    barsym_write_bar(io_barsym, l_bar_space, 0);

    l_ptr1++;
    l_ptr2++;

  }while(1);

  return;
}

extern void
barsym_interleaved2of5(
  struct barsym*const                   io_barsym,
  char const*                           i_digits)
{
  unsigned                              l_digit;
  char const*                           l_enc1;
  char const*                           l_enc2;
  char const*                           l_ptr;
  cairo_text_extents_t                  l_extent;
  double                                l_center;

  l_ptr= i_digits;

  (*io_barsym).m_pos_x+= (*io_barsym).m_quiet_zone_left;
  barsym_write_bar(io_barsym, "1010", BARSYM_GUARD);

  do
  {

    if (0 == l_ptr[0])
    {
      break;
    }

    l_digit= l_ptr[0] - 0x30;
    l_enc1= g_encode[l_digit];

    l_digit= l_ptr[1] - 0x30;
    l_enc2= g_encode[l_digit];

    barsym_interleaved2of5_encode(io_barsym, l_enc1, l_enc2);

    l_ptr++;
    l_ptr++;

  }while(1);

  barsym_write_bar(io_barsym, "11101", BARSYM_GUARD);
  (*io_barsym).m_pos_x+= (*io_barsym).m_quiet_zone_right;

  cairo_text_extents((*io_barsym).m_cr, i_digits, &l_extent);
  l_center= ((*io_barsym).m_pos_x / 2.0) - (l_extent.width / 2.0);

  cairo_move_to((*io_barsym).m_cr, l_center, (*io_barsym).m_height);
  cairo_show_text((*io_barsym).m_cr, i_digits);

  return;
}

extern double
barsym_interleaved2of5_get_width(
  struct barsym*const                   io_barsym,
  char const*                           i_digits)
{
  double                                l_width;

  l_width= (*io_barsym).m_quiet_zone_left;
  l_width+= (*io_barsym).m_quiet_zone_right;
  l_width+= ((2+strlen(i_digits)) * (*io_barsym).m_bar_width * 14.0);

  return l_width;
}

extern int
barsym_interleaved2of5_verify(
  char const*                           i_digits)
{
  int                                   l_exit;

  l_exit= barsym_verify_digits(i_digits, strlen(i_digits));

  return l_exit;
}
