/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2015, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "barsym_code93.h"

static char const* g_encode_start_stop= "101011110";

static unsigned char
barsym_code93_get_checksum_k(
  unsigned char const*                  i_buffer,
  unsigned const                        i_length,
  unsigned char                         i_checksum_c)
{
  struct barsym_code39_encode           l_encode;
  unsigned                              l_left;
  unsigned char const*                  l_ptr;
  unsigned                              l_slot;
  unsigned                              l_sum;
  unsigned                              l_weight;

  memset(&l_encode, 0, sizeof(l_encode));
  l_left= i_length;
  l_ptr= &i_buffer[i_length - 1];
  l_sum= i_checksum_c;
  l_weight= 2;

  do
  {

    if (0 == l_left)
    {
      break;
    }

    barsym_code93_encode(&l_encode, *l_ptr); 
    l_slot= l_encode.m_count;

    do
    {

      if (0 == l_slot)
      {
        break;
      }

      l_slot--;
      l_sum+= l_encode.m_tuple[l_slot].m_value * l_weight;

      if (15 > l_weight)
      {
        l_weight++;
      }
      else
      {
        l_weight= 1;
      }

    }while(1);

    l_left--;
    l_ptr--;

  }while(1);

  return (l_sum % 47);
}

static unsigned char
barsym_code93_get_checksum_c(
  unsigned char const*                  i_buffer,
  unsigned const                        i_length)
{
  struct barsym_code39_encode           l_encode;
  unsigned                              l_left;
  unsigned char const*                  l_ptr;
  unsigned                              l_slot;
  unsigned                              l_sum;
  unsigned                              l_weight;

  memset(&l_encode, 0, sizeof(l_encode));
  l_left= i_length;
  l_ptr= &i_buffer[i_length - 1];
  l_sum= 0;
  l_weight= 1;

  do
  {

    if (0 == l_left)
    {
      break;
    }

    barsym_code93_encode(&l_encode, *l_ptr); 
    l_slot= l_encode.m_count;

    do
    {

      if (0 == l_slot)
      {
        break;
      }

      l_slot--;
      l_sum+= l_encode.m_tuple[l_slot].m_value * l_weight;

      if (20 > l_weight)
      {
        l_weight++;
      }
      else
      {
        l_weight= 1;
      }

    }while(1);

    l_left--;
    l_ptr--;

  }while(1);

  return (l_sum % 47);
}

extern void
barsym_code93(
  struct barsym*const                   io_barsym,
  unsigned char const*                  i_buffer,
  unsigned const                        i_length)
{
  double                                l_center;
  struct barsym_code39_encode           l_encode;
  cairo_text_extents_t                  l_extent;
  unsigned char*                        l_filter;
  unsigned                              l_position;
  unsigned char const*                  l_ptr;
  unsigned                              l_slot;
  unsigned char                         l_sum_c; 
  unsigned char                         l_sum_k; 

  memset(&l_encode, 0, sizeof(l_encode));
  l_sum_c= barsym_code93_get_checksum_c(i_buffer, i_length);
  l_sum_k= barsym_code93_get_checksum_k(i_buffer, i_length, l_sum_c);
  l_position= 0;
  l_ptr= i_buffer;

  (*io_barsym).m_pos_x+= (*io_barsym).m_quiet_zone_left;
  barsym_write_bar(io_barsym, g_encode_start_stop, BARSYM_GUARD);

  do
  {

    if (i_length <= l_position)
    {
      break;
    }

    barsym_code93_encode(&l_encode, *l_ptr); 

    for (l_slot= 0; l_encode.m_count > l_slot; l_slot++)
    {
      barsym_write_bar(io_barsym, l_encode.m_tuple[l_slot].m_encode, 0);
    }

    l_ptr++;
    l_position++;

  }while(1);

  barsym_write_bar(io_barsym, g_code93_encode[l_sum_c], 0);
  barsym_write_bar(io_barsym, g_code93_encode[l_sum_k], 0);
  barsym_write_bar(io_barsym, g_encode_start_stop, BARSYM_GUARD);

  l_filter= barsym_filter(i_buffer, i_length);
  cairo_text_extents((*io_barsym).m_cr, (char*)l_filter, &l_extent);
  l_center= ((*io_barsym).m_pos_x / 2.0) - (l_extent.width / 2.0);

  cairo_move_to((*io_barsym).m_cr, l_center, (*io_barsym).m_height);
  cairo_show_text((*io_barsym).m_cr, (char*)l_filter);
  free(l_filter);

  return;
}

extern double
barsym_code93_get_width(
  struct barsym*const                   io_barsym,
  unsigned char const*                  i_buffer,
  unsigned const                        i_length)
{
  double                                l_width;

  l_width= (*io_barsym).m_quiet_zone_left;
  l_width+= (*io_barsym).m_quiet_zone_right;
  l_width+= ((2*i_length) * (*io_barsym).m_bar_width * 10.0);
  l_width+= (i_length * (*io_barsym).m_bar_width);

  return l_width;
}

extern int
barsym_code93_verify(
  unsigned char const*                  i_buffer,
  unsigned const                        i_length)
{
  struct barsym_code39_encode           l_encode;
  int                                   l_exit;
  unsigned char const*                  l_ptr;
  unsigned                              l_slot;

  l_exit= 0;
  l_ptr= i_buffer;
  l_slot= 0;

  do
  {

    if (i_length <= l_slot)
    {
      break;
    }

    l_exit= barsym_code93_encode(&l_encode, *l_ptr);

    if (l_exit)
    {
      break;
    }

    l_ptr++;
    l_slot++;

  }while(1);

  return l_exit;
}
