/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "orcl.hpp"

extern int
iwsql_connect(
  char**                                o_error,
  struct iwsql_aspect const*const       i_aspect,
  struct orcl*const                     io_oracle)
{
  std::string                           l_db;
  int                                   l_exit= 0;
  std::string                           l_pwd;
  std::string                           l_user;
  char const*                           l_emsg;

  (*o_error)= 0;

  try
  {
    l_user= (*i_aspect).m_username;
    l_pwd= (*i_aspect).m_password;
    l_db= (*i_aspect).m_dbname;
    (*io_oracle).m_env= oracle::occi::Environment::createEnvironment();
    (*io_oracle).m_conn= (*io_oracle).m_env->createConnection(
      l_user,
      l_pwd,
      l_db);
  }
  catch(std::exception& exception)
  {
    oracle::occi::Environment::terminateEnvironment((*io_oracle).m_env);
    (*io_oracle).m_env= 0;
    l_emsg= exception.what();
    (*o_error)= (char*)malloc(1+strlen(l_emsg));
    strcpy((*o_error), l_emsg);
    l_exit= -1;
  }

  return l_exit;
}
