/* code49.h - Code 49 Tables */

/*
    libzint - the open source barcode library
    Copyright (C) 2009 Robin Stuart <robin@zint.org.uk>

    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions
    are met:

    1. Redistributions of source code must retain the above copyright 
       notice, this list of conditions and the following disclaimer.  
    2. Redistributions in binary form must reproduce the above copyright
       notice, this list of conditions and the following disclaimer in the
       documentation and/or other materials provided with the distribution.  
    3. Neither the name of the project nor the names of its contributors
       may be used to endorse or promote products derived from this software
       without specific prior written permission. 

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
    ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
    IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
    ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
    FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
    DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
    OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
    HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
    LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
    OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
    SUCH DAMAGE.
*/

/* This data set taken from ANSI/AIM-BC6-2000, 4th April 2000 */

static const char *c49_table7[128] = {
	/* Table 7: Code 49 ASCII Chart */
	"! ", "!A", "!B", "!C", "!D", "!E", "!F", "!G", "!H", "!I", "!J", "!K", "!L",
	"!M", "!N", "!O", "!P", "!Q", "!R", "!S", "!T", "!U", "!V", "!W", "!X", "!Y",
	"!Z", "!1", "!2", "!3", "!4", "!5", " ", "!6", "!7", "!8", "$", "%", "!9", "!0",
	"!-", "!.", "!$", "+", "!/", "-", ".", "/", "0", "1", "2", "3", "4", "5", "6",
	"7", "8", "9", "!+", "&1", "&2", "&3", "&4", "&5", "&6", "A", "B", "C", "D", "E",
	"F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U",
	"V", "W", "X", "Y", "Z", "&7", "&8", "&9", "&0", "&-", "&.", "&A", "&B", "&C",
	"&D", "&E", "&F", "&G", "&H", "&I", "&J", "&K", "&L", "&M", "&N", "&O", "&P",
	"&Q", "&R", "&S", "&T", "&U", "&V", "&W", "&X", "&Y", "&Z", "&$", "&/", "&+",
	"&%", "& "
};

/* Table 5: Check Character Weighting Values */
static const int c49_x_weight[] = {
	1, 9, 31, 26, 2, 12, 17, 23, 37, 18, 22, 6, 27, 44, 15, 43,
	39, 11, 13, 5, 41, 33, 36, 8, 4, 32, 3, 19, 40, 25, 29, 10
};

static const int c49_y_weight[] = {
	9, 31, 26, 2, 12, 17, 23, 37, 18, 22, 6, 27, 44, 15, 43, 39,
	11, 13, 5, 41, 33, 36, 8, 4, 32, 3, 19, 40, 25, 29, 10, 24
};

static const int c49_z_weight[] = {
	31, 26, 2, 12, 17, 23, 37, 18, 22, 6, 27, 44, 15, 43, 39, 11,
	13, 5, 41, 33, 36, 8, 4, 32, 3, 19, 40, 25, 29, 10, 24, 30
};

static const char *c49_table4[8] = {
	/* Table 4: Row Parity Pattern for Code 49 Symbols */
	"OEEO", "EOEO", "OOEE", "EEOO", "OEOE", "EOOE", "OOOO", "EEEE"
};

static const char *c49_appxe_even[2401] = {
	/* Appendix E - Code 49 Encodation Patterns (Even Symbol Character Parity) */
	/* Column 1 */
	"11521132",
	"25112131", "14212132", "25121221", "14221222", "12412132",
	"23321221", "12421222", "21521221", "15112222", "15121312",
	"13312222", "24221311", "13321312", "11512222", "22421311",
	"11521312", "25112311", "14212312", "23312311", "12412312",
	"21512311", "16121131", "14321131", "12521131", "15212131",
	"15221221", "13412131", "13421221", "11612131", "16112221",
	"16121311", "14312221", "14321311", "12512221", "12521311",
	"15212311", "13412311", "11612311", "11131135", "31131133",
	"51131131", "21122134", "41122132", "21131224", "41131222",
	"11113135", "31113133", "51113131", "11122225", "31122223",
	"51122221", "11131315", "31131313", "51131311", "21113224",
	"41113222", "21122314",
	/* Column 2 */
				"41122312", "11113315", "31113313",
	"51113311", "12131134", "32131132", "21231133", "41231131",
	"22122133", "42122131", "11222134", "22131223", "42131221",
	"11231224", "31231222", "12113134", "32113132", "12122224",
	"32122222", "12131314", "32131312", "21231313", "41231311",
	"22113223", "42113221", "11213224", "22122313", "42122311",
	"11222314", "31222312", "12113314", "32113312", "21213313",
	"41213311", "13131133", "33131131", "22231132", "11331133",
	"31331131", "23122132", "12222133", "23131222", "12231223",
	"32231221", "21331222", "13113133", "33113131", "13122223",
	"33122221", "11313133", "13131313", "33131311", "11322223",
	"22231312", "11331313", "31331311", "23113222", "12213223",
	/* Column 3 */
	"23122312", "12222313", "32222311", "21322312", "13113313",
	"33113311", "22213312", "11313313", "31313311", "14131132",
	"23231131", "12331132", "21431131", "24122131", "13222132",
	"24131221", "13231222", "11422132", "22331221", "11431222",
	"14113132", "14122222", "12313132", "14131312", "12322222",
	"23231311", "12331312", "21431311", "24113221", "13213222",
	"24122311", "13222312", "11413222", "22322311", "11422312",
	"14113312", "23213311", "12313312", "21413311", "15131131",
	"13331131", "14222131", "14231221", "12422131", "12431221",
	"15113131", "15122221", "13313131", "15131311", "13322221",
	"11513131", "13331311", "11522221", "14213221", "14222311",
	"12413221", "12422311", "15113311",
	/* Column 4 */
					"13313311", "11513311",
	"11141134", "31141132", "21132133", "41132131", "21141223",
	"41141221", "11123134", "31123132", "11132224", "31132222",
	"11141314", "31141312", "21114133", "41114131", "21123223",
	"41123221", "21132313", "41132311", "11114224", "31114222",
	"11123314", "31123312", "21114313", "41114311", "12141133",
	"32141131", "21241132", "22132132", "11232133", "22141222",
	"11241223", "31241221", "12123133", "32123131", "12132223",
	"32132221", "12141313", "32141311", "21241312", "22114132",
	"11214133", "22123222", "11223223", "22132312", "11232313",
	"31232311", "12114223", "32114221", "12123313", "32123311",
	"21223312", "22114312", "11214313", "31214311", "13141132",
	"22241131",
	/* Column 5 */
		"11341132", "23132131", "12232132", "23141221",
	"12241222", "21341221", "13123132", "13132222", "11323132",
	"13141312", "11332222", "22241311", "11341312", "23114131",
	"12214132", "23123221", "12223222", "23132311", "12232312",
	"21332311", "13114222", "13123312", "11314222", "22223311",
	"11323312", "23114311", "12214312", "21314311", "14141131",
	"12341131", "13232131", "13241221", "11432131", "14123131",
	"14132221", "12323131", "14141311", "12332221", "12341311",
	"13214131", "13223221", "11414131", "13232311", "11423221",
	"11432311", "14114221", "14123311", "12314221", "12323311",
	"13214311", "11414311", "11151133", "31151131", "21142132",
	"21151222", "11133133", "31133131", "11142223",
	/* Column 6 */
							"31142221",
	"11151313", "31151311", "21124132", "21133222", "21142312",
	"11115133", "31115131", "11124223", "31124221", "11133313",
	"31133311", "21115222", "21124312", "12151132", "21251131",
	"22142131", "11242132", "22151221", "11251222", "12133132",
	"12142222", "12151312", "21251311", "22124131", "11224132",
	"22133221", "11233222", "22142311", "11242312", "12115132",
	"12124222", "12133312", "21233311", "22115221", "11215222",
	"22124311", "11224312", "13151131", "12242131", "12251221",
	"13133131", "13142221", "11333131", "13151311", "11342221",
	"12224131", "12233221", "12242311", "13115131", "13124221",
	"11315131", "13133311", "11324221", "11333311", "12215221",
	"12224311", "11161132",
	/* Column 7 */
				"21152131", "21161221", "11143132",
	"11152222", "11161312", "21134131", "21143221", "21152311",
	"11125132", "11134222", "11143312", "21116131", "21125221",
	"21134311", "12161131", "11252131", "12143131", "12152221",
	"12161311", "11234131", "11243221", "11252311", "12125131",
	"12134221", "12143311", "11216131", "11225221", "11234311",
	"11111236", "31111234", "51111232", "21111325", "41111323",
	"61111321", "11111416", "31111414", "51111412", "31211143",
	"51211141", "12111235", "32111233", "52111231", "21211234",
	"41211232", "22111324", "42111322", "11211325", "31211323",
	"51211321", "12111415", "32111413", "52111411", "21211414",
	"41211412", "12211144", "32211142", "21311143", "41311141",
	/* Column 8 */
	"13111234", "33111232", "22211233", "42211231", "11311234",
	"31311232", "23111323", "43111321", "12211324", "32211322",
	"21311323", "41311321", "13111414", "33111412", "22211413",
	"42211411", "11311414", "31311412", "13211143", "33211141",
	"22311142", "11411143", "31411141", "14111233", "34111231",
	"23211232", "12311233", "32311231", "21411232", "24111322",
	"13211323", "33211321", "22311322", "11411323", "31411321",
	"14111413", "34111411", "23211412", "12311413", "32311411",
	"21411412", "14211142", "23311141", "12411142", "21511141",
	"15111232", "24211231", "13311232", "22411231", "11511232",
	"25111321", "14211322", "23311321", "12411322", "21511321",
	"15111412", "24211411", "13311412",
	/* Column 9 */
					"22411411", "11511412",
	"15211141", "13411141", "11611141", "16111231", "14311231",
	"12511231", "15211321", "13411321", "11611321", "16111411",
	"14311411", "12511411", "21121144", "41121142", "11112145",
	"31112143", "51112141", "11121235", "31121233", "51121231",
	"21112234", "41112232", "21121324", "41121322", "11112325",
	"31112323", "51112321", "11121415", "31121413", "51121411",
	"21112414", "41112412", "22121143", "42121141", "11221144",
	"31221142", "12112144", "32112142", "12121234", "32121232",
	"21221233", "41221231", "22112233", "42112231", "11212234",
	"22121323", "42121321", "11221324", "31221322", "12112324",
	"32112322", "12121414", "32121412", "21221413", "41221411",
	"22112413",
	/* Column 10 */
		"42112411", "11212414", "31212412", "23121142",
	"12221143", "32221141", "21321142", "13112143", "33112141",
	"13121233", "33121231", "11312143", "22221232", "11321233",
	"31321231", "23112232", "12212233", "23121322", "12221323",
	"32221321", "21321322", "13112323", "33112321", "13121413",
	"33121411", "11312323", "22221412", "11321413", "31321411",
	"23112412", "12212413", "32212411", "21312412", "24121141",
	"13221142", "22321141", "11421142", "14112142", "14121232",
	"12312142", "23221231", "12321232", "21421231", "24112231",
	"13212232", "24121321", "13221322", "11412232", "22321321",
	"11421322", "14112322", "14121412", "12312322", "23221411",
	"12321412", "21421411", "24112411", "13212412",
	/* Column 11 */
							"22312411",
	"11412412", "14221141", "12421141", "15112141", "15121231",
	"13312141", "13321231", "11512141", "11521231", "14212231",
	"14221321", "12412231", "12421321", "15112321", "15121411",
	"13312321", "13321411", "11512321", "11521411", "14212411",
	"12412411", "21131143", "41131141", "11122144", "31122142",
	"11131234", "31131232", "21113143", "41113141", "21122233",
	"41122231", "21131323", "41131321", "11113234", "31113232",
	"11122324", "31122322", "11131414", "31131412", "21113323",
	"41113321", "21122413", "41122411", "11113414", "31113412",
	"22131142", "11231143", "31231141", "12122143", "32122141",
	"12131233", "32131231", "21231232", "22113142", "11213143",
	"22122232", "11222233",
	/* Column 12 */
				"22131322", "11231323", "31231321",
	"12113233", "32113231", "12122323", "32122321", "12131413",
	"32131411", "21231412", "22113322", "11213323", "22122412",
	"11222413", "31222411", "12113413", "32113411", "21213412",
	"23131141", "12231142", "21331141", "13122142", "13131232",
	"11322142", "22231231", "11331232", "23113141", "12213142",
	"23122231", "12222232", "23131321", "12231322", "21331321",
	"13113232", "13122322", "11313232", "13131412", "11322322",
	"22231411", "11331412", "23113321", "12213322", "23122411",
	"12222412", "21322411", "13113412", "22213411", "11313412",
	"13231141", "11431141", "14122141", "14131231", "12322141",
	"12331231", "13213141", "13222231", "11413141", "13231321",
	/* Column 13 */
	"11422231", "11431321", "14113231", "14122321", "12313231",
	"14131411", "12322321", "12331411", "13213321", "13222411",
	"11413321", "11422411", "14113411", "12313411", "21141142",
	"11132143", "31132141", "11141233", "31141231", "21123142",
	"21132232", "21141322", "11114143", "31114141", "11123233",
	"31123231", "11132323", "31132321", "11141413", "31141411",
	"21114232", "21123322", "21132412", "11114323", "31114321",
	"11123413", "31123411", "22141141", "11241142", "12132142",
	"12141232", "21241231", "22123141", "11223142", "22132231",
	"11232232", "22141321", "11241322", "12114142", "12123232",
	"12132322", "12141412", "21241411", "22114231", "11214232",
	"22123321", "11223322", "22132411",
	/* Column 14 */
					"11232412", "12114322",
	"12123412", "21223411", "12241141", "13132141", "13141231",
	"11332141", "11341231", "12223141", "12232231", "12241321",
	"13114141", "13123231", "11314141", "13132321", "11323231",
	"13141411", "11332321", "11341411", "12214231", "12223321",
	"12232411", "13114321", "13123411", "11314321", "11323411",
	"21151141", "11142142", "11151232", "21133141", "21142231",
	"21151321", "11124142", "11133232", "11142322", "11151412",
	"21115141", "21124231", "21133321", "21142411", "11115232",
	"11124322", "11133412", "11251141", "12142141", "12151231",
	"11233141", "11242231", "11251321", "12124141", "12133231",
	"12142321", "12151411", "11215141", "11224231", "11233321",
	"11242411",
	/* Column 15 */
		"12115231", "12124321", "12133411", "11152141",
	"11161231", "11134141", "11143231", "11152321", "11161411",
	"11116141", "11125231", "11134321", "11143411", "21111244",
	"41111242", "11111335", "31111333", "51111331", "21111424",
	"41111422", "11111515", "31111513", "51111511", "21211153",
	"41211151", "22111243", "42111241", "11211244", "31211242",
	"12111334", "32111332", "21211333", "41211331", "22111423",
	"42111421", "11211424", "31211422", "12111514", "32111512",
	"21211513", "41211511", "22211152", "11311153", "31311151",
	"23111242", "12211243", "32211241", "21311242", "13111333",
	"33111331", "22211332", "11311333", "31311331", "23111422",
	"12211423", "32211421", "21311422", "13111513",
	/* Column 16 */
							"33111511",
	"22211512", "11311513", "31311511", "23211151", "12311152",
	"21411151", "24111241", "13211242", "22311241", "11411242",
	"14111332", "23211331", "12311332", "21411331", "24111421",
	"13211422", "22311421", "11411422", "14111512", "23211511",
	"12311512", "21411511", "13311151", "11511151", "14211241",
	"12411241", "15111331", "13311331", "11511331", "14211421",
	"12411421", "15111511", "13311511", "11511511", "31121152",
	"21112153", "41112151", "21121243", "41121241", "11112244",
	"31112242", "11121334", "31121332", "21112333", "41112331",
	"21121423", "41121421", "11112424", "31112422", "11121514",
	"31121512", "21112513", "41112511", "12121153", "32121151",
	"21221152", "22112152",
	/* Column 17 */
				"11212153", "22121242", "11221243",
	"31221241", "12112243", "32112241", "12121333", "32121331",
	"21221332", "22112332", "11212333", "22121422", "11221423",
	"31221421", "12112423", "32112421", "12121513", "32121511",
	"21221512", "22112512", "11212513", "31212511", "13121152",
	"22221151", "11321152", "23112151", "12212152", "23121241",
	"12221242", "21321241", "13112242", "13121332", "11312242",
	"22221331", "11321332", "23112331", "12212332", "23121421",
	"12221422", "21321421", "13112422", "13121512", "11312422",
	"22221511", "11321512", "23112511", "12212512", "21312511",
	"14121151", "12321151", "13212151", "13221241", "11412151",
	"11421241", "14112241", "14121331", "12312241", "12321331",
	/* Column 18 */
	"13212331", "13221421", "11412331", "11421421", "14112421",
	"14121511", "12312421", "12321511", "13212511", "11412511",
	"11131153", "31131151", "21122152", "21131242", "11113153",
	"31113151", "11122243", "31122241", "11131333", "31131331",
	"21113242", "21122332", "21131422", "11113333", "31113331",
	"11122423", "31122421", "11131513", "31131511", "21113422",
	"21122512", "12131152", "21231151", "22122151", "11222152",
	"22131241", "11231242", "12113152", "12122242", "12131332",
	"21231331", "22113241", "11213242", "22122331", "11222332",
	"22131421", "11231422", "12113332", "12122422", "12131512",
	"21231511", "22113421", "11213422", "22122511", "11222512",
	"13131151", "11331151", "12222151",
	/* Column 19 */
					"12231241", "13113151",
	"13122241", "11313151", "13131331", "11322241", "11331331",
	"12213241", "12222331", "12231421", "13113331", "13122421",
	"11313331", "13131511", "11322421", "11331511", "12213421",
	"12222511", "11141152", "21132151", "21141241", "11123152",
	"11132242", "11141332", "21114151", "21123241", "21132331",
	"21141421", "11114242", "11123332", "11132422", "11141512",
	"21114331", "21123421", "21132511", "12141151", "11232151",
	"11241241", "12123151", "12132241", "12141331", "11214151",
	"11223241", "11232331", "11241421", "12114241", "12123331",
	"12132421", "12141511", "11214331", "11223421", "11232511",
	"11151151", "11133151", "11142241", "11151331", "11115151",
	"11124241",
	/* Column 20 */
		"11133331", "11142421", "11151511", "11111254",
	"31111252", "21111343", "41111341", "11111434", "31111432",
	"21111523", "41111521", "11111614", "31111612", "31211161",
	"12111253", "32111251", "21211252", "22111342", "11211343",
	"31211341", "12111433", "32111431", "21211432", "22111522",
	"11211523", "31211521", "12111613", "32111611", "21211612",
	"12211162", "21311161", "13111252", "22211251", "11311252",
	"23111341", "12211342", "21311341", "13111432", "22211431",
	"11311432", "23111521", "12211522", "21311521", "13111612",
	"22211611", "11311612", "13211161", "11411161", "14111251",
	"12311251", "13211341", "11411341", "14111431", "12311431",
	"13211521", "11411521", "14111611", "12311611",
	/* Column 21 */
							"21121162",
	"11112163", "31112161", "11121253", "31121251", "21112252",
	"21121342", "11112343", "31112341", "11121433", "31121431",
	"21112432", "21121522", "11112523", "31112521", "11121613",
	"31121611", "22121161", "11221162", "12112162", "12121252",
	"21221251", "22112251", "11212252", "22121341", "11221342",
	"12112342", "12121432", "21221431", "22112431", "11212432",
	"22121521", "11221522", "12112522", "12121612", "21221611",
	"12221161", "13112161", "13121251", "11312161", "11321251",
	"32121115", "52121113", "21221116", "41221114", "61221112",
	"22112116", "42112114", "31212115", "51212113", "13121116",
	"33121114", "22221115", "42221113", "11321116", "31321114",
	"51321112", "23112115",
	/* Column 22 */
				"43112113", "12212116", "32212114",
	"52212112", "21312115", "41312113", "61312111", "14121115",
	"34121113", "23221114", "43221112", "12321115", "32321113",
	"52321111", "21421114", "41421112", "24112114", "13212115",
	"33212113", "22312114", "42312112", "11412115", "31412113",
	"51412111", "15121114", "24221113", "13321114", "33321112",
	"22421113", "42421111", "11521114", "31521112", "25112113",
	"14212114", "34212112", "23312113", "43312111", "12412114",
	"32412112", "21512113", "41512111", "16121113", "25221112",
	"14321113", "34321111", "23421112", "12521113", "32521111",
	"15212113", "24312112", "13412113", "33412111", "22512112",
	"11612113", "31612111", "31131115", "51131113", "21122116",
	/* Column 23 */
	"41122114", "61122112", "31113115", "51113113", "12131116",
	"32131114", "52131112", "21231115", "41231113", "61231111",
	"22122115", "42122113", "11222116", "31222114", "51222112",
	"12113116", "32113114", "52113112", "21213115", "41213113",
	"61213111", "13131115", "33131113", "22231114", "42231112",
	"11331115", "31331113", "51331111", "23122114", "43122112",
	"12222115", "32222113", "52222111", "21322114", "41322112",
	"13113115", "33113113", "22213114", "42213112", "11313115",
	"31313113", "51313111", "14131114", "34131112", "23231113",
	"43231111", "12331114", "32331112", "21431113", "41431111",
	"24122113", "13222114", "33222112", "22322113", "42322111",
	"11422114", "31422112", "14113114",
	/* Column 24 */
					"34113112", "23213113",
	"43213111", "12313114", "32313112", "21413113", "41413111",
	"15131113", "24231112", "13331113", "33331111", "22431112",
	"25122112", "14222113", "34222111", "23322112", "12422113",
	"32422111", "21522112", "15113113", "24213112", "13313113",
	"33313111", "22413112", "11513113", "31513111", "16131112",
	"25231111", "14331112", "23431111", "15222112", "24322111",
	"13422112", "22522111", "16113112", "25213111", "14313112",
	"23413111", "12513112", "21613111", "11141116", "31141114",
	"51141112", "21132115", "41132113", "61132111", "11123116",
	"31123114", "51123112", "21114115", "41114113", "61114111",
	"12141115", "32141113", "52141111", "21241114", "41241112",
	"22132114",
	/* Column 25 */
		"42132112", "11232115", "31232113", "51232111",
	"12123115", "32123113", "52123111", "21223114", "41223112",
	"22114114", "42114112", "11214115", "31214113", "51214111",
	"13141114", "33141112", "22241113", "42241111", "11341114",
	"31341112", "23132113", "43132111", "12232114", "32232112",
	"21332113", "41332111", "13123114", "33123112", "22223113",
	"42223111", "11323114", "31323112", "23114113", "43114111",
	"12214114", "32214112", "21314113", "41314111", "14141113",
	"34141111", "23241112", "12341113", "32341111", "24132112",
	"13232113", "33232111", "22332112", "11432113", "31432111",
	"14123113", "34123111", "23223112", "12323113", "32323111",
	"21423112", "24114112", "13214113", "33214111",
	/* Column 26 */
							"22314112",
	"11414113", "31414111", "15141112", "24241111", "13341112",
	"25132111", "14232112", "23332111", "12432112", "15123112",
	"24223111", "13323112", "22423111", "11523112", "25114111",
	"14214112", "23314111", "12414112", "21514111", "16141111",
	"14341111", "15232111", "13432111", "16123111", "14323111",
	"12523111", "15214111", "13414111", "11614111", "11151115",
	"31151113", "51151111", "21142114", "41142112", "11133115",
	"31133113", "51133111", "21124114", "41124112", "11115115",
	"31115113", "51115111", "12151114", "32151112", "21251113",
	"41251111", "22142113", "42142111", "11242114", "31242112",
	"12133114", "32133112", "21233113", "41233111", "22124113",
	"42124111", "11224114",
	/* Column 27 */
				"31224112", "12115114", "32115112",
	"21215113", "41215111", "13151113", "33151111", "22251112",
	"23142112", "12242113", "32242111", "21342112", "13133113",
	"33133111", "22233112", "11333113", "31333111", "23124112",
	"12224113", "32224111", "21324112", "13115113", "33115111",
	"22215112", "11315113", "31315111", "14151112", "23251111",
	"24142111", "13242112", "22342111", "14133112", "23233111",
	"12333112", "21433111", "24124111", "13224112", "22324111",
	"11424112", "14115112", "23215111", "12315112", "21415111",
	"15151111", "14242111", "15133111", "13333111", "14224111",
	"12424111", "15115111", "13315111", "11515111", "11161114",
	"31161112", "21152113", "41152111", "11143114", "31143112",
	/* Column 28 */
	"21134113", "41134111", "11125114", "31125112", "21116113",
	"41116111", "12161113", "32161111", "22152112", "11252113",
	"31252111", "12143113", "32143111", "21243112", "22134112",
	"11234113", "31234111", "12125113", "32125111", "21225112",
	"22116112", "11216113", "31216111", "13161112", "23152111",
	"12252112", "13143112", "22243111", "11343112", "23134111",
	"12234112", "21334111", "13125112", "22225111", "11325112",
	"23116111", "12216112", "21316111", "14161111", "13252111",
	"14143111", "12343111", "13234111", "11434111", "14125111",
	"12325111", "13216111", "11416111", "31111216", "51111214",
	"31211125", "51211123", "32111215", "52111213", "21211216",
	"41211214", "61211212", "12211126",
	/* Column 29 */
					"32211124", "52211122",
	"21311125", "41311123", "61311121", "13111216", "33111214",
	"22211215", "42211213", "11311216", "31311214", "51311212",
	"13211125", "33211123", "22311124", "42311122", "11411125",
	"31411123", "51411121", "14111215", "34111213", "23211214",
	"43211212", "12311215", "32311213", "52311211", "21411214",
	"41411212", "14211124", "34211122", "23311123", "43311121",
	"12411124", "32411122", "21511123", "41511121", "15111214",
	"24211213", "13311214", "33311212", "22411213", "42411211",
	"11511214", "31511212", "15211123", "24311122", "13411123",
	"33411121", "22511122", "11611123", "31611121", "16111213",
	"25211212", "14311213", "34311211", "23411212", "12511213",
	"32511211",
	/* Column 30 */
		"21611212", "21121126", "41121124", "61121122",
	"31112125", "51112123", "31121215", "51121213", "21112216",
	"41112214", "61112212", "22121125", "42121123", "11221126",
	"31221124", "51221122", "12112126", "32112124", "52112122",
	"12121216", "32121214", "52121212", "21221215", "41221213",
	"61221211", "22112215", "42112213", "11212216", "31212214",
	"51212212", "23121124", "43121122", "12221125", "32221123",
	"52221121", "21321124", "41321122", "13112125", "33112123",
	"13121215", "33121213", "11312125", "22221214", "42221212",
	"11321215", "31321213", "51321211", "23112214", "43112212",
	"12212215", "32212213", "52212211", "21312214", "41312212",
	"24121123", "13221124", "33221122", "22321123",
	/* Column 31 */
							"42321121",
	"11421124", "31421122", "14112124", "34112122", "14121214",
	"34121212", "12312124", "23221213", "43221211", "12321214",
	"32321212", "21421213", "41421211", "24112213", "13212214",
	"33212212", "22312213", "42312211", "11412214", "31412212",
	"25121122", "14221123", "34221121", "23321122", "12421123",
	"32421121", "21521122", "15112123", "15121213", "13312123",
	"24221212", "13321213", "33321211", "11512123", "22421212",
	"11521213", "31521211", "25112212", "14212213", "34212211",
	"23312212", "12412213", "32412211", "21512212", "15221122",
	"24321121", "13421122", "22521121", "16112122", "16121212",
	"14312122", "25221211", "14321212", "12512122", "23421211",
	"12521212", "15212212",
	/* Column 32 */
				"24312211", "13412212", "22512211",
	"11612212", "21131125", "41131123", "61131121", "11122126",
	"31122124", "51122122", "11131216", "31131214", "51131212",
	"21113125", "41113123", "61113121", "21122215", "41122213",
	"61122211", "11113216", "31113214", "51113212", "22131124",
	"42131122", "11231125", "31231123", "51231121", "12122125",
	"32122123", "52122121", "12131215", "32131213", "52131211",
	"21231214", "41231212", "22113124", "42113122", "11213125",
	"22122214", "42122212", "11222215", "31222213", "51222211",
	"12113215", "32113213", "52113211", "21213214", "41213212",
	"23131123", "43131121", "12231124", "32231122", "21331123",
	"41331121", "13122124", "33122122", "13131214", "33131212",
	/* Column 33 */
	"11322124", "22231213", "42231211", "11331214", "31331212",
	"23113123", "43113121", "12213124", "23122213", "43122211",
	"12222214", "32222212", "21322213", "41322211", "13113214",
	"33113212", "22213213", "42213211", "11313214", "31313212",
	"24131122", "13231123", "33231121", "22331122", "11431123",
	"31431121", "14122123", "34122121", "14131213", "34131211",
	"12322123", "23231212", "12331213", "32331211", "21431212",
	"24113122", "13213123", "24122212", "13222213", "33222211",
	"11413123", "22322212", "11422213", "31422211", "14113213",
	"34113211", "23213212", "12313213", "32313211", "21413212",
	"25131121", "14231122", "23331121", "12431122", "15122122",
	"15131212", "13322122", "24231211",
	/* Column 34 */
					"13331212", "11522122",
	"22431211", "25113121", "14213122", "25122211", "14222212",
	"12413122", "23322211", "12422212", "21522211", "15113212",
	"24213211", "13313212", "22413211", "11513212", "15231121",
	"13431121", "16122121", "16131211", "14322121", "14331211",
	"12522121", "15213121", "15222211", "13413121", "13422211",
	"11613121", "16113211", "14313211", "12513211", "21141124",
	"41141122", "11132125", "31132123", "51132121", "11141215",
	"31141213", "51141211", "21123124", "41123122", "21132214",
	"41132212", "11114125", "31114123", "51114121", "11123215",
	"31123213", "51123211", "21114214", "41114212", "22141123",
	"42141121", "11241124", "31241122", "12132124", "32132122",
	"12141214",
	/* Column 35 */
		"32141212", "21241213", "41241211", "22123123",
	"42123121", "11223124", "22132213", "42132211", "11232214",
	"31232212", "12114124", "32114122", "12123214", "32123212",
	"21223213", "41223211", "22114213", "42114211", "11214214",
	"31214212", "23141122", "12241123", "32241121", "21341122",
	"13132123", "33132121", "13141213", "33141211", "11332123",
	"22241212", "11341213", "31341211", "23123122", "12223123",
	"23132212", "12232213", "32232211", "21332212", "13114123",
	"33114121", "13123213", "33123211", "11314123", "22223212",
	"11323213", "31323211", "23114212", "12214213", "32214211",
	"21314212", "24141121", "13241122", "22341121", "14132122",
	"14141212", "12332122", "23241211", "12341212",
	/* Column 36 */
							"24123121",
	"13223122", "24132211", "13232212", "11423122", "22332211",
	"11432212", "14114122", "14123212", "12314122", "23223211",
	"12323212", "21423211", "24114211", "13214212", "22314211",
	"11414212", "14241121", "15132121", "15141211", "13332121",
	"13341211", "14223121", "14232211", "12423121", "12432211",
	"15114121", "15123211", "13314121", "13323211", "11514121",
	"11523211", "14214211", "12414211", "21151123", "41151121",
	"11142124", "31142122", "11151214", "31151212", "21133123",
	"41133121", "21142213", "41142211", "11124124", "31124122",
	"11133214", "31133212", "21115123", "41115121", "21124213",
	"41124211", "11115214", "31115212", "22151122", "11251123",
	"31251121", "12142123",
	/* Column 37 */
				"32142121", "12151213", "32151211",
	"21251212", "22133122", "11233123", "22142212", "11242213",
	"31242211", "12124123", "32124121", "12133213", "32133211",
	"21233212", "22115122", "11215123", "22124212", "11224213",
	"31224211", "12115213", "32115211", "21215212", "23151121",
	"12251122", "13142122", "13151212", "11342122", "22251211",
	"23133121", "12233122", "23142211", "12242212", "21342211",
	"13124122", "13133212", "11324122", "22233211", "11333212",
	"23115121", "12215122", "23124211", "12224212", "21324211",
	"13115212", "22215211", "11315212", "13251121", "14142121",
	"14151211", "12342121", "13233121", "13242211", "11433121",
	"14124121", "14133211", "12324121", "12333211", "13215121",
	/* Column 38 */
	"13224211", "11415121", "11424211", "14115211", "12315211",
	"21161122", "11152123", "31152121", "11161213", "31161211",
	"21143122", "21152212", "11134123", "31134121", "11143213",
	"31143211", "21125122", "21134212", "11116123", "31116121",
	"11125213", "31125211", "22161121", "12152122", "12161212",
	"22143121", "11243122", "22152211", "11252212", "12134122",
	"12143212", "21243211", "22125121", "11225122", "22134211",
	"11234212", "12116122", "12125212", "21225211", "13152121",
	"13161211", "12243121", "12252211", "13134121", "13143211",
	"11334121", "11343211", "12225121", "12234211", "13116121",
	"13125211", "11316121", "11325211", "21111226", "41111224",
	"61111222", "31111315", "51111313",
	/* Column 39 */
					"21211135", "41211133",
	"61211131", "22111225", "42111223", "11211226", "31211224",
	"51211222", "12111316", "32111314", "52111312", "21211315",
	"41211313", "61211311", "22211134", "42211132", "11311135",
	"31311133", "51311131", "23111224", "43111222", "12211225",
	"32211223", "52211221", "21311224", "41311222", "13111315",
	"33111313", "22211314", "42211312", "11311315", "31311313",
	"51311311", "23211133", "43211131", "12311134", "32311132",
	"21411133", "41411131", "24111223", "13211224", "33211222",
	"22311223", "42311221", "11411224", "31411222", "14111314",
	"34111312", "23211313", "43211311", "12311314", "32311312",
	"21411313", "41411311", "24211132", "13311133", "33311131",
	"22411132",
	/* Column 40 */
		"11511133", "31511131", "25111222", "14211223",
	"34211221", "23311222", "12411223", "32411221", "21511222",
	"15111313", "24211312", "13311313", "33311311", "22411312",
	"11511313", "31511311", "25211131", "14311132", "23411131",
	"12511132", "21611131", "15211222", "24311221", "13411222",
	"22511221", "11611222", "16111312", "25211311", "14311312",
	"23411311", "12511312", "21611311", "31121134", "51121132",
	"21112135", "41112133", "61112131", "21121225", "41121223",
	"61121221", "11112226", "31112224", "51112222", "11121316",
	"31121314", "51121312", "21112315", "41112313", "61112311",
	"12121135", "32121133", "52121131", "21221134", "41221132",
	"22112134", "42112132", "11212135", "22121224",
	/* Column 41 */
							"42121222",
	"11221225", "31221223", "51221221", "12112225", "32112223",
	"52112221", "12121315", "32121313", "52121311", "21221314",
	"41221312", "22112314", "42112312", "11212315", "31212313",
	"51212311", "13121134", "33121132", "22221133", "42221131",
	"11321134", "31321132", "23112133", "43112131", "12212134",
	"23121223", "43121221", "12221224", "32221222", "21321223",
	"41321221", "13112224", "33112222", "13121314", "33121312",
	"11312224", "22221313", "42221311", "11321314", "31321312",
	/* Column 42 */
	"23112313", "43112311", "12212314", "32212312", "21312313",
	"41312311", "14121133", "34121131", "23221132", "12321133",
	"32321131", "21421132", "24112132", "13212133", "24121222",
	"13221223", "33221221", "11412133", "22321222", "11421223",
	"31421221", "14112223", "34112221", "14121313", "34121311",
	"12312223", "23221312", "12321313", "32321311", "21421312",
	"24112312", "13212313", "33212311", "22312312", "11412313",
	"31412311", "15121132", "24221131", "13321132", "22421131"
};

static const char *c49_appxe_odd[2401] = {
	/* Appendix E - Code 49 Encodation Patterns (Odd Symbol Character Parity) */
	/* Column 1 */
	"22121116",
	"42121114", "31221115", "51221113", "32112115", "52112113",
	"21212116", "41212114", "61212112", "23121115", "43121113",
	"12221116", "32221114", "52221112", "21321115", "41321113",
	"61321111", "13112116", "33112114", "22212115", "42212113",
	"11312116", "31312114", "51312112", "24121114", "13221115",
	"33221113", "22321114", "42321112", "11421115", "31421113",
	"51421111", "14112115", "34112113", "23212114", "43212112",
	"12312115", "32312113", "52312111", "21412114", "41412112",
	"25121113", "14221114", "34221112", "23321113", "43321111",
	"12421114", "32421112", "21521113", "41521111", "15112114",
	"24212113", "13312114", "33312112", "22412113", "42412111",
	"11512114", "31512112",
	/* Column 2 */
				"15221113", "24321112", "13421113",
	"33421111", "22521112", "16112113", "25212112", "14312113",
	"34312111", "23412112", "12512113", "32512111", "21612112",
	"21131116", "41131114", "61131112", "31122115", "51122113",
	"21113116", "41113114", "61113112", "22131115", "42131113",
	"11231116", "31231114", "51231112", "12122116", "32122114",
	"52122112", "21222115", "41222113", "61222111", "22113115",
	"42113113", "11213116", "31213114", "51213112", "23131114",
	"43131112", "12231115", "32231113", "52231111", "21331114",
	"41331112", "13122115", "33122113", "22222114", "42222112",
	"11322115", "31322113", "51322111", "23113114", "43113112",
	"12213115", "32213113", "52213111", "21313114", "41313112",
	/* Column 3 */
	"24131113", "13231114", "33231112", "22331113", "42331111",
	"11431114", "31431112", "14122114", "34122112", "23222113",
	"43222111", "12322114", "32322112", "21422113", "41422111",
	"24113113", "13213114", "33213112", "22313113", "42313111",
	"11413114", "31413112", "25131112", "14231113", "34231111",
	"23331112", "12431113", "32431111", "15122113", "24222112",
	"13322113", "33322111", "22422112", "11522113", "31522111",
	"25113112", "14213113", "34213111", "23313112", "12413113",
	"32413111", "21513112", "15231112", "24331111", "13431112",
	"16122112", "25222111", "14322112", "23422111", "12522112",
	"15213112", "24313111", "13413112", "22513111", "11613112",
	"21141115", "41141113", "61141111",
	/* Column 4 */
					"11132116", "31132114",
	"51132112", "21123115", "41123113", "61123111", "11114116",
	"31114114", "51114112", "22141114", "42141112", "11241115",
	"31241113", "51241111", "12132115", "32132113", "52132111",
	"21232114", "41232112", "22123114", "42123112", "11223115",
	"31223113", "51223111", "12114115", "32114113", "52114111",
	"21214114", "41214112", "23141113", "43141111", "12241114",
	"32241112", "21341113", "41341111", "13132114", "33132112",
	"22232113", "42232111", "11332114", "31332112", "23123113",
	"43123111", "12223114", "32223112", "21323113", "41323111",
	"13114114", "33114112", "22214113", "42214111", "11314114",
	"31314112", "24141112", "13241113", "33241111", "22341112",
	"14132113",
	/* Column 5 */
		"34132111", "23232112", "12332113", "32332111",
	"21432112", "24123112", "13223113", "33223111", "22323112",
	"11423113", "31423111", "14114113", "34114111", "23214112",
	"12314113", "32314111", "21414112", "25141111", "14241112",
	"23341111", "15132112", "24232111", "13332112", "22432111",
	"25123111", "14223112", "23323111", "12423112", "21523111",
	"15114112", "24214111", "13314112", "22414111", "11514112",
	"15241111", "16132111", "14332111", "15223111", "13423111",
	"16114111", "14314111", "12514111", "21151114", "41151112",
	"11142115", "31142113", "51142111", "21133114", "41133112",
	"11124115", "31124113", "51124111", "21115114", "41115112",
	"22151113", "42151111", "11251114", "31251112",
	/* Column 6 */
							"12142114",
	"32142112", "21242113", "41242111", "22133113", "42133111",
	"11233114", "31233112", "12124114", "32124112", "21224113",
	"41224111", "22115113", "42115111", "11215114", "31215112",
	"23151112", "12251113", "32251111", "13142113", "33142111",
	"22242112", "11342113", "31342111", "23133112", "12233113",
	"32233111", "21333112", "13124113", "33124111", "22224112",
	"11324113", "31324111", "23115112", "12215113", "32215111",
	"21315112", "24151111", "13251112", "14142112", "23242111",
	"12342112", "24133111", "13233112", "22333111", "11433112",
	"14124112", "23224111", "12324112", "21424111", "24115111",
	"13215112", "22315111", "11415112", "14251111", "15142111",
	"13342111", "14233111",
	/* Column 7 */
				"12433111", "15124111", "13324111",
	"11524111", "14215111", "12415111", "21161113", "41161111",
	"11152114", "31152112", "21143113", "41143111", "11134114",
	"31134112", "21125113", "41125111", "11116114", "31116112",
	"22161112", "12152113", "32152111", "21252112", "22143112",
	"11243113", "31243111", "12134113", "32134111", "21234112",
	"22125112", "11225113", "31225111", "12116113", "32116111",
	"21216112", "23161111", "13152112", "22252111", "23143111",
	"12243112", "21343111", "13134112", "22234111", "11334112",
	"23125111", "12225112", "21325111", "13116112", "22216111",
	"11316112", "14152111", "13243111", "14134111", "12334111",
	"13225111", "11425111", "14116111", "12316111", "41111215",
	/* Column 8 */
	"61111213", "21211126", "41211124", "61211122", "22111216",
	"42111214", "31211215", "51211213", "22211125", "42211123",
	"11311126", "31311124", "51311122", "23111215", "43111213",
	"12211216", "32211214", "52211212", "21311215", "41311213",
	"61311211", "23211124", "43211122", "12311125", "32311123",
	"52311121", "21411124", "41411122", "24111214", "13211215",
	"33211213", "22311214", "42311212", "11411215", "31411213",
	"51411211", "24211123", "13311124", "33311122", "22411123",
	"42411121", "11511124", "31511122", "25111213", "14211214",
	"34211212", "23311213", "43311211", "12411214", "32411212",
	"21511213", "41511211", "25211122", "14311123", "34311121",
	"23411122", "12511123", "32511121",
	/* Column 9 */
					"21611122", "15211213",
	"24311212", "13411213", "33411211", "22511212", "11611213",
	"31611211", "31121125", "51121123", "21112126", "41112124",
	"61112122", "21121216", "41121214", "61121212", "31112215",
	"51112213", "12121126", "32121124", "52121122", "21221125",
	"41221123", "61221121", "22112125", "42112123", "11212126",
	"22121215", "42121213", "11221216", "31221214", "51221212",
	"12112216", "32112214", "52112212", "21212215", "41212213",
	"61212211", "13121125", "33121123", "22221124", "42221122",
	"11321125", "31321123", "51321121", "23112124", "43112122",
	"12212125", "23121214", "43121212", "12221215", "32221213",
	"52221211", "21321214", "41321212", "13112215", "33112213",
	"22212214",
	/* Column 10 */
		"42212212", "11312215", "31312213", "51312211",
	"14121124", "34121122", "23221123", "43221121", "12321124",
	"32321122", "21421123", "41421121", "24112123", "13212124",
	"24121213", "13221214", "33221212", "11412124", "22321213",
	"42321211", "11421214", "31421212", "14112214", "34112212",
	"23212213", "43212211", "12312214", "32312212", "21412213",
	"41412211", "15121123", "24221122", "13321123", "33321121",
	"22421122", "11521123", "31521121", "25112122", "14212123",
	"25121212", "14221213", "34221211", "12412123", "23321212",
	"12421213", "32421211", "21521212", "15112213", "24212212",
	"13312213", "33312211", "22412212", "11512213", "31512211",
	"16121122", "25221121", "14321122", "23421121",
	/* Column 11 */
							"12521122",
	"15212122", "15221212", "13412122", "24321211", "13421212",
	"11612122", "22521211", "16112212", "25212211", "14312212",
	"23412211", "12512212", "21612211", "11131126", "31131124",
	"51131122", "21122125", "41122123", "61122121", "21131215",
	"41131213", "61131211", "11113126", "31113124", "51113122",
	"11122216", "31122214", "51122212", "21113215", "41113213",
	"61113211", "12131125", "32131123", "52131121", "21231124",
	"41231122", "22122124", "42122122", "11222125", "22131214",
	"42131212", "11231215", "31231213", "51231211", "12113125",
	"32113123", "52113121", "12122215", "32122213", "52122211",
	"21222214", "41222212", "22113214", "42113212", "11213215",
	"31213213", "51213211",
	/* Column 12 */
				"13131124", "33131122", "22231123",
	"42231121", "11331124", "31331122", "23122123", "43122121",
	"12222124", "23131213", "43131211", "12231214", "32231212",
	"21331213", "41331211", "13113124", "33113122", "13122214",
	"33122212", "11313124", "22222213", "42222211", "11322214",
	"31322212", "23113213", "43113211", "12213214", "32213212",
	"21313213", "41313211", "14131123", "34131121", "23231122",
	"12331123", "32331121", "21431122", "24122122", "13222123",
	"24131212", "13231213", "33231211", "11422123", "22331212",
	"11431213", "31431211", "14113123", "34113121", "14122213",
	"34122211", "12313123", "23222212", "12322213", "32322211",
	"21422212", "24113212", "13213213", "33213211", "22313212",
	/* Column 13 */
	"11413213", "31413211", "15131122", "24231121", "13331122",
	"22431121", "25122121", "14222122", "25131211", "14231212",
	"12422122", "23331211", "12431212", "15113122", "15122212",
	"13313122", "24222211", "13322212", "11513122", "22422211",
	"11522212", "25113211", "14213212", "23313211", "12413212",
	"21513211", "16131121", "14331121", "15222121", "15231211",
	"13422121", "13431211", "16113121", "16122211", "14313121",
	"14322211", "12513121", "12522211", "15213211", "13413211",
	"11613211", "11141125", "31141123", "51141121", "21132124",
	"41132122", "21141214", "41141212", "11123125", "31123123",
	"51123121", "11132215", "31132213", "51132211", "21114124",
	"41114122", "21123214", "41123212",
	/* Column 14 */
					"11114215", "31114213",
	"51114211", "12141124", "32141122", "21241123", "41241121",
	"22132123", "42132121", "11232124", "22141213", "42141211",
	"11241214", "31241212", "12123124", "32123122", "12132214",
	"32132212", "21232213", "41232211", "22114123", "42114121",
	"11214124", "22123213", "42123211", "11223214", "31223212",
	"12114214", "32114212", "21214213", "41214211", "13141123",
	"33141121", "22241122", "11341123", "31341121", "23132122",
	"12232123", "23141212", "12241213", "32241211", "21341212",
	"13123123", "33123121", "13132213", "33132211", "11323123",
	"22232212", "11332213", "31332211", "23114122", "12214123",
	"23123212", "12223213", "32223211", "21323212", "13114213",
	"33114211",
	/* Column 15 */
		"22214212", "11314213", "31314211", "14141122",
	"23241121", "12341122", "24132121", "13232122", "24141211",
	"13241212", "11432122", "22341211", "14123122", "14132212",
	"12323122", "23232211", "12332212", "21432211", "24114121",
	"13214122", "24123211", "13223212", "11414122", "22323211",
	"11423212", "14114212", "23214211", "12314212", "21414211",
	"15141121", "13341121", "14232121", "14241211", "12432121",
	"15123121", "15132211", "13323121", "13332211", "11523121",
	"14214121", "14223211", "12414121", "12423211", "15114211",
	"13314211", "11514211", "11151124", "31151122", "21142123",
	"41142121", "21151213", "41151211", "11133124", "31133122",
	"11142214", "31142212", "21124123", "41124121",
	/* Column 16 */
							"21133213",
	"41133211", "11115124", "31115122", "11124214", "31124212",
	"21115213", "41115211", "12151123", "32151121", "21251122",
	"22142122", "11242123", "22151212", "11251213", "31251211",
	"12133123", "32133121", "12142213", "32142211", "21242212",
	"22124122", "11224123", "22133212", "11233213", "31233211",
	"12115123", "32115121", "12124213", "32124211", "21224212",
	"22115212", "11215213", "31215211", "13151122", "22251121",
	"23142121", "12242122", "23151211", "12251212", "13133122",
	"13142212", "11333122", "22242211", "11342212", "23124121",
	"12224122", "23133211", "12233212", "21333211", "13115122",
	"13124212", "11315122", "22224211", "11324212", "23115211",
	"12215212", "21315211",
	/* Column 17 */
				"14151121", "13242121", "13251211",
	"14133121", "14142211", "12333121", "12342211", "13224121",
	"13233211", "11424121", "11433211", "14115121", "14124211",
	"12315121", "12324211", "13215211", "11415211", "11161123",
	"31161121", "21152122", "21161212", "11143123", "31143121",
	"11152213", "31152211", "21134122", "21143212", "11125123",
	"31125121", "11134213", "31134211", "21116122", "21125212",
	"12161122", "22152121", "11252122", "22161211", "12143122",
	"12152212", "21252211", "22134121", "11234122", "22143211",
	"11243212", "12125122", "12134212", "21234211", "22116121",
	"11216122", "22125211", "11225212", "13161121", "12252121",
	"13143121", "13152211", "11343121", "12234121", "12243211",
	/* Column 18 */
	"13125121", "13134211", "11325121", "11334211", "12216121",
	"12225211", "31111225", "51111223", "21111316", "41111314",
	"61111312", "31211134", "51211132", "12111226", "32111224",
	"52111222", "21211225", "41211223", "61211221", "22111315",
	"42111313", "11211316", "31211314", "51211312", "12211135",
	"32211133", "52211131", "21311134", "41311132", "13111225",
	"33111223", "22211224", "42211222", "11311225", "31311223",
	"51311221", "23111314", "43111312", "12211315", "32211313",
	"52211311", "21311314", "41311312", "13211134", "33211132",
	"22311133", "42311131", "11411134", "31411132", "14111224",
	"34111222", "23211223", "43211221", "12311224", "32311222",
	"21411223", "41411221", "24111313",
	/* Column 19 */
					"13211314", "33211312",
	"22311313", "42311311", "11411314", "31411312", "14211133",
	"34211131", "23311132", "12411133", "32411131", "21511132",
	"15111223", "24211222", "13311223", "33311221", "22411222",
	"11511223", "31511221", "25111312", "14211313", "34211311",
	"23311312", "12411313", "32411311", "21511312", "15211132",
	"24311131", "13411132", "22511131", "11611132", "16111222",
	"25211221", "14311222", "23411221", "12511222", "21611221",
	"15211312", "24311311", "13411312", "22511311", "11611312",
	"21121135", "41121133", "61121131", "11112136", "31112134",
	"51112132", "11121226", "31121224", "51121222", "21112225",
	"41112223", "61112221", "21121315", "41121313", "61121311",
	"11112316",
	/* Column 20 */
		"31112314", "51112312", "22121134", "42121132",
	"11221135", "31221133", "51221131", "12112135", "32112133",
	"52112131", "12121225", "32121223", "52121221", "21221224",
	"41221222", "22112224", "42112222", "11212225", "22121314",
	"42121312", "11221315", "31221313", "51221311", "12112315",
	"32112313", "52112311", "21212314", "41212312", "23121133",
	"43121131", "12221134", "32221132", "21321133", "41321131",
	"13112134", "33112132", "13121224", "33121222", "11312134",
	"22221223", "42221221", "11321224", "31321222", "23112223",
	"43112221", "12212224", "23121313", "43121311", "12221314",
	"32221312", "21321313", "41321311", "13112314", "33112312",
	"22212313", "42212311", "11312314", "31312312",
	/* Column 21 */
							"24121132",
	"13221133", "33221131", "22321132", "11421133", "31421131",
	"14112133", "34112131", "14121223", "34121221", "12312133",
	"23221222", "12321223", "32321221", "21421222", "24112222",
	"13212223", "24121312", "13221313", "33221311", "11412223",
	"22321312", "11421313", "31421311", "14112313", "34112311",
	"23212312", "12312313", "32312311", "21412312", "25121131",
	"14221132", "23321131", "12421132", "21521131", "15112132",
	"15121222", "13312132", "24221221", "13321222", "11512132",
	"22421221", "11521222", "25112221", "14212222", "25121311",
	"14221312", "12412222", "23321311", "12421312", "21521311",
	"15112312", "24212311", "13312312", "22412311", "11512312",
	"15221131", "13421131",
	/* Column 22 */
				"16112131", "16121221", "14312131",
	"14321221", "12512131", "12521221", "15212221", "15221311",
	"13412221", "13421311", "11612221", "16112311", "14312311",
	"12512311", "21131134", "41131132", "11122135", "31122133",
	"51122131", "11131225", "31131223", "51131221", "21113134",
	"41113132", "21122224", "41122222", "21131314", "41131312",
	"11113225", "31113223", "51113221", "11122315", "31122313",
	"51122311", "21113314", "41113312", "22131133", "42131131",
	"11231134", "31231132", "12122134", "32122132", "12131224",
	"32131222", "21231223", "41231221", "22113133", "42113131",
	"11213134", "22122223", "42122221", "11222224", "22131313",
	"42131311", "11231314", "31231312", "12113224", "32113222",
	/* Column 23 */
	"12122314", "32122312", "21222313", "41222311", "22113313",
	"42113311", "11213314", "31213312", "23131132", "12231133",
	"32231131", "21331132", "13122133", "33122131", "13131223",
	"33131221", "11322133", "22231222", "11331223", "31331221",
	"23113132", "12213133", "23122222", "12222223", "23131312",
	"12231313", "32231311", "21331312", "13113223", "33113221",
	"13122313", "33122311", "11313223", "22222312", "11322313",
	"31322311", "23113312", "12213313", "32213311", "21313312",
	"24131131", "13231132", "22331131", "11431132", "14122132",
	"14131222", "12322132", "23231221", "12331222", "21431221",
	"24113131", "13213132", "24122221", "13222222", "24131311",
	"11413132", "13231312", "11422222",
	/* Column 24 */
					"22331311", "11431312",
	"14113222", "14122312", "12313222", "23222311", "12322312",
	"21422311", "24113311", "13213312", "22313311", "11413312",
	"14231131", "12431131", "15122131", "15131221", "13322131",
	"13331221", "11522131", "14213131", "14222221", "12413131",
	"14231311", "12422221", "12431311", "15113221", "15122311",
	"13313221", "13322311", "11513221", "11522311", "14213311",
	"12413311", "21141133", "41141131", "11132134", "31132132",
	"11141224", "31141222", "21123133", "41123131", "21132223",
	"41132221", "21141313", "41141311", "11114134", "31114132",
	"11123224", "31123222", "11132314", "31132312", "21114223",
	"41114221", "21123313", "41123311", "11114314", "31114312",
	"22141132",
	/* Column 25 */
		"11241133", "31241131", "12132133", "32132131",
	"12141223", "32141221", "21241222", "22123132", "11223133",
	"22132222", "11232223", "22141312", "11241313", "31241311",
	"12114133", "32114131", "12123223", "32123221", "12132313",
	"32132311", "21232312", "22114222", "11214223", "22123312",
	"11223313", "31223311", "12114313", "32114311", "21214312",
	"23141131", "12241132", "21341131", "13132132", "13141222",
	"11332132", "22241221", "11341222", "23123131", "12223132",
	"23132221", "12232222", "23141311", "12241312", "21341311",
	"13114132", "13123222", "11314132", "13132312", "11323222",
	"22232311", "11332312", "23114221", "12214222", "23123311",
	"12223312", "21323311", "13114312", "22214311",
	/* Column 26 */
							"11314312",
	"13241131", "14132131", "14141221", "12332131", "12341221",
	"13223131", "13232221", "11423131", "13241311", "11432221",
	"14114131", "14123221", "12314131", "14132311", "12323221",
	"12332311", "13214221", "13223311", "11414221", "11423311",
	"14114311", "12314311", "21151132", "11142133", "31142131",
	"11151223", "31151221", "21133132", "21142222", "21151312",
	"11124133", "31124131", "11133223", "31133221", "11142313",
	"31142311", "21115132", "21124222", "21133312", "11115223",
	"31115221", "11124313", "31124311", "22151131", "11251132",
	"12142132", "12151222", "21251221", "22133131", "11233132",
	"22142221", "11242222", "22151311", "11251312", "12124132",
	"12133222", "12142312",
	/* Column 27 */
				"21242311", "22115131", "11215132",
	"22124221", "11224222", "22133311", "11233312", "12115222",
	"12124312", "21224311", "12251131", "13142131", "13151221",
	"11342131", "12233131", "12242221", "12251311", "13124131",
	"13133221", "11324131", "13142311", "11333221", "11342311",
	"12215131", "12224221", "12233311", "13115221", "13124311",
	"11315221", "11324311", "21161131", "11152132", "11161222",
	"21143131", "21152221", "21161311", "11134132", "11143222",
	"11152312", "21125131", "21134221", "21143311", "11116132",
	"11125222", "11134312", "12152131", "12161221", "11243131",
	"11252221", "12134131", "12143221", "12152311", "11225131",
	"11234221", "11243311", "12116131", "12125221", "12134311",
	/* Column 28 */
	"21111235", "41111233", "61111231", "11111326", "31111324",
	"51111322", "21111415", "41111413", "61111411", "21211144",
	"41211142", "22111234", "42111232", "11211235", "31211233",
	"51211231", "12111325", "32111323", "52111321", "21211324",
	"41211322", "22111414", "42111412", "11211415", "31211413",
	"51211411", "22211143", "42211141", "11311144", "31311142",
	"23111233", "43111231", "12211234", "32211232", "21311233",
	"41311231", "13111324", "33111322", "22211323", "42211321",
	"11311324", "31311322", "23111413", "43111411", "12211414",
	"32211412", "21311413", "41311411", "23211142", "12311143",
	"32311141", "21411142", "24111232", "13211233", "33211231",
	"22311232", "11411233", "31411231",
	/* Column 29 */
					"14111323", "34111321",
	"23211322", "12311323", "32311321", "21411322", "24111412",
	"13211413", "33211411", "22311412", "11411413", "31411411",
	"24211141", "13311142", "22411141", "11511142", "25111231",
	"14211232", "23311231", "12411232", "21511231", "15111322",
	"24211321", "13311322", "22411321", "11511322", "25111411",
	"14211412", "23311411", "12411412", "21511411", "14311141",
	"12511141", "15211231", "13411231", "11611231", "16111321",
	"14311321", "12511321", "15211411", "13411411", "11611411",
	"31121143", "51121141", "21112144", "41112142", "21121234",
	"41121232", "11112235", "31112233", "51112231", "11121325",
	"31121323", "51121321", "21112324", "41112322", "21121414",
	"41121412",
	/* Column 30 */
		"11112415", "31112413", "51112411", "12121144",
	"32121142", "21221143", "41221141", "22112143", "42112141",
	"11212144", "22121233", "42121231", "11221234", "31221232",
	"12112234", "32112232", "12121324", "32121322", "21221323",
	"41221321", "22112323", "42112321", "11212324", "22121413",
	"42121411", "11221414", "31221412", "12112414", "32112412",
	"21212413", "41212411", "13121143", "33121141", "22221142",
	"11321143", "31321141", "23112142", "12212143", "23121232",
	"12221233", "32221231", "21321232", "13112233", "33112231",
	"13121323", "33121321", "11312233", "22221322", "11321323",
	"31321321", "23112322", "12212323", "23121412", "12221413",
	"32221411", "21321412", "13112413", "33112411",
	/* Column 31 */
							"22212412",
	"11312413", "31312411", "14121142", "23221141", "12321142",
	"21421141", "24112141", "13212142", "24121231", "13221232",
	"11412142", "22321231", "11421232", "14112232", "14121322",
	"12312232", "23221321", "12321322", "21421321", "24112321",
	"13212322", "24121411", "13221412", "11412322", "22321411",
	"11421412", "14112412", "23212411", "12312412", "21412411",
	"15121141", "13321141", "11521141", "14212141", "14221231",
	"12412141", "12421231", "15112231", "15121321", "13312231",
	"13321321", "11512231", "11521321", "14212321", "14221411",
	"12412321", "12421411", "15112411", "13312411", "11512411",
	"11131144", "31131142", "21122143", "41122141", "21131233",
	"41131231", "11113144",
	/* Column 32 */
				"31113142", "11122234", "31122232",
	"11131324", "31131322", "21113233", "41113231", "21122323",
	"41122321", "21131413", "41131411", "11113324", "31113322",
	"11122414", "31122412", "21113413", "41113411", "12131143",
	"32131141", "21231142", "22122142", "11222143", "22131232",
	"11231233", "31231231", "12113143", "32113141", "12122233",
	"32122231", "12131323", "32131321", "21231322", "22113232",
	"11213233", "22122322", "11222323", "22131412", "11231413",
	"31231411", "12113323", "32113321", "12122413", "32122411",
	"21222412", "22113412", "11213413", "31213411", "13131142",
	"22231141", "11331142", "23122141", "12222142", "23131231",
	"12231232", "21331231", "13113142", "13122232", "11313142",
	/* Column 33 */
	"13131322", "11322232", "22231321", "11331322", "23113231",
	"12213232", "23122321", "12222322", "23131411", "12231412",
	"21331411", "13113322", "13122412", "11313322", "22222411",
	"11322412", "23113411", "12213412", "21313411", "14131141",
	"12331141", "13222141", "13231231", "11422141", "11431231",
	"14113141", "14122231", "12313141", "14131321", "12322231",
	"12331321", "13213231", "13222321", "11413231", "13231411",
	"11422321", "11431411", "14113321", "14122411", "12313321",
	"12322411", "13213411", "11413411", "11141143", "31141141",
	"21132142", "21141232", "11123143", "31123141", "11132233",
	"31132231", "11141323", "31141321", "21114142", "21123232",
	"21132322", "21141412", "11114233",
	/* Column 34 */
					"31114231", "11123323",
	"31123321", "11132413", "31132411", "21114322", "21123412",
	"12141142", "21241141", "22132141", "11232142", "22141231",
	"11241232", "12123142", "12132232", "12141322", "21241321",
	"22114141", "11214142", "22123231", "11223232", "22132321",
	"11232322", "22141411", "11241412", "12114232", "12123322",
	"12132412", "21232411", "22114321", "11214322", "22123411",
	"11223412", "13141141", "11341141", "12232141", "12241231",
	"13123141", "13132231", "11323141", "13141321", "11332231",
	"11341321", "12214141", "12223231", "12232321", "12241411",
	"13114231", "13123321", "11314231", "13132411", "11323321",
	"11332411", "12214321", "12223411", "11151142", "21142141",
	"21151231",
	/* Column 35 */
		"11133142", "11142232", "11151322", "21124141",
	"21133231", "21142321", "21151411", "11115142", "11124232",
	"11133322", "11142412", "21115231", "21124321", "21133411",
	"12151141", "11242141", "11251231", "12133141", "12142231",
	"12151321", "11224141", "11233231", "11242321", "11251411",
	"12115141", "12124231", "12133321", "12142411", "11215231",
	"11224321", "11233411", "11161141", "11143141", "11152231",
	"11161321", "11125141", "11134231", "11143321", "11152411",
	"11111245", "31111243", "51111241", "21111334", "41111332",
	"11111425", "31111423", "51111421", "21111514", "41111512",
	"31211152", "12111244", "32111242", "21211243", "41211241",
	"22111333", "42111331", "11211334", "31211332",
	/* Column 36 */
							"12111424",
	"32111422", "21211423", "41211421", "22111513", "42111511",
	"11211514", "31211512", "12211153", "32211151", "21311152",
	"13111243", "33111241", "22211242", "11311243", "31311241",
	"23111332", "12211333", "32211331", "21311332", "13111423",
	"33111421", "22211422", "11311423", "31311421", "23111512",
	"12211513", "32211511", "21311512", "13211152", "22311151",
	"11411152", "14111242", "23211241", "12311242", "21411241",
	"24111331", "13211332", "22311331", "11411332", "14111422",
	"23211421", "12311422", "21411421", "24111511", "13211512",
	"22311511", "11411512", "14211151", "12411151", "15111241",
	"13311241", "11511241", "14211331", "12411331", "15111421",
	"13311421", "11511421",
	/* Column 37 */
				"14211511", "12411511", "21121153",
	"41121151", "11112154", "31112152", "11121244", "31121242",
	"21112243", "41112241", "21121333", "41121331", "11112334",
	"31112332", "11121424", "31121422", "21112423", "41112421",
	"21121513", "41121511", "11112514", "31112512", "22121152",
	"11221153", "31221151", "12112153", "32112151", "12121243",
	"32121241", "21221242", "22112242", "11212243", "22121332",
	"11221333", "31221331", "12112333", "32112331", "12121423",
	"32121421", "21221422", "22112422", "11212423", "22121512",
	"11221513", "31221511", "12112513", "32112511", "21212512",
	"23121151", "12221152", "21321151", "13112152", "13121242",
	"11312152", "22221241", "11321242", "23112241", "12212242",
	/* Column 38 */
	"23121331", "12221332", "21321331", "13112332", "13121422",
	"11312332", "22221421", "11321422", "23112421", "12212422",
	"23121511", "12221512", "21321511", "13112512", "22212511",
	"11312512", "13221151", "11421151", "14112151", "14121241",
	"12312151", "12321241", "13212241", "13221331", "11412241",
	"11421331", "14112331", "14121421", "12312331", "12321421",
	"13212421", "13221511", "11412421", "11421511", "14112511",
	"12312511", "21131152", "11122153", "31122151", "11131243",
	"31131241", "21113152", "21122242", "21131332", "11113243",
	"31113241", "11122333", "31122331", "11131423", "31131421",
	"21113332", "21122422", "21131512", "11113423", "31113421",
	"11122513", "31122511", "22131151",
	/* Column 39 */
					"11231152", "12122152",
	"12131242", "21231241", "22113151", "11213152", "22122241",
	"11222242", "22131331", "11231332", "12113242", "12122332",
	"12131422", "21231421", "22113331", "11213332", "22122421",
	"11222422", "22131511", "11231512", "12113422", "12122512",
	"21222511", "12231151", "13122151", "13131241", "11322151",
	"11331241", "12213151", "12222241", "12231331", "13113241",
	"13122331", "11313241", "13131421", "11322331", "11331421",
	"12213331", "12222421", "12231511", "13113421", "13122511",
	"11313421", "11322511", "21141151", "11132152", "11141242",
	"21123151", "21132241", "21141331", "11114152", "11123242",
	"11132332", "11141422", "21114241", "21123331", "21132421",
	"21141511",
	/* Column 40 */
		"11114332", "11123422", "11132512", "11241151",
	"12132151", "12141241", "11223151", "11232241", "11241331",
	"12114151", "12123241", "12132331", "12141421", "11214241",
	"11223331", "11232421", "11241511", "12114331", "12123421",
	"12132511", "11142151", "11151241", "11124151", "11133241",
	"11142331", "11151421", "11115241", "11124331", "11133421",
	"11142511", "21111253", "41111251", "11111344", "31111342",
	"21111433", "41111431", "11111524", "31111522", "21111613",
	"41111611", "21211162", "22111252", "11211253", "31211251",
	"12111343", "32111341", "21211342", "22111432", "11211433",
	"31211431", "12111523", "32111521", "21211522", "22111612",
	"11211613", "31211611", "22211161", "11311162",
	/* Column 41 */
							"23111251",
	"12211252", "21311251", "13111342", "22211341", "11311342",
	"23111431", "12211432", "21311431", "13111522", "22211521",
	"11311522", "23111611", "12211612", "21311611", "12311161",
	"13211251", "11411251", "14111341", "12311341", "13211431",
	"11411431", "14111521", "12311521", "13211611", "11411611",
	"31121161", "21112162", "21121252", "11112253", "31112251",
	"11121343", "31121341", "21112342", "21121432", "11112433",
	"31112431", "11121523", "31121521", "21112522", "21121612",
	/* Column 42 */
	"12121162", "21221161", "22112161", "11212162", "22121251",
	"11221252", "12112252", "12121342", "21221341", "22112341",
	"11212342", "22121431", "11221432", "12112432", "12121522",
	"21221521", "22112521", "11212522", "22121611", "11221612",
	"13121161", "11321161", "12212161", "12221251", "13112251",
	"13121341", "11312251", "11321341", "12212341", "12221431",
	"13112431", "13121521", "11312431", "11321521", "12212521",
	"12221611", "11131162", "21122161", "21131251", "11113162"
};
