/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __xml_h__

#include <glib.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

struct xml_attribute
{
  char*                                m_tag;
  char*                                m_value;              
};

struct xml
{
  char*                                 m_tag;
  GString*                              m_string;
  struct xml_attribute*                 m_attr;
  unsigned                              m_attr_slots;
  GList*                                m_children;
};

extern gboolean
xml_convert_boolean(
  char const*                           i_value);

extern gdouble
xml_convert_double(
  char const*                           i_value);

extern guint64
xml_convert_ulong(
  char const*                           i_value);

extern void
xml_free(
  struct xml*const                      io_xml);

extern char const*
xml_lookup_attribute_value(
  struct xml*const                      io_xml,
  char const*                           i_tag);

extern int
xml_parse(
  GError**                              o_error,
  struct xml**                          o_xml,
  char const*                           i_filename);

#define __xml_h__
#endif
