/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015-2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __query_h__

#include "global_common.h"
#include "database_aspect.h"
#include "goop.h"

struct query_node
{
  char                                  m_tag[31+1];
  char*                                 m_text;
  unsigned                              m_size;
  struct query_node*                    m_next;
  struct query_node*                    m_prev;
};

struct query
{
  struct query_node*                    m_head;
  struct query_node*                    m_tail;
};

extern void
query_assign(
  struct query*                         o_query);

extern void
query_clear(
  struct query*                         io_query);

extern void
query_count(
  unsigned*const                        o_count,
  struct query const*const              i_query);

extern void
query_delete(
  struct query*                         io_query,
  struct query_node*                    io_node);

extern void
query_discharge(
  struct query*                         io_query);

extern void
query_first_new(
  struct query_node**                   o_node,
  struct query*                         io_query);

extern void
query_insert_after(
  struct query*const                     io_query,
  struct query_node*const                i_node,
  struct query_node*const                i_node_new);

extern void
query_insert_before(
  struct query*const                     io_query,
  struct query_node*const                i_node,
  struct query_node*const                i_node_new);

extern void
query_last_new(
  struct query_node**                   o_node,
  struct query*                         io_query);

extern void
query_list_delete(
  struct query*                         io_query);

extern void
query_node_assign(
  struct query_node*                    io_node);

extern void
query_node_discharge(
  struct query_node*                    io_node);

extern int
query_property(
  struct query *const                   io_query,
  struct database_aspect *const         io_aspect);

extern int
query_read(
  GError**                              o_error,
  struct query*const                    io_query,
  struct xml *const                     i_xml);

extern int
query_write(
  GError**                              o_error,
  FILE*const                            io_fp,
  struct query const*const              i_query);

extern void
query_unlink(
  struct query_node*                    io_node,
  struct query*const                    io_query);

#define __query_h__
#endif

