/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2015-2016, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "menu.h"

G_MODULE_EXPORT void
about_menuitem_activate_cb(
  GtkMenuItem *                         i_menuitem,
  gpointer                              i_user_data)
{
  GtkDialog*                            l_dialog;
  char const*                           l_stage;

  l_stage= version_get_stage_text(g_version.m_stage);

  l_dialog= GTK_DIALOG(gtk_message_dialog_new(
    get_main_window(),
    GTK_DIALOG_MODAL,
    GTK_MESSAGE_INFO,
    GTK_BUTTONS_OK,
    "version: %d.%d.%d.%d (%s.%s.%s-%s)\n%s",
    g_version.m_major,
    g_version.m_minor,
    g_version.m_stage,
    g_version.m_micro,
    g_version.m_stamp.m_year,
    g_version.m_stamp.m_month,
    g_version.m_stamp.m_day,
    l_stage,
    g_copyright));

  gtk_dialog_run(l_dialog);
  gtk_widget_destroy(GTK_WIDGET(l_dialog));

  return;
}

G_MODULE_EXPORT void
break_menuitem_activate_cb(
  GtkMenuItem *                         i_menuitem,
  gpointer                              i_user_data)
{
  struct mainw*                         l_mainw;
  GtkAllocation                         l_alloc;

  l_mainw= (struct mainw*)i_user_data;
  layout_break_property(&(*l_mainw).m_report.m_object.m_layout);

  gtk_widget_get_allocation(GTK_WIDGET((*l_mainw).m_window), &l_alloc);
  g_signal_emit_by_name((*l_mainw).m_window, "size-allocate", &l_alloc, 0);

  return;
}

G_MODULE_EXPORT void
circle_menuitem_activate_cb(
  GtkMenuItem *                         i_menuitem,
  gpointer                              i_user_data)
{
  struct mainw*                         l_mainw;

  l_mainw= (struct mainw*)i_user_data;
  report_item_new(&(*l_mainw).m_report, item_type_circle);

  return;
}

G_MODULE_EXPORT void
coverfooter_menuitem_toggled_cb(
  GtkMenuItem *                         i_menuitem,
  gpointer                              i_user_data)
{
  struct mainw*                         l_mainw;
  gboolean                              l_state;

  l_state= gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(i_menuitem));
  l_mainw= (struct mainw*)i_user_data;

  if (l_state)
  {
    layout_new_coverfooter(&(*l_mainw).m_report.m_object.m_layout);
  }
  else
  {
    layout_delete_coverfooter(&(*l_mainw).m_report.m_object.m_layout);
  }

  return;
}

G_MODULE_EXPORT void
coverheader_menuitem_toggled_cb(
  GtkMenuItem *                         i_menuitem,
  gpointer                              i_user_data)
{
  struct mainw*                         l_mainw;
  gboolean                              l_state;

  l_state= gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(i_menuitem));
  l_mainw= (struct mainw*)i_user_data;

  if (l_state)
  {
    layout_new_coverheader(&(*l_mainw).m_report.m_object.m_layout);
  }
  else
  {
    layout_delete_coverheader(&(*l_mainw).m_report.m_object.m_layout);
  }

  return;
}

G_MODULE_EXPORT void
export_menuitem_activate_cb(
  GtkMenuItem *                         i_menuitem,
  gpointer                              i_user_data)
{
  struct mainw*                         l_mainw;
  GtkWidget*                            l_widget;

  l_mainw= (struct mainw*)i_user_data;

  if ((*l_mainw).m_size_allocate_handle)
  {
    g_signal_handler_disconnect((*l_mainw).m_window, (*l_mainw).m_size_allocate_handle);
    (*l_mainw).m_size_allocate_handle= 0;
  }

  report_discharge(&(*l_mainw).m_report);
  report_assign_export(&(*l_mainw).m_report);

  l_widget= report_gui_new(&(*l_mainw).m_report);
  gtk_paned_add1((*l_mainw).m_paned, l_widget);
  g_object_unref(l_widget);

  menu_export_set_defaults();

  gtk_widget_show_all(GTK_WIDGET((*l_mainw).m_paned));

  return;
}

G_MODULE_EXPORT void
database_menuitem_activate_cb(
  GtkMenuItem *                         i_menuitem,
  gpointer                              i_user_data)
{
  struct mainw*                         l_mainw;

  l_mainw= (struct mainw*)i_user_data;
  database_aspect_property(&(*l_mainw).m_report.m_aspect);
  database_field_destroy_cache();

  if (style_export == (*l_mainw).m_report.m_style)
  {
    export_reload(
      &(*l_mainw).m_report.m_object.m_export,
      &(*l_mainw).m_report.m_aspect,
      &(*l_mainw).m_report.m_query);
  }

  return;
}

G_MODULE_EXPORT void
datetime_menuitem_activate_cb(
  GtkMenuItem *                         i_menuitem,
  gpointer                              i_user_data)
{
  struct mainw*                         l_mainw;

  l_mainw= (struct mainw*)i_user_data;
  report_item_new(&(*l_mainw).m_report, item_type_date);

  return;
}

G_MODULE_EXPORT void
fbarcode_menuitem_activate_cb(
  GtkMenuItem *                         i_menuitem,
  gpointer                              i_user_data)
{
  struct mainw*                         l_mainw;

  l_mainw= (struct mainw*)i_user_data;
  report_item_new(&(*l_mainw).m_report, item_type_fbarcode);

  return;
}

G_MODULE_EXPORT void
fimage_menuitem_activate_cb(
  GtkMenuItem *                         i_menuitem,
  gpointer                              i_user_data)
{
  struct mainw*                         l_mainw;

  l_mainw= (struct mainw*)i_user_data;
  report_item_new(&(*l_mainw).m_report, item_type_fimage);

  return;
}

G_MODULE_EXPORT void
fnumber_menuitem_activate_cb(
  GtkMenuItem *                         i_menuitem,
  gpointer                              i_user_data)
{
  struct mainw*                         l_mainw;

  l_mainw= (struct mainw*)i_user_data;
  report_item_new(&(*l_mainw).m_report, item_type_fnumber);

  return;
}

G_MODULE_EXPORT void
frame_menuitem_activate_cb(
  GtkMenuItem *                         i_menuitem,
  gpointer                              i_user_data)
{
  struct mainw*                         l_mainw;

  l_mainw= (struct mainw*)i_user_data;
  report_item_new(&(*l_mainw).m_report, item_type_frame);

  return;
}

G_MODULE_EXPORT void
ftext_menuitem_activate_cb(
  GtkMenuItem *                         i_menuitem,
  gpointer                              i_user_data)
{
  struct mainw*                         l_mainw;

  l_mainw= (struct mainw*)i_user_data;
  report_item_new(&(*l_mainw).m_report, item_type_ftext);

  return;
}

G_MODULE_EXPORT void
highlight_menuitem_toggled_cb(
  GtkMenuItem *                         i_menuitem,
  gpointer                              i_user_data)
{
  struct mainw*                         l_mainw;
  gboolean                              l_state;

  l_state= gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(i_menuitem));
  l_mainw= (struct mainw*)i_user_data;
  report_highlight_objects(&(*l_mainw).m_report, l_state);

  return;
}

G_MODULE_EXPORT void
image_menuitem_activate_cb(
  GtkMenuItem *                         i_menuitem,
  gpointer                              i_user_data)
{
  struct mainw*                         l_mainw;

  l_mainw= (struct mainw*)i_user_data;
  report_item_new(&(*l_mainw).m_report, item_type_image);

  return;
}

G_MODULE_EXPORT void
line_menuitem_activate_cb(
  GtkMenuItem *                         i_menuitem,
  gpointer                              i_user_data)
{
  struct mainw*                         l_mainw;

  l_mainw= (struct mainw*)i_user_data;
  report_item_new(&(*l_mainw).m_report, item_type_line);

  return;
}

G_MODULE_EXPORT void
label_menuitem_activate_cb(
  GtkMenuItem *                         i_menuitem,
  gpointer                              i_user_data)
{
  GtkAllocation                         l_alloc;
  struct mainw*                         l_mainw;
  GtkWidget*                            l_widget;

  l_mainw= (struct mainw*)i_user_data;

  report_discharge(&(*l_mainw).m_report);
  report_assign_label(&(*l_mainw).m_report);

  l_widget= report_gui_new(&(*l_mainw).m_report);
  gtk_paned_add1((*l_mainw).m_paned, l_widget);

  if (0 == (*l_mainw).m_size_allocate_handle)
  {
    (*l_mainw).m_size_allocate_handle= g_signal_connect(
      (*l_mainw).m_window,
      "size-allocate",
      G_CALLBACK(mainw_size_allocate),
      l_mainw);
  }

  menu_label_set_defaults();
  gtk_widget_show_all(GTK_WIDGET((*l_mainw).m_paned));

  gtk_widget_get_allocation(GTK_WIDGET((*l_mainw).m_window), &l_alloc);
  g_signal_emit_by_name((*l_mainw).m_window, "size-allocate", &l_alloc, 0);
  database_field_destroy_cache();

  return;
}

G_MODULE_EXPORT void
layout_menuitem_activate_cb(
  GtkMenuItem *                         i_menuitem,
  gpointer                              i_user_data)
{
  GtkAllocation                         l_alloc;
  struct mainw*                         l_mainw;
  GtkWidget*                            l_widget;

  l_mainw= (struct mainw*)i_user_data;

  report_discharge(&(*l_mainw).m_report);
  report_assign_layout(&(*l_mainw).m_report);

  l_widget= report_gui_new(&(*l_mainw).m_report);
  layout_add_default_sections(&(*l_mainw).m_report.m_object.m_layout);
  gtk_paned_add1((*l_mainw).m_paned, l_widget);

  if (0 == (*l_mainw).m_size_allocate_handle)
  {
    (*l_mainw).m_size_allocate_handle= g_signal_connect(
      (*l_mainw).m_window,
      "size-allocate",
      G_CALLBACK(mainw_size_allocate),
      l_mainw);
  }

  menu_layout_set_defaults();
  menu_layout_set_sections(&(*l_mainw).m_report.m_object.m_layout);

  gtk_widget_show_all(GTK_WIDGET((*l_mainw).m_paned));

  gtk_widget_get_allocation(GTK_WIDGET((*l_mainw).m_window), &l_alloc);
  g_signal_emit_by_name((*l_mainw).m_window, "size-allocate", &l_alloc, 0);
  database_field_destroy_cache();

  return;
}

G_MODULE_EXPORT void
open_menuitem_activate_cb(
  GtkMenuItem *                         i_menuitem,
  gpointer                              i_user_data)
{
  GtkFileChooser*                       l_chooser;
  GtkWidget*                            l_dialog;
  GtkFileFilter*                        l_filter;
  struct mainw*                         l_mainw;
  int                                   l_rc;
  char*                                 l_reportfile;

  l_mainw= (struct mainw*)i_user_data;
  l_reportfile= 0;
  l_dialog= 0;
  
  do
  {
    
    l_dialog = gtk_file_chooser_dialog_new(
      "Open Report",
      (*l_mainw).m_window,
      GTK_FILE_CHOOSER_ACTION_OPEN,
      "_Cancel",
      GTK_RESPONSE_CANCEL,
      "_Save",
      GTK_RESPONSE_ACCEPT,
      NULL);

    l_chooser= GTK_FILE_CHOOSER(l_dialog);
    
    l_filter= gtk_file_filter_new();
    gtk_file_filter_add_pattern(l_filter, "*.irpt");
    gtk_file_filter_set_name(l_filter, "iwrite report");
    gtk_file_chooser_add_filter(l_chooser, l_filter);

    l_rc= gtk_dialog_run(GTK_DIALOG(l_dialog));

    if (GTK_RESPONSE_ACCEPT != l_rc)
    {
      break;
    }

    l_reportfile= gtk_file_chooser_get_filename(l_chooser);
    l_rc= mainw_open(l_mainw, l_reportfile);

  }while(0);

  if (l_dialog)
  {
    gtk_widget_destroy(l_dialog); 
  }

  if (l_reportfile)
  {
    g_free(l_reportfile);
  }

  return;
}

G_MODULE_EXPORT void
pagenumber_menuitem_activate_cb(
  GtkMenuItem *                         i_menuitem,
  gpointer                              i_user_data)
{
  struct mainw*                         l_mainw;

  l_mainw= (struct mainw*)i_user_data;
  report_item_new(&(*l_mainw).m_report, item_type_page_number);

  return;
}

G_MODULE_EXPORT void
pagesetup_menuitem_activate_cb(
  GtkMenuItem *                         i_menuitem,
  gpointer                              i_user_data)
{
  GtkAllocation                         l_alloc;
  struct mainw*                         l_mainw;
  int                                   l_exit;

  do
  {

    l_mainw= (struct mainw*)i_user_data;

    if (style_export == (*l_mainw).m_report.m_style)
    {
      export_page_setup_property(&(*l_mainw).m_report.m_object.m_export);
      break;
    }

    if (style_layout == (*l_mainw).m_report.m_style)
    {
      l_exit= layout_page_setup_property(
        &(*l_mainw).m_report.m_object.m_layout.m_paper);

      if (0 == l_exit)
      {
        break;
      }

      layout_paper_changed(&(*l_mainw).m_report.m_object.m_layout);
    }
    else if (style_label == (*l_mainw).m_report.m_style)
    {
      l_exit= label_page_setup_property(
        &(*l_mainw).m_report.m_object.m_label.m_paper);

      if (0 == l_exit)
      {
        break;
      }

      label_paper_changed(&(*l_mainw).m_report.m_object.m_label);
    }
    else
    {
      /* programming error */
      break;
    }

    gtk_widget_get_allocation(GTK_WIDGET((*l_mainw).m_window), &l_alloc);
    g_signal_emit_by_name((*l_mainw).m_window, "size-allocate", &l_alloc, 0);

  }while(0);

  return;
}

G_MODULE_EXPORT void
reportdetail_menuitem_toggled_cb(
  GtkMenuItem *                         i_menuitem,
  gpointer                              i_user_data)
{
  struct mainw*                         l_mainw;
  gboolean                              l_state;

  l_state= gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(i_menuitem));
  l_mainw= (struct mainw*)i_user_data;

  if (l_state)
  {
    layout_new_reportdetail(&(*l_mainw).m_report.m_object.m_layout);
  }
  else
  {
    layout_delete_reportdetail(&(*l_mainw).m_report.m_object.m_layout);
  }

  return;
}

G_MODULE_EXPORT void
reportfooter_menuitem_toggled_cb(
  GtkMenuItem *                         i_menuitem,
  gpointer                              i_user_data)
{
  struct mainw*                         l_mainw;
  gboolean                              l_state;

  l_state= gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(i_menuitem));
  l_mainw= (struct mainw*)i_user_data;

  if (l_state)
  {
    layout_new_reportfooter(&(*l_mainw).m_report.m_object.m_layout);
  }
  else
  {
    layout_delete_reportfooter(&(*l_mainw).m_report.m_object.m_layout);
  }

  return;
}

G_MODULE_EXPORT void
reportheader_menuitem_toggled_cb(
  GtkMenuItem *                         i_menuitem,
  gpointer                              i_user_data)
{
  struct mainw*                         l_mainw;
  gboolean                              l_state;

  l_state= gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(i_menuitem));
  l_mainw= (struct mainw*)i_user_data;

  if (l_state)
  {
    layout_new_reportheader(&(*l_mainw).m_report.m_object.m_layout);
  }
  else
  {
    layout_delete_reportheader(&(*l_mainw).m_report.m_object.m_layout);
  }

  return;
}

G_MODULE_EXPORT void
query_menuitem_activate_cb(
  GtkMenuItem *                         i_menuitem,
  gpointer                              i_user_data)
{
  struct mainw*                         l_mainw;

  l_mainw= (struct mainw*)i_user_data;

  query_property(&(*l_mainw).m_report.m_query, &(*l_mainw).m_report.m_aspect);
  database_field_destroy_cache();

  if (style_export == (*l_mainw).m_report.m_style)
  {
    export_reload(
      &(*l_mainw).m_report.m_object.m_export,
      &(*l_mainw).m_report.m_aspect,
      &(*l_mainw).m_report.m_query);
  }

  return;
}

G_MODULE_EXPORT void
quit_menuitem_activate_cb(
  GtkMenuItem *                         i_menuitem,
  gpointer                              i_user_data)
{

  mainw_discharge((struct mainw*)i_user_data);
  database_field_destroy_cache();
  gtk_main_quit();

  return;
}

G_MODULE_EXPORT void
ruleline_horizontal_menuitem_toggled_cb(
  GtkCheckMenuItem *                    i_menuitem,
  gpointer                              i_user_data)
{
  struct mainw*                         l_mainw;
  gboolean                              l_state;

  l_state= gtk_check_menu_item_get_active(i_menuitem);
  l_mainw= (struct mainw*)i_user_data;
  report_set_horizontal_ruler_line(&(*l_mainw).m_report, l_state);

  return;
}

G_MODULE_EXPORT void
ruleline_vertical_menuitem_toggled_cb(
  GtkCheckMenuItem *                    i_menuitem,
  gpointer                              i_user_data)
{
  struct mainw*                         l_mainw;
  gboolean                              l_state;

  l_state= gtk_check_menu_item_get_active(i_menuitem);
  l_mainw= (struct mainw*)i_user_data;
  report_set_vertical_ruler_line(&(*l_mainw).m_report, l_state);

  return;
}

G_MODULE_EXPORT void
run_menuitem_activate_cb(
  GtkMenuItem *                         i_menuitem,
  gpointer                              i_user_data)
{
  struct mainw*                         l_mainw;

  l_mainw= (struct mainw*)i_user_data;
  mainw_run(l_mainw);

  return;
}

G_MODULE_EXPORT void
save_as_menuitem_activate_cb(
  GtkMenuItem *                         i_menuitem,
  gpointer                              i_user_data)
{
  struct mainw*                         l_mainw;

  l_mainw= (struct mainw*)i_user_data;
  mainw_save_as(l_mainw);

  return;
}

G_MODULE_EXPORT void
save_menuitem_activate_cb(
  GtkMenuItem *                         i_menuitem,
  gpointer                              i_user_data)
{
  struct mainw*                         l_mainw;

  l_mainw= (struct mainw*)i_user_data;
  mainw_save(l_mainw);

  return;
}

G_MODULE_EXPORT void
fsum_menuitem_activate_cb(
  GtkMenuItem *                         i_menuitem,
  gpointer                              i_user_data)
{
  struct mainw*                         l_mainw;

  l_mainw= (struct mainw*)i_user_data;
  report_item_new(&(*l_mainw).m_report, item_type_fsum);

  return;
}

G_MODULE_EXPORT void
text_menuitem_activate_cb(
  GtkMenuItem *                         i_menuitem,
  gpointer                              i_user_data)
{
  struct mainw*                         l_mainw;

  l_mainw= (struct mainw*)i_user_data;
  report_item_new(&(*l_mainw).m_report, item_type_text);

  return;
}

G_MODULE_EXPORT void
zoom100_menuitem_activate_cb(
  GtkMenuItem *                         i_menuitem,
  gpointer                              i_user_data)
{
  GtkAllocation                         l_alloc;
  struct mainw*                         l_mainw;

  l_mainw= (struct mainw*)i_user_data;
  report_set_scale(&(*l_mainw).m_report, 1.00);

  gtk_widget_get_allocation(GTK_WIDGET((*l_mainw).m_window), &l_alloc);
  g_signal_emit_by_name((*l_mainw).m_window, "size-allocate", &l_alloc, 0);

  return;
}

G_MODULE_EXPORT void
zoom200_menuitem_activate_cb(
  GtkMenuItem *                         i_menuitem,
  gpointer                              i_user_data)
{
  GtkAllocation                         l_alloc;
  struct mainw*                         l_mainw;

  l_mainw= (struct mainw*)i_user_data;
  report_set_scale(&(*l_mainw).m_report, 2.00);

  gtk_widget_get_allocation(GTK_WIDGET((*l_mainw).m_window), &l_alloc);
  g_signal_emit_by_name((*l_mainw).m_window, "size-allocate", &l_alloc, 0);

  return;
}

G_MODULE_EXPORT void
zoom50_menuitem_activate_cb(
  GtkMenuItem *                         i_menuitem,
  gpointer                              i_user_data)
{
  GtkAllocation                         l_alloc;
  struct mainw*                         l_mainw;

  l_mainw= (struct mainw*)i_user_data;
  report_set_scale(&(*l_mainw).m_report, 0.50);

  gtk_widget_get_allocation(GTK_WIDGET((*l_mainw).m_window), &l_alloc);
  g_signal_emit_by_name((*l_mainw).m_window, "size-allocate", &l_alloc, 0);

  return;
}

G_MODULE_EXPORT void
zoom75_menuitem_activate_cb(
  GtkMenuItem *                         i_menuitem,
  gpointer                              i_user_data)
{
  GtkAllocation                         l_alloc;
  struct mainw*                         l_mainw;

  l_mainw= (struct mainw*)i_user_data;
  report_set_scale(&(*l_mainw).m_report, 0.75);

  gtk_widget_get_allocation(GTK_WIDGET((*l_mainw).m_window), &l_alloc);
  g_signal_emit_by_name((*l_mainw).m_window, "size-allocate", &l_alloc, 0);

  return;
}

G_MODULE_EXPORT void
zoomin_menuitem_activate_cb(
  GtkMenuItem *                         i_menuitem,
  gpointer                              i_user_data)
{
  GtkAllocation                         l_alloc;
  struct mainw*                         l_mainw;

  l_mainw= (struct mainw*)i_user_data;
  report_set_scale_zoom_in(&(*l_mainw).m_report);

  gtk_widget_get_allocation(GTK_WIDGET((*l_mainw).m_window), &l_alloc);
  g_signal_emit_by_name((*l_mainw).m_window, "size-allocate", &l_alloc, 0);

  return;
}

G_MODULE_EXPORT void
zoomout_menuitem_activate_cb(
  GtkMenuItem *                         i_menuitem,
  gpointer                              i_user_data)
{
  GtkAllocation                         l_alloc;
  struct mainw*                         l_mainw;

  l_mainw= (struct mainw*)i_user_data;
  report_set_scale_zoom_out(&(*l_mainw).m_report);

  gtk_widget_get_allocation(GTK_WIDGET((*l_mainw).m_window), &l_alloc);
  g_signal_emit_by_name((*l_mainw).m_window, "size-allocate", &l_alloc, 0);

  return;
}

GtkMenuItem*                            g_view_menuitem;
GtkMenuItem*                            g_section_menuitem;
GtkMenuItem*                            g_insert_menuitem;
GtkMenuItem*                            g_break_menuitem;
GtkCheckMenuItem*                       g_highlight_menuitem;
GtkCheckMenuItem*                       g_ruleline_horizontal_menuitem;
GtkCheckMenuItem*                       g_ruleline_vertical_menuitem;
GtkCheckMenuItem*                       g_coverheader_menuitem;
GtkCheckMenuItem*                       g_coverfooter_menuitem;
GtkCheckMenuItem*                       g_reportheader_menuitem;
GtkCheckMenuItem*                       g_reportdetail_menuitem;
GtkCheckMenuItem*                       g_reportfooter_menuitem;

extern int
menu_layout_bind(
  GtkBuilder*const                      i_builder,
  struct mainw*                         i_mainw)
{

  gtk_builder_connect_signals(i_builder, i_mainw);

  g_view_menuitem= GTK_MENU_ITEM(
    gtk_builder_get_object(i_builder, "view_menuitem"));

  g_section_menuitem= GTK_MENU_ITEM(
    gtk_builder_get_object(i_builder, "section_menuitem"));

  g_insert_menuitem= GTK_MENU_ITEM(
    gtk_builder_get_object(i_builder, "insert_menuitem"));

  g_break_menuitem= GTK_MENU_ITEM(
    gtk_builder_get_object(i_builder, "break_menuitem"));

  g_highlight_menuitem= GTK_CHECK_MENU_ITEM(
    gtk_builder_get_object(i_builder, "highlight_menuitem"));

  g_ruleline_horizontal_menuitem= GTK_CHECK_MENU_ITEM(
    gtk_builder_get_object(i_builder, "ruleline_horizontal_menuitem"));

  g_ruleline_vertical_menuitem= GTK_CHECK_MENU_ITEM(
    gtk_builder_get_object(i_builder, "ruleline_vertical_menuitem"));

  g_coverheader_menuitem= GTK_CHECK_MENU_ITEM(
    gtk_builder_get_object(i_builder, "coverheader_menuitem"));

  g_coverfooter_menuitem= GTK_CHECK_MENU_ITEM(
    gtk_builder_get_object(i_builder, "coverfooter_menuitem"));

  g_reportheader_menuitem= GTK_CHECK_MENU_ITEM(
    gtk_builder_get_object(i_builder, "reportheader_menuitem"));

  g_reportdetail_menuitem= GTK_CHECK_MENU_ITEM(
    gtk_builder_get_object(i_builder, "reportdetail_menuitem"));

  g_reportfooter_menuitem= GTK_CHECK_MENU_ITEM(
    gtk_builder_get_object(i_builder, "reportfooter_menuitem"));

  return 0;
}

extern void
menu_export_set_defaults()
{

  gtk_widget_set_sensitive(GTK_WIDGET(g_view_menuitem), 0);
  gtk_widget_set_sensitive(GTK_WIDGET(g_section_menuitem), 0);
  gtk_widget_set_sensitive(GTK_WIDGET(g_insert_menuitem), 0);
  gtk_widget_set_sensitive(GTK_WIDGET(g_break_menuitem), 0);
  gtk_widget_hide(GTK_WIDGET(g_view_menuitem));
  gtk_widget_hide(GTK_WIDGET(g_section_menuitem));
  gtk_widget_hide(GTK_WIDGET(g_insert_menuitem));
  gtk_widget_hide(GTK_WIDGET(g_break_menuitem));

  return;
}

extern void
menu_label_set_defaults()
{

  gtk_widget_set_sensitive(GTK_WIDGET(g_view_menuitem), 1);
  gtk_widget_set_sensitive(GTK_WIDGET(g_section_menuitem), 0);
  gtk_widget_set_sensitive(GTK_WIDGET(g_insert_menuitem), 1);
  gtk_widget_set_sensitive(GTK_WIDGET(g_break_menuitem), 0);
  gtk_widget_show(GTK_WIDGET(g_view_menuitem));
  gtk_widget_hide(GTK_WIDGET(g_section_menuitem));
  gtk_widget_show(GTK_WIDGET(g_insert_menuitem));
  gtk_widget_hide(GTK_WIDGET(g_break_menuitem));

  gtk_check_menu_item_set_active(g_highlight_menuitem, 0);
  gtk_check_menu_item_set_active(g_ruleline_horizontal_menuitem, 0);
  gtk_check_menu_item_set_active(g_ruleline_vertical_menuitem, 0);

  return;
}

extern void
menu_layout_set_defaults()
{

  gtk_widget_set_sensitive(GTK_WIDGET(g_view_menuitem), 1);
  gtk_widget_set_sensitive(GTK_WIDGET(g_section_menuitem), 1);
  gtk_widget_set_sensitive(GTK_WIDGET(g_insert_menuitem), 1);
  gtk_widget_set_sensitive(GTK_WIDGET(g_break_menuitem), 1);
  gtk_widget_show(GTK_WIDGET(g_view_menuitem));
  gtk_widget_show(GTK_WIDGET(g_section_menuitem));
  gtk_widget_show(GTK_WIDGET(g_insert_menuitem));
  gtk_widget_show(GTK_WIDGET(g_break_menuitem));

  gtk_check_menu_item_set_active(g_highlight_menuitem, 0);
  gtk_check_menu_item_set_active(g_ruleline_horizontal_menuitem, 0);
  gtk_check_menu_item_set_active(g_ruleline_vertical_menuitem, 0);

  return;
}

extern void
menu_layout_set_sections(
  struct layout const*const             i_layout)
{

  gtk_check_menu_item_set_active(
    g_coverheader_menuitem,
    ((*i_layout).m_cover.m_header.m_page ? 1 : 0));

  gtk_check_menu_item_set_active(
    g_coverfooter_menuitem,
    ((*i_layout).m_cover.m_footer.m_page ? 1 : 0));

  gtk_check_menu_item_set_active(
    g_reportheader_menuitem,
    ((*i_layout).m_report.m_header.m_page ? 1 : 0));

  gtk_check_menu_item_set_active(
    g_reportdetail_menuitem,
    ((*i_layout).m_report.m_detail.m_page ? 1 : 0));

  gtk_check_menu_item_set_active(
    g_reportfooter_menuitem,
    ((*i_layout).m_report.m_footer.m_page ? 1 : 0));

  return;
}
