/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015-2016, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "item_fbarcode.h"

extern void
item_fbarcode_assign(
  struct item_fbarcode*const            o_fbarcode,
  struct item_method*const              o_method)
{

  memset(o_fbarcode, 0, sizeof(*o_fbarcode));

  (*o_fbarcode).m_len_x= 30.0;
  (*o_fbarcode).m_len_y= 18.0;
  (*o_fbarcode).m_scale= 1.0;

  ITEM_METHOD_ASSIGN(o_method, fbarcode);

  return;
}

extern void
item_fbarcode_discharge(
  struct item_fbarcode*const            io_fbarcode)
{

  if ((*io_fbarcode).m_value)
  {
    g_free((*io_fbarcode).m_value);
  }

  memset(io_fbarcode, 0, sizeof(*io_fbarcode));

  return;
}

extern void
item_fbarcode_draw_design(
  struct item_fbarcode*const            i_fbarcode,
  struct item_draw_context const*const  i_ctx)
{

  item_common_box_draw_hightlight(
    (*i_ctx).m_cr, 
    (struct geom_rect*)i_fbarcode,
    1.0);

  if ((*i_ctx).m_selected)
  {
    item_common_box_draw_grips((*i_ctx).m_cr, (struct geom_rect*)i_fbarcode);
  }

  return;
}

extern void
item_fbarcode_draw(
  struct item_fbarcode*const            i_fbarcode,
  struct item_draw_context const*const  i_ctx)
{
  struct symbology                      l_symbology;

  do
  {

    if (item_draw_design == (*i_ctx).m_option.m_type)
    {
      item_fbarcode_draw_design(i_fbarcode, i_ctx);
      break;
    }

    if (0 == (*i_fbarcode).m_value || 0 == (*i_fbarcode).m_value_size)
    {
      break;
    }

    memset(&l_symbology, 0, sizeof(l_symbology));
    
    l_symbology.m_barcode= (*i_fbarcode).m_barcode;
    l_symbology.m_scale= (*i_fbarcode).m_scale;

    symbology_encode(
      (*i_ctx).m_cr,
      &l_symbology,
      (*i_fbarcode).m_pos_x,
      (*i_fbarcode).m_pos_y,
      (unsigned char*)(*i_fbarcode).m_value,
      (*i_fbarcode).m_value_size);

  }while(0);

  return;
}

extern void
item_fbarcode_get_bbox(
  struct geom_rect*const                o_bbox,
  void const*const                      i_object)
{
  (*o_bbox)= *(struct geom_rect*)i_object;
  return;
}

extern void
item_fbarcode_in_event(
  enum event_type*const                 o_type,
  struct item_fbarcode const*const      i_fbarcode,
  struct item_in_event const*const      i_ctx)
{

  item_common_box_in_event(o_type, i_ctx, (struct geom_rect*)i_fbarcode);

  return;
}

extern void
item_fbarcode_move(
  struct item_fbarcode*const            io_fbarcode,
  struct geom_point const*const         i_event)
{
  item_common_box_move((struct geom_rect*)io_fbarcode, i_event);
  return;
}

extern void
item_fbarcode_normalize(
  struct item_fbarcode*const            io_fbarcode,
  double const                          i_bound_width,
  double const                          i_bound_height)
{
  item_common_box_normalize(
    (struct geom_rect*)io_fbarcode, 
    i_bound_width,
    i_bound_height);
  return;

}

extern int
item_fbarcode_read(
  GError**                              o_error,
  struct item_fbarcode*const            io_fbarcode,
  struct xml *const                     i_xml)
{
  GError*                               l_error;
  int                                   l_exit;
  int                                   l_found;
  GList*                                l_node;
  enum element_tag_type                 l_type;
  char const*                           l_value;
  struct xml*                           l_xml;

  l_error= 0;
  l_exit= 0;

  l_node= (*i_xml).m_children;

  do
  {

    if (0 == l_node)
    {
      break;
    }

    l_xml= (*l_node).data;

    item_common_lookup(&l_found, &l_type, (*l_xml).m_tag);
    g_strstrip((*l_xml).m_string->str);
    l_value= (*l_xml).m_string->str;

    if (l_found)
    {
      switch(l_type)
      {
        case element_tag_pos_x:
          (*io_fbarcode).m_pos_x= xml_convert_double(l_value);
          break;
        case element_tag_pos_y:
          (*io_fbarcode).m_pos_y= xml_convert_double(l_value);
          break;
        case element_tag_len_x:
          (*io_fbarcode).m_len_x= xml_convert_double(l_value);
          break;
        case element_tag_len_y:
          (*io_fbarcode).m_len_y= xml_convert_double(l_value);
          break;
        case element_tag_type:
          (*io_fbarcode).m_barcode= xml_convert_ulong(l_value);
          break;
        case element_tag_scale:
          (*io_fbarcode).m_scale= xml_convert_double(l_value);
          break;
        case element_tag_tag:
          g_strlcpy((*io_fbarcode).m_tag, l_value, sizeof((*io_fbarcode).m_tag));
          break;
        default:
          break;
      }
    }

    l_node= (*l_node).next;

  }while(1);

  if (l_error)
  {
    g_propagate_error(o_error, l_error);
  }

  return l_exit;
}

extern void
item_fbarcode_resize(
  struct item_fbarcode*const            io_fbarcode,
  struct item_resize_event const*const  i_ctx)
{

  item_common_box_resize((struct geom_rect *)io_fbarcode, i_ctx);

  return;
}

extern int
item_fbarcode_write(
  GError**                              o_error,
  FILE*const                            io_fp,
  struct item_fbarcode const*const      i_fbarcode)
{
  char                                  l_buf[G_ASCII_DTOSTR_BUF_SIZE+1];
  int                                   l_exit;

  l_exit= 0;
  fprintf(io_fp, "\t\t\t<item name=\"fbarcode\">\n");
  fprintf(io_fp, "\t\t\t\t<pos_x>%s</pos_x>\n", g_ascii_dtostr(l_buf, sizeof(l_buf), (*i_fbarcode).m_pos_x));
  fprintf(io_fp, "\t\t\t\t<pos_y>%s</pos_y>\n", g_ascii_dtostr(l_buf, sizeof(l_buf), (*i_fbarcode).m_pos_y));
  fprintf(io_fp, "\t\t\t\t<len_x>%s</len_x>\n", g_ascii_dtostr(l_buf, sizeof(l_buf), (*i_fbarcode).m_len_x));
  fprintf(io_fp, "\t\t\t\t<len_y>%s</len_y>\n", g_ascii_dtostr(l_buf, sizeof(l_buf), (*i_fbarcode).m_len_y));
  fprintf(io_fp, "\t\t\t\t<type>%d</type>\n", (*i_fbarcode).m_barcode);
  fprintf(io_fp, "\t\t\t\t<scale>%s</scale>\n", g_ascii_dtostr(l_buf, sizeof(l_buf), (*i_fbarcode).m_scale));

  if ((*i_fbarcode).m_tag && (*i_fbarcode).m_tag[0])
  {
    fprintf(io_fp, "\t\t\t\t<tag>%s</tag>\n", (*i_fbarcode).m_tag);
  }

  fprintf(io_fp, "\t\t\t</item>\n");

  return l_exit;
}
