/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "item_common_line.h"

extern int
item_common_line_in_event(
  struct item_in_event const*const      i_ctx,
  struct geom_line const*const          i_line)
{
  gdouble                               l_angle;
  gdouble                               l_angle_abs;
  gdouble                               l_delta;
  int                                   l_hit;
  gdouble                               l_intercept;
  gdouble                               l_len_x;
  gdouble                               l_len_y;
  gdouble                               l_pos_x1;
  gdouble                               l_pos_x2;
  gdouble                               l_pos_y1;
  gdouble                               l_pos_y2;
  gdouble                               l_pt;
  gdouble                               l_slope;

  l_hit= 0;

  if ((*i_line).m_pos_x1 < (*i_line).m_pos_x2)
  {
    l_pos_x1= (*i_ctx).m_scale * (*i_line).m_pos_x1;
    l_pos_x2= (*i_ctx).m_scale * (*i_line).m_pos_x2;
  }
  else
  {
    l_pos_x1= (*i_ctx).m_scale * (*i_line).m_pos_x2;
    l_pos_x2= (*i_ctx).m_scale * (*i_line).m_pos_x1;
  }

  if ((*i_line).m_pos_y1 < (*i_line).m_pos_y2)
  {
    l_pos_y1= (*i_ctx).m_scale * (*i_line).m_pos_y1;
    l_pos_y2= (*i_ctx).m_scale * (*i_line).m_pos_y2;
  }
  else
  {
    l_pos_y1= (*i_ctx).m_scale * (*i_line).m_pos_y2;
    l_pos_y2= (*i_ctx).m_scale * (*i_line).m_pos_y1;
  }

  do
  {

    if ((*i_ctx).m_event.m_pos_x < l_pos_x1 - 4.0)
    {
      break;
    }

    if ((*i_ctx).m_event.m_pos_x > l_pos_x2 + 4.0)
    {
      break;
    }

    if ((*i_ctx).m_event.m_pos_y < l_pos_y1 - 4.0)
    {
      break;
    }

    if ((*i_ctx).m_event.m_pos_y > l_pos_y2 + 4.0)
    {
      break;
    }

    l_len_x= (*i_line).m_pos_x2 - (*i_line).m_pos_x1;
    l_len_x*= (*i_ctx).m_scale;
    l_len_y= (*i_line).m_pos_y2 - (*i_line).m_pos_y1;
    l_len_y*= (*i_ctx).m_scale;
    l_angle= atan2(l_len_y, l_len_x) * 180 / G_PI;
    l_angle_abs= fabs(l_angle);

    if ((0.0 >= l_angle_abs && 4.0 >= l_angle_abs) || 
      (86.0 <= l_angle_abs && 94.0 >= l_angle_abs) ||
      (176.0 <= l_angle_abs && 184.0 >= l_angle_abs))
    {
      l_hit= 1;
      break;
    }

    l_slope= l_len_y / l_len_x;
    l_intercept= ((*i_ctx).m_scale * (*i_line).m_pos_y1) - l_slope * ((*i_ctx).m_scale * (*i_line).m_pos_x1);
    l_pt= l_slope * (*i_ctx).m_event.m_pos_x + l_intercept;
    l_delta= fabs(l_pt - (*i_ctx).m_event.m_pos_y);
    l_hit= l_delta < 3.0;

  }while(0);

  return l_hit;
}
