/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
#include "icu.h"
#include <time.h>
#include <stdio.h>

int
main (int argc, char *argv[])
{
  char *l_text;
  time_t l_time;

  l_time = time (0);

  icu_date_to_textual(
    &l_text,
    l_time, 
    date_style_full, 
    date_style_full,
		0,
    0);

  printf ("%s\n", l_text);
  free (l_text);
  l_text= 0;

  icu_date_to_textual(
    &l_text,
    l_time, 
    date_style_full, 
    date_style_full,
    "de_DE.UTF-8",
    "Europe/Luxembourg");

  printf ("%s\n", l_text);
  free (l_text);

  icu_double_to_textual(&l_text, 123456789.919999, "en_US.UTF-8");
  printf ("%s\n", l_text);
  free (l_text);

  icu_double_to_textual(&l_text, 0.00999999, "en_US.UTF-8");
  printf ("%s\n", l_text);
  free (l_text);

  return 0;
}
