/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __icu_h__

#include <locale.h>
#include <math.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

enum date_style_type
{
  date_style_none= 0,
  date_style_short,
  date_style_medium,
  date_style_long,
  date_style_full
};

#ifdef __cplusplus
extern "C" {
#endif

extern int
icu_double_to_textual(
  char**                                o_text,
  double const                          i_number,
  char const*                           i_locale);

extern int
icu_date_to_textual(
  char**                                o_text,
  time_t const                          i_time,
  enum date_style_type const            i_date_style,
  enum date_style_type const            i_time_style,
  char const*                           i_locale,
  char const*                           i_timezone);

extern int
icu_double_to_locale(
  char**                                o_text,
  char const*                           i_number,
  char const*                           i_locale,
  unsigned const                        i_fractions,
  char const*                           i_pattern);

extern int
icu_integer_to_locale(
  char**                                o_text,
  char const*                           i_number,
  char const*                           i_locale,
  char const*                           i_pattern);

extern int
icu_monetary_to_locale(
  char**                                o_text,
  char const*                           i_amount,
  char const*                           i_locale);

#ifdef __cplusplus
}
#endif

#define __icu_h__
#endif
