/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "geom_line.h"

extern double
geom_line_get_rotation(
  struct geom_line const*const          i_line)
{
  double                                l_delta_x;
  double                                l_delta_y;
  double                                l_rotation;

  l_delta_x= (*i_line).m_pos_x2 - (*i_line).m_pos_x1;
  l_delta_y= (*i_line).m_pos_y2 - (*i_line).m_pos_y1;
  l_rotation= atan2(l_delta_y, l_delta_x) * 180 / G_PI;

  return l_rotation;
}

extern double
geom_line_length(
  struct geom_line const*const          i_line)
{
  double                                l_len;
  double                                l_len_x;
  double                                l_len_y;

  l_len_x= fabs((*i_line).m_pos_x2 - (*i_line).m_pos_x1);
  l_len_y= fabs((*i_line).m_pos_y2 - (*i_line).m_pos_y1);
  l_len= sqrt((l_len_x*l_len_x) + (l_len_y*l_len_y));

  return l_len;
}

extern void
geom_line_rotate(
  struct geom_line*const                io_line,
  double const                          i_degrees)
{
  double                                l_radians;
  double                                l_adjust_x;
  double                                l_adjust_y;
  double                                l_cos;
  struct geom_line                      l_origin;
  struct geom_line                      l_prime;
  double                                l_sin;

  l_adjust_x= (*io_line).m_pos_x1;
  l_adjust_y= (*io_line).m_pos_y1;

  l_origin.m_pos_x1= 0.0;
  l_origin.m_pos_y1= 0.0;
  l_origin.m_pos_x2= (*io_line).m_pos_x2 - l_adjust_x;
  l_origin.m_pos_y2= (*io_line).m_pos_y2 - l_adjust_y;

  l_radians= geom_deg2rad(i_degrees);
  l_cos= cos(l_radians);
  l_sin= sin(l_radians);

  l_prime.m_pos_x1= (l_origin.m_pos_x1 * l_cos) - (l_origin.m_pos_y1 * l_sin);
  l_prime.m_pos_y1= (l_origin.m_pos_x1 * l_sin) + (l_origin.m_pos_y1 * l_cos);
  l_prime.m_pos_x2= (l_origin.m_pos_x2 * l_cos) - (l_origin.m_pos_y2 * l_sin);
  l_prime.m_pos_y2= (l_origin.m_pos_x2 * l_sin) + (l_origin.m_pos_y2 * l_cos);

  (*io_line).m_pos_x1= l_prime.m_pos_x1 + l_adjust_x;
  (*io_line).m_pos_y1= l_prime.m_pos_y1 + l_adjust_y;
  (*io_line).m_pos_x2= l_prime.m_pos_x2 + l_adjust_x;
  (*io_line).m_pos_y2= l_prime.m_pos_y2 + l_adjust_y;

  return;
}
