/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015-2016, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "export.h"

struct page_setup_dialog
{
  GtkCheckButton*                       m_print_header_checkbutton;
};

static int
page_setup_bind(
  struct page_setup_dialog*const        io_pd,
  GtkBuilder*const                      i_builder)
{
  int                                   l_exit;

  l_exit= 0;

  do
  {

    (*io_pd).m_print_header_checkbutton= GTK_CHECK_BUTTON(
      gtk_builder_get_object(i_builder, "print_header_checkbutton"));

  }while(0);

  return l_exit;
}

static void
page_setup_set_values(
  struct page_setup_dialog*const        io_pd,
  struct exports const*const            i_export)
{

  gtk_toggle_button_set_active(
    GTK_TOGGLE_BUTTON((*io_pd).m_print_header_checkbutton),
      (*i_export).m_config.m_print_header);

  return;
}

static void
page_setup_copy_values(
  struct exports *const                 io_export,
  struct page_setup_dialog const*const  i_pd)
{

  (*io_export).m_config.m_print_header=
    gtk_toggle_button_get_active(
      GTK_TOGGLE_BUTTON((*i_pd).m_print_header_checkbutton));

  return;
}

extern int
export_page_setup_property(
  struct exports*const                  io_export)
{
  struct page_setup_dialog              l_pd;
  GtkBuilder*                           l_builder;
  GtkDialog*                            l_dialog;
  GError*                               l_error;
  int                                   l_exit;
  int                                   l_rc;

  l_builder= 0;
  l_dialog= 0;
  l_error= 0;
  l_exit= 0;
  memset(&l_pd, 0, sizeof(l_pd));

  do
  {

    l_builder= gtk_builder_new();

    l_rc= wrap_gtk_builder_add_from_file(
      l_builder,
      "export_page_setup.glade",
      &l_error);

    if (0 == l_rc)
    {
      l_exit= -1;
      break;
    }

    l_dialog= (GtkDialog*)gtk_builder_get_object(l_builder, "page_setup_dialog");

    if (0 == l_dialog)
    {
      l_error= g_error_new(
        GENERAL,
        GENERIC,
        "Unable to find dialog object: 'page_setup_dialog'");
      l_exit= -1;
      break;
    }

    page_setup_bind(&l_pd, l_builder);
    page_setup_set_values(&l_pd, io_export);

    gtk_window_set_transient_for(GTK_WINDOW(l_dialog), get_main_window());
    gtk_widget_show_all(GTK_WIDGET(l_dialog));
    gtk_window_set_modal(GTK_WINDOW(l_dialog), 1);

    gtk_widget_grab_focus(gtk_dialog_get_widget_for_response(
      GTK_DIALOG(l_dialog), GTK_RESPONSE_OK));

    l_exit= gtk_dialog_run(l_dialog);

    if (GTK_RESPONSE_OK != l_exit) 
    {
      break;
    }

    page_setup_copy_values(io_export, &l_pd);

  }while(0);

  if (l_builder)
  {
    g_object_unref(l_builder);
  }

  if (l_error)
  {
    _error_log(l_error);
    _error_display_prompt(l_error);
  }

  g_clear_error(&l_error);

  if (l_dialog)
  {
    gtk_widget_destroy(GTK_WIDGET(l_dialog));
  }

  return l_exit;
}
