/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2015, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "barsym.h"

static char const* g_encode[10]= {
/*0 NNWWN */ "10101110111010",
/*1 WNNNW */ "11101010101110",
/*2 NWNNW */ "10111010101110",
/*3 WWNNN */ "11101110101010",
/*4 NNWNW */ "10101110101110",
/*5 WNWNN */ "11101011101010",
/*6 NWWNN */ "10111011101010",
/*7 NNNWW */ "10101011101110",
/*8 WNNWN */ "11101010111010",
/*9 NWNWN */ "10111010111010"
};

extern void
barsym_standard2of5(
  struct barsym*const                   io_barsym,
  char const*                           i_digits)
{
  double                                l_center;
  unsigned                              l_digit;
  char const*                           l_encode;
  cairo_text_extents_t                  l_extent;
  unsigned                              l_length;
  char const*                           l_ptr;

  l_length= 0;
  l_ptr= i_digits;

  (*io_barsym).m_pos_x+= (*io_barsym).m_quiet_zone_left;
  barsym_write_bar(io_barsym, "11011010", BARSYM_GUARD);

  do
  {

    if (0 == l_ptr[0])
    {
      break;
    }

    l_digit= l_ptr[0] - 0x30;
    l_encode= g_encode[l_digit];
    barsym_write_bar(io_barsym, l_encode, 0);

    l_ptr++;
    l_length++;

  }while(1);

  barsym_write_bar(io_barsym, "11010110", BARSYM_GUARD);
  (*io_barsym).m_pos_x+= (*io_barsym).m_quiet_zone_right;

  cairo_text_extents((*io_barsym).m_cr, i_digits, &l_extent);
  l_center= ((*io_barsym).m_pos_x / 2.0) - (l_extent.width / 2.0);

  cairo_move_to((*io_barsym).m_cr, l_center, (*io_barsym).m_height);
  cairo_show_text((*io_barsym).m_cr, i_digits);

  return;
}

extern double
barsym_standard2of5_get_width(
  struct barsym*const                   io_barsym,
  char const*                           i_digits)
{
  double                                l_width;

  l_width= (*io_barsym).m_quiet_zone_left;
  l_width+= (*io_barsym).m_quiet_zone_right;
  l_width+= ((2+strlen(i_digits)) * (*io_barsym).m_bar_width * 14.0);

  return l_width;
}

extern int
barsym_standard2of5_verify(
  char const*                           i_digits)
{
  int                                   l_exit;

  l_exit= barsym_verify_digits(i_digits, strlen(i_digits));

  return l_exit;
}
