/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2015, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "barsym_code39.h"

char const* g_encode_start_stop=        "100101101101" /* '*' */;

extern void
barsym_code39(
  struct barsym*const                   io_barsym,
  unsigned char const*                  i_buffer,
  unsigned const                        i_length)
{
  double                                l_center;
  char const*                           l_encode;
  cairo_text_extents_t                  l_extent;
  unsigned char*                        l_filter;
  unsigned                              l_position;
  unsigned char const*                  l_ptr;

  l_position= 0;
  l_ptr= i_buffer;

  (*io_barsym).m_pos_x+= (*io_barsym).m_quiet_zone_left;
  
  barsym_write_bar(io_barsym, g_encode_start_stop, BARSYM_GUARD);
  (*io_barsym).m_pos_x+= (*io_barsym).m_bar_width;

  do
  {

    if (i_length <= l_position)
    {
      break;
    }

    l_encode= barsym_code39_encode(l_ptr[0]);
    barsym_write_bar(io_barsym, l_encode, 0);
    (*io_barsym).m_pos_x+= (*io_barsym).m_bar_width;

    l_ptr++;
    l_position++;

  }while(1);

  barsym_write_bar(io_barsym, g_encode_start_stop, BARSYM_GUARD);

  l_filter= barsym_filter(i_buffer, i_length);
  cairo_text_extents((*io_barsym).m_cr, (char*)l_filter, &l_extent);
  l_center= ((*io_barsym).m_pos_x / 2.0) - (l_extent.width / 2.0);

  cairo_move_to((*io_barsym).m_cr, l_center, (*io_barsym).m_height);
  cairo_show_text((*io_barsym).m_cr, (char*)l_filter);
  free(l_filter);

  return;
}

extern double
barsym_code39_get_width(
  struct barsym*const                   io_barsym,
  unsigned char const*                  i_buffer,
  unsigned const                        i_length)
{
  double                                l_width;

  l_width= (*io_barsym).m_quiet_zone_left;
  l_width+= (*io_barsym).m_quiet_zone_right;
  l_width+= ((2+i_length) * (*io_barsym).m_bar_width * 12.0);
  l_width+= (i_length * (*io_barsym).m_bar_width);

  return l_width;
}

extern int
barsym_code39_verify(
  unsigned char const*                  i_buffer,
  unsigned const                        i_length)
{
  char const*                           l_encode;
  int                                   l_exit;
  unsigned char const*                  l_ptr;
  unsigned                              l_slot;

  l_exit= 0;
  l_ptr= i_buffer;
  l_slot= 0;

  do
  {

    if (i_length <= l_slot)
    {
      break;
    }

    l_encode= barsym_code39_encode(*l_ptr);

    if (0 == l_encode)
    {
      l_exit= -1;
      break;
    }

    l_ptr++;
    l_slot++;

  }while(1);

  return l_exit;
}
