/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2015, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "barsym.h"

extern unsigned char*
barsym_filter(
  unsigned char const*                  i_buffer,
  unsigned const                        i_length)
{
  unsigned                              l_slot;
  unsigned char const*                  l_src;
  unsigned char*                        l_text;
  unsigned char*                        l_tgt;

  l_text= (unsigned char*)malloc(1+i_length);
  l_src= i_buffer;
  l_tgt= l_text;
  
  for (l_slot= 0; i_length > l_slot; l_slot++)
  {
    
    if ((0x20 <= *l_src) && (0x7F != *l_src))
    {
      *l_tgt= *l_src;
    }
    else
    {
      *l_tgt= 0x20;
    }

    l_src++;
    l_tgt++;
  }

  *l_tgt= 0;

  return l_text;
}

extern void
barsym_set_font(
  struct barsym*const                   io_barsym)
{

  cairo_set_source_rgb((*io_barsym).m_cr, 0.0, 0.0, 0.0);
  cairo_set_font_size((*io_barsym).m_cr, BARSYM_FONT_SIZE);
  cairo_select_font_face(
    (*io_barsym).m_cr,
    "Serif",
    CAIRO_FONT_SLANT_NORMAL,
    CAIRO_FONT_WEIGHT_NORMAL);

  return;
}

extern int
barsym_verify_digits(
  char const*                           i_digits,
  unsigned const                        i_length)
{
  int                                   l_exit;
  char const*                           l_ptr;
  unsigned                              l_slot;

  l_exit= 0;
  l_ptr= i_digits;
  l_slot= 0;

  do
  {

    if (i_length <= l_slot)
    {
      break;
    }

    if (!isdigit(*l_ptr))
    {
      l_exit= -1;
      break;
    }

    l_ptr++;
    l_slot++;

  }while(1); 

  return l_exit;
}

extern void
barsym_write_bar(
  struct barsym*const                   io_barsym,
  char const*                           i_encode,
  int const                             i_flags)
{
  char const*                           l_ptr;
  double                                l_line_height;

  l_ptr= &i_encode[0];

  cairo_set_source_rgb((*io_barsym).m_cr, 0.0, 0.0, 0.0);
  cairo_set_line_width((*io_barsym).m_cr, (*io_barsym).m_bar_width);

  if (0 == (BARSYM_GUARD & i_flags))
  {
    l_line_height= (*io_barsym).m_bar_height;
  }
  else
  {
    l_line_height= (*io_barsym).m_guard_height;
  }

  do
  {

    if (0 == (*l_ptr))
    {
      break;
    }

    if ('1' == (*l_ptr))
    {
      cairo_move_to(
        (*io_barsym).m_cr, 
        (*io_barsym).m_pos_x, 
        (*io_barsym).m_pos_y);

      cairo_line_to(
        (*io_barsym).m_cr,
        (*io_barsym).m_pos_x,
        l_line_height);

      cairo_stroke((*io_barsym).m_cr);
    }

    (*io_barsym).m_pos_x+= (*io_barsym).m_bar_width;
    l_ptr++;

  }while(1); 
  
  return;
}
