/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "orcl.hpp"

extern int
iwsql_next(
  char**                                o_error,
  int*const                             o_eof,
  struct orcl *const                    io_oracle)
{
  int                                   l_exit= 0;
  oracle::occi::ResultSet::Status       l_status;
  unsigned                              l_slot;
  struct iwsql_attr*                    l_attr;
  std::string                           l_value;
  int                                   l_length;

  (*o_error)= 0;
  (*o_eof)= 0;

  do
  {

    l_status= (*io_oracle).m_rs->status();

    if ((oracle::occi::ResultSet::END_OF_FETCH == l_status) || 
      (oracle::occi::ResultSet::END_OF_FETCH == (*io_oracle).m_rs->next()))
    {
      (*o_eof)= 1;
      break;
    }

    l_attr= (*io_oracle).m_attr;

    for (l_slot= 0; (*io_oracle).m_attr_slots > l_slot; l_slot++)
    {

      if ((*l_attr).m_value)
      {
        free((*l_attr).m_value);
        (*l_attr).m_value= 0;
      }

      try
      {
        l_value= (*io_oracle).m_rs->getString(1+l_slot);
        l_length= l_value.length();
        if (l_length)
        {
          (*l_attr).m_value= (char*)malloc(1+l_length);
          memset((*l_attr).m_value, 0, 1+l_length);
          memcpy((*l_attr).m_value, l_value.c_str(), l_length);
          (*l_attr).m_size= l_length;
        }
      } 
      catch(std::exception excp)
      {
        // TODO:
      }
      l_attr++;
    }

  }while(0);

  return l_exit;
}
