/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2015, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "ruler_wrap.h"
#include "mainw.h"

#define RULER_DEFAULT_WIDTH 18.0
#define NOTEBOOK_HEIGHT 32.0

extern void
ruler_wrap_add_track_widget(
  GtkWidget*                            io_widget)
{

  g_signal_connect_swapped (
    io_widget,
    "motion-notify-event",
    G_CALLBACK(ruler_motion_notify),
    (*g_mainw).m_ruler.m_top.m_ruler);

  g_signal_connect_swapped (
    io_widget,
    "motion-notify-event",
    G_CALLBACK(ruler_motion_notify),
    (*g_mainw).m_ruler.m_left.m_ruler);

  return;
}

extern void
ruler_wrap_adjust_allocate(
  double const                          i_pos_x,
  double const                          i_pos_y)
{

  gtk_widget_set_size_request(
    GTK_WIDGET((*g_mainw).m_ruler.m_top.m_frame_left),
    RULER_DEFAULT_WIDTH+i_pos_x,
    RULER_DEFAULT_WIDTH);

  gtk_widget_set_size_request(
    GTK_WIDGET((*g_mainw).m_ruler.m_left.m_frame_top),
    0,
    i_pos_y);

  return;
}

extern void
ruler_wrap_adjust_paper(
  GtkPageSetup const*const              i_page_setup)
{
  struct paper                          l_paper;

  paper_set_from_page_setup(&l_paper, i_page_setup);

  ruler_set_paper_length((*g_mainw).m_ruler.m_top.m_ruler, l_paper.m_width);
  ruler_set_margin(
    (*g_mainw).m_ruler.m_top.m_ruler,
    l_paper.m_margin_left,
    l_paper.m_margin_right);

  ruler_set_paper_length((*g_mainw).m_ruler.m_left.m_ruler, l_paper.m_height);
  ruler_set_margin(
    (*g_mainw).m_ruler.m_left.m_ruler,
    l_paper.m_margin_top,
    l_paper.m_margin_bottom);

  return;
}

extern void
ruler_wrap_assign(
  struct ruler*const                    o_ruler)
{

  memset(o_ruler, 0, sizeof(*o_ruler));

  return;
}

extern void
ruler_wrap_discharge(
  struct ruler*const                    io_ruler)
{

  memset(io_ruler, 0, sizeof(*io_ruler));

  return;
}

static void
ruler_wrap_margin_changed(
  Ruler*                                i_ruler, 
  gpointer*                             i_user)
{
#if 0
  gdouble                               l_margin_bottom;
  gdouble                               l_margin_left;
  gdouble                               l_margin_right;
  gdouble                               l_margin_top;
  GList*                                l_node;
  struct section*                       l_section;

  ruler_get_margin(
    (*g_mainw).m_ruler.m_top.m_ruler,
    &l_margin_left,
    &l_margin_right);

  gtk_page_setup_set_left_margin(
    (*g_mainw).m_report.m_object.m_part.m_config.m_page_setup,
    l_margin_left,
    GTK_UNIT_INCH);

  gtk_page_setup_set_right_margin(
    (*g_mainw).m_report.m_object.m_part.m_config.m_page_setup,
    l_margin_right,
    GTK_UNIT_INCH);

  ruler_get_margin(
    (*g_mainw).m_ruler.m_left.m_ruler,
    &l_margin_top,
    &l_margin_bottom);

  gtk_page_setup_set_top_margin(
    (*g_mainw).m_report.m_object.m_part.m_config.m_page_setup,
    l_margin_top,
    GTK_UNIT_INCH);

  gtk_page_setup_set_bottom_margin(
    (*g_mainw).m_report.m_object.m_part.m_config.m_page_setup,
    l_margin_bottom,
    GTK_UNIT_INCH);

  l_node= (*g_mainw).m_report.m_object.m_part.m_section_list;

  do
  {

    if (0 == l_node)
    {
      break;
    }

    l_section= (struct section*)(*l_node).data;

    iwr_page_set_paper(
      (*l_section).m_page,
      (*g_mainw).m_report.m_object.m_part.m_config.m_page_setup);

    l_node= (*l_node).next;

  }while(1);
#endif
  return;
}

extern void
ruler_wrap_create(
  struct ruler*const                    io_ruler,
  GtkBuilder*const                      i_builder)
{
  GtkGrid*                              l_grid;
  GValue                                l_value;

  do
  {
    /* top ruler */
    (*io_ruler).m_top.m_ruler= RULER(ruler_new(GTK_ORIENTATION_HORIZONTAL));
    gtk_widget_set_size_request(GTK_WIDGET((*io_ruler).m_top.m_ruler), -1, RULER_DEFAULT_WIDTH);
    ruler_set_paper_length((*io_ruler).m_top.m_ruler, PAPER_DEFAULT_WIDTH);
    ruler_set_margin((*io_ruler).m_top.m_ruler, PAPER_DEFAULT_MARGIN, PAPER_DEFAULT_MARGIN);

    (*io_ruler).m_top.m_box= GTK_BOX(gtk_box_new(GTK_ORIENTATION_HORIZONTAL, 0));
    (*io_ruler).m_top.m_frame_left= GTK_FRAME(gtk_frame_new(0));
    gtk_widget_set_size_request(GTK_WIDGET((*io_ruler).m_top.m_frame_left), RULER_DEFAULT_WIDTH, RULER_DEFAULT_WIDTH);
    (*io_ruler).m_top.m_frame_right= GTK_FRAME(gtk_frame_new(0));
    gtk_widget_set_size_request(GTK_WIDGET((*io_ruler).m_top.m_frame_right), 0, 0);

    gtk_box_pack_start((*io_ruler).m_top.m_box, GTK_WIDGET((*io_ruler).m_top.m_frame_left), 0, 0, 0);
    gtk_box_pack_start((*io_ruler).m_top.m_box, GTK_WIDGET((*io_ruler).m_top.m_ruler), 1, 1, 0);
    gtk_box_pack_end((*io_ruler).m_top.m_box, GTK_WIDGET((*io_ruler).m_top.m_frame_right), 0, 0, 0);

    l_grid= GTK_GRID(gtk_builder_get_object(i_builder, "grid1"));
    gtk_grid_attach(l_grid, GTK_WIDGET((*io_ruler).m_top.m_box), 0, 2, 1, 1);

    /* left ruler */
    (*io_ruler).m_left.m_ruler= RULER(ruler_new(GTK_ORIENTATION_VERTICAL));
    gtk_widget_set_size_request(GTK_WIDGET((*io_ruler).m_left.m_ruler), RULER_DEFAULT_WIDTH, -1);
    ruler_set_paper_length((*io_ruler).m_left.m_ruler, PAPER_DEFAULT_HEIGHT);
    ruler_set_margin((*io_ruler).m_left.m_ruler, PAPER_DEFAULT_MARGIN, PAPER_DEFAULT_MARGIN);

    (*io_ruler).m_left.m_box= GTK_BOX(gtk_box_new(GTK_ORIENTATION_VERTICAL, 0));

    (*io_ruler).m_left.m_frame_top= GTK_FRAME(gtk_frame_new(0));
    gtk_box_pack_start((*io_ruler).m_left.m_box, GTK_WIDGET((*io_ruler).m_left.m_frame_top), 0, 0, 0);
    gtk_widget_set_size_request(GTK_WIDGET((*io_ruler).m_left.m_frame_top), 0, 0);

    gtk_box_pack_start((*io_ruler).m_left.m_box, GTK_WIDGET((*io_ruler).m_left.m_ruler), 1, 1, 0);

    (*io_ruler).m_left.m_frame_bottom= GTK_FRAME(gtk_frame_new(0));
    gtk_widget_set_size_request(GTK_WIDGET((*io_ruler).m_left.m_frame_bottom), RULER_DEFAULT_WIDTH, NOTEBOOK_HEIGHT);
    gtk_box_pack_end((*io_ruler).m_left.m_box, GTK_WIDGET((*io_ruler).m_left.m_frame_bottom), 0, 0, 0);

    l_grid= GTK_GRID(gtk_builder_get_object(i_builder, "grid2"));
    gtk_grid_attach(l_grid, GTK_WIDGET((*io_ruler).m_left.m_box), 0, 0, 1, 1);

    memset(&l_value, 0, sizeof(l_value));
    g_value_init(&l_value, G_TYPE_INT);
    g_value_set_int(&l_value, GTK_SHADOW_NONE);

    g_object_set_property(G_OBJECT((*io_ruler).m_top.m_frame_left), "shadow-type", &l_value);
    g_object_set_property(G_OBJECT((*io_ruler).m_left.m_frame_top), "shadow-type", &l_value);
    g_object_set_property(G_OBJECT((*io_ruler).m_left.m_frame_bottom), "shadow-type", &l_value);

    g_signal_connect((*io_ruler).m_top.m_ruler, "margin-changed", G_CALLBACK(ruler_wrap_margin_changed), 0);
    g_signal_connect((*io_ruler).m_left.m_ruler, "margin-changed", G_CALLBACK(ruler_wrap_margin_changed), 0);

  }while(0);

  return;
}

extern void
ruler_wrap_remove_track_widget(
  GtkWidget*                            i_widget)
{

  g_signal_handlers_disconnect_by_func(
    i_widget,
    ruler_motion_notify,
    (*g_mainw).m_ruler.m_top.m_ruler);

  g_signal_handlers_disconnect_by_func(
    i_widget,
    ruler_motion_notify,
    (*g_mainw).m_ruler.m_left.m_ruler);

  return;
}

extern void
ruler_wrap_reset()
{
  ruler_wrap_adjust_allocate(0.0, 0.0);
  ruler_wrap_set_scale(1.0);
  ruler_wrap_set_hscroll(0.0); 
  ruler_wrap_set_vscroll(0.0); 
  return;
}

extern void
ruler_wrap_set_hscroll(
  gdouble                               i_pos_x)
{
  ruler_set_adjustment((*g_mainw).m_ruler.m_top.m_ruler, i_pos_x);
}

extern void
ruler_wrap_set_scale(
  gdouble const                         i_scale)
{
  ruler_set_scale((*g_mainw).m_ruler.m_top.m_ruler, i_scale);
  ruler_set_scale((*g_mainw).m_ruler.m_left.m_ruler, i_scale);
  return;
}

extern void
ruler_wrap_set_visible(
  gboolean                              i_visible)
{
  gtk_widget_set_visible(GTK_WIDGET((*g_mainw).m_ruler.m_top.m_box), i_visible);
  gtk_widget_set_visible(GTK_WIDGET((*g_mainw).m_ruler.m_left.m_box), i_visible);
}

extern void
ruler_wrap_set_vscroll(
  gdouble                               i_pos_y)
{
  ruler_set_adjustment((*g_mainw).m_ruler.m_left.m_ruler, i_pos_y);
}

