/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2015, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __report_h__

#include "global_common.h"
#include "label.h"
#include "layout.h"
#include "query.h"
#include "query_exec.h"
#include "paper.h"
#include "export.h"

enum report_style
{
  style_unassigned= 0,
  style_layout,
  style_export,
  style_label
};

enum report_format
{
  format_pdf
};

struct report
{
  char*                                 m_reportfile;
  enum report_style                     m_style;
  union
  {
    struct layout                       m_layout;
    struct exports                      m_export;
    struct label                        m_label;
  }                                     m_object;
  struct database_aspect                m_aspect;
  struct query                          m_query;
};

extern void
report_assign(
  struct report*const                   o_report);

extern void
report_assign_export(
  struct report*const                   o_report);

extern void
report_assign_filename(
  struct report*const                   io_report,
  char const*                           i_reportfile);

extern void
report_assign_label(
  struct report*const                   o_report);

extern void
report_assign_layout(
  struct report*const                   o_report);

extern void
report_discharge(
  struct report*const                   io_report);

extern GtkWidget*
report_gui_new(
  struct report*const                   io_report);

extern void
report_highlight_objects(
  struct report*const                   io_report,
  gboolean const                        i_state);

extern struct item_node*
report_item_new(
  struct report*const                   io_report,
  enum item_type const                  i_type);

extern int
report_read(
  GError**                              o_error,
  GtkWidget**                           o_widget,
  struct report*const                   io_report);

extern void
report_set_horizontal_ruler_line(
  struct report *const                  io_report,
  gboolean const                        i_state);

extern void
report_set_vertical_ruler_line(
  struct report *const                  io_report,
  gboolean const                        i_state);

extern void
report_set_scale(
  struct report *const                  io_report,
  double const                          i_scale);

extern void
report_set_scale_zoom_in(
  struct report *const                  io_report);

extern void
report_set_scale_zoom_out(
  struct report *const                  io_report);

extern int
report_write(
  GError**                              o_error,
  struct report const*const             i_report);

#define  __report_h__
#endif
