/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2015-2016, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "mainw.h"
#include "goop.h"
#include "query_exec.h"
#include "query.h"
#include "sql.h"

enum
{
  RESPONSE_TEST=1,
  RESPONSE_NEW=2,
  RESPONSE_DELETE=3
};

struct query_dialog
{
  GtkEntry*                             m_tag_entry;
  GtkComboBoxText*                      m_query_comboboxtext;
  GtkTextView*                          m_query_textview;
  guint                                 m_query_signal_handle;
  GtkButton*                            m_up_button;
  GtkButton*                            m_down_button;
  GtkButton*                            m_delete_button;
  struct query*                         m_query;
  struct query_node*                    m_active;
};

static void
query_property_query_load(
  struct query_dialog*const             io_qd);

static void
query_property_set_values2(
  struct query_dialog*const             io_qd);

static void
query_property_upbutton_cb(
  GtkWidget *                           i_widget,
  gpointer                              i_data)
{
  struct query_dialog *                 l_qd;
  struct query_node*                    l_node;
  struct query_node*                    l_next;

  l_qd= (struct query_dialog*)i_data;
  l_node= (*l_qd).m_active;

  do
  {

    if (0 == l_node)
    {
      break;
    }

    if (0 == (*l_node).m_prev)
    {
      break;
    }
  
    l_next= (*l_node).m_next;

    if (0 == l_next)
    {
      break;
    }

    query_unlink(l_node, (*l_qd).m_query);
    query_insert_after((*l_qd).m_query, l_next, l_node);
    query_property_query_load(l_qd);
    query_property_set_values2(l_qd);

  }while(0);

  return;
}

static void
query_downbutton_cb(
  GtkWidget *                           i_widget,
  gpointer                              i_data)
{
  struct query_dialog *                 l_qd;
  struct query_node*                    l_node;
  struct query_node*                    l_prev;

  l_qd= (struct query_dialog*)i_data;
  l_node= (*l_qd).m_active;

  do
  {

    if (0 == l_node)
    {
      break;
    }

    l_prev= (*l_node).m_prev;

    if ((0 == l_prev) || (0 == (*l_prev).m_prev))
    {
      break;
    }

    query_unlink(l_node, (*l_qd).m_query);
    query_insert_before((*l_qd).m_query, l_prev, l_node);
    query_property_query_load(l_qd);
    query_property_set_values2(l_qd);

  }while(0);

  return;
}

static void
query_property_set_values2(
  struct query_dialog*const             io_qd)
{
  GtkTextBuffer*                        l_buffer;
  GtkTextIter                           l_end;
  struct query_node*                    l_node;
  int                                   l_rc;
  unsigned                              l_slot;
  GtkTextIter                           l_start;

  do
  {

    l_rc= strcmp("primary", (*io_qd).m_active->m_tag);

    g_object_set(
      (*io_qd).m_tag_entry,
      "editable",
      ((l_rc) ? TRUE : FALSE),
      NULL);

    gtk_entry_set_text((*io_qd).m_tag_entry, (*io_qd).m_active->m_tag);

    l_slot= 0;
    l_node= (*io_qd).m_query->m_head;

    do
    {

      if (0 == l_node)
      {
        break;
      }

      if (l_node == (*io_qd).m_active)
      {
        g_signal_handler_block(
          (*io_qd).m_query_comboboxtext,
          (*io_qd).m_query_signal_handle);

        gtk_combo_box_set_active(
          GTK_COMBO_BOX((*io_qd).m_query_comboboxtext),
          l_slot);

        g_signal_handler_unblock(
          (*io_qd).m_query_comboboxtext,
          (*io_qd).m_query_signal_handle);
        break;
      }

      l_node= (*l_node).m_next;
      l_slot++;

    }while(1);

    l_buffer= gtk_text_view_get_buffer((*io_qd).m_query_textview);

    if (0 == (*io_qd).m_active->m_size)
    {
      gtk_text_buffer_get_start_iter(l_buffer, &l_start);
      gtk_text_buffer_get_end_iter(l_buffer, &l_end);
      gtk_text_buffer_delete(l_buffer, &l_start, &l_end); 
      break;
    }

    gtk_text_buffer_set_text(
      l_buffer, 
      (*io_qd).m_active->m_text,
      (*io_qd).m_active->m_size);

  }while(0);

  return;
}

static void
query_property_save(
  struct query_dialog*const             io_qd)
{
  GtkTextBuffer*                        l_buffer;
  GtkTextIter                           l_end;
  struct query_node*                    l_node;
  gint                                  l_off_end;
  gint                                  l_off_start;
  GtkTextIter                           l_start;
  gchar const*                          l_text;

  l_node= (*io_qd).m_active;

  l_text= gtk_entry_get_text((*io_qd).m_tag_entry);
  memset((*l_node).m_tag, 0, sizeof((*l_node).m_tag));

  if (l_text[0])
  {
    strncpy((*l_node).m_tag, l_text, (sizeof((*l_node).m_tag)-1));
  }
  else
  {
    strcpy((*l_node).m_tag, "default");
  }

  l_buffer= gtk_text_view_get_buffer((*io_qd).m_query_textview);
  gtk_text_buffer_get_start_iter(l_buffer, &l_start);
  gtk_text_buffer_get_end_iter(l_buffer, &l_end);

  if ((*l_node).m_text)
  {
    g_free((*l_node).m_text);
  }

  (*l_node).m_text= gtk_text_buffer_get_text(
    l_buffer,
    &l_start,
    &l_end,
    FALSE);

  l_off_start= gtk_text_iter_get_offset(&l_start);
  l_off_end= gtk_text_iter_get_offset(&l_end);

  (*l_node).m_size= (l_off_end - l_off_start);

  return;
}

static void
query_comboboxtext_cb(
  GtkWidget *                           i_widget,
  gpointer                              i_data)
{
  struct query_dialog *                 l_qd;
  struct query_node*                    l_node;
  unsigned                              l_slot;
  int                                   l_active;

  l_qd= (struct query_dialog*)i_data;
  query_property_save(l_qd);
  l_active= gtk_combo_box_get_active(GTK_COMBO_BOX(i_widget));

  l_slot= 0;
  l_node= (*l_qd).m_query->m_head;

  do
  {

    if (0 == l_node)
    {
      break;
    }

    if (l_slot == l_active)
    {
      (*l_qd).m_active= l_node;
      break;
    }

    l_slot++;
    l_node= (*l_node).m_next;

  }while(1);

  gtk_widget_set_sensitive(GTK_WIDGET((*l_qd).m_delete_button), l_active);
  gtk_widget_set_sensitive(GTK_WIDGET((*l_qd).m_up_button), l_slot);
  gtk_widget_set_sensitive(GTK_WIDGET((*l_qd).m_down_button), l_slot);

  query_property_set_values2(l_qd);

  return;
}

static void
query_property_bind(
  struct query_dialog*const             o_qd,
  GtkBuilder*const                      i_builder)
{

  do
  {

    (*o_qd).m_tag_entry= GTK_ENTRY(
      gtk_builder_get_object(i_builder, "tag_entry"));

    (*o_qd).m_query_comboboxtext= GTK_COMBO_BOX_TEXT(
      gtk_builder_get_object(i_builder, "query_comboboxtext"));

    (*o_qd).m_query_signal_handle= g_signal_connect(
      (*o_qd).m_query_comboboxtext,
      "changed",
      G_CALLBACK(query_comboboxtext_cb),
      o_qd);

    (*o_qd).m_query_textview= GTK_TEXT_VIEW(
      gtk_builder_get_object(i_builder, "query_textview"));

    (*o_qd).m_up_button= GTK_BUTTON(
      gtk_builder_get_object(i_builder, "up_button"));

    gtk_widget_set_sensitive(GTK_WIDGET((*o_qd).m_up_button), 0);

    g_signal_connect(
      (*o_qd).m_up_button,
      "clicked",
      G_CALLBACK(query_property_upbutton_cb),
      o_qd);

    (*o_qd).m_down_button= GTK_BUTTON(
      gtk_builder_get_object(i_builder, "down_button"));

    gtk_widget_set_sensitive(GTK_WIDGET((*o_qd).m_down_button), 0);

    g_signal_connect(
      (*o_qd).m_down_button,
      "clicked",
      G_CALLBACK(query_downbutton_cb),
      o_qd);

    (*o_qd).m_delete_button= GTK_BUTTON(
      gtk_builder_get_object(i_builder, "delete_button"));

    gtk_widget_set_sensitive(GTK_WIDGET((*o_qd).m_delete_button), 0);

  }while(0);

  return;
}

static void
query_property_clear_values(
  struct query_dialog*const             io_qd)
{
  GtkTextBuffer*                        l_buffer;
  GtkTextIter                           l_start;
  GtkTextIter                           l_end;
  GtkEntryBuffer*                       l_ebuf;

  g_signal_handler_block(
    (*io_qd).m_query_comboboxtext,
    (*io_qd).m_query_signal_handle);

  l_ebuf= gtk_entry_get_buffer((*io_qd).m_tag_entry);
  gtk_entry_buffer_delete_text(l_ebuf, 0, -1);
  gtk_combo_box_text_remove_all((*io_qd).m_query_comboboxtext);
  gtk_combo_box_set_active(GTK_COMBO_BOX((*io_qd).m_query_comboboxtext), -1);
  l_buffer= gtk_text_view_get_buffer((*io_qd).m_query_textview);
  gtk_text_buffer_get_start_iter(l_buffer, &l_start);
  gtk_text_buffer_get_end_iter(l_buffer, &l_end);
  gtk_text_buffer_delete(l_buffer, &l_start, &l_end); 

  g_signal_handler_unblock(
    (*io_qd).m_query_comboboxtext,
    (*io_qd).m_query_signal_handle);

  return;
}

static void
query_property_query_load(
  struct query_dialog*const             io_qd)
{
  unsigned                              l_slot;
  struct query_node*                    l_node;

  g_signal_handler_block(
    (*io_qd).m_query_comboboxtext,
    (*io_qd).m_query_signal_handle);

  gtk_combo_box_text_remove_all((*io_qd).m_query_comboboxtext);

  l_slot= 0;
  l_node= (*io_qd).m_query->m_head;

  do
  {

    if (0 == l_node)
    {
      break;
    }

    gtk_combo_box_text_append_text(
      (*io_qd).m_query_comboboxtext,
      (*l_node).m_tag);

    l_node= (*l_node).m_next;
    l_slot++;

  }while(1);

  g_signal_handler_unblock(
    (*io_qd).m_query_comboboxtext,
    (*io_qd).m_query_signal_handle);

  return;
}

static void
query_property_set_values(
  struct query_dialog*const             io_qd)
{

  query_property_clear_values(io_qd);
  query_property_query_load(io_qd);
  query_property_set_values2(io_qd);

  return;
}

static void
query_property_new(
  struct query_dialog*const             io_qd)
{
  GtkTextBuffer*                        l_buffer;
  long                                  l_cur_value;
  GtkTextIter                           l_end;
  struct query_node*                    l_node;
  int                                   l_rc;
  int                                   l_slot;
  GtkTextIter                           l_start;
  long                                  l_value;

  l_node= (*io_qd).m_query->m_head;
  l_slot= 0;
  l_cur_value= 0;

  l_buffer= gtk_text_view_get_buffer((*io_qd).m_query_textview);
  gtk_text_buffer_get_start_iter(l_buffer, &l_start);
  gtk_text_buffer_get_end_iter(l_buffer, &l_end);
  gtk_text_buffer_delete(l_buffer, &l_start, &l_end); 

  do
  {

    if (0 == l_node)
    {
      query_last_new(&l_node, (*io_qd).m_query);
      sprintf((*l_node).m_tag, "default%ld", l_cur_value);

      (*io_qd).m_active= l_node;

      g_object_set((*io_qd).m_tag_entry, "editable", TRUE, NULL);
      gtk_entry_set_text((*io_qd).m_tag_entry, (*l_node).m_tag);
      
      g_signal_handler_block(
        (*io_qd).m_query_comboboxtext,
        (*io_qd).m_query_signal_handle);

      gtk_combo_box_text_append_text(
        (*io_qd).m_query_comboboxtext,
        (*l_node).m_tag);

      gtk_combo_box_set_active(
        GTK_COMBO_BOX((*io_qd).m_query_comboboxtext),
        l_slot);

      g_signal_handler_unblock(
        (*io_qd).m_query_comboboxtext,
        (*io_qd).m_query_signal_handle);

      break;
    } 

    l_rc= strncmp("default", (*l_node).m_tag, 7);

    if (0 == l_rc)
    {
      l_value= strtol(&(*l_node).m_tag[7], 0, 10);
      if (0 > l_value) 
      {
        l_value=0;
      }
      l_value++;
      if (l_value > l_cur_value) 
      {
        l_cur_value= l_value;
      }
    }

    l_node= (*l_node).m_next;
    l_slot++;

  }while(1);

  gtk_widget_set_sensitive(GTK_WIDGET((*io_qd).m_delete_button), 1);
  gtk_widget_set_sensitive(GTK_WIDGET((*io_qd).m_up_button), 1 < l_slot);
  gtk_widget_set_sensitive(GTK_WIDGET((*io_qd).m_down_button), 1 < l_slot);

  return;
}

static void
query_property_delete(
  struct query_dialog*const             io_qd)
{
  int                                   l_rc;
  struct query_node*                    l_node;
  unsigned                              l_slot;

  do
  {

    if (0 == (*io_qd).m_active)
    {
      break;
    }

    l_rc= !strcmp("primary", (*io_qd).m_active->m_tag);

    if (l_rc)
    {
      if ((*io_qd).m_active->m_text)
      {
        g_free((*io_qd).m_active->m_text);
        (*io_qd).m_active->m_text= 0;
      }
      (*io_qd).m_active->m_size= 0;
      query_property_set_values2(io_qd);
      break;
    }

    if ((*io_qd).m_active->m_next)
    {
      l_node= (*io_qd).m_active->m_next;
    }
    else
    {
      l_node= (*io_qd).m_active->m_prev;
    }

    query_delete((*io_qd).m_query, (*io_qd).m_active);

    (*io_qd).m_active= l_node;

    query_property_set_values(io_qd);

  }while(0);

  gtk_widget_set_sensitive(
    GTK_WIDGET((*io_qd).m_delete_button),
    ((*io_qd).m_active != (*io_qd).m_query->m_head));

  gtk_widget_set_sensitive(GTK_WIDGET((*io_qd).m_up_button), 0);
  gtk_widget_set_sensitive(GTK_WIDGET((*io_qd).m_down_button), 0);

  l_slot= 0;
  for(l_node= (*io_qd).m_query->m_head; l_node; l_node= (*l_node).m_next)
  {
    l_slot++;
    if (2 < l_slot)
    {
      gtk_widget_set_sensitive(GTK_WIDGET((*io_qd).m_up_button), 1);
      gtk_widget_set_sensitive(GTK_WIDGET((*io_qd).m_down_button), 1);
      break;
    }
  }

  return;
}

void
query_property_show_results(
  struct query_exec const*const         io_exec)
{
  GtkTextBuffer*                        l_buffer;
  GtkBuilder*                           l_builder;
  GtkDialog*                            l_dialog;
  GError*                               l_error;
  FILE*                                 l_fp;
  struct query_exec_node*               l_query;
  int                                   l_rc;
  size_t                                l_size;
  unsigned                              l_slot_attr;
  unsigned                              l_slot_sql;
  char*                                 l_text;
  GtkTextView*                          l_textview;
  char                                  l_buf[15+1];

  l_dialog= 0;
  l_error= 0;
  l_text= 0;
  memset(&l_buf[0], 0, sizeof(l_buf));

  do
  {

    l_fp= tmpfile();

    if (0 == l_fp)
    {
      break;
    }

    l_query= &(*io_exec).m_sql[0];
    l_slot_sql= 0;

    do
    {

      if ((*io_exec).m_count <= l_slot_sql)
      {
        break;
      }

      for(l_slot_attr= 0; (*l_query).m_attr_count > l_slot_attr; l_slot_attr++)
      {
        strncpy(l_buf, (*l_query).m_attr[l_slot_attr].m_tag, sizeof(l_buf)-1);
        fprintf(l_fp, "%-15s  ", l_buf);
      }

      fprintf(l_fp, "\n");

      for(l_slot_attr= 0; (*l_query).m_attr_count > l_slot_attr; l_slot_attr++)
      {
        fprintf(l_fp, "---------------  ");
      }

      fprintf(l_fp, "\n");

      for(l_slot_attr= 0; (*l_query).m_attr_count > l_slot_attr; l_slot_attr++)
      {
        memset(l_buf, 0, sizeof(l_buf));
        if ((*l_query).m_attr[l_slot_attr].m_value)
        {
          strncpy(l_buf, (*l_query).m_attr[l_slot_attr].m_value, sizeof(l_buf)-1);
        }
        utf8_scrub_kludge(l_buf); 
        fprintf(l_fp, "%-15s  ", l_buf);
      }

      fprintf(l_fp, "\n\n");

      l_slot_sql++;
      l_query++;

    }while(1);

    fseek(l_fp, 0, SEEK_END);
    l_size= ftell(l_fp);
    fseek(l_fp, 0, SEEK_SET);

    l_text= (char*)g_malloc0(1+l_size);

    fread(l_text, l_size, 1, l_fp);
    fclose(l_fp);
    l_fp= 0;

    l_builder= gtk_builder_new();

    l_rc= wrap_gtk_builder_add_from_file(
      l_builder,
      "scrollwin.glade",
      &l_error);

    if (0 == l_rc)
    {
      break;
    }

    l_dialog= GTK_DIALOG(gtk_builder_get_object(l_builder, "scrollwin_dialog"));

    if (0 == l_dialog)
    {
      l_error= g_error_new(
        GENERAL,
        GENERIC,
        "Unable to find dialog object: 'scrollwin_dialog'");
      break;
    }

    l_textview= GTK_TEXT_VIEW(gtk_builder_get_object(l_builder, "textview1"));
#if GTK_CHECK_VERSION(3,16,0)
    gtk_text_view_set_monospace(l_textview, 1);
#endif
    l_buffer= gtk_text_view_get_buffer(l_textview);
    gtk_text_buffer_set_text(l_buffer, l_text, l_size);

    gtk_window_set_transient_for(GTK_WINDOW(l_dialog), mainw());
    gtk_widget_show_all(GTK_WIDGET(l_dialog));
    gtk_window_set_modal(GTK_WINDOW(l_dialog), 1);
    gtk_dialog_run(l_dialog);

  }while(0);

  if (l_error)
  {
    _error_display_prompt(l_error);
  }

  g_clear_error(&l_error);

  if (l_text)
  {
    g_free(l_text);
  }

  if (l_dialog)
  {
    gtk_widget_destroy((GtkWidget*)l_dialog);
  }

  if (l_builder)
  {
    g_object_unref(l_builder);
  }

  return;
}

static void
query_property_test(
  struct database_aspect *const         io_aspect,
  struct query_dialog*                  io_qd)
{
  GError*                               l_error;
  int                                   l_eof;
  struct query_exec                     l_exec;
  int                                   l_exit;

  l_error= 0;
  query_exec_assign(&l_exec);

  do
  {
        
    database_aspect_password_fill(&l_exit, io_aspect);

    if (l_exit)
    {
      break;
    }

    l_exit= query_exec_connect_prepare_first(
      &l_error,
      &l_eof,
      &l_exec,
      (*io_qd).m_query,
      io_aspect,
      0,
      1);

    if (l_exit)
    {
      _error_display_prompt(l_error);
      break;
    }

    query_property_show_results(&l_exec);

  }while(0);

  g_clear_error(&l_error);

  query_exec_discharge(&l_exec);

  return;
}

extern int
query_property(
  struct query *const                   io_query,
  struct database_aspect *const         io_aspect)
{
  GtkBuilder*                           l_builder;
  GtkDialog*                            l_dialog;
  GError*                               l_error;
  int                                   l_exit;
  struct query_node*                    l_node;
  struct query_dialog                   l_qd;
  int                                   l_rc;

  l_builder= 0;
  l_dialog= 0;
  l_error= 0;
  l_exit= 0;

  memset(&l_qd, 0, sizeof(l_qd));

  do
  {

    l_builder= gtk_builder_new();

    l_rc= wrap_gtk_builder_add_from_file(
      l_builder,
      "query.glade",
      &l_error);

    if (0 == l_rc)
    {
      l_exit= -1;
      break;
    }
  
    l_dialog= (GtkDialog*)gtk_builder_get_object(l_builder, "query_dialog");

    if (0 == l_dialog)
    {
      g_warning("Unable to find dialog object: 'database_dialog'");
      l_exit= -1;
      break;
    }

    gtk_window_set_transient_for(GTK_WINDOW(l_dialog), mainw());

    l_qd.m_query= io_query;
    l_node= (*io_query).m_head;

    do
    {

      if (0 == l_node)
      {
        query_first_new(&l_node, io_query);
        strcpy((*l_node).m_tag, "primary");
        l_qd.m_active= l_node;
        break;
      }

      l_rc= strcmp("primary", (*l_node).m_tag);

      if (0 == l_rc)
      {
        l_qd.m_active= l_node;
        break;
      }

      l_node= (*l_node).m_next;

    }while(1);

    query_property_bind(&l_qd, l_builder);
    query_property_set_values(&l_qd);

    gtk_widget_show_all(GTK_WIDGET(l_dialog));
    gtk_window_set_modal(GTK_WINDOW(l_dialog), 1);

    gtk_widget_grab_focus(gtk_dialog_get_widget_for_response(
      GTK_DIALOG(l_dialog), GTK_RESPONSE_OK));

    do
    {

      l_exit= gtk_dialog_run(GTK_DIALOG(l_dialog));

      if (GTK_RESPONSE_DELETE_EVENT == l_exit)
      {
        break;
      }

      if (GTK_RESPONSE_CANCEL == l_exit)
      {
        break;
      }

      query_property_save(&l_qd);

      if (GTK_RESPONSE_OK == l_exit) 
      {
        break;
      }

      switch(l_exit)
      {
        case RESPONSE_TEST:
          query_property_test(io_aspect, &l_qd);
          break;
        case RESPONSE_NEW:
          query_property_new(&l_qd);
          break;
        case RESPONSE_DELETE:
          query_property_delete(&l_qd);
          break;
        default:
          break;
      }

    }while(1);

  }while(0);

  if (l_dialog)
  {
    gtk_widget_destroy((GtkWidget*)l_dialog);
  }

  if (l_builder)
  {
    g_object_unref(l_builder);
  }

  if (l_error)
  {
    _error_log(l_error);
    _error_display_prompt(l_error);
  }

  g_clear_error(&l_error);

  return l_exit;
}
