/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015-2016, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "pixbuf.h"

extern void
pixbuf_get_attributes(
  struct pixbuf_attribute*const         o_attr,
  GdkPixbuf const*const                 i_pixbuf)
{

  memset(o_attr, 0, sizeof(*o_attr));
  (*o_attr).m_colorspace= gdk_pixbuf_get_colorspace(i_pixbuf);
  (*o_attr).m_channels= gdk_pixbuf_get_n_channels(i_pixbuf);
  (*o_attr).m_has_alpha= gdk_pixbuf_get_has_alpha(i_pixbuf);
  (*o_attr).m_bits_per_sample= gdk_pixbuf_get_bits_per_sample(i_pixbuf);
  (*o_attr).m_width= gdk_pixbuf_get_width(i_pixbuf);
  (*o_attr).m_height= gdk_pixbuf_get_height(i_pixbuf);
  (*o_attr).m_rowstride= gdk_pixbuf_get_rowstride(i_pixbuf);
  (*o_attr).m_byte_length= gdk_pixbuf_get_byte_length(i_pixbuf);

  return;
}

extern int
pixbuf_new_from_blob(
  GError**                              o_error,
  GdkPixbuf **                          o_pixbuf,
  void const*                           i_blob,
  size_t const                          i_size)
{
  GError*                               l_error;
  int                                   l_exit;
  GdkPixbufLoader*                      l_loader;
  GdkPixbuf*                            l_pixbuf;

  (*o_pixbuf)= 0;
  l_error= 0;
  l_exit= 0;
  l_loader= 0;
  l_pixbuf= 0;

  do
  {

    if (0 == i_blob || 0 == i_size)
    {
      break;
    }

    l_loader= gdk_pixbuf_loader_new();

    gdk_pixbuf_loader_write(l_loader, i_blob, i_size, &l_error);
    gdk_pixbuf_loader_close(l_loader, 0);

    if (l_error)
    {
      _error_log(l_error);
      l_exit= -1;
      break;
    }

    l_pixbuf= gdk_pixbuf_loader_get_pixbuf(l_loader);

    if (0 == l_pixbuf)
    {
      break;
    }

    (*o_pixbuf)= l_pixbuf;


  }while(0);

  if (l_error)
  {
    g_propagate_error(o_error, l_error);
  }

  if (l_loader)
  {
    g_object_unref(l_loader);
  }

  return l_exit;
}

extern int
pixbuf_read(
  GdkPixbuf **                          o_pixbuf,
  struct bson_node *const               i_element)
{
  struct pixbuf_attribute const*        l_attr;
  struct pixbuf_attribute               l_attr_new;
  int                                   l_exit;
  GdkPixbuf*                            l_pixbuf_new;
  guchar*                               l_pixels;
  guchar*                               l_pixels_new;

  (*o_pixbuf)= 0;
  l_exit= 0;

  l_attr= (struct pixbuf_attribute*)(*i_element).m_object.m_binary.m_byte;
  l_pixels= (guchar*)&l_attr[1];

  l_pixbuf_new= gdk_pixbuf_new(
    (*l_attr).m_colorspace,
    (*l_attr).m_has_alpha,
    (*l_attr).m_bits_per_sample,
    (*l_attr).m_width,
    (*l_attr).m_height);

  pixbuf_get_attributes(&l_attr_new, l_pixbuf_new);
  l_pixels_new= gdk_pixbuf_get_pixels(l_pixbuf_new);
  memset(l_pixels_new, 0, l_attr_new.m_byte_length);

  do
  {

    if (((*l_attr).m_rowstride == l_attr_new.m_rowstride) &&
      ((*l_attr).m_byte_length == l_attr_new.m_byte_length))
    {
      memcpy(l_pixels_new, l_pixels, (*l_attr).m_byte_length);
      (*o_pixbuf)= l_pixbuf_new;
      break;
    }

    /* _mjo todo: copy bits - best fit */
    g_object_unref(l_pixbuf_new);

  }while(0);

  return l_exit;
}

extern int
pixbuf_write(
  FILE*                                 io_fp,
  GdkPixbuf const*const                 i_pixbuf)
{
  struct pixbuf_attribute               l_attr;
  int                                   l_exit;
  int32_t                               l_int32;
  char                                  l_octet;
  guchar*                               l_pixels;

  pixbuf_get_attributes(&l_attr, i_pixbuf);
  l_exit= 0;

  l_pixels= gdk_pixbuf_get_pixels(i_pixbuf);

  /* pixbuf */
  l_octet= bson_type_binary;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "pixbuf%c",0);

  l_int32= sizeof(l_attr) + l_attr.m_byte_length;
  fwrite(&l_int32, sizeof(int32_t), 1, io_fp); 

  l_octet= bson_subtype_binary;
  fwrite(&l_octet, 1, 1, io_fp); 

  fwrite(&l_attr, sizeof(l_attr), 1, io_fp);
  fwrite(l_pixels, l_attr.m_byte_length, 1, io_fp);

  return l_exit;
}
