/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "paper.h"

extern void
paper_set_from_page_setup(
  struct paper*const                    o_paper,
  GtkPageSetup const*const              i_page_setup)
{

  memset(o_paper, 0, sizeof(*o_paper));

  (*o_paper).m_width= gtk_page_setup_get_paper_width(
    (GtkPageSetup*)i_page_setup,
    GTK_UNIT_INCH);

  (*o_paper).m_height= gtk_page_setup_get_paper_height(
    (GtkPageSetup*)i_page_setup,
    GTK_UNIT_INCH);

  (*o_paper).m_margin_top= gtk_page_setup_get_top_margin(
    (GtkPageSetup*)i_page_setup,
    GTK_UNIT_INCH);

  (*o_paper).m_margin_bottom= gtk_page_setup_get_bottom_margin(
    (GtkPageSetup*)i_page_setup,
    GTK_UNIT_INCH);

  (*o_paper).m_margin_left= gtk_page_setup_get_left_margin(
    (GtkPageSetup*)i_page_setup,
    GTK_UNIT_INCH);

  (*o_paper).m_margin_right= gtk_page_setup_get_right_margin(
    (GtkPageSetup*)i_page_setup,
    GTK_UNIT_INCH);

  return;
}

extern void
paper_set_from_page_setup_pt(
  struct paper*const                    o_paper,
  GtkPageSetup const*const              i_page_setup)
{

  memset(o_paper, 0, sizeof(*o_paper));

  (*o_paper).m_width= gtk_page_setup_get_paper_width(
    (GtkPageSetup*)i_page_setup,
    GTK_UNIT_POINTS);

  (*o_paper).m_height= gtk_page_setup_get_paper_height(
    (GtkPageSetup*)i_page_setup,
    GTK_UNIT_POINTS);

  (*o_paper).m_margin_top= gtk_page_setup_get_top_margin(
    (GtkPageSetup*)i_page_setup,
    GTK_UNIT_POINTS);

  (*o_paper).m_margin_bottom= gtk_page_setup_get_bottom_margin(
    (GtkPageSetup*)i_page_setup,
    GTK_UNIT_POINTS);

  (*o_paper).m_margin_left= gtk_page_setup_get_left_margin(
    (GtkPageSetup*)i_page_setup,
    GTK_UNIT_POINTS);

  (*o_paper).m_margin_right= gtk_page_setup_get_right_margin(
    (GtkPageSetup*)i_page_setup,
    GTK_UNIT_POINTS);

  return;
}
