/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2015, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __mainw_h__

#include "global_common.h"
#include "config.h"
#include "csv.h"
#include "database_session.h"
#include "report.h"
#include "iwr_page.h"
#include "pdf.h"

struct mainw
{
  GtkGrid*                              m_grid;
  GtkMenuBar*                           m_menu;
  GtkWindow*                            m_window;
  GtkPaned*                             m_paned;
  struct report                         m_report;
  gulong                                m_size_allocate_handle;
};

struct mainw*                           g_mainw;

extern void
mainw_assign(
  struct mainw*const                    o_mainw);

extern int
mainw_create(
  struct mainw*const                    io_mainw);

extern void
mainw_discharge(
  struct mainw*const                    io_mainw);

extern int
mainw_open(
  struct mainw*const                    io_mainw,
  char const*                           i_filename);

extern int
mainw_run(
  struct mainw*const                    io_mainw);

extern int
mainw_save(
  struct mainw*const                    io_mainw);

extern int
mainw_save_as(
  struct mainw*const                    io_mainw);

extern void
mainw_size_allocate(
  GtkWidget*                            i_widget,
  GdkRectangle*                         i_alloc,
  gpointer                              i_user_data);

extern int
mainw_xdg_open_file(
  char const*                           i_filename);

#define  __mainw_h__
#endif
