/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2015, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "mainw.h"
#include "option.h"
#include "goop.h"
#ifndef WIN32
#include <X11/Xlib.h>
#endif

struct mainw*                           g_mainw;

extern GtkWindow*
mainw()
{
  return (*g_mainw).m_window; 
}

#include "icu.h"

int 
main(
  int                                   i_argc, 
  char *                                i_argv[])
{
  int                                   l_exit;
  struct goop                           l_goop;
  struct mainw                          l_mainw;
  struct option                         l_option;

  option_assign(&l_option);

  memset(&l_goop, 0, sizeof(l_goop));

  do
  {

#ifdef G_OS_UNIX
    XInitThreads();
#endif

    gtk_init(&i_argc, &i_argv);

    l_exit= option_parse(&l_option, i_argc, i_argv);

    if (l_exit)
    {
      break;
    }

    g_mainw= &l_mainw;
    mainw_assign(&l_mainw);
    mainw_create(&l_mainw);

    if (l_option.m_reportfile)
    {
      mainw_open(&l_mainw, l_option.m_reportfile);
    }

    if ((l_option).m_password)
    {
      l_mainw.m_report.m_aspect.m_password= l_option.m_password;
      l_option.m_password= 0;
    }

    if (l_option.m_outputfile)
    {
      l_goop.m_interactive= 0;
      l_goop.m_outputfile= l_option.m_outputfile;
      l_goop.m_prompt= l_option.m_prompt;
      l_mainw.m_report.m_aspect.m_prompt_password= 0;
      switch(l_mainw.m_report.m_style)
      {
        case style_layout:
          l_exit= pdf_run(&l_mainw.m_report, &l_goop);
          break;
        case style_export:
          l_exit= csv_run(&l_mainw.m_report, &l_goop);
          break;
        case style_label:
          l_exit= label_pdf_run(&l_mainw.m_report, &l_goop);
          break;
        default:
          /* programmer error */
          l_exit= -1;
          break;
      }
      break;
    }

    gtk_main();

  }while(0);

  option_discharge(&l_option);

  return l_exit;
}
