/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2015-2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "layout.h"

static double const                     SCALE_MAX= 2.50;
static double const                     SCALE_MIN= 0.25;
static double const                     SCALE_FACTOR= 0.25;

extern void
layout_division_size_allocate_cb(
  GtkWidget*                            i_widget,
  GdkRectangle*                         i_alloc,
  gpointer                              i_user_data)
{
  layout_set_layout_size((struct layout*)i_user_data);
}

extern void
layout_add_default_sections(
  struct layout*const                   io_layout)
{
  GtkWidget*                            l_widget;
  gint                                  l_row;
  struct paper                          l_paper;
  /*double                                l_paper_height;*/
  IwrPage*                              l_page;

  paper_set_from_page_setup_pt(&l_paper, (*io_layout).m_config.m_page_setup);
  l_row= 0;
  /*l_paper_height= l_paper.m_height;*/

/*
  l_widget= gtk_button_new_with_label("Cover.Header");
  gtk_button_set_relief(GTK_BUTTON(l_widget), GTK_RELIEF_NONE);
  gtk_widget_set_sensitive(l_widget, 0);
  l_page= IWR_PAGE(iwr_page_new());
  (*io_layout).m_cover.m_header.m_page= l_page;
  strcpy((*io_layout).m_cover.m_header.m_tag, "Cover.Header");
  iwr_page_set_section_type(l_page, section_cover_header);
  iwr_page_set_paper(l_page, &l_paper);
  gtk_grid_attach((*io_layout).m_grid, l_widget, 0, l_row++, 1, 1);
  gtk_grid_attach((*io_layout).m_grid, GTK_WIDGET(l_page), 0, l_row++, 1, 1);
*/

  l_widget= gtk_button_new_with_label("Report.Header");
  gtk_button_set_relief(GTK_BUTTON(l_widget), GTK_RELIEF_NONE);
  gtk_widget_set_sensitive(l_widget, 0);
  l_page= IWR_PAGE(iwr_page_new());
  (*io_layout).m_report.m_header.m_page= l_page;
  strcpy((*io_layout).m_report.m_header.m_tag, "Report.Header");
  iwr_page_set_section_type(l_page, section_report_header);
  l_paper.m_height= POINTS_PER_INCH * 1.5;
  iwr_page_set_paper(l_page, &l_paper);
  gtk_grid_attach((*io_layout).m_grid, l_widget, 0, l_row++, 1, 1);
  gtk_grid_attach((*io_layout).m_grid, GTK_WIDGET(l_page), 0, l_row++, 1, 1);
  g_signal_connect(l_page, "size-allocate", G_CALLBACK(layout_division_size_allocate_cb), io_layout);

  l_widget= gtk_button_new_with_label("Report.Detail");
  gtk_button_set_relief(GTK_BUTTON(l_widget), GTK_RELIEF_NONE);
  gtk_widget_set_sensitive(l_widget, 0);
  l_page= IWR_PAGE(iwr_page_new());
  (*io_layout).m_report.m_detail.m_page= l_page;
  strcpy((*io_layout).m_report.m_detail.m_tag, "Report.Detail");
  iwr_page_set_section_type(l_page, section_report_detail);
  l_paper.m_height= POINTS_PER_INCH * 1.5;
  iwr_page_set_paper(l_page, &l_paper);
  gtk_grid_attach((*io_layout).m_grid, l_widget, 0, l_row++, 1, 1);
  gtk_grid_attach((*io_layout).m_grid, GTK_WIDGET(l_page), 0, l_row++, 1, 1);
  g_signal_connect(l_page, "size-allocate", G_CALLBACK(layout_division_size_allocate_cb), io_layout);

  l_widget= gtk_button_new_with_label("Report.Footer");
  gtk_button_set_relief(GTK_BUTTON(l_widget), GTK_RELIEF_NONE);
  gtk_widget_set_sensitive(l_widget, 0);
  l_page= IWR_PAGE(iwr_page_new());
  (*io_layout).m_report.m_footer.m_page= l_page;
  strcpy((*io_layout).m_report.m_footer.m_tag, "Report.Footer");
  iwr_page_set_section_type(l_page, section_report_footer);
  l_paper.m_height= POINTS_PER_INCH * 1.0;
  iwr_page_set_paper(l_page, &l_paper);
  gtk_grid_attach((*io_layout).m_grid, l_widget, 0, l_row++, 1, 1);
  gtk_grid_attach((*io_layout).m_grid, GTK_WIDGET(l_page), 0, l_row++, 1, 1);
  g_signal_connect(l_page, "size-allocate", G_CALLBACK(layout_division_size_allocate_cb), io_layout);

/*
  l_widget= gtk_button_new_with_label("Cover.Footer");
  gtk_button_set_relief(GTK_BUTTON(l_widget), GTK_RELIEF_NONE);
  gtk_widget_set_sensitive(l_widget, 0);
  l_page= IWR_PAGE(iwr_page_new());
  (*io_layout).m_cover.m_footer.m_page= l_page;
  strcpy((*io_layout).m_cover.m_footer.m_tag, "Cover.Footer");
  iwr_page_set_section_type(l_page, section_cover_footer);
  l_paper.m_height= l_paper_height;
  iwr_page_set_paper(l_page, &l_paper);
  gtk_grid_attach((*io_layout).m_grid, l_widget, 0, l_row++, 1, 1);
  gtk_grid_attach((*io_layout).m_grid, GTK_WIDGET(l_page), 0, l_row++, 1, 1);
*/

  layout_set_layout_size(io_layout);

  return;
}

static void
layout_divisions_read_config(
  struct layout*const                   io_layout)
{
  struct paper                          l_paper;
  IwrPage*                              l_page;
  unsigned                              l_slot;

  paper_set_from_page_setup_pt(&l_paper, (*io_layout).m_config.m_page_setup);

  l_page= (*io_layout).m_cover.m_header.m_page;
  if (l_page)
  {
    config_read_division_height(
      &l_paper.m_height,
      (*io_layout).m_cover.m_header.m_tag,
      &(*io_layout).m_config);
    iwr_page_set_paper(l_page, &l_paper);
  }

  l_page= (*io_layout).m_cover.m_footer.m_page;
  if (l_page)
  {
    config_read_division_height(
      &l_paper.m_height,
      (*io_layout).m_cover.m_footer.m_tag,
      &(*io_layout).m_config);
    iwr_page_set_paper(l_page, &l_paper);
  }

  l_page= (*io_layout).m_report.m_header.m_page;
  if (l_page)
  {
    config_read_division_height(
      &l_paper.m_height,
      (*io_layout).m_report.m_header.m_tag,
      &(*io_layout).m_config);
    iwr_page_set_paper(l_page, &l_paper);
  }

  l_page= (*io_layout).m_report.m_detail.m_page;
  if (l_page)
  {
    config_read_division_height(
      &l_paper.m_height,
      (*io_layout).m_report.m_detail.m_tag,
      &(*io_layout).m_config);
    iwr_page_set_paper(l_page, &l_paper);
  }

  l_page= (*io_layout).m_report.m_footer.m_page;
  if (l_page)
  {
    config_read_division_height(
      &l_paper.m_height,
      (*io_layout).m_report.m_footer.m_tag,
      &(*io_layout).m_config);
    iwr_page_set_paper(l_page, &l_paper);
  }

  for (l_slot= 0; (*io_layout).m_group_slots > l_slot; l_slot++)
  {
    l_page= (*io_layout).m_group[l_slot].m_header.m_page;
    config_read_division_height(
      &l_paper.m_height,
      (*io_layout).m_group[l_slot].m_header.m_tag,
      &(*io_layout).m_config);
    iwr_page_set_paper(l_page, &l_paper);

    l_page= (*io_layout).m_group[l_slot].m_footer.m_page;
    config_read_division_height(
      &l_paper.m_height,
      (*io_layout).m_group[l_slot].m_footer.m_tag,
      &(*io_layout).m_config);
    iwr_page_set_paper(l_page, &l_paper);
  }

  return;
}

static void
layout_divisions_write_config(
  struct layout const*const             i_layout)
{
  IwrPage*                              l_page;
  struct paper                          l_paper;
  unsigned                              l_slot;

  l_page= (*i_layout).m_cover.m_header.m_page;
  if (l_page)
  {
    iwr_page_get_paper(&l_paper, l_page);
    config_write_division_height(
      &(*i_layout).m_config,
      (*i_layout).m_cover.m_header.m_tag,
      l_paper.m_height);
  }

  l_page= (*i_layout).m_cover.m_footer.m_page;
  if (l_page)
  {
    iwr_page_get_paper(&l_paper, l_page);
    config_write_division_height(
      &(*i_layout).m_config,
      (*i_layout).m_cover.m_footer.m_tag,
      l_paper.m_height);
  }

  l_page= (*i_layout).m_report.m_header.m_page;
  if (l_page)
  {
    iwr_page_get_paper(&l_paper, l_page);
    config_write_division_height(
      &(*i_layout).m_config,
      (*i_layout).m_report.m_header.m_tag,
      l_paper.m_height);
  }

  l_page= (*i_layout).m_report.m_detail.m_page;
  if (l_page)
  {
    iwr_page_get_paper(&l_paper, l_page);
    config_write_division_height(
      &(*i_layout).m_config,
      (*i_layout).m_report.m_detail.m_tag,
      l_paper.m_height);
  }

  l_page= (*i_layout).m_report.m_footer.m_page;
  if (l_page)
  {
    iwr_page_get_paper(&l_paper, l_page);
    config_write_division_height(
      &(*i_layout).m_config,
      (*i_layout).m_report.m_footer.m_tag,
      l_paper.m_height);
  }

  for (l_slot= 0; (*i_layout).m_group_slots > l_slot; l_slot++)
  {

    l_page= (*i_layout).m_group[l_slot].m_header.m_page;
    iwr_page_get_paper(&l_paper, l_page);
    config_write_division_height(
      &(*i_layout).m_config,
      (*i_layout).m_group[l_slot].m_header.m_tag,
      l_paper.m_height);

    l_page= (*i_layout).m_group[l_slot].m_footer.m_page;
    iwr_page_get_paper(&l_paper, l_page);
    config_write_division_height(
      &(*i_layout).m_config,
      (*i_layout).m_group[l_slot].m_footer.m_tag,
      l_paper.m_height);
  }

  return;
}

extern void
layout_add_divisions_to_grid(
  struct layout*const                   io_layout)
{
  IwrPage*                              l_page;
  unsigned                              l_row;
  unsigned                              l_slot;
  GtkWidget*                            l_widget;

  l_row= 0;

  l_page= (*io_layout).m_cover.m_header.m_page;
  if (l_page)
  {
    l_widget= gtk_button_new_with_label((*io_layout).m_cover.m_header.m_tag);
    gtk_button_set_relief(GTK_BUTTON(l_widget), GTK_RELIEF_NONE);
    gtk_widget_set_sensitive(l_widget, 0);
    gtk_grid_attach((*io_layout).m_grid, l_widget, 0, l_row++, 1, 1);
    gtk_grid_attach((*io_layout).m_grid, GTK_WIDGET(l_page), 0, l_row++, 1, 1);
    g_signal_connect(l_page, "size-allocate", G_CALLBACK(layout_division_size_allocate_cb), io_layout);
  }

  l_page= (*io_layout).m_cover.m_footer.m_page;
  if (l_page)
  {
    l_widget= gtk_button_new_with_label((*io_layout).m_cover.m_footer.m_tag);
    gtk_button_set_relief(GTK_BUTTON(l_widget), GTK_RELIEF_NONE);
    gtk_widget_set_sensitive(l_widget, 0);
    gtk_grid_attach((*io_layout).m_grid, l_widget, 0, l_row++, 1, 1);
    gtk_grid_attach((*io_layout).m_grid, GTK_WIDGET(l_page), 0, l_row++, 1, 1);
    g_signal_connect(l_page, "size-allocate", G_CALLBACK(layout_division_size_allocate_cb), io_layout);
  }

  l_page= (*io_layout).m_report.m_header.m_page;
  if (l_page)
  {
    l_widget= gtk_button_new_with_label((*io_layout).m_report.m_header.m_tag);
    gtk_button_set_relief(GTK_BUTTON(l_widget), GTK_RELIEF_NONE);
    gtk_widget_set_sensitive(l_widget, 0);
    gtk_grid_attach((*io_layout).m_grid, l_widget, 0, l_row++, 1, 1);
    gtk_grid_attach((*io_layout).m_grid, GTK_WIDGET(l_page), 0, l_row++, 1, 1);
    g_signal_connect(l_page, "size-allocate", G_CALLBACK(layout_division_size_allocate_cb), io_layout);
  }

  for (l_slot= 0; (*io_layout).m_group_slots > l_slot; l_slot++)
  {
    l_page= (*io_layout).m_group[l_slot].m_header.m_page;
    l_widget= gtk_button_new_with_label((*io_layout).m_group[l_slot].m_header.m_tag);
    gtk_button_set_relief(GTK_BUTTON(l_widget), GTK_RELIEF_NONE);
    gtk_widget_set_sensitive(l_widget, 0);
    gtk_grid_attach((*io_layout).m_grid, l_widget, 0, l_row++, 1, 1);
    gtk_grid_attach((*io_layout).m_grid, GTK_WIDGET(l_page), 0, l_row++, 1, 1);
    g_signal_connect(l_page, "size-allocate", G_CALLBACK(layout_division_size_allocate_cb), io_layout);
  }

  l_page= (*io_layout).m_report.m_detail.m_page;
  if (l_page)
  {
    l_widget= gtk_button_new_with_label((*io_layout).m_report.m_detail.m_tag);
    gtk_button_set_relief(GTK_BUTTON(l_widget), GTK_RELIEF_NONE);
    gtk_widget_set_sensitive(l_widget, 0);
    gtk_grid_attach((*io_layout).m_grid, l_widget, 0, l_row++, 1, 1);
    gtk_grid_attach((*io_layout).m_grid, GTK_WIDGET(l_page), 0, l_row++, 1, 1);
    g_signal_connect(l_page, "size-allocate", G_CALLBACK(layout_division_size_allocate_cb), io_layout);
  }

  l_slot= (*io_layout).m_group_slots;

  do
  {

    if (0 == l_slot)
    {
      break;
    }

    l_slot--;

    l_page= (*io_layout).m_group[l_slot].m_footer.m_page;
    l_widget= gtk_button_new_with_label((*io_layout).m_group[l_slot].m_footer.m_tag);
    gtk_button_set_relief(GTK_BUTTON(l_widget), GTK_RELIEF_NONE);
    gtk_widget_set_sensitive(l_widget, 0);
    gtk_grid_attach((*io_layout).m_grid, l_widget, 0, l_row++, 1, 1);
    gtk_grid_attach((*io_layout).m_grid, GTK_WIDGET(l_page), 0, l_row++, 1, 1);
    g_signal_connect(l_page, "size-allocate", G_CALLBACK(layout_division_size_allocate_cb), io_layout);

  }while(1);

  l_page= (*io_layout).m_report.m_footer.m_page;
  if (l_page)
  {
    l_widget= gtk_button_new_with_label((*io_layout).m_report.m_footer.m_tag);
    gtk_button_set_relief(GTK_BUTTON(l_widget), GTK_RELIEF_NONE);
    gtk_widget_set_sensitive(l_widget, 0);
    gtk_grid_attach((*io_layout).m_grid, l_widget, 0, l_row++, 1, 1);
    gtk_grid_attach((*io_layout).m_grid, GTK_WIDGET(l_page), 0, l_row++, 1, 1);
    g_signal_connect(l_page, "size-allocate", G_CALLBACK(layout_division_size_allocate_cb), io_layout);
  }

  l_page= (*io_layout).m_cover.m_footer.m_page;
  if (l_page)
  {
    l_widget= gtk_button_new_with_label((*io_layout).m_cover.m_footer.m_tag);
    gtk_button_set_relief(GTK_BUTTON(l_widget), GTK_RELIEF_NONE);
    gtk_widget_set_sensitive(l_widget, 0);
    gtk_grid_attach((*io_layout).m_grid, l_widget, 0, l_row++, 1, 1);
    gtk_grid_attach((*io_layout).m_grid, GTK_WIDGET(l_page), 0, l_row++, 1, 1);
    g_signal_connect(l_page, "size-allocate", G_CALLBACK(layout_division_size_allocate_cb), io_layout);
  }

  return;
}

extern void
layout_assign(
  struct layout*const                   o_layout)
{

  memset(o_layout, 0, sizeof(*o_layout));
  config_assign(&(*o_layout).m_config);
  (*o_layout).m_scale= 1.0;

  return;
}

extern void
layout_assign_filename(
  struct layout*const                   io_layout,
  char const*                           i_filename)
{

  config_assign_filename(&(*io_layout).m_config, i_filename);

  return;
}

extern void
layout_delete_coverfooter(
  struct layout*const                   io_layout)
{
  gint                                  l_row;

  do
  {

    if (0 == (*io_layout).m_cover.m_footer.m_page)
    {
      break;
    }

    l_row= 0;

    if ((*io_layout).m_cover.m_header.m_page)
    {
      l_row++;
      l_row++;
    }

    if ((*io_layout).m_report.m_header.m_page)
    {
      l_row++;
      l_row++;
    }

    if ((*io_layout).m_report.m_detail.m_page)
    {
      l_row++;
      l_row++;
    }

    if ((*io_layout).m_report.m_footer.m_page)
    {
      l_row++;
      l_row++;
    }

    l_row+= 2*(*io_layout).m_group_slots;

    (*io_layout).m_cover.m_footer.m_page= 0;

    gtk_grid_remove_row((*io_layout).m_grid, l_row);
    gtk_grid_remove_row((*io_layout).m_grid, l_row);

    layout_set_layout_size(io_layout);

  }while(0);

  return;
}

extern void
layout_delete_coverheader(
  struct layout*const                   io_layout)
{

  do
  {

    if (0 == (*io_layout).m_cover.m_header.m_page)
    {
      break;
    }

    gtk_grid_remove_row((*io_layout).m_grid, 0);
    gtk_grid_remove_row((*io_layout).m_grid, 0);

    layout_set_layout_size(io_layout);
    (*io_layout).m_cover.m_header.m_page= 0;

  }while(0);

  return;
}

extern void
layout_delete_reportdetail(
  struct layout*const                   io_layout)
{
  gint                                  l_row;

  do
  {

    if (0 == (*io_layout).m_report.m_detail.m_page)
    {
      break;
    }

    l_row= 0;

    if ((*io_layout).m_cover.m_header.m_page)
    {
      l_row++;
      l_row++;
    }

    if ((*io_layout).m_report.m_header.m_page)
    {
      l_row++;
      l_row++;
    }

    l_row+= 2*(*io_layout).m_group_slots;

    (*io_layout).m_report.m_detail.m_page= 0;

    gtk_grid_remove_row((*io_layout).m_grid, l_row);
    gtk_grid_remove_row((*io_layout).m_grid, l_row);

    layout_set_layout_size(io_layout);

  }while(0);

  return;
}

extern void
layout_delete_reportfooter(
  struct layout*const                   io_layout)
{
  gint                                  l_row;

  do
  {

    if (0 == (*io_layout).m_report.m_footer.m_page)
    {
      break;
    }

    l_row= 0;

    if ((*io_layout).m_cover.m_header.m_page)
    {
      l_row++;
      l_row++;
    }

    if ((*io_layout).m_report.m_header.m_page)
    {
      l_row++;
      l_row++;
    }

    l_row+= 2*(*io_layout).m_group_slots;

    if ((*io_layout).m_report.m_detail.m_page)
    {
      l_row++;
      l_row++;
    }

    l_row+= 2*(*io_layout).m_group_slots;

    (*io_layout).m_report.m_footer.m_page= 0;

    gtk_grid_remove_row((*io_layout).m_grid, l_row);
    gtk_grid_remove_row((*io_layout).m_grid, l_row);

    layout_set_layout_size(io_layout);

  }while(0);

  return;
}

extern void
layout_delete_reportheader(
  struct layout*const                   io_layout)
{
  gint                                  l_row;

  do
  {

    if (0 == (*io_layout).m_report.m_header.m_page)
    {
      break;
    }

    l_row= 0;

    if ((*io_layout).m_cover.m_header.m_page)
    {
      l_row++;
      l_row++;
    }

    if ((*io_layout).m_cover.m_footer.m_page)
    {
      l_row++;
      l_row++;
    }

    (*io_layout).m_report.m_header.m_page= 0;

    gtk_grid_remove_row((*io_layout).m_grid, l_row);
    gtk_grid_remove_row((*io_layout).m_grid, l_row);

    layout_set_layout_size(io_layout);

  }while(0);

  return;
}

extern void
layout_discharge(
  struct layout*const                   io_layout)
{
  unsigned                              l_slot;

  config_discharge(&(*io_layout).m_config);

  g_free((*io_layout).m_page_break.m_value);

  for (l_slot= 0; (*io_layout).m_group_slots > l_slot; l_slot++)
  {
    g_free((*io_layout).m_group[l_slot].m_break.m_value);
  }

  gtk_widget_destroy(GTK_WIDGET((*io_layout).m_window));

  memset(io_layout, 0, sizeof(*io_layout));

  return;
}

extern IwrPage*
layout_get_focused_page(
  struct layout*const                   io_layout)
{
  IwrPage*                              l_page;
  gboolean                              l_focus;
  unsigned                              l_slot;

  l_page= 0;

  do
  {

    l_page= (*io_layout).m_cover.m_header.m_page;

    if (l_page)
    {

      l_focus= gtk_widget_has_focus(GTK_WIDGET(l_page));

      if (l_focus)
      {
        break;
      }

    }

    l_page= (*io_layout).m_cover.m_footer.m_page;

    if (l_page)
    {

      l_focus= gtk_widget_has_focus(GTK_WIDGET(l_page));

      if (l_focus)
      {
        break;
      }

    }

    l_page= (*io_layout).m_report.m_header.m_page;

    if (l_page)
    {

      l_focus= gtk_widget_has_focus(GTK_WIDGET(l_page));

      if (l_focus)
      {
        break;
      }

    }

    l_page= (*io_layout).m_report.m_detail.m_page;

    if (l_page)
    {

      l_focus= gtk_widget_has_focus(GTK_WIDGET(l_page));

      if (l_focus)
      {
        break;
      }

    }

    l_page= (*io_layout).m_report.m_footer.m_page;

    if (l_page)
    {

      l_focus= gtk_widget_has_focus(GTK_WIDGET(l_page));

      if (l_focus)
      {
        break;
      }

    }

    l_page= 0;

    for (l_slot= 0; (*io_layout).m_group_slots > l_slot; l_slot++)
    {
      l_focus= gtk_widget_has_focus(
        GTK_WIDGET((*io_layout).m_group[l_slot].m_header.m_page));

      if (l_focus)
      {
        l_page= (*io_layout).m_group[l_slot].m_header.m_page;
        break;
      }

      l_focus= gtk_widget_has_focus(
        GTK_WIDGET((*io_layout).m_group[l_slot].m_footer.m_page));

      if (l_focus)
      {
        l_page= (*io_layout).m_group[l_slot].m_footer.m_page;
        break;
      }
    }

  }while(0);

  return l_page;
}

extern struct item_node*
layout_item_new(
  struct layout*const                   io_layout,
  enum item_type const                  i_type)
{
  struct item_node*                     l_node;
  IwrPage*                              l_page;

  l_page= layout_get_focused_page(io_layout);

  do
  {

    if (l_page)
    {
      break;
    }

    l_page= (*io_layout).m_report.m_detail.m_page;

    if (l_page)
    {
      break;
    }

    l_page= (*io_layout).m_report.m_header.m_page;

    if (l_page)
    {
      break;
    }

    l_page= (*io_layout).m_report.m_footer.m_page;

    if (l_page)
    {
      break;
    }

    l_page= (*io_layout).m_cover.m_header.m_page;

    if (l_page)
    {
      break;
    }

    if ((*io_layout).m_group_slots)
    {
      l_page= (*io_layout).m_group[0].m_header.m_page;
      break;
    }

    l_page= (*io_layout).m_cover.m_footer.m_page;

  }while(0);

  if (l_page)
  {
    gtk_widget_grab_focus(GTK_WIDGET(l_page));
    iwr_page_item_new(&l_node, l_page, i_type);
  }

  return l_node;
}

extern GtkWidget*
layout_gui_new(
  struct layout*const                   io_layout)
{

  (*io_layout).m_grid= GTK_GRID(gtk_grid_new());
  gtk_widget_set_hexpand(GTK_WIDGET((*io_layout).m_grid), 1);
  gtk_widget_set_vexpand(GTK_WIDGET((*io_layout).m_grid), 1);

  (*io_layout).m_window= GTK_SCROLLED_WINDOW(gtk_scrolled_window_new(0, 0));
  gtk_widget_set_hexpand(GTK_WIDGET((*io_layout).m_window), 1);
  gtk_widget_set_vexpand(GTK_WIDGET((*io_layout).m_window), 1);

  (*io_layout).m_layout= GTK_LAYOUT(gtk_layout_new(0, 0));

  gtk_container_add(
    GTK_CONTAINER((*io_layout).m_window),
    GTK_WIDGET((*io_layout).m_layout));

  gtk_container_add(
    GTK_CONTAINER((*io_layout).m_layout), 
    GTK_WIDGET((*io_layout).m_grid));

  return GTK_WIDGET((*io_layout).m_window);
}

extern void
layout_highlight_objects(
  struct layout*const                   io_layout,
  gboolean const                        i_state)
{
  IwrPage*                              l_page;
  unsigned                              l_slot;

  l_page= (*io_layout).m_cover.m_header.m_page;
  if (l_page)
  {
    iwr_page_set_highlight_objects(l_page, i_state);
  }

  l_page= (*io_layout).m_cover.m_footer.m_page;
  if (l_page)
  {
    iwr_page_set_highlight_objects(l_page, i_state);
  }

  l_page= (*io_layout).m_report.m_header.m_page;
  if (l_page)
  {
    iwr_page_set_highlight_objects(l_page, i_state);
  }

  l_page= (*io_layout).m_report.m_detail.m_page;
  if (l_page)
  {
    iwr_page_set_highlight_objects(l_page, i_state);
  }

  l_page= (*io_layout).m_report.m_footer.m_page;
  if (l_page)
  {
    iwr_page_set_highlight_objects(l_page, i_state);
  }

  for (l_slot= 0; (*io_layout).m_group_slots > l_slot; l_slot++)
  {
    l_page= (*io_layout).m_group[l_slot].m_header.m_page;
    iwr_page_set_highlight_objects(l_page, i_state);

    l_page= (*io_layout).m_group[l_slot].m_footer.m_page;
    iwr_page_set_highlight_objects(l_page, i_state);
  }

  return;
}

extern void
layout_new_coverfooter(
  struct layout*const                   io_layout)
{
  IwrPage*                              l_page;
  struct paper                          l_paper;
  gint                                  l_row;
  GtkWidget*                            l_widget;

  paper_set_from_page_setup_pt(&l_paper, (*io_layout).m_config.m_page_setup);

  do
  {

    if ((*io_layout).m_cover.m_footer.m_page)
    {
      break;
    }

    l_row= 0;

    if ((*io_layout).m_cover.m_header.m_page)
    {
      l_row++;
      l_row++;
    }

    if ((*io_layout).m_report.m_header.m_page)
    {
      l_row++;
      l_row++;
    }

    if ((*io_layout).m_report.m_detail.m_page)
    {
      l_row++;
      l_row++;
    }

    if ((*io_layout).m_report.m_footer.m_page)
    {
      l_row++;
      l_row++;
    }

    l_row+= 2*(*io_layout).m_group_slots;

    l_widget= gtk_button_new_with_label("Cover.Footer");
    gtk_button_set_relief(GTK_BUTTON(l_widget), GTK_RELIEF_NONE);
    gtk_widget_set_sensitive(l_widget, 0);
    l_page= IWR_PAGE(iwr_page_new());
    (*io_layout).m_cover.m_footer.m_page= l_page;
    strcpy((*io_layout).m_cover.m_footer.m_tag, "Cover.Footer");
    iwr_page_set_section_type(l_page, section_cover_footer);
    iwr_page_set_paper(l_page, &l_paper);
    gtk_grid_attach((*io_layout).m_grid, l_widget, 0, l_row++, 1, 1);
    gtk_grid_attach((*io_layout).m_grid, GTK_WIDGET(l_page), 0, l_row++, 1, 1);

    gtk_widget_show(GTK_WIDGET(l_widget));
    gtk_widget_show(GTK_WIDGET(l_page));

    layout_set_layout_size(io_layout);

  }while(0);

  return;
}

extern void
layout_new_coverheader(
  struct layout*const                   io_layout)
{
  IwrPage*                              l_page;
  struct paper                          l_paper;
  GtkWidget*                            l_widget;

  paper_set_from_page_setup_pt(&l_paper, (*io_layout).m_config.m_page_setup);

  do
  {

    if ((*io_layout).m_cover.m_header.m_page)
    {
      break;
    }

    l_widget= gtk_button_new_with_label("Cover.Header");
    gtk_button_set_relief(GTK_BUTTON(l_widget), GTK_RELIEF_NONE);
    gtk_widget_set_sensitive(l_widget, 0);
    l_page= IWR_PAGE(iwr_page_new());
    (*io_layout).m_cover.m_header.m_page= l_page;
    strcpy((*io_layout).m_cover.m_header.m_tag, "Cover.Header");
    iwr_page_set_section_type(l_page, section_cover_header);
    iwr_page_set_paper(l_page, &l_paper);
    gtk_grid_insert_row((*io_layout).m_grid, 0);
    gtk_grid_attach((*io_layout).m_grid, l_widget, 0, 0, 1, 1);
    gtk_grid_insert_row((*io_layout).m_grid, 1);
    gtk_grid_attach((*io_layout).m_grid, GTK_WIDGET(l_page), 0, 1, 1, 1);

    gtk_widget_show(GTK_WIDGET(l_widget));
    gtk_widget_show(GTK_WIDGET(l_page));

    layout_set_layout_size(io_layout);

  }while(0);

  return;
}

extern void
layout_new_reportdetail(
  struct layout*const                   io_layout)
{
  IwrPage*                              l_page;
  struct paper                          l_paper;
  gint                                  l_row;
  GtkWidget*                            l_widget;

  paper_set_from_page_setup_pt(&l_paper, (*io_layout).m_config.m_page_setup);

  do
  {

    if ((*io_layout).m_report.m_detail.m_page)
    {
      break;
    }

    l_row= 0;

    if ((*io_layout).m_cover.m_header.m_page)
    {
      l_row++;
      l_row++;
    }

    if ((*io_layout).m_report.m_header.m_page)
    {
      l_row++;
      l_row++;
    }

    l_widget= gtk_button_new_with_label("Report.Detail");
    gtk_button_set_relief(GTK_BUTTON(l_widget), GTK_RELIEF_NONE);
    gtk_widget_set_sensitive(l_widget, 0);
    l_page= IWR_PAGE(iwr_page_new());
    (*io_layout).m_report.m_detail.m_page= l_page;
    strcpy((*io_layout).m_report.m_detail.m_tag, "Report.Detail");
    iwr_page_set_section_type(l_page, section_report_detail);
    l_paper.m_height= POINTS_PER_INCH * 1.5;
    iwr_page_set_paper(l_page, &l_paper);
    gtk_grid_insert_row((*io_layout).m_grid, l_row);
    gtk_grid_attach((*io_layout).m_grid, l_widget, 0, l_row++, 1, 1);
    gtk_grid_insert_row((*io_layout).m_grid, l_row);
    gtk_grid_attach((*io_layout).m_grid, GTK_WIDGET(l_page), 0, l_row++, 1, 1);

    gtk_widget_show(GTK_WIDGET(l_widget));
    gtk_widget_show(GTK_WIDGET(l_page));

    layout_set_layout_size(io_layout);

  }while(0);

  return;
}

extern void
layout_new_reportfooter(
  struct layout*const                   io_layout)
{
  IwrPage*                              l_page;
  struct paper                          l_paper;
  gint                                  l_row;
  GtkWidget*                            l_widget;

  paper_set_from_page_setup_pt(&l_paper, (*io_layout).m_config.m_page_setup);

  do
  {

    if ((*io_layout).m_report.m_footer.m_page)
    {
      break;
    }

    l_row= 0;

    if ((*io_layout).m_cover.m_header.m_page)
    {
      l_row++;
      l_row++;
    }

    if ((*io_layout).m_report.m_header.m_page)
    {
      l_row++;
      l_row++;
    }

    l_row+= 2*(*io_layout).m_group_slots;

    if ((*io_layout).m_report.m_detail.m_page)
    {
      l_row++;
      l_row++;
    }

    l_row+= 2*(*io_layout).m_group_slots;

    l_widget= gtk_button_new_with_label("Report.Footer");
    gtk_button_set_relief(GTK_BUTTON(l_widget), GTK_RELIEF_NONE);
    gtk_widget_set_sensitive(l_widget, 0);
    l_page= IWR_PAGE(iwr_page_new());
    (*io_layout).m_report.m_footer.m_page= l_page;
    strcpy((*io_layout).m_report.m_footer.m_tag, "Report.Footer");
    l_paper.m_height= POINTS_PER_INCH * 1.0;
    iwr_page_set_section_type(l_page, section_report_footer);
    iwr_page_set_paper(l_page, &l_paper);
    gtk_grid_attach((*io_layout).m_grid, l_widget, 0, l_row++, 1, 1);
    gtk_grid_attach((*io_layout).m_grid, GTK_WIDGET(l_page), 0, l_row++, 1, 1);

    gtk_widget_show(GTK_WIDGET(l_widget));
    gtk_widget_show(GTK_WIDGET(l_page));

    layout_set_layout_size(io_layout);

  }while(0);

  return;
}

extern void
layout_new_reportheader(
  struct layout*const                   io_layout)
{
  IwrPage*                              l_page;
  struct paper                          l_paper;
  gint                                  l_row;
  GtkWidget*                            l_widget;

  paper_set_from_page_setup_pt(&l_paper, (*io_layout).m_config.m_page_setup);

  do
  {

    if ((*io_layout).m_report.m_header.m_page)
    {
      break;
    }

    l_row= 0;

    if ((*io_layout).m_cover.m_header.m_page)
    {
      l_row++;
      l_row++;
    }

    l_widget= gtk_button_new_with_label("Report.Header");
    gtk_button_set_relief(GTK_BUTTON(l_widget), GTK_RELIEF_NONE);
    gtk_widget_set_sensitive(l_widget, 0);
    l_page= IWR_PAGE(iwr_page_new());
    (*io_layout).m_report.m_header.m_page= l_page;
    strcpy((*io_layout).m_report.m_header.m_tag, "Report.Header");
    iwr_page_set_section_type(l_page, section_report_header);
    l_paper.m_height= POINTS_PER_INCH * 1.5;
    iwr_page_set_paper(l_page, &l_paper);
    gtk_grid_insert_row((*io_layout).m_grid, l_row);
    gtk_grid_attach((*io_layout).m_grid, l_widget, 0, l_row++, 1, 1);
    gtk_grid_insert_row((*io_layout).m_grid, l_row);
    gtk_grid_attach((*io_layout).m_grid, GTK_WIDGET(l_page), 0, l_row++, 1, 1);

    gtk_widget_show(GTK_WIDGET(l_widget));
    gtk_widget_show(GTK_WIDGET(l_page));

    layout_set_layout_size(io_layout);

  }while(0);

  return;
}

extern void
layout_paper_changed(
  struct layout*const                   io_layout)
{
  IwrPage*                              l_page;
  struct paper                          l_paper;
  struct paper                          l_paper2;
  unsigned                              l_slot;

  paper_set_from_page_setup_pt(&l_paper, (*io_layout).m_config.m_page_setup);

  l_page= (*io_layout).m_cover.m_header.m_page;
  if (l_page)
  {
    iwr_page_set_paper(l_page, &l_paper);
  }

  l_page= (*io_layout).m_cover.m_footer.m_page;
  if (l_page)
  {
    iwr_page_set_paper(l_page, &l_paper);
  }

  l_page= (*io_layout).m_report.m_header.m_page;
  if (l_page)
  {
    iwr_page_get_paper(&l_paper2, l_page);
    l_paper.m_height= l_paper2.m_height;
    iwr_page_set_paper(l_page, &l_paper);
  }

  l_page= (*io_layout).m_report.m_detail.m_page;
  if (l_page)
  {
    iwr_page_get_paper(&l_paper2, l_page);
    l_paper.m_height= l_paper2.m_height;
    iwr_page_set_paper(l_page, &l_paper);
  }

  l_page= (*io_layout).m_report.m_footer.m_page;
  if (l_page)
  {
    iwr_page_get_paper(&l_paper2, l_page);
    l_paper.m_height= l_paper2.m_height;
    iwr_page_set_paper(l_page, &l_paper);
  }

  for (l_slot= 0; (*io_layout).m_group_slots > l_slot; l_slot++)
  {
    l_page= (*io_layout).m_group[l_slot].m_header.m_page;
    iwr_page_get_paper(&l_paper2, l_page);
    l_paper.m_height= l_paper2.m_height;
    iwr_page_set_paper(l_page, &l_paper);

    l_page= (*io_layout).m_group[l_slot].m_footer.m_page;
    iwr_page_get_paper(&l_paper2, l_page);
    l_paper.m_height= l_paper2.m_height;
    iwr_page_set_paper(l_page, &l_paper);
  }

  layout_set_layout_size(io_layout);

  return;
}

static void
layout_steal_division(
  struct division*const                 io_target,
  struct division*const                 io_source)
{
  struct item*                          l_target;
  struct item*                          l_source;

  do
  {

    if (0 == (*io_target).m_page)
    {
      strcpy((*io_target).m_tag, (*io_source).m_tag);
      (*io_target).m_page= (*io_source).m_page;
      break;
    }

    iwr_page_get_item(&l_target, (*io_target).m_page);
    iwr_page_get_item(&l_source, (*io_source).m_page);

    if (0 == (*l_target).m_head)
    {
      memcpy(l_target, l_source, sizeof(*l_target));
    }
    else
    {
      (*l_target).m_tail->m_next= (*l_source).m_head;
      (*l_source).m_head->m_prev= (*l_target).m_tail; 
      (*l_target).m_tail= (*l_source).m_tail;
    }

    memset(l_source, 0, sizeof(*l_source));
    gtk_widget_destroy(GTK_WIDGET((*io_source).m_page));

  }while(0);

  memset(io_source, 0, sizeof(*io_source));

  return;
}

static int
layout_read_division(
  GError**                              o_error,
  struct layout *const                  io_layout,
  struct bson_node const*const          i_bson_section)
{
  struct division                       l_division;
  int                                   l_exit;
  enum iwr_page_section_type            l_type;

  memset(&l_division, 0, sizeof(l_division));

  do
  {

    strncpy(
      l_division.m_tag,
      (*i_bson_section).m_ename,
      sizeof(l_division.m_tag));

    l_division.m_page= IWR_PAGE(iwr_page_new());

    l_exit= iwr_page_read(
      o_error,
      l_division.m_page, 
      (*i_bson_section).m_object.m_array.m_head);

    if (l_exit)
    {
      gtk_widget_destroy(GTK_WIDGET(l_division.m_page));
      break;
    }

    iwr_page_get_section_type(&l_type, l_division.m_page);

    switch(l_type)
    {
    case section_cover_header:
      layout_steal_division(&(*io_layout).m_cover.m_header, &l_division);
      break;
    case section_cover_footer:
      layout_steal_division(&(*io_layout).m_cover.m_footer, &l_division);
      break;
    case section_report_header:
      layout_steal_division(&(*io_layout).m_report.m_header, &l_division);
      break;
    case section_report_detail:
      layout_steal_division(&(*io_layout).m_report.m_detail, &l_division);
      break;
    case section_report_footer:
      layout_steal_division(&(*io_layout).m_report.m_footer, &l_division);
      break;
    default:
      gtk_widget_destroy(GTK_WIDGET(l_division.m_page));
      break;
    }

  }while(0);

  return l_exit;
}

static int
layout_read_divisions(
  GError**                              o_error,
  struct layout *const                  io_layout,
  struct bson_node const*const          i_bson_document)
{
  int                                   l_exit;
  struct bson_node const*               l_bson_section;

  l_exit= 0;
  l_bson_section= (*i_bson_document).m_object.m_document.m_head;

  do
  {

    if (0 == l_bson_section)
    {
      break;
    }

    if (bson_type_array == (*l_bson_section).m_type)
    {

      l_exit= layout_read_division(o_error, io_layout, l_bson_section);

      if (l_exit)
      {
        break;
      }
    }

    l_bson_section= (*l_bson_section).m_next;

  }while(1);

  return l_exit;
}

static int
layout_read_group(
  GError**                              o_error,
  struct layout *const                  io_layout,
  struct bson_node const*const          i_bson_group)
{
  int                                   l_exit;
  int                                   l_found;
  struct division_group                 l_group;
  struct bson_node*                     l_bson_header;
  struct bson_node*                     l_bson_footer;
  unsigned                              l_slot;
  struct division_group*                l_ptr;

  l_exit= 0;
  memset(&l_group, 0, sizeof(l_group));
  
  do
  {

    strncpy(
      l_group.m_break.m_tag,
      (*i_bson_group).m_ename, 
      sizeof(l_group.m_break.m_tag));

    l_bson_header= (*i_bson_group).m_object.m_array.m_head;
    l_group.m_header.m_page= IWR_PAGE(iwr_page_new());

    strncpy(
      l_group.m_header.m_tag, 
      (*l_bson_header).m_ename,
      sizeof(l_group.m_header.m_tag));

    l_exit= iwr_page_read(
      o_error,
      l_group.m_header.m_page,
      (*l_bson_header).m_object.m_array.m_head);

    if (l_exit)
    {
      gtk_widget_destroy(GTK_WIDGET(l_group.m_header.m_page));
      break;
    }
  
    l_bson_footer= (*l_bson_header).m_next;
    l_group.m_footer.m_page= IWR_PAGE(iwr_page_new());

    strncpy(
      l_group.m_footer.m_tag, 
      (*l_bson_footer).m_ename,
      sizeof(l_group.m_footer.m_tag));

    l_exit= iwr_page_read(
      o_error,
      l_group.m_footer.m_page,
      (*l_bson_footer).m_object.m_array.m_head);

    if (l_exit)
    {
      gtk_widget_destroy(GTK_WIDGET(l_group.m_header.m_page));
      gtk_widget_destroy(GTK_WIDGET(l_group.m_footer.m_page));
      break;
    }
  
    l_found= 0;
    for (l_slot= 0; (*io_layout).m_group_slots > l_slot; l_slot++)
    {

      l_found= (0 == strcmp(
        (*io_layout).m_group[l_slot].m_break.m_tag,
        l_group.m_break.m_tag));

      if (l_found)
      {
        layout_steal_division(
          &(*io_layout).m_group[l_slot].m_header,
          &l_group.m_header);
        layout_steal_division(
          &(*io_layout).m_group[l_slot].m_footer,
          &l_group.m_footer);
        break;
      }

    }

    if (l_found)
    {
      break;
    }

    (*io_layout).m_group= realloc(
      (*io_layout).m_group,
      (1 + (*io_layout).m_group_slots) * sizeof(struct division_group));

    l_ptr= &(*io_layout).m_group[(*io_layout).m_group_slots];
    memset(l_ptr, 0, sizeof(*l_ptr));
    (*io_layout).m_group_slots++;

    strcpy((*l_ptr).m_break.m_tag, l_group.m_break.m_tag);
    layout_steal_division(&(*l_ptr).m_header, &l_group.m_header);
    layout_steal_division(&(*l_ptr).m_footer, &l_group.m_footer);

  }while(0);

  return l_exit;
}

static int
layout_read_groups(
  GError**                              o_error,
  struct layout *const                  io_layout,
  struct bson_node const*const          i_bson_document)
{
  int                                   l_exit;
  struct bson_node const*               l_bson_section;

  l_bson_section= (*i_bson_document).m_object.m_document.m_head;

  do
  {

    if (0 == l_bson_section)
    {
      break;
    }

    if (bson_type_array == (*l_bson_section).m_type)
    {
      l_exit= layout_read_group(o_error, io_layout, l_bson_section);
    }
    else if (bson_type_string == (*l_bson_section).m_type)
    {
      if (0 == strcmp("page_break", (*l_bson_section).m_ename))
      {
        strncpy(
          (*io_layout).m_page_break.m_tag,
          (*l_bson_section).m_object.m_string.m_text, 
          sizeof((*io_layout).m_page_break.m_tag));
      }
    }

    l_bson_section= (*l_bson_section).m_next;

  }while(1);

  return l_exit;
}

extern int
layout_read(
  GError**                              o_error,
  struct layout *const                  io_layout,
  struct bson_node const*const          i_element)
{
  struct bson_node const*               l_bson;
  GError*                               l_error;
  int                                   l_exit;
  int                                   l_rc;

  l_error= 0;

  do
  {

    l_exit= config_read(&l_error, &(*io_layout).m_config);

    if (l_exit)
    {
      break;
    }

    l_bson= i_element;

    do
    {

      if (0 == l_bson)
      {
        break;
      }

      do
      {

        if (bson_type_document != (*l_bson).m_type)
        {
          break;
        }

        l_rc= strcmp("sections", (*l_bson).m_ename);

        if (0 == l_rc) 
        {
          l_exit= layout_read_divisions(&l_error, io_layout, l_bson);
          break;
        }

        l_rc= strcmp("groups", (*l_bson).m_ename);

        if (0 == l_rc)
        {
          l_exit= layout_read_groups(&l_error, io_layout, l_bson);
          break;
        }

      }while(0);

      if (l_exit)
      {
        break;
      }

      l_bson= (*l_bson).m_next;

    }while(1);

    if (l_exit)
    {
      break;
    }

    layout_divisions_read_config(io_layout);
    layout_add_divisions_to_grid(io_layout);

  }while(0);

  if (l_error)
  {
    g_propagate_error(o_error, l_error);
  }

  return l_exit;
}

extern void
layout_set_horizontal_ruler_line(
  struct layout *const                  io_layout,
  gboolean const                        i_state)
{
  IwrPage*                              l_page;
  unsigned                              l_slot;

  l_page= (*io_layout).m_cover.m_header.m_page;
  if (l_page)
  {
    iwr_page_set_horizontal_ruler_line(l_page, i_state);
  }

  l_page= (*io_layout).m_cover.m_footer.m_page;
  if (l_page)
  {
    iwr_page_set_horizontal_ruler_line(l_page, i_state);
  }

  l_page= (*io_layout).m_report.m_header.m_page;
  if (l_page)
  {
    iwr_page_set_horizontal_ruler_line(l_page, i_state);
  }

  l_page= (*io_layout).m_report.m_detail.m_page;
  if (l_page)
  {
    iwr_page_set_horizontal_ruler_line(l_page, i_state);
  }

  l_page= (*io_layout).m_report.m_footer.m_page;
  if (l_page)
  {
    iwr_page_set_horizontal_ruler_line(l_page, i_state);
  }

  for (l_slot= 0; (*io_layout).m_group_slots > l_slot; l_slot++)
  {
    l_page= (*io_layout).m_group[l_slot].m_header.m_page;
    iwr_page_set_horizontal_ruler_line(l_page, i_state);

    l_page= (*io_layout).m_group[l_slot].m_footer.m_page;
    iwr_page_set_horizontal_ruler_line(l_page, i_state);
  }

  return;
}

extern void
layout_set_layout_size(
  struct layout*const                   io_layout)
{
  unsigned                              l_count;
  double                                l_height;
  IwrPage*                              l_page;
  struct paper                          l_paper;
  unsigned                              l_slot;
  double                                l_width;

  l_height= 0.0;
  l_count= 0;

  l_page= (*io_layout).m_cover.m_header.m_page;
  if (l_page)
  {
    iwr_page_get_paper(&l_paper, l_page);
    l_height+= l_paper.m_height;
    l_count++;
  }

  l_page= (*io_layout).m_cover.m_footer.m_page;
  if (l_page)
  {
    iwr_page_get_paper(&l_paper, l_page);
    l_height+= l_paper.m_height;
    l_count++;
  }

  l_page= (*io_layout).m_report.m_header.m_page;
  if (l_page)
  {
    iwr_page_get_paper(&l_paper, l_page);
    l_height+= l_paper.m_height;
    l_count++;
  }

  l_page= (*io_layout).m_report.m_detail.m_page;
  if (l_page)
  {
    iwr_page_get_paper(&l_paper, l_page);
    l_height+= l_paper.m_height;
    l_count++;
  }

  l_page= (*io_layout).m_report.m_footer.m_page;
  if (l_page)
  {
    iwr_page_get_paper(&l_paper, l_page);
    l_height+= l_paper.m_height;
    l_count++;
  }

  for (l_slot= 0; (*io_layout).m_group_slots > l_slot; l_slot++)
  {
    l_page= (*io_layout).m_group[l_slot].m_header.m_page;
    iwr_page_get_paper(&l_paper, l_page);
    l_height+= l_paper.m_height;

    l_page= (*io_layout).m_group[l_slot].m_footer.m_page;
    iwr_page_get_paper(&l_paper, l_page);
    l_height+= l_paper.m_height;
    l_count++;
    l_count++;
  }

  paper_set_from_page_setup_pt(&l_paper, (*io_layout).m_config.m_page_setup);

  l_height*= (*io_layout).m_scale;
  l_height+= 32.0 * l_count;
  l_width= (*io_layout).m_scale * l_paper.m_width;

  gtk_layout_set_size((*io_layout).m_layout, l_width, l_height);

  return;
}

extern void
layout_set_scale(
  struct layout *const                  io_layout,
  double const                          i_scale)
{
  IwrPage*                              l_page;
  unsigned                              l_slot;

  (*io_layout).m_scale= i_scale;

  l_page= (*io_layout).m_cover.m_header.m_page;
  if (l_page)
  {
    iwr_page_set_scale(l_page, (*io_layout).m_scale);
  }

  l_page= (*io_layout).m_cover.m_footer.m_page;
  if (l_page)
  {
    iwr_page_set_scale(l_page, (*io_layout).m_scale);
  }

  l_page= (*io_layout).m_report.m_header.m_page;
  if (l_page)
  {
    iwr_page_set_scale(l_page, (*io_layout).m_scale);
  }

  l_page= (*io_layout).m_report.m_detail.m_page;
  if (l_page)
  {
    iwr_page_set_scale(l_page, (*io_layout).m_scale);
  }

  l_page= (*io_layout).m_report.m_footer.m_page;
  if (l_page)
  {
    iwr_page_set_scale(l_page, (*io_layout).m_scale);
  }

  for (l_slot= 0; (*io_layout).m_group_slots > l_slot; l_slot++)
  {
    l_page= (*io_layout).m_group[l_slot].m_header.m_page;
    iwr_page_set_scale(l_page, (*io_layout).m_scale);

    l_page= (*io_layout).m_group[l_slot].m_footer.m_page;
    iwr_page_set_scale(l_page, (*io_layout).m_scale);
  }

  layout_set_layout_size(io_layout);

  return;
}

extern void
layout_set_scale_zoom_in(
  struct layout *const                    io_layout)
{
  double                                  l_scale;

  do
  {

    if (SCALE_MIN >= (*io_layout).m_scale)
    {
      break;
    }

    l_scale= ((*io_layout).m_scale - SCALE_FACTOR);

    layout_set_scale(io_layout, l_scale);

  }while(0);

  return;
}

extern void
layout_set_scale_zoom_out(
  struct layout *const                    io_layout)
{
  double                                  l_scale;

  do
  {

    if (SCALE_MAX <= (*io_layout).m_scale)
    {
      break;
    }

    l_scale= ((*io_layout).m_scale + SCALE_FACTOR);

    layout_set_scale(io_layout, l_scale);

  }while(0);

  return;
}

extern void
layout_set_vertical_ruler_line(
  struct layout *const                  io_layout,
  gboolean const                        i_state)
{
  IwrPage*                              l_page;
  unsigned                              l_slot;

  l_page= (*io_layout).m_cover.m_header.m_page;
  if (l_page)
  {
    iwr_page_set_vertical_ruler_line(l_page, i_state);
  }

  l_page= (*io_layout).m_cover.m_footer.m_page;
  if (l_page)
  {
    iwr_page_set_vertical_ruler_line(l_page, i_state);
  }

  l_page= (*io_layout).m_report.m_header.m_page;
  if (l_page)
  {
    iwr_page_set_vertical_ruler_line(l_page, i_state);
  }

  l_page= (*io_layout).m_report.m_detail.m_page;
  if (l_page)
  {
    iwr_page_set_vertical_ruler_line(l_page, i_state);
  }

  l_page= (*io_layout).m_report.m_footer.m_page;
  if (l_page)
  {
    iwr_page_set_vertical_ruler_line(l_page, i_state);
  }

  for (l_slot= 0; (*io_layout).m_group_slots > l_slot; l_slot++)
  {
    l_page= (*io_layout).m_group[l_slot].m_header.m_page;
    iwr_page_set_vertical_ruler_line(l_page, i_state);

    l_page= (*io_layout).m_group[l_slot].m_footer.m_page;
    iwr_page_set_vertical_ruler_line(l_page, i_state);
  }

  return;
}

extern void
layout_size_allocate(
  struct layout*const                   io_layout,
  GdkRectangle const*const              i_alloc)
{
  guint                                 l_len_x;
  guint                                 l_len_y;
  double                                l_page_center;
  double                                l_pos_x;
  double                                l_pos_y;
  double                                l_window_center;

  gtk_layout_get_size((*io_layout).m_layout, &l_len_x, &l_len_y); 

  l_window_center= (*i_alloc).width / 2.0;
  l_page_center= l_len_x / 2.0;
  l_pos_x= (l_window_center - l_page_center);

  if (0 > l_pos_x)
  {
    l_pos_x= 0.0;
  }

  l_window_center= (*i_alloc).height / 2.0;
  l_page_center= l_len_y / 2.0;
  l_pos_y= (l_window_center - l_page_center);

  if (0 > l_pos_y)
  {
    l_pos_y= 0.0;
  }

  gtk_layout_move(
    (*io_layout).m_layout, 
    GTK_WIDGET((*io_layout).m_grid),
    l_pos_x,
    l_pos_y);

  return;
}

static int
layout_write_division(
  GError**                              o_error,
  FILE*const                            io_fp,
  struct division const*                i_division)
{
  int                                   l_exit;
  int32_t                               l_int32;
  char                                  l_octet;
  int32_t                               l_offset;
  int32_t                               l_size;
  enum iwr_page_section_type            l_type;

  l_exit= 0;

  do
  {

    if (0 == i_division)
    {
      break;
    }

    if (0 == (*i_division).m_page)
    {
      break;
    }

    l_octet= bson_type_array;
    fwrite(&l_octet, 1, 1, io_fp); 
    fprintf(io_fp, "%s%c", (*i_division).m_tag, 0);

    /* document */
    l_offset= ftell(io_fp);
    l_int32= 0;
    fwrite(&l_int32, sizeof(int32_t), 1, io_fp); 

    /* type */
    iwr_page_get_section_type(&l_type, (*i_division).m_page);
    l_octet= bson_type_int32;
    fwrite(&l_octet, 1, 1, io_fp); 
    fprintf(io_fp, "type%c",0);
    fwrite(&l_type, sizeof(int32_t), 1, io_fp);

    l_exit= iwr_page_write(o_error, io_fp, (*i_division).m_page);

    if (l_exit)
    {
      break;
    }

    /* end of document */
    l_octet= 0;
    fwrite(&l_octet, 1, 1, io_fp); 

    /* document */
    l_int32= ftell(io_fp);
    l_size= (l_int32 - l_offset);
    fseek(io_fp, l_offset, SEEK_SET);
    fwrite(&l_size, sizeof(l_size), 1, io_fp); 

    fseek(io_fp, 0, SEEK_END);

  }while(0);

  return l_exit;
}

static int
layout_write_divisions(
  GError**                              o_error,
  FILE*const                            io_fp,
  struct layout const*const             i_layout)
{
  int                                   l_exit;
  int32_t                               l_int32;
  char                                  l_octet;
  int32_t                               l_offset;
  int32_t                               l_size;

  do
  {

    l_octet= bson_type_document;
    fwrite(&l_octet, 1, 1, io_fp); 
    fprintf(io_fp, "%s%c", "sections", 0);

    /* document */
    l_offset= ftell(io_fp);
    l_int32= 0;
    fwrite(&l_int32, sizeof(int32_t), 1, io_fp); 

    l_exit= layout_write_division(o_error, io_fp, &(*i_layout).m_cover.m_header);

    if (l_exit)
    {
      break;
    }

    l_exit= layout_write_division(o_error, io_fp, &(*i_layout).m_cover.m_footer);

    if (l_exit)
    {
      break;
    }

    l_exit= layout_write_division(o_error, io_fp, &(*i_layout).m_report.m_header);

    if (l_exit)
    {
      break;
    }

    l_exit= layout_write_division(o_error, io_fp, &(*i_layout).m_report.m_detail);

    if (l_exit)
    {
      break;
    }

    l_exit= layout_write_division(o_error, io_fp, &(*i_layout).m_report.m_footer);

    if (l_exit)
    {
      break;
    }

    /* end of document */
    l_octet= 0;
    fwrite(&l_octet, 1, 1, io_fp); 

    /* document */
    l_int32= ftell(io_fp);
    l_size= (l_int32 - l_offset);
    fseek(io_fp, l_offset, SEEK_SET);
    fwrite(&l_size, sizeof(l_size), 1, io_fp); 

    fseek(io_fp, 0, SEEK_END);

  }while(0);

  return l_exit;
}

extern int
layout_write_group(
  GError**                              o_error,
  FILE*const                            io_fp,
  struct division_group const*const     i_group)
{
  int                                   l_exit;
  int32_t                               l_int32;
  char                                  l_octet;
  int32_t                               l_offset;
  int32_t                               l_size;

  do
  {

    l_octet= bson_type_array;
    fwrite(&l_octet, 1, 1, io_fp); 
    fprintf(io_fp, "%s%c", (*i_group).m_break.m_tag, 0);

    /* document */
    l_offset= ftell(io_fp);
    l_int32= 0;
    fwrite(&l_int32, sizeof(int32_t), 1, io_fp); 

    l_exit= layout_write_division(o_error, io_fp, &(*i_group).m_header);

    if (l_exit)
    {
      break;
    }

    l_exit= layout_write_division(o_error, io_fp, &(*i_group).m_footer);

    if (l_exit)
    {
      break;
    }

    /* end of document */
    l_octet= 0;
    fwrite(&l_octet, 1, 1, io_fp); 

    /* document */
    l_int32= ftell(io_fp);
    l_size= (l_int32 - l_offset);
    fseek(io_fp, l_offset, SEEK_SET);
    fwrite(&l_size, sizeof(l_size), 1, io_fp); 

    fseek(io_fp, 0, SEEK_END);

  }while(0);

  return l_exit;
}

extern int
layout_write_groups(
  GError**                              o_error,
  FILE*const                            io_fp,
  struct layout const*const             i_layout)
{
  int                                   l_exit;
  struct division_group*                l_group;
  int32_t                               l_int32;
  char                                  l_octet;
  int32_t                               l_offset;
  int32_t                               l_size;
  unsigned                              l_slot;

  do
  {

    if ((0 == (*i_layout).m_group_slots) &&
      (0 == (*i_layout).m_page_break.m_tag[0]))
    {
      break;
    } 

    l_octet= bson_type_document;
    fwrite(&l_octet, 1, 1, io_fp); 
    fprintf(io_fp, "%s%c", "groups", 0);

    /* document */
    l_offset= ftell(io_fp);
    l_int32= 0;
    fwrite(&l_int32, sizeof(int32_t), 1, io_fp); 

    /* page break */
    if ((*i_layout).m_page_break.m_tag[0])
    {
      l_octet= bson_type_string;
      fwrite(&l_octet, 1, 1, io_fp); 
      fprintf(io_fp, "page_break%c",0);
      l_int32= 1+strlen((*i_layout).m_page_break.m_tag);
      fwrite(&l_int32, sizeof(int32_t), 1, io_fp); 
      fwrite((*i_layout).m_page_break.m_tag, 1, l_int32, io_fp);
    }

    l_group= &(*i_layout).m_group[0];

    for (l_slot= 0; (*i_layout).m_group_slots > l_slot; l_slot++)
    {

      l_exit= layout_write_group(o_error, io_fp, l_group);

      if (l_exit)
      {
        break;
      }

      l_group++;
    }

    /* end of document */
    l_octet= 0;
    fwrite(&l_octet, 1, 1, io_fp); 

    /* document */
    l_int32= ftell(io_fp);
    l_size= (l_int32 - l_offset);
    fseek(io_fp, l_offset, SEEK_SET);
    fwrite(&l_size, sizeof(l_size), 1, io_fp); 

    fseek(io_fp, 0, SEEK_END);

  }while(0);

  return l_exit;
}

extern int
layout_write(
  GError**                              o_error,
  FILE*const                            io_fp,
  struct layout const*const             i_layout)
{
  int                                   l_exit;

  do
  {

    l_exit= config_write(o_error, &(*i_layout).m_config);

    if (l_exit)
    {
      break;
    }

    layout_divisions_write_config(i_layout);

    l_exit= layout_write_divisions(o_error, io_fp, i_layout);

    if (l_exit)
    {
      break;
    }

    l_exit= layout_write_groups(o_error, io_fp, i_layout);

  }while(0);

  return l_exit;
}
