/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2015-2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __iwr_page_h__

#include "global_common.h"
#include "item.h"
#include "paper.h"

G_BEGIN_DECLS

#define IWR_TYPE_PAGE\
  (iwr_page_get_type ())

#define IWR_PAGE(obj)\
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), IWR_TYPE_PAGE, IwrPage))

#define IWR_PAGE_CLASS(klass)\
  (G_TYPE_CHECK_CLASS_CAST ((klass), IWR_TYPE_PAGE, IwrPageClass))

#define IWR_IS_PAGE(obj)\
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IWR_TYPE_PAGE))

#define IWR_IS_PAGE_CLASS(klass)\
  (G_TYPE_CHECK_CLASS_TYPE ((klass), IWR_TYPE_PAGE))

#define IWR_PAGE_GET_CLASS(obj)\
  (G_TYPE_INSTANCE_GET_CLASS ((obj), IWR_TYPE_PAGE, IwrPageClass))

typedef struct _IwrPage	                IwrPage;
typedef struct _IwrPageClass            IwrPageClass;
typedef struct _IwrPagePrivate          IwrPagePrivate;

enum iwr_page_section_type
{
  section_unknown= -1,
  section_cover_header=0,
  section_cover_footer,
  section_report_header,
  section_report_detail,
  section_report_footer,
  section_group_header,
  section_group_footer,
  section_label
};

struct _IwrPage
{
  GtkWidget                             m_widget;
  IwrPagePrivate*                       m_priv;
};

struct _IwrPageClass
{
  GtkWidgetClass                        parent_class;
};

extern void
iwr_page_clear(
  IwrPage*const                         io_page);

extern void
iwr_page_draw_item(
  cairo_t*const                         i_cr,
  IwrPage *const                        io_page,
  struct item_draw_options const*const  i_option);

extern GType
iwr_page_get_type();

extern void
iwr_page_get_item(
  struct item**const                    o_item,
  IwrPage const*const                   i_page);

extern void
iwr_page_get_paper(
  struct paper *const                   o_paper,
  IwrPage const*const                   i_page);

extern void
iwr_page_get_scale(
  double *const                          o_scale,
  IwrPage const*const                    i_page);

extern void
iwr_page_get_section_type(
  enum iwr_page_section_type* const     o_type,
  IwrPage const*const                   i_page);

extern void
iwr_page_item_new(
  struct item_node**                    o_node,
  IwrPage*const                         io_page,
  enum item_type const                  i_type);

extern void
iwr_page_item_selected_move(
  IwrPage*const                         io_page,
  struct geom_point const*const         i_event);

extern GtkWidget *
iwr_page_new();

extern int
iwr_page_read(
  GError**                              o_error,
  IwrPage*const                         io_page,
  struct bson_node const*const          i_element);

extern void
iwr_page_set_highlight_objects(
  IwrPage*const                         io_page,
  gboolean const                        i_state);

extern void
iwr_page_set_paper(
  IwrPage*const                         io_page,
  struct paper const*const              i_paper);

extern void
iwr_page_set_horizontal_ruler_line(
  IwrPage*const                         io_page,
  gboolean const                        i_state);

extern void
iwr_page_set_vertical_ruler_line(
  IwrPage*const                         io_page,
  gboolean const                        i_state);

extern void
iwr_page_set_scale(
  IwrPage*const                         io_page,
  double const                          i_scale);

extern void
iwr_page_set_section_type(
  IwrPage*const                         io_page,
  enum iwr_page_section_type const      i_type);

extern int
iwr_page_write(
  GError**                              o_error,
  FILE*const                            io_fp,
  IwrPage const*const                   i_page);

G_END_DECLS

#define  __iwr_page_h__
#endif 
