/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2015-2016, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "item_text.h"

struct text_dialog
{
  GtkEntry*                             m_color_entry;
  GtkButton*                            m_color_button;
  GtkEntry*                             m_font_entry;
  GtkButton*                            m_font_button; 
  GtkCheckButton*                       m_rotate_checkbutton;
  GtkCheckButton*                       m_autowrap_checkbutton;
  GtkTextView*                          m_text_textview;
};

static void
item_text_color_button_cb(
  GtkWidget *                           i_widget,
  gpointer                              i_data)
{
  GdkRGBA                               l_color;
  GtkWidget*                            l_dialog;
  int                                   l_exit;
  struct text_dialog*                   l_textd;
  gchar*                                l_rgba;
  gchar const*                          l_text;

  l_dialog= 0;
  memset(&l_color, 0, sizeof(l_color));

  do
  {

    l_textd= (struct text_dialog*)i_data;

    l_dialog= gtk_color_chooser_dialog_new("Border Color", mainw());

    l_text= gtk_entry_get_text((*l_textd).m_color_entry);
    gdk_rgba_parse(&l_color, l_text);
    gtk_color_chooser_set_rgba(GTK_COLOR_CHOOSER(l_dialog), &l_color);

    gtk_window_set_modal((GtkWindow*)l_dialog, 1);
    l_exit= gtk_dialog_run(GTK_DIALOG(l_dialog));

    if (GTK_RESPONSE_OK != l_exit)
    {
      break;
    }

    gtk_color_chooser_get_rgba(GTK_COLOR_CHOOSER(l_dialog), &l_color);

    l_rgba= gdk_rgba_to_string(&l_color);
    gtk_entry_set_text((*l_textd).m_color_entry, l_rgba);
    g_free(l_rgba);

  }while(0);

  if (l_dialog)
  {
    gtk_widget_destroy((GtkWidget*)l_dialog);
  }
  
  return;
}

static void
item_text_font_button_cb(
  GtkWidget *                           i_widget,
  gpointer                              i_data)
{
  GtkWidget*                            l_dialog;
  int                                   l_exit;
  struct text_dialog*                  l_textd;
  gchar*                                l_font;
  gchar const*                          l_text;

  l_dialog= 0;
  l_exit= 0;
  l_font= 0;

  do
  {

    l_textd= (struct text_dialog*)i_data;

    l_text= gtk_entry_get_text(GTK_ENTRY((*l_textd).m_font_entry));

    l_dialog= gtk_font_chooser_dialog_new("Font", mainw());

    gtk_font_chooser_set_font(GTK_FONT_CHOOSER(l_dialog), l_text);

    gtk_window_set_modal((GtkWindow*)l_dialog, 1);
    l_exit= gtk_dialog_run(GTK_DIALOG(l_dialog));

    if (GTK_RESPONSE_OK != l_exit)
    {
      break;
    }

    l_font= gtk_font_chooser_get_font(GTK_FONT_CHOOSER(l_dialog));
    gtk_entry_set_text(
      (GTK_ENTRY((*l_textd).m_font_entry)),
      l_font);

  }while(0);

  if (l_font)
  {
    g_free(l_font);
  }

  if (l_dialog)
  {
    gtk_widget_destroy((GtkWidget*)l_dialog);
  }

  return;
}

static void
item_text_bind(
  struct text_dialog*const              o_textd,
  GtkBuilder*const                      i_builder)
{

  memset(o_textd, 0, sizeof(*o_textd));

  do
  {

    (*o_textd).m_color_entry=
      GTK_ENTRY(gtk_builder_get_object(i_builder, "color_entry"));

    (*o_textd).m_color_button=
      GTK_BUTTON(gtk_builder_get_object(i_builder, "color_button"));

    g_signal_connect(
      (*o_textd).m_color_button,
      "clicked",
      G_CALLBACK(item_text_color_button_cb),
      o_textd);

    (*o_textd).m_font_entry=
      GTK_ENTRY(gtk_builder_get_object(i_builder, "font_entry"));

    (*o_textd).m_font_button=
      GTK_BUTTON(gtk_builder_get_object(i_builder, "font_button"));

    g_signal_connect(
      (*o_textd).m_font_button,
      "clicked",
      G_CALLBACK(item_text_font_button_cb),
      o_textd);

    (*o_textd).m_rotate_checkbutton=
      GTK_CHECK_BUTTON(gtk_builder_get_object(i_builder, "rotate_checkbutton"));

    (*o_textd).m_autowrap_checkbutton=
      GTK_CHECK_BUTTON(gtk_builder_get_object(i_builder, "autowrap_checkbutton"));

    (*o_textd).m_text_textview=
      GTK_TEXT_VIEW(gtk_builder_get_object(i_builder, "text_textview"));

  }while(0);

  return;
}

static void
item_text_set_values(
  struct text_dialog*const              i_textd,
  struct item_text *const               i_text)
{
  GtkTextBuffer*                        l_buffer;
  gchar *                               l_color;
  gchar *                               l_font;

  l_color= gdk_rgba_to_string(&(*i_text).m_color);
  gtk_entry_set_text((*i_textd).m_color_entry, l_color);
  g_free(l_color);
  l_color= 0;

  l_font= pango_font_description_to_string((*i_text).m_font);
  gtk_entry_set_text((*i_textd).m_font_entry, l_font);
  g_free(l_font);

  gtk_toggle_button_set_active(
    GTK_TOGGLE_BUTTON((*i_textd).m_rotate_checkbutton),
    (*i_text).m_rotate);

  gtk_toggle_button_set_active(
    GTK_TOGGLE_BUTTON((*i_textd).m_autowrap_checkbutton),
    (*i_text).m_autowrap);

  if ((*i_text).m_text)
  {
    l_buffer= gtk_text_view_get_buffer((*i_textd).m_text_textview);
    gtk_text_buffer_set_text(l_buffer, (*i_text).m_text, -1);
  }

  return;
}

static void
item_text_copy_values(
  struct item_text *const              io_text,
  struct text_dialog const*const       i_textd)
{
  GtkTextBuffer*                        l_buffer;
  GtkTextIter                           l_end;
  int                                   l_first;
  int                                   l_last;
  int                                   l_size;
  GtkTextIter                           l_start;
  gchar const*                          l_text;

  l_text= gtk_entry_get_text(GTK_ENTRY((*i_textd).m_color_entry));
  gdk_rgba_parse(&(*io_text).m_color, l_text);

  l_text= gtk_entry_get_text(GTK_ENTRY((*i_textd).m_font_entry));
  if ((*io_text).m_font)
  {
    pango_font_description_free((*io_text).m_font);
  }

  (*io_text).m_font= pango_font_description_from_string(l_text);

  (*io_text).m_rotate= 
    gtk_toggle_button_get_active(
      GTK_TOGGLE_BUTTON((*i_textd).m_rotate_checkbutton));

  if (0 == (*io_text).m_rotate)
  {
    (*io_text).m_rotation= 0.0;
    (*io_text).m_pos_y2= (*io_text).m_pos_y1;
  }

  (*io_text).m_autowrap= 
    gtk_toggle_button_get_active(
      GTK_TOGGLE_BUTTON((*i_textd).m_autowrap_checkbutton));

  l_buffer= gtk_text_view_get_buffer((*i_textd).m_text_textview);

  gtk_text_buffer_get_start_iter(l_buffer, &l_start);
  gtk_text_buffer_get_end_iter(l_buffer, &l_end);
  l_first= gtk_text_iter_get_offset(&l_start);
  l_last= gtk_text_iter_get_offset(&l_end);
  l_size= l_last - l_first;

  if ((*io_text).m_text)
  {
    g_free((*io_text).m_text);
  }

  (*io_text).m_text= (char*)g_malloc0(1+l_size);

  l_text= gtk_text_buffer_get_text(l_buffer, &l_start, &l_end, 0); 
  memcpy((*io_text).m_text, l_text, l_size);
  utf8_scrub_kludge((*io_text).m_text);

  return;
}

extern int
item_text_property(
  struct item_text*const               io_text)
{
  GtkBox*                               l_box;
  GtkBuilder*                           l_builder;
  GtkDialog*                            l_dialog;
  GtkBox*                               l_instance;
  GError*                               l_error;
  int                                   l_exit;
  struct text_dialog                    l_textd;
  int                                   l_rc;

  l_builder= 0;
  l_instance= 0;
  l_error= 0;
  l_exit= 0;

  do
  {

    l_builder= gtk_builder_new();

    l_rc= wrap_gtk_builder_add_from_file(l_builder, "text.glade", &l_error);

    if (0 == l_rc)
    {
      l_exit= -1;
      break;
    }
  
    l_instance= GTK_BOX(gtk_builder_get_object(l_builder, "text_box"));

    if (0 == l_instance)
    {
      l_error= g_error_new(
        GENERAL,
        GENERIC,
        "Unable to find dialog object: 'text_box'");
      l_exit= -1;
      break;
    }

    item_text_bind(&l_textd, l_builder);

    item_text_set_values(&l_textd, io_text);

    l_dialog= GTK_DIALOG(gtk_dialog_new_with_buttons(
      "Text Edit",
      mainw(),
      GTK_DIALOG_MODAL,
      "Ok",
      GTK_RESPONSE_OK,
      "Cancel",
      GTK_RESPONSE_CANCEL,
      NULL));
  
    gtk_window_set_default_size(GTK_WINDOW(l_dialog), 340, 450);

    l_box= GTK_BOX(gtk_dialog_get_content_area(GTK_DIALOG(l_dialog)));

    gtk_box_pack_start(GTK_BOX(l_box), GTK_WIDGET(l_instance), 1, 1,0);

    gtk_widget_show(GTK_WIDGET(l_instance));

    gtk_widget_show_all(GTK_WIDGET(l_dialog));
    gtk_window_set_modal(GTK_WINDOW(l_dialog), 1);
    l_exit= gtk_dialog_run(l_dialog);

    if (GTK_RESPONSE_OK != l_exit)
    {
      break;
    }

    item_text_copy_values(io_text, &l_textd);

  }while(0);

  if (l_builder)
  {
    g_object_unref(l_builder);
  }

  if (l_error)
  {
    _error_log(l_error);
    _error_display_prompt(l_error);
  }

  g_clear_error(&l_error);

  if (l_instance)
  {
    gtk_widget_destroy(GTK_WIDGET(l_dialog));
  }

  return l_exit;
}
