/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2015-2016, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "item_special.h"

struct special_dialog
{
  GtkEntry*                             m_x_entry;
  GtkEntry*                             m_y_entry;
  GtkEntry*                             m_width_entry;
  GtkEntry*                             m_height_entry;
  GtkEntry*                             m_color_entry;
  GtkButton*                            m_color_button;
  GtkEntry*                             m_font_entry;
  GtkButton*                            m_font_button; 
  GtkCheckButton*                       m_border_checkbutton;
  GtkComboBoxText*                      m_style_comboboxtext;
  GtkSpinButton*                        m_thickness_spinbutton;
  GtkEntry*                             m_format_entry;
};

static void
item_special_collor_button_cb(
  GtkWidget *                           i_widget,
  gpointer                              i_data)
{
  GdkRGBA                               l_color;
  GtkWidget*                            l_dialog;
  int                                   l_exit;
  struct special_dialog*                l_special;
  gchar*                                l_rgba;
  gchar const*                          l_text;

  l_dialog= 0;
  memset(&l_color, 0, sizeof(l_color));

  do
  {

    l_special= (struct special_dialog*)i_data;

    l_dialog= gtk_color_chooser_dialog_new("Border Color", mainw());

    l_text= gtk_entry_get_text((*l_special).m_color_entry);
    gdk_rgba_parse(&l_color, l_text);
    gtk_color_chooser_set_rgba(GTK_COLOR_CHOOSER(l_dialog), &l_color);

    gtk_window_set_modal((GtkWindow*)l_dialog, 1);
    l_exit= gtk_dialog_run(GTK_DIALOG(l_dialog));

    if (GTK_RESPONSE_OK != l_exit)
    {
      break;
    }

    gtk_color_chooser_get_rgba(GTK_COLOR_CHOOSER(l_dialog), &l_color);

    l_rgba= gdk_rgba_to_string(&l_color);
    gtk_entry_set_text((*l_special).m_color_entry, l_rgba);
    g_free(l_rgba);

  }while(0);

  if (l_dialog)
  {
    gtk_widget_destroy((GtkWidget*)l_dialog);
  }
  
  return;
}

static void
item_special_font_button_cb(
  GtkWidget *                           i_widget,
  gpointer                              i_data)
{
  GtkWidget*                            l_dialog;
  int                                   l_exit;
  struct special_dialog*                l_special;
  gchar*                                l_font;
  gchar const*                          l_text;

  l_dialog= 0;
  l_exit= 0;
  l_font= 0;

  do
  {

    l_special= (struct special_dialog*)i_data;

    l_text= gtk_entry_get_text(GTK_ENTRY((*l_special).m_font_entry));

    l_dialog= gtk_font_chooser_dialog_new("Font", mainw());

    gtk_font_chooser_set_font(GTK_FONT_CHOOSER(l_dialog), l_text);

    gtk_window_set_modal((GtkWindow*)l_dialog, 1);
    l_exit= gtk_dialog_run(GTK_DIALOG(l_dialog));

    if (GTK_RESPONSE_OK != l_exit)
    {
      break;
    }

    l_font= gtk_font_chooser_get_font(GTK_FONT_CHOOSER(l_dialog));
    gtk_entry_set_text(
      (GTK_ENTRY((*l_special).m_font_entry)),
      l_font);

  }while(0);

  if (l_font)
  {
    g_free(l_font);
  }

  if (l_dialog)
  {
    gtk_widget_destroy((GtkWidget*)l_dialog);
  }

  return;
}

static void
item_special_bind(
  struct special_dialog*const           o_special,
  GtkBuilder*const                      i_builder)
{

  memset(o_special, 0, sizeof(*o_special));

  do
  {

    (*o_special).m_x_entry=
      GTK_ENTRY(gtk_builder_get_object(i_builder, "x_entry"));

    (*o_special).m_y_entry=
      GTK_ENTRY(gtk_builder_get_object(i_builder, "y_entry"));

    (*o_special).m_width_entry=
      GTK_ENTRY(gtk_builder_get_object(i_builder, "width_entry"));

    (*o_special).m_height_entry=
      GTK_ENTRY(gtk_builder_get_object(i_builder, "height_entry"));

    (*o_special).m_color_entry=
      GTK_ENTRY(gtk_builder_get_object(i_builder, "color_entry"));

    (*o_special).m_color_button=
      GTK_BUTTON(gtk_builder_get_object(i_builder, "color_button"));

    g_signal_connect(
      (*o_special).m_color_button,
      "clicked",
      G_CALLBACK(item_special_collor_button_cb),
      o_special);

    (*o_special).m_font_entry=
      GTK_ENTRY(gtk_builder_get_object(i_builder, "font_entry"));

    (*o_special).m_font_button=
      GTK_BUTTON(gtk_builder_get_object(i_builder, "font_button"));

    g_signal_connect(
      (*o_special).m_font_button,
      "clicked",
      G_CALLBACK(item_special_font_button_cb),
      o_special);

    (*o_special).m_border_checkbutton=
      GTK_CHECK_BUTTON(gtk_builder_get_object(i_builder, "border_checkbutton"));

    (*o_special).m_style_comboboxtext=
      GTK_COMBO_BOX_TEXT(gtk_builder_get_object(i_builder, "style_comboboxtext"));

    (*o_special).m_thickness_spinbutton=
      GTK_SPIN_BUTTON(gtk_builder_get_object(i_builder, "thickness_spinbutton"));

    (*o_special).m_format_entry=
      GTK_ENTRY(gtk_builder_get_object(i_builder, "format_entry"));

  }while(0);

  return;
}

static void
item_special_set_values(
  struct special_dialog*const           i_speciald,
  struct item_special const*const       i_special)
{
  gchar*                                l_color;
  gchar*                                l_font;
  char                                  l_text[128];

  sprintf(l_text, "%d", (int)(*i_special).m_pos_x);
  gtk_entry_set_text ((*i_speciald).m_x_entry, l_text);

  sprintf(l_text, "%d", (int)(*i_special).m_pos_y);
  gtk_entry_set_text ((*i_speciald).m_y_entry, l_text);

  sprintf(l_text, "%d", (int)(*i_special).m_len_x);
  gtk_entry_set_text ((*i_speciald).m_width_entry, l_text);

  sprintf(l_text, "%d", (int)(*i_special).m_len_y);
  gtk_entry_set_text ((*i_speciald).m_height_entry, l_text);

  l_color= gdk_rgba_to_string(&(*i_special).m_color);
  gtk_entry_set_text((*i_speciald).m_color_entry, l_color);
  g_free(l_color);
  l_color= 0;

  l_font= pango_font_description_to_string((*i_special).m_font);
  gtk_entry_set_text((*i_speciald).m_font_entry, l_font);
  g_free(l_font);

  gtk_toggle_button_set_active(
    GTK_TOGGLE_BUTTON((*i_speciald).m_border_checkbutton),
    (*i_special).m_border);

  gtk_combo_box_set_active(
      GTK_COMBO_BOX((*i_speciald).m_style_comboboxtext), 
      (*i_special).m_style);

  gtk_spin_button_set_value(
    GTK_SPIN_BUTTON((*i_speciald).m_thickness_spinbutton),
    (*i_special).m_thickness);

  gtk_entry_set_text((*i_speciald).m_format_entry, (*i_special).m_format);

  return;
}

static void
item_special_copy_values(
  struct item_special *const            io_special,
  struct special_dialog const*const     i_speciald)
{
  gchar const*                          l_text;
  gint                                  l_rc;

  l_text= gtk_entry_get_text(GTK_ENTRY((*i_speciald).m_x_entry));
  (*io_special).m_pos_x= (double)g_ascii_strtoll(l_text, 0, 10);

  l_text= gtk_entry_get_text(GTK_ENTRY((*i_speciald).m_y_entry));
  (*io_special).m_pos_y= (double)g_ascii_strtoll(l_text, 0, 10);

  l_text= gtk_entry_get_text(GTK_ENTRY((*i_speciald).m_width_entry));
  (*io_special).m_len_x= (double)g_ascii_strtoll(l_text, 0, 10);

  l_text= gtk_entry_get_text(GTK_ENTRY((*i_speciald).m_height_entry));
  (*io_special).m_len_y= (double)g_ascii_strtoll(l_text, 0, 10);

  l_text= gtk_entry_get_text(GTK_ENTRY((*i_speciald).m_color_entry));
  gdk_rgba_parse(&(*io_special).m_color, l_text);

  l_text= gtk_entry_get_text(GTK_ENTRY((*i_speciald).m_font_entry));
  if ((*io_special).m_font)
  {
    pango_font_description_free((*io_special).m_font);
  }
  (*io_special).m_font= pango_font_description_from_string(l_text);

  (*io_special).m_border=
    gtk_toggle_button_get_active(
      GTK_TOGGLE_BUTTON((*i_speciald).m_border_checkbutton));

  l_rc = gtk_combo_box_get_active(
    GTK_COMBO_BOX((*i_speciald).m_style_comboboxtext));

  if ((0 <= l_rc) && (LINE_STYLE_SLOTS > l_rc))
  {
    (*io_special).m_style= (enum line_style_type)l_rc;
  }
  else
  {
    (*io_special).m_style= line_style_solid;
  }

  (*io_special).m_thickness= gtk_spin_button_get_value_as_int(
    GTK_SPIN_BUTTON((*i_speciald).m_thickness_spinbutton));

  l_text= gtk_entry_get_text(GTK_ENTRY((*i_speciald).m_format_entry));
  memset((*io_special).m_format, 0, sizeof((*io_special).m_format));
  strncpy((*io_special).m_format, l_text, sizeof((*io_special).m_format)-1);
  g_strstrip((*io_special).m_format);

  return;
}

extern int
item_special_property(
  struct item_special*const             io_special)
{
  GtkBox*                               l_box;
  GtkBuilder*                           l_builder;
  GtkDialog*                            l_dialog;
  GtkGrid*                              l_grid;
  GError*                               l_error;
  int                                   l_exit;
  struct special_dialog                 l_special;
  int                                   l_rc;

  l_builder= 0;
  l_grid= 0;
  l_dialog= 0;
  l_error= 0;
  l_exit= 0;

  do
  {

    l_builder= gtk_builder_new();

    l_rc= wrap_gtk_builder_add_from_file(l_builder, "special.glade", &l_error);

    if (0 == l_rc)
    {
      _error_log(l_error);
      l_exit= -1;
      break;
    }
  
    l_grid= GTK_GRID(gtk_builder_get_object(l_builder, "special_grid"));

    if (0 == l_grid)
    {
      l_error= g_error_new(
        GENERAL,
        GENERIC,
        "Unable to find dialog object: 'special_grid'");
      l_exit= -1;
      break;
    }

    item_special_bind(&l_special, l_builder);

    item_special_set_values(&l_special, io_special);

    l_dialog= GTK_DIALOG(gtk_dialog_new_with_buttons(
      "Special Edit",
      mainw(),
      GTK_DIALOG_MODAL,
      "Ok",
      GTK_RESPONSE_OK,
      "Cancel",
      GTK_RESPONSE_CANCEL,
      NULL));

    l_box= GTK_BOX(gtk_dialog_get_content_area(GTK_DIALOG(l_dialog)));

    gtk_box_pack_start(GTK_BOX(l_box), GTK_WIDGET(l_grid), 1, 1,0);

    gtk_widget_show(GTK_WIDGET(l_grid));

    gtk_widget_show_all(GTK_WIDGET(l_dialog));
    gtk_window_set_modal(GTK_WINDOW(l_dialog), 1);
    l_exit= gtk_dialog_run(l_dialog);

    if (GTK_RESPONSE_OK != l_exit)
    {
      break;
    }

    item_special_copy_values(io_special, &l_special);

  }while(0);

  if (l_builder)
  {
    g_object_unref(l_builder);
  }

  if (l_error)
  {
    _error_log(l_error);
    _error_display_prompt(l_error);
  }

  g_clear_error(l_error);

  if (l_grid)
  {
    gtk_widget_destroy((GtkWidget*)l_dialog);
  }

  return l_exit;
}

