/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2015-2016, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "item_page_number.h"

struct page_number_dialog
{
  GtkEntry*                             m_color_entry;
  GtkButton*                            m_color_button;
  GtkEntry*                             m_font_entry;
  GtkButton*                            m_font_button; 
  GtkCheckButton*                       m_border_checkbutton;
  GtkComboBoxText*                      m_border_style_comboboxtext;
  GtkSpinButton*                        m_border_thickness_spinbutton;
  GtkEntry*                             m_border_color_entry;
  GtkButton*                            m_border_color_button;
  GtkCheckButton*                       m_fill_color_checkbutton;
  GtkEntry*                             m_fill_color_entry;
  GtkButton*                            m_fill_color_button; 
  GtkRadioButton*                       m_all_radiobutton;
  GtkRadioButton*                       m_even_radiobutton;
  GtkRadioButton*                       m_odd_radiobutton;
  GtkEntry*                             m_format_entry;
};

static void
item_page_number_color_button_cb(
  GtkWidget *                           i_widget,
  gpointer                              i_data)
{
  GdkRGBA                               l_color;
  GtkWidget*                            l_dialog;
  int                                   l_exit;
  struct page_number_dialog*            l_page_number;
  gchar*                                l_rgba;
  gchar const*                          l_text;

  l_dialog= 0;
  memset(&l_color, 0, sizeof(l_color));

  do
  {

    l_page_number= (struct page_number_dialog*)i_data;

    l_dialog= gtk_color_chooser_dialog_new("Border Color", mainw());

    l_text= gtk_entry_get_text((*l_page_number).m_color_entry);
    gdk_rgba_parse(&l_color, l_text);
    gtk_color_chooser_set_rgba(GTK_COLOR_CHOOSER(l_dialog), &l_color);

    gtk_window_set_modal((GtkWindow*)l_dialog, 1);
    l_exit= gtk_dialog_run(GTK_DIALOG(l_dialog));

    if (GTK_RESPONSE_OK != l_exit)
    {
      break;
    }

    gtk_color_chooser_get_rgba(GTK_COLOR_CHOOSER(l_dialog), &l_color);

    l_rgba= gdk_rgba_to_string(&l_color);
    gtk_entry_set_text((*l_page_number).m_color_entry, l_rgba);
    g_free(l_rgba);

  }while(0);

  if (l_dialog)
  {
    gtk_widget_destroy((GtkWidget*)l_dialog);
  }
  
  return;
}

static void
item_page_number_border_color_button_cb(
  GtkWidget *                           i_widget,
  gpointer                              i_data)
{
  GdkRGBA                               l_color;
  GtkWidget*                            l_dialog;
  int                                   l_exit;
  struct page_number_dialog*                  l_page_numberd;
  gchar*                                l_rgba;
  gchar const*                          l_text;

  l_dialog= 0;
  memset(&l_color, 0, sizeof(l_color));

  do
  {

    l_page_numberd= (struct page_number_dialog*)i_data;

    l_dialog= gtk_color_chooser_dialog_new("Border Color", mainw());

    l_text= gtk_entry_get_text((*l_page_numberd).m_color_entry);
    gdk_rgba_parse(&l_color, l_text);
    gtk_color_chooser_set_rgba(GTK_COLOR_CHOOSER(l_dialog), &l_color);

    gtk_window_set_modal((GtkWindow*)l_dialog, 1);
    l_exit= gtk_dialog_run(GTK_DIALOG(l_dialog));

    if (GTK_RESPONSE_OK != l_exit)
    {
      break;
    }

    gtk_color_chooser_get_rgba(GTK_COLOR_CHOOSER(l_dialog), &l_color);

    l_rgba= gdk_rgba_to_string(&l_color);
    gtk_entry_set_text((*l_page_numberd).m_border_color_entry, l_rgba);
    g_free(l_rgba);

  }while(0);

  if (l_dialog)
  {
    gtk_widget_destroy((GtkWidget*)l_dialog);
  }
  
  return;
}

static void
item_page_number_fill_color_button_cb(
  GtkWidget *                           i_widget,
  gpointer                              i_data)
{
  GdkRGBA                               l_color;
  GtkWidget*                            l_dialog;
  int                                   l_exit;
  struct page_number_dialog*                   l_page_numberd;
  gchar*                                l_rgba;
  gchar const*                          l_text;

  l_dialog= 0;
  memset(&l_color, 0, sizeof(l_color));

  do
  {

    l_page_numberd= (struct page_number_dialog*)i_data;

    l_dialog= gtk_color_chooser_dialog_new("Border Color", mainw());

    l_text= gtk_entry_get_text((*l_page_numberd).m_color_entry);
    gdk_rgba_parse(&l_color, l_text);
    gtk_color_chooser_set_rgba(GTK_COLOR_CHOOSER(l_dialog), &l_color);

    gtk_window_set_modal((GtkWindow*)l_dialog, 1);
    l_exit= gtk_dialog_run(GTK_DIALOG(l_dialog));

    if (GTK_RESPONSE_OK != l_exit)
    {
      break;
    }

    gtk_color_chooser_get_rgba(GTK_COLOR_CHOOSER(l_dialog), &l_color);

    l_rgba= gdk_rgba_to_string(&l_color);
    gtk_entry_set_text((*l_page_numberd).m_fill_color_entry, l_rgba);
    g_free(l_rgba);

  }while(0);

  if (l_dialog)
  {
    gtk_widget_destroy((GtkWidget*)l_dialog);
  }
  
  return;
}

static void
item_page_number_font_button_cb(
  GtkWidget *                           i_widget,
  gpointer                              i_data)
{
  GtkWidget*                            l_dialog;
  int                                   l_exit;
  struct page_number_dialog*            l_page_number;
  gchar*                                l_font;
  gchar const*                          l_text;

  l_dialog= 0;
  l_exit= 0;
  l_font= 0;

  do
  {

    l_page_number= (struct page_number_dialog*)i_data;

    l_text= gtk_entry_get_text(GTK_ENTRY((*l_page_number).m_font_entry));

    l_dialog= gtk_font_chooser_dialog_new("Font", mainw());

    gtk_font_chooser_set_font(GTK_FONT_CHOOSER(l_dialog), l_text);

    gtk_window_set_modal((GtkWindow*)l_dialog, 1);
    l_exit= gtk_dialog_run(GTK_DIALOG(l_dialog));

    if (GTK_RESPONSE_OK != l_exit)
    {
      break;
    }

    l_font= gtk_font_chooser_get_font(GTK_FONT_CHOOSER(l_dialog));
    gtk_entry_set_text(
      (GTK_ENTRY((*l_page_number).m_font_entry)),
      l_font);

  }while(0);

  if (l_font)
  {
    g_free(l_font);
  }

  if (l_dialog)
  {
    gtk_widget_destroy((GtkWidget*)l_dialog);
  }

  return;
}

static void
item_page_number_bind(
  struct page_number_dialog*const       o_page_numberd,
  GtkBuilder*const                      i_builder)
{

  memset(o_page_numberd, 0, sizeof(*o_page_numberd));

  do
  {

    (*o_page_numberd).m_color_entry=
      GTK_ENTRY(gtk_builder_get_object(i_builder, "color_entry"));

    (*o_page_numberd).m_color_button=
      GTK_BUTTON(gtk_builder_get_object(i_builder, "color_button"));

    g_signal_connect(
      (*o_page_numberd).m_color_button,
      "clicked",
      G_CALLBACK(item_page_number_color_button_cb),
      o_page_numberd);

    (*o_page_numberd).m_font_entry=
      GTK_ENTRY(gtk_builder_get_object(i_builder, "font_entry"));

    (*o_page_numberd).m_font_button=
      GTK_BUTTON(gtk_builder_get_object(i_builder, "font_button"));

    g_signal_connect(
      (*o_page_numberd).m_font_button,
      "clicked",
      G_CALLBACK(item_page_number_font_button_cb),
      o_page_numberd);

    (*o_page_numberd).m_border_checkbutton=
      GTK_CHECK_BUTTON(gtk_builder_get_object(i_builder, "border_checkbutton"));

    (*o_page_numberd).m_border_style_comboboxtext=
      GTK_COMBO_BOX_TEXT(gtk_builder_get_object(i_builder, "border_style_comboboxtext"));

    (*o_page_numberd).m_border_thickness_spinbutton=
      GTK_SPIN_BUTTON(gtk_builder_get_object(i_builder, "border_thickness_spinbutton"));

    (*o_page_numberd).m_border_color_entry=
      GTK_ENTRY(gtk_builder_get_object(i_builder, "border_color_entry"));

    (*o_page_numberd).m_border_color_button=
      GTK_BUTTON(gtk_builder_get_object(i_builder, "border_color_button"));

    g_signal_connect(
      (*o_page_numberd).m_border_color_button,
      "clicked",
      G_CALLBACK(item_page_number_border_color_button_cb),
      o_page_numberd);

    (*o_page_numberd).m_fill_color_checkbutton=
      GTK_CHECK_BUTTON(gtk_builder_get_object(i_builder, "fill_color_checkbutton"));

    (*o_page_numberd).m_fill_color_button=
      GTK_BUTTON(gtk_builder_get_object(i_builder, "fill_color_button"));

    g_signal_connect(
      (*o_page_numberd).m_fill_color_button,
      "clicked",
      G_CALLBACK(item_page_number_fill_color_button_cb),
      o_page_numberd);

    (*o_page_numberd).m_fill_color_entry=
      GTK_ENTRY(gtk_builder_get_object(i_builder, "fill_color_entry"));

    (*o_page_numberd).m_all_radiobutton=
      GTK_RADIO_BUTTON(gtk_builder_get_object(i_builder, "all_radiobutton"));

    (*o_page_numberd).m_even_radiobutton=
      GTK_RADIO_BUTTON(gtk_builder_get_object(i_builder, "even_radiobutton"));

    (*o_page_numberd).m_odd_radiobutton=
      GTK_RADIO_BUTTON(gtk_builder_get_object(i_builder, "odd_radiobutton"));

    (*o_page_numberd).m_format_entry=
      GTK_ENTRY(gtk_builder_get_object(i_builder, "format_entry"));

  }while(0);

  return;
}

static void
item_page_number_set_values(
  struct page_number_dialog*const       i_page_numberd,
  struct item_page_number const*const   i_page_number)
{
  gchar*                                l_color;
  gchar*                                l_font;

  l_color= gdk_rgba_to_string(&(*i_page_number).m_color);
  gtk_entry_set_text((*i_page_numberd).m_color_entry, l_color);
  g_free(l_color);
  l_color= 0;

  l_font= pango_font_description_to_string((*i_page_number).m_font);
  gtk_entry_set_text((*i_page_numberd).m_font_entry, l_font);
  g_free(l_font);

  gtk_toggle_button_set_active(
    GTK_TOGGLE_BUTTON((*i_page_numberd).m_border_checkbutton),
    (*i_page_number).m_border);

  gtk_combo_box_set_active(
      GTK_COMBO_BOX((*i_page_numberd).m_border_style_comboboxtext), 
      (*i_page_number).m_border_style);

  gtk_spin_button_set_value(
    GTK_SPIN_BUTTON((*i_page_numberd).m_border_thickness_spinbutton),
    (*i_page_number).m_border_thickness);

  switch((*i_page_number).m_type)
  {
    case page_number_even:
      gtk_toggle_button_set_active(
        GTK_TOGGLE_BUTTON((*i_page_numberd).m_even_radiobutton), 1);
      break;
    case page_number_odd:
      gtk_toggle_button_set_active(
        GTK_TOGGLE_BUTTON((*i_page_numberd).m_odd_radiobutton), 1);
      break;
    default:
      gtk_toggle_button_set_active(
        GTK_TOGGLE_BUTTON((*i_page_numberd).m_all_radiobutton), 1);
      break;
  }

  gtk_entry_set_text((*i_page_numberd).m_format_entry, (*i_page_number).m_format);

  return;
}

static void
item_page_number_copy_values(
  struct item_page_number *const        io_page_number,
  struct page_number_dialog const*const i_page_numberd)
{
  gboolean                              l_bool;
  gchar const*                          l_text;
  gint                                  l_rc;

  l_text= gtk_entry_get_text(GTK_ENTRY((*i_page_numberd).m_color_entry));
  gdk_rgba_parse(&(*io_page_number).m_color, l_text);

  l_text= gtk_entry_get_text(GTK_ENTRY((*i_page_numberd).m_font_entry));
  if ((*io_page_number).m_font)
  {
    pango_font_description_free((*io_page_number).m_font);
  }
  (*io_page_number).m_font= pango_font_description_from_string(l_text);

  (*io_page_number).m_border=
    gtk_toggle_button_get_active(
      GTK_TOGGLE_BUTTON((*i_page_numberd).m_border_checkbutton));

  l_rc = gtk_combo_box_get_active(
    GTK_COMBO_BOX((*i_page_numberd).m_border_style_comboboxtext));

  if ((0 <= l_rc) && (LINE_STYLE_SLOTS > l_rc))
  {
    (*io_page_number).m_border_style= (enum line_style_type)l_rc;
  }
  else
  {
    (*io_page_number).m_border_style= line_style_solid;
  }

  (*io_page_number).m_border_thickness= gtk_spin_button_get_value_as_int(
    GTK_SPIN_BUTTON((*i_page_numberd).m_border_thickness_spinbutton));

  gtk_toggle_button_set_active(
    GTK_TOGGLE_BUTTON((*i_page_numberd).m_border_checkbutton),
    (*io_page_number).m_border);

  gtk_combo_box_set_active(
      GTK_COMBO_BOX((*i_page_numberd).m_border_style_comboboxtext), 
      (*io_page_number).m_border_style);

  gtk_spin_button_set_value(
    GTK_SPIN_BUTTON((*i_page_numberd).m_border_thickness_spinbutton),
    (*io_page_number).m_border_thickness);

  l_text= gtk_entry_get_text(GTK_ENTRY((*i_page_numberd).m_border_color_entry));
  gdk_rgba_parse(&(*io_page_number).m_border_color, l_text);

  (*io_page_number).m_fill=
    gtk_toggle_button_get_active(
      GTK_TOGGLE_BUTTON((*i_page_numberd).m_fill_color_checkbutton));
  
  do
  {

    l_bool= gtk_toggle_button_get_active(
        GTK_TOGGLE_BUTTON((*i_page_numberd).m_even_radiobutton));

    if (l_bool)
    {
      (*io_page_number).m_type= page_number_even;
      break;
    }

    l_bool= gtk_toggle_button_get_active(
        GTK_TOGGLE_BUTTON((*i_page_numberd).m_odd_radiobutton));

    if (l_bool)
    {
      (*io_page_number).m_type= page_number_odd;
      break;
    }

    (*io_page_number).m_type= page_number_all;

  }while(0);

  l_text= gtk_entry_get_text(GTK_ENTRY((*i_page_numberd).m_format_entry));
  memset((*io_page_number).m_format, 0, sizeof((*io_page_number).m_format));
  strncpy((*io_page_number).m_format, l_text, sizeof((*io_page_number).m_format)-1);
  g_strstrip((*io_page_number).m_format);

  return;
}

extern int
item_page_number_property(
  struct item_page_number*const         io_page_number)
{
  GtkBox*                               l_box;
  GtkBuilder*                           l_builder;
  GtkDialog*                            l_dialog;
  GtkGrid*                              l_grid;
  GError*                               l_error;
  int                                   l_exit;
  struct page_number_dialog             l_page_number;
  int                                   l_rc;

  l_builder= 0;
  l_grid= 0;
  l_dialog= 0;
  l_error= 0;
  l_exit= 0;

  do
  {

    l_builder= gtk_builder_new();

    l_rc= wrap_gtk_builder_add_from_file(
      l_builder,
      "page_number.glade",
      &l_error);

    if (0 == l_rc)
    {
      l_exit= -1;
      break;
    }
  
    l_grid= GTK_GRID(gtk_builder_get_object(l_builder, "page_number_grid"));

    if (0 == l_grid)
    {
      l_error= g_error_new(
        GENERAL,
        GENERIC,
        "Unable to find dialog object: 'page_number_grid'");
      l_exit= -1;
      break;
    }

    item_page_number_bind(&l_page_number, l_builder);

    item_page_number_set_values(&l_page_number, io_page_number);

    l_dialog= GTK_DIALOG(gtk_dialog_new_with_buttons(
      "Page Number Edit",
      mainw(),
      GTK_DIALOG_MODAL,
      "Ok",
      GTK_RESPONSE_OK,
      "Cancel",
      GTK_RESPONSE_CANCEL,
      NULL));

    l_box= GTK_BOX(gtk_dialog_get_content_area(GTK_DIALOG(l_dialog)));

    gtk_box_pack_start(GTK_BOX(l_box), GTK_WIDGET(l_grid), 1, 1,0);

    gtk_widget_show(GTK_WIDGET(l_grid));

    gtk_widget_show_all(GTK_WIDGET(l_dialog));
    gtk_window_set_modal(GTK_WINDOW(l_dialog), 1);
    l_exit= gtk_dialog_run(l_dialog);

    if (GTK_RESPONSE_OK != l_exit)
    {
      break;
    }

    item_page_number_copy_values(io_page_number, &l_page_number);

  }while(0);

  if (l_builder)
  {
    g_object_unref(l_builder);
  }

  if (l_error)
  {
    _error_log(l_error);
    _error_display_prompt(l_error);
  }

  g_clear_error(&l_error);

  if (l_grid)
  {
    gtk_widget_destroy((GtkWidget*)l_dialog);
  }

  return l_exit;
}

