/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015-2016, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "item_ftext.h"

extern void
item_ftext_assign(
  struct item_ftext*const               o_ftext,
  struct item_method*const              o_method)
{

  memset(o_ftext, 0, sizeof(*o_ftext));

  (*o_ftext).m_len_x= 30.0;
  (*o_ftext).m_len_y= 18.0;
  (*o_ftext).m_font= pango_font_description_new();
  (*o_ftext).m_border_style= line_style_solid;
  (*o_ftext).m_border_thickness= 1.0;

  ITEM_METHOD_ASSIGN(o_method, ftext);

  return;
}

extern void
item_ftext_discharge(
  struct item_ftext*const                io_ftext)
{
  if ((*io_ftext).m_font)
  {
    pango_font_description_free((*io_ftext).m_font);
  }

  if ((*io_ftext).m_value)
  {
    g_free((*io_ftext).m_value);
  }

  memset(io_ftext, 0, sizeof(*io_ftext));

  return;
}

extern void
item_ftext_draw(
  struct item_ftext*const               i_ftext,
  struct item_draw_context const*const  i_ctx)
{
  PangoFontDescription*                 l_font;
  PangoLayout*                          l_layout;
  char*                                 l_text;

  l_font= 0;
  l_layout= 0;

  do
  {

    if ((*i_ftext).m_fill)
    {
      cairo_set_source_rgb(
        (*i_ctx).m_cr,
        (*i_ftext).m_fill_color.red,
        (*i_ftext).m_fill_color.green,
        (*i_ftext).m_fill_color.blue);

      cairo_rectangle(
        (*i_ctx).m_cr,
        (*i_ftext).m_pos_x,
        (*i_ftext).m_pos_y,
        (*i_ftext).m_len_x,
        (*i_ftext).m_len_y);

      cairo_fill((*i_ctx).m_cr);
    }

    cairo_save((*i_ctx).m_cr);

    cairo_rectangle(
      (*i_ctx).m_cr,
      (*i_ftext).m_pos_x,
      (*i_ftext).m_pos_y,
      (*i_ftext).m_len_x,
      (*i_ftext).m_len_x);

    cairo_clip((*i_ctx).m_cr);

    cairo_set_source_rgb(
      (*i_ctx).m_cr,
      (*i_ftext).m_color.red,
      (*i_ftext).m_color.green,
      (*i_ftext).m_color.blue);

    l_layout= pango_cairo_create_layout((*i_ctx).m_cr);
    pango_layout_set_font_description(l_layout, (*i_ftext).m_font); 

    if ((*i_ftext).m_autowrap)
    {
      pango_layout_set_width(l_layout, PANGO_SCALE*(*i_ftext).m_len_x);
      pango_layout_set_wrap(l_layout, (*i_ftext).m_wrapmode);
    }

    cairo_translate((*i_ctx).m_cr, (*i_ftext).m_pos_x, (*i_ftext).m_pos_y);

    if (item_draw_design == (*i_ctx).m_option.m_type)
    {
      l_text= "default";
    }
    else
    {
      l_text= (*i_ftext).m_value;
    }

    if (l_text)
    {
      pango_layout_set_text(l_layout, l_text, -1);
    }

    pango_cairo_update_layout((*i_ctx).m_cr, l_layout);
    pango_cairo_show_layout((*i_ctx).m_cr, l_layout);

    cairo_restore((*i_ctx).m_cr);

    if ((*i_ftext).m_border)
    {

      item_common_cairo_dash_set((*i_ctx).m_cr, (*i_ftext).m_border_style);
      cairo_set_line_width((*i_ctx).m_cr, (*i_ftext).m_border_thickness);
      cairo_set_source_rgb(
        (*i_ctx).m_cr,
        (*i_ftext).m_border_color.red,
        (*i_ftext).m_border_color.green,
        (*i_ftext).m_border_color.blue);

      cairo_rectangle(
        (*i_ctx).m_cr,
        (*i_ftext).m_pos_x,
        (*i_ftext).m_pos_y,
        (*i_ftext).m_len_x,
        (*i_ftext).m_len_y);

      cairo_stroke((*i_ctx).m_cr);
    }

    if (0 == (*i_ctx).m_selected)
    {
      if ((*i_ctx).m_option.m_highlight &&
        (item_draw_design == (*i_ctx).m_option.m_type))
      {
        item_common_box_draw_hightlight(
          (*i_ctx).m_cr, 
          (struct geom_rect*)i_ftext,
          (*i_ftext).m_border_thickness);
      }
      break;
    }

    item_common_box_draw_grips((*i_ctx).m_cr, (struct geom_rect*)i_ftext);

  }while(0);

  if (l_font)
  {
    pango_font_description_free(l_font);
  }

  if (l_layout)
  {
    g_object_unref(l_layout);
  }

  return;
}

extern void
item_ftext_get_bbox(
  struct geom_rect*const                o_bbox,
  int*const                             o_overlay,
  void const*const                      i_object)
{
  (*o_bbox)= *(struct geom_rect*)i_object;
  (*o_overlay)= 0;
  return;
}

extern void
item_ftext_in_event(
  enum event_type*const                 o_type,
  struct item_ftext const*const         i_ftext,
  struct item_in_event const*const      i_ctx)
{

  item_common_box_in_event(o_type, i_ctx, (struct geom_rect*)i_ftext);

  return;
}

extern void
item_ftext_move(
  struct item_ftext*const               io_ftext,
  struct geom_point const*const         i_event)
{
  item_common_box_move((struct geom_rect*)io_ftext, i_event);
  return;
}

extern void
item_ftext_normalize(
  struct item_ftext*const               io_ftext,
  double const                          i_bound_width,
  double const                          i_bound_height)
{
  item_common_box_normalize(
    (struct geom_rect*)io_ftext, 
    i_bound_width,
    i_bound_height);
  return;

}

extern int
item_ftext_read(
  GError**                              o_error,
  struct item_ftext*const               io_ftext,
  struct bson_node *const               i_element)
{
  struct bson_node *                    l_element;
  int                                   l_found;
  enum element_tag_type                 l_type;

  l_element= i_element;

  do
  {

    if (0 == l_element)
    {
      break;
    }

    if (bson_type_end == (*l_element).m_type)
    {
      break;
    }

    item_common_lookup(&l_found, &l_type, (*l_element).m_ename);

    if (l_found)
    {
        switch(l_type)
        {
          case element_tag_autowrap:
            if (bson_type_int32 == (*l_element).m_type)
            {
              (*io_ftext).m_autowrap= (*l_element).m_object.m_int32;
            }
            break;
          case element_tag_border:
            if (bson_type_int32 == (*l_element).m_type)
            {
              (*io_ftext).m_border= (*l_element).m_object.m_int32;
            }
            break;
          case element_tag_border_color_red:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_ftext).m_border_color.red= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_border_color_green:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_ftext).m_border_color.green= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_border_color_blue:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_ftext).m_border_color.blue= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_border_thickness:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_ftext).m_border_thickness= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_border_style:
            if (bson_type_int32 == (*l_element).m_type)
            {
              (*io_ftext).m_border_style= (*l_element).m_object.m_int32;
            }
            break;
          case element_tag_color_red:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_ftext).m_color.red= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_color_green:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_ftext).m_color.green= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_color_blue:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_ftext).m_color.blue= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_fill:
            if (bson_type_int32 == (*l_element).m_type)
            {
              (*io_ftext).m_fill= (*l_element).m_object.m_int32;
            }
            break;
          case element_tag_fill_color_red:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_ftext).m_fill_color.red= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_fill_color_green:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_ftext).m_fill_color.green= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_fill_color_blue:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_ftext).m_fill_color.blue= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_font:
            if (bson_type_string == (*l_element).m_type)
            {
              if ((*io_ftext).m_font)
              {
                pango_font_description_free((*io_ftext).m_font);
              }
              (*io_ftext).m_font= pango_font_description_from_string(
                (*l_element).m_object.m_string.m_text);
            }
            break;
          case element_tag_len_x:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_ftext).m_len_x= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_len_y:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_ftext).m_len_y= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_pos_x:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_ftext).m_pos_x= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_pos_y:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_ftext).m_pos_y= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_name:
            if (bson_type_string == (*l_element).m_type)
            {
              strncpy(
                (*io_ftext).m_tag, 
                (*l_element).m_object.m_string.m_text, 
                sizeof((*io_ftext).m_tag));
            }
            break;
          case element_tag_wrapmode:
            if (bson_type_int32 == (*l_element).m_type)
            {
              (*io_ftext).m_wrapmode= (*l_element).m_object.m_int32;
            }
            break;
          default:
            break;
        }
    }

    l_element= (*l_element).m_next;

  }while(1);

  return 0;
}

extern void
item_ftext_resize(
  struct item_ftext*const               io_ftext,
  struct item_resize_event const*const  i_ctx)
{

  item_common_box_resize((struct geom_rect *)io_ftext, i_ctx);

  return;
}

extern int
item_ftext_write(
  GError**                              o_error,
  FILE*const                            io_fp,
  struct item_ftext const*const         i_ftext)
{
  int                                   l_exit;
  int32_t                               l_int32;
  char                                  l_octet;
  int32_t                               l_offset;
  int32_t                               l_size;
  char*                                 l_text;

  l_exit= 0;
  l_text= 0;

  /* array */
  l_octet= bson_type_array;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "ftext%c",0);

  /* document */
  l_offset= ftell(io_fp);
  l_int32= 0;
  fwrite(&l_int32, sizeof(int32_t), 1, io_fp); 

  /* pos_x */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "pos_x%c",0);
  fwrite(&(*i_ftext).m_pos_x, sizeof(double), 1, io_fp);

  /* pos_y */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "pos_y%c",0);
  fwrite(&(*i_ftext).m_pos_y, sizeof(double), 1, io_fp);

  /* len_x */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "len_x%c",0);
  fwrite(&(*i_ftext).m_len_x, sizeof(double), 1, io_fp);

  /* len_y */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "len_y%c",0);
  fwrite(&(*i_ftext).m_len_y, sizeof(double), 1, io_fp);

  /* font */
  l_text= pango_font_description_to_string((*i_ftext).m_font);
  if (l_text[0])
  {
    l_octet= bson_type_string;
    fwrite(&l_octet, 1, 1, io_fp); 
    fprintf(io_fp, "font%c",0);
    l_int32= (1+strlen(l_text));
    fwrite(&l_int32, sizeof(l_int32), 1, io_fp); 
    fwrite(l_text, l_int32, 1, io_fp);
  }
  g_free(l_text);
  l_text= 0;

  /* color - red */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "color_red%c",0);
  fwrite(&(*i_ftext).m_color.red, sizeof(double), 1, io_fp);

  /* color - green */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "color_green%c",0);
  fwrite(&(*i_ftext).m_color.green, sizeof(double), 1, io_fp);

  /* color - blue */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "color_blue%c",0);
  fwrite(&(*i_ftext).m_color.blue, sizeof(double), 1, io_fp);

  /* border */
  l_octet= bson_type_int32;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "border%c",0);
  fwrite(&(*i_ftext).m_border, sizeof(int32_t), 1, io_fp);

  /* border_style */
  l_octet= bson_type_int32;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "border_style%c",0);
  fwrite(&(*i_ftext).m_border_style, sizeof(int32_t), 1, io_fp);

  /* border_thickness */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "border_thickness%c",0);
  fwrite(&(*i_ftext).m_border_thickness, sizeof(double), 1, io_fp);

  /* border_color - red */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "border_color_red%c",0);
  fwrite(&(*i_ftext).m_border_color.red, sizeof(double), 1, io_fp);

  /* border_color - green */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "border_color_green%c",0);
  fwrite(&(*i_ftext).m_border_color.green, sizeof(double), 1, io_fp);

  /* border_color - blue */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "border_color_blue%c",0);
  fwrite(&(*i_ftext).m_border_color.blue, sizeof(double), 1, io_fp);

  /* fill */
  l_octet= bson_type_int32;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "fill%c",0);
  fwrite(&(*i_ftext).m_fill, sizeof(int32_t), 1, io_fp);

  /* fill color - red */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "fill_red%c",0);
  fwrite(&(*i_ftext).m_fill_color.red, sizeof(double), 1, io_fp);

  /* fill color - green */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "fill_green%c",0);
  fwrite(&(*i_ftext).m_fill_color.green, sizeof(double), 1, io_fp);

  /* fill color - blue */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "fill_blue%c",0);
  fwrite(&(*i_ftext).m_fill_color.blue, sizeof(double), 1, io_fp);

  /* autowrap */
  l_octet= bson_type_int32;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "autowrap%c",0);
  fwrite(&(*i_ftext).m_autowrap, sizeof(int32_t), 1, io_fp);

  /* wrap mode */
  l_octet= bson_type_int32;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "wrapmode%c",0);
  fwrite(&(*i_ftext).m_wrapmode, sizeof(int32_t), 1, io_fp);

  /* tag */
  if ((*i_ftext).m_tag[0])
  {
    l_octet= bson_type_string;
    fwrite(&l_octet, 1, 1, io_fp); 
    fprintf(io_fp, "name%c",0);
    l_int32= 1+strlen((*i_ftext).m_tag);
    fwrite(&l_int32, sizeof(int32_t), 1, io_fp); 
    fwrite((*i_ftext).m_tag, 1, l_int32, io_fp);
  }

  /* end of document */
  l_octet= 0;
  fwrite(&l_octet, 1, 1, io_fp); 

  /* document */
  l_int32= ftell(io_fp);
  l_size= (l_int32 - l_offset);
  fseek(io_fp, l_offset, SEEK_SET);
  fwrite(&l_size, sizeof(l_size), 1, io_fp); 

  fseek(io_fp, 0, SEEK_END);

  return l_exit;
}
