/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015-2016, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "item_frame.h"

extern void
item_frame_assign(
  struct item_frame*const               o_frame,
  struct item_method*const              o_method)
{

  memset(o_frame, 0, sizeof(*o_frame));

  (*o_frame).m_rect[top_left_x]= 0.0;
  (*o_frame).m_rect[top_left_y]= 0.0;
  (*o_frame).m_rect[top_right_x]= 100.0;
  (*o_frame).m_rect[top_right_y]= 0.0;
  (*o_frame).m_rect[bottom_right_x]= 100.0;
  (*o_frame).m_rect[bottom_right_y]= 24.0;
  (*o_frame).m_rect[bottom_left_x]= 0.0;
  (*o_frame).m_rect[bottom_left_y]= 24.0;

  (*o_frame).m_border_style= line_style_solid;
  (*o_frame).m_border_thickness= 1.0;

  ITEM_METHOD_ASSIGN(o_method, frame);

  return;
}

extern void
item_frame_discharge(
  struct item_frame*const                io_frame)
{
  memset(io_frame, 0, sizeof(*io_frame));
}

extern void
item_frame_draw(
  struct item_frame*const               i_frame,
  struct item_draw_context const*const  i_ctx)
{

  do
  {

    if ((*i_frame).m_fill)
    {
      cairo_set_source_rgb(
        (*i_ctx).m_cr,
        (*i_frame).m_fill_color.red,
        (*i_frame).m_fill_color.green,
        (*i_frame).m_fill_color.blue);

      cairo_move_to((*i_ctx).m_cr, (*i_frame).m_rect[top_left_x], (*i_frame).m_rect[top_left_y]);
      cairo_line_to((*i_ctx).m_cr, (*i_frame).m_rect[top_right_x], (*i_frame).m_rect[top_right_y]);
      cairo_line_to((*i_ctx).m_cr, (*i_frame).m_rect[bottom_right_x], (*i_frame).m_rect[bottom_right_y]);
      cairo_line_to((*i_ctx).m_cr, (*i_frame).m_rect[bottom_left_x], (*i_frame).m_rect[bottom_left_y]);
      cairo_close_path((*i_ctx).m_cr);
      cairo_fill((*i_ctx).m_cr);

    }

    item_common_cairo_dash_set((*i_ctx).m_cr, (*i_frame).m_border_style);
    cairo_set_line_width((*i_ctx).m_cr, (*i_frame).m_border_thickness);
    cairo_set_source_rgb(
      (*i_ctx).m_cr,
      (*i_frame).m_border_color.red,
      (*i_frame).m_border_color.green,
      (*i_frame).m_border_color.blue);

    cairo_move_to((*i_ctx).m_cr, (*i_frame).m_rect[top_left_x], (*i_frame).m_rect[top_left_y]);
    cairo_line_to((*i_ctx).m_cr, (*i_frame).m_rect[top_right_x], (*i_frame).m_rect[top_right_y]);
    cairo_line_to((*i_ctx).m_cr, (*i_frame).m_rect[bottom_right_x], (*i_frame).m_rect[bottom_right_y]);
    cairo_line_to((*i_ctx).m_cr, (*i_frame).m_rect[bottom_left_x], (*i_frame).m_rect[bottom_left_y]);
    cairo_close_path((*i_ctx).m_cr);
    cairo_stroke((*i_ctx).m_cr);

    if (0 == (*i_ctx).m_selected)
    {
      break;
    }

    item_common_rectvect_draw_grips((*i_ctx).m_cr, (double*)i_frame);

  }while(0);

  return;
}

extern void
item_frame_get_bbox(
  struct geom_rect*const                o_bbox,
  int*const                             o_overlay,
  void const*const                      i_object)
{
  geom_rectvect_get_bounding_box(o_bbox, (double*)i_object);
  (*o_overlay)= 0;
  return;
}

extern void
item_frame_in_event(
  enum event_type*const                 o_type,
  struct item_frame const*const         i_frame,
  struct item_in_event const*const      i_ctx)
{

  item_common_rectvect_in_event(o_type, i_ctx, (double*)i_frame);

}

extern void
item_frame_move(
  struct item_frame*const               io_frame,
  struct geom_point const*const         i_event)
{

  item_common_rectvect_move((double*)io_frame, i_event);

  return;
}

extern void
item_frame_normalize(
  struct item_frame*const               io_frame,
  double const                          i_bound_width,
  double const                          i_bound_height)
{
  return;
}

extern int
item_frame_read(
  GError**                              o_error,
  struct item_frame*const               io_frame,
  struct bson_node *const               i_element)
{
  struct bson_node *                    l_element;
  int                                   l_found;
  enum element_tag_type                 l_type;

  l_element= i_element;

  do
  {

    if (0 == l_element)
    {
      break;
    }

    if (bson_type_end == (*l_element).m_type)
    {
      break;
    }

    item_common_lookup(&l_found, &l_type, (*l_element).m_ename);

    if (l_found)
    {
        switch(l_type)
        {
          case element_tag_border_color_blue:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_frame).m_border_color.blue= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_border_color_green:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_frame).m_border_color.green= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_border_color_red:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_frame).m_border_color.red= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_fill:
            if (bson_type_int32 == (*l_element).m_type)
            {
              (*io_frame).m_fill= (*l_element).m_object.m_int32;
            }
            break;
          case element_tag_fill_color_blue:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_frame).m_fill_color.blue= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_fill_color_green:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_frame).m_fill_color.green= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_fill_color_red:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_frame).m_fill_color.red= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_rect_v0:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_frame).m_rect[0]= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_rect_v1:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_frame).m_rect[1]= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_rect_v2:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_frame).m_rect[2]= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_rect_v3:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_frame).m_rect[3]= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_rect_v4:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_frame).m_rect[4]= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_rect_v5:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_frame).m_rect[5]= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_rect_v6:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_frame).m_rect[6]= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_rect_v7:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_frame).m_rect[7]= (*l_element).m_object.m_float;
            }
            break;
          default:
            break;
        }
    }

    l_element= (*l_element).m_next;

  }while(1);

  return 0;
}

extern void
item_frame_resize(
  struct item_frame*const               io_frame,
  struct item_resize_event const*const  i_ctx)
{

  item_common_rectvect_resize((double*)io_frame, i_ctx, (*io_frame).m_rotate_shear);

  return;
}

extern int
item_frame_write(
  GError**                              o_error,
  FILE*const                            io_fp,
  struct item_frame const*const         i_frame)
{
  int                                   l_exit;
  int32_t                               l_int32;
  char                                  l_octet;
  int32_t                               l_offset;
  int32_t                               l_size;

  l_exit= 0;

  /* array */
  l_octet= bson_type_array;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "frame%c",0);

  /* document */
  l_offset= ftell(io_fp);
  l_size= 0;
  fwrite(&l_size, sizeof(int32_t), 1, io_fp); 

  /* rect_v0 */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "rect_v0%c",0);
  fwrite(&(*i_frame).m_rect[0], sizeof(double), 1, io_fp);

  /* rect_v1 */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "rect_v1%c",0);
  fwrite(&(*i_frame).m_rect[1], sizeof(double), 1, io_fp);

  /* rect_v2 */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "rect_v2%c",0);
  fwrite(&(*i_frame).m_rect[2], sizeof(double), 1, io_fp);

  /* rect_v3 */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "rect_v3%c",0);
  fwrite(&(*i_frame).m_rect[3], sizeof(double), 1, io_fp);

  /* rect_v4 */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "rect_v4%c",0);
  fwrite(&(*i_frame).m_rect[4], sizeof(double), 1, io_fp);

  /* rect_v5 */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "rect_v5%c",0);
  fwrite(&(*i_frame).m_rect[5], sizeof(double), 1, io_fp);

  /* rect_v6 */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "rect_v6%c",0);
  fwrite(&(*i_frame).m_rect[6], sizeof(double), 1, io_fp);

  /* rect_v7 */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "rect_v7%c",0);
  fwrite(&(*i_frame).m_rect[7], sizeof(double), 1, io_fp);

  /* border_style */
  l_octet= bson_type_int32;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "border_style%c",0);
  fwrite(&(*i_frame).m_border_style, sizeof(int32_t), 1, io_fp);

  /* border_thickness */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "border_thickness%c",0);
  fwrite(&(*i_frame).m_border_thickness, sizeof(double), 1, io_fp);

  /* border_color - red */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "border_color_red%c",0);
  fwrite(&(*i_frame).m_border_color.red, sizeof(double), 1, io_fp);

  /* border_color - green */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "border_color_green%c",0);
  fwrite(&(*i_frame).m_border_color.green, sizeof(double), 1, io_fp);

  /* border_color - blue */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "border_color_blue%c",0);
  fwrite(&(*i_frame).m_border_color.blue, sizeof(double), 1, io_fp);

  /* fill */
  l_octet= bson_type_int32;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "fill%c",0);
  fwrite(&(*i_frame).m_fill, sizeof(int32_t), 1, io_fp);

  /* fill color - red */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "fill_red%c",0);
  fwrite(&(*i_frame).m_fill_color.red, sizeof(double), 1, io_fp);

  /* fill color - green */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "fill_green%c",0);
  fwrite(&(*i_frame).m_fill_color.green, sizeof(double), 1, io_fp);

  /* fill color - blue */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "fill_blue%c",0);
  fwrite(&(*i_frame).m_fill_color.blue, sizeof(double), 1, io_fp);

  /* end of document */
  l_octet= 0;
  fwrite(&l_octet, 1, 1, io_fp); 

  /* document */
  l_int32= ftell(io_fp);
  l_size= (l_int32 - l_offset);
  fseek(io_fp, l_offset, SEEK_SET);
  fwrite(&l_size, sizeof(l_size), 1, io_fp); 

  fseek(io_fp, 0, SEEK_END);

  return l_exit;
}
