/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2015-2016, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "item_fnumber.h"
#include "database_field.h"
#include "mainw.h"

struct fnumber_dialog
{
  GtkEntry*                             m_color_entry;
  GtkButton*                            m_color_button;
  GtkEntry*                             m_font_entry;
  GtkButton*                            m_font_button; 
  GtkCheckButton*                       m_border_checkbutton;
  GtkComboBoxText*                      m_border_style_comboboxtext;
  GtkSpinButton*                        m_border_thickness_spinbutton;
  GtkEntry*                             m_border_color_entry;
  GtkButton*                            m_border_color_button;
  GtkCheckButton*                       m_fill_color_checkbutton;
  GtkEntry*                             m_fill_color_entry;
  GtkButton*                            m_fill_color_button; 
  GtkComboBoxText*                      m_type_comboboxtext;
  GtkEntry*                             m_pattern_entry;
  GtkEntry*                             m_locale_entry;
  GtkEntry*                             m_field_entry;
  GtkButton*                            m_field_button;
};

static void
item_fnumber_field_button_cb(
  GtkWidget *                           i_widget,
  gpointer                              i_data)
{
  struct fnumber_dialog*                l_fnumber;
  char*                                 l_attribute;

  l_attribute= 0;

  l_fnumber= (struct fnumber_dialog*)i_data;

  database_field_property(
    &l_attribute, 
    &(*g_mainw).m_report.m_aspect,
    &(*g_mainw).m_report.m_query);

  if (l_attribute)
  {
    gtk_entry_set_text((*l_fnumber).m_field_entry, l_attribute);
  }

  if (l_attribute)
  {
    g_free(l_attribute);
  }

  return;
}

static void
item_fnumber_color_button_cb(
  GtkWidget *                           i_widget,
  gpointer                              i_data)
{
  GdkRGBA                               l_color;
  GtkWidget*                            l_dialog;
  int                                   l_exit;
  struct fnumber_dialog*                l_fnumber;
  gchar*                                l_rgba;
  gchar const*                          l_text;

  l_dialog= 0;
  memset(&l_color, 0, sizeof(l_color));

  do
  {

    l_fnumber= (struct fnumber_dialog*)i_data;

    l_dialog= gtk_color_chooser_dialog_new("Border Color", mainw());

    l_text= gtk_entry_get_text((*l_fnumber).m_color_entry);
    gdk_rgba_parse(&l_color, l_text);
    gtk_color_chooser_set_rgba(GTK_COLOR_CHOOSER(l_dialog), &l_color);

    gtk_window_set_modal((GtkWindow*)l_dialog, 1);
    l_exit= gtk_dialog_run(GTK_DIALOG(l_dialog));

    if (GTK_RESPONSE_OK != l_exit)
    {
      break;
    }

    gtk_color_chooser_get_rgba(GTK_COLOR_CHOOSER(l_dialog), &l_color);

    l_rgba= gdk_rgba_to_string(&l_color);
    gtk_entry_set_text((*l_fnumber).m_color_entry, l_rgba);
    g_free(l_rgba);

  }while(0);

  if (l_dialog)
  {
    gtk_widget_destroy((GtkWidget*)l_dialog);
  }
  
  return;
}

static void
item_fnumber_border_color_button_cb(
  GtkWidget *                           i_widget,
  gpointer                              i_data)
{
  GdkRGBA                               l_color;
  GtkWidget*                            l_dialog;
  int                                   l_exit;
  struct fnumber_dialog*                l_fnumber;
  gchar*                                l_rgba;
  gchar const*                          l_text;

  l_dialog= 0;
  memset(&l_color, 0, sizeof(l_color));

  do
  {

    l_fnumber= (struct fnumber_dialog*)i_data;

    l_dialog= gtk_color_chooser_dialog_new("Border Color", mainw());

    l_text= gtk_entry_get_text((*l_fnumber).m_color_entry);
    gdk_rgba_parse(&l_color, l_text);
    gtk_color_chooser_set_rgba(GTK_COLOR_CHOOSER(l_dialog), &l_color);

    gtk_window_set_modal((GtkWindow*)l_dialog, 1);
    l_exit= gtk_dialog_run(GTK_DIALOG(l_dialog));

    if (GTK_RESPONSE_OK != l_exit)
    {
      break;
    }

    gtk_color_chooser_get_rgba(GTK_COLOR_CHOOSER(l_dialog), &l_color);

    l_rgba= gdk_rgba_to_string(&l_color);
    gtk_entry_set_text((*l_fnumber).m_border_color_entry, l_rgba);
    g_free(l_rgba);

  }while(0);

  if (l_dialog)
  {
    gtk_widget_destroy((GtkWidget*)l_dialog);
  }
  
  return;
}

static void
item_fnumber_fill_color_button_cb(
  GtkWidget *                           i_widget,
  gpointer                              i_data)
{
  GdkRGBA                               l_color;
  GtkWidget*                            l_dialog;
  int                                   l_exit;
  struct fnumber_dialog*                l_fnumber;
  gchar*                                l_rgba;
  gchar const*                          l_text;

  l_dialog= 0;
  memset(&l_color, 0, sizeof(l_color));

  do
  {

    l_fnumber= (struct fnumber_dialog*)i_data;

    l_dialog= gtk_color_chooser_dialog_new("Border Color", mainw());

    l_text= gtk_entry_get_text((*l_fnumber).m_color_entry);
    gdk_rgba_parse(&l_color, l_text);
    gtk_color_chooser_set_rgba(GTK_COLOR_CHOOSER(l_dialog), &l_color);

    gtk_window_set_modal((GtkWindow*)l_dialog, 1);
    l_exit= gtk_dialog_run(GTK_DIALOG(l_dialog));

    if (GTK_RESPONSE_OK != l_exit)
    {
      break;
    }

    gtk_color_chooser_get_rgba(GTK_COLOR_CHOOSER(l_dialog), &l_color);

    l_rgba= gdk_rgba_to_string(&l_color);
    gtk_entry_set_text((*l_fnumber).m_fill_color_entry, l_rgba);
    g_free(l_rgba);

  }while(0);

  if (l_dialog)
  {
    gtk_widget_destroy((GtkWidget*)l_dialog);
  }
  
  return;
}

static void
item_fnumber_font_button_cb(
  GtkWidget *                           i_widget,
  gpointer                              i_data)
{
  GtkWidget*                            l_dialog;
  int                                   l_exit;
  struct fnumber_dialog*                l_fnumber;
  gchar*                                l_font;
  gchar const*                          l_text;

  l_dialog= 0;
  l_exit= 0;
  l_font= 0;

  do
  {

    l_fnumber= (struct fnumber_dialog*)i_data;

    l_text= gtk_entry_get_text(GTK_ENTRY((*l_fnumber).m_font_entry));

    l_dialog= gtk_font_chooser_dialog_new("Font", mainw());

    gtk_font_chooser_set_font(GTK_FONT_CHOOSER(l_dialog), l_text);

    gtk_window_set_modal((GtkWindow*)l_dialog, 1);
    l_exit= gtk_dialog_run(GTK_DIALOG(l_dialog));

    if (GTK_RESPONSE_OK != l_exit)
    {
      break;
    }

    l_font= gtk_font_chooser_get_font(GTK_FONT_CHOOSER(l_dialog));
    gtk_entry_set_text(
      (GTK_ENTRY((*l_fnumber).m_font_entry)),
      l_font);

  }while(0);

  if (l_font)
  {
    g_free(l_font);
  }

  if (l_dialog)
  {
    gtk_widget_destroy((GtkWidget*)l_dialog);
  }

  return;
}

static void
item_fnumber_bind(
  struct fnumber_dialog*const           o_fnumber,
  GtkBuilder*const                      i_builder)
{

  memset(o_fnumber, 0, sizeof(*o_fnumber));

  do
  {

    (*o_fnumber).m_color_entry=
      GTK_ENTRY(gtk_builder_get_object(i_builder, "color_entry"));

    (*o_fnumber).m_color_button=
      GTK_BUTTON(gtk_builder_get_object(i_builder, "color_button"));

    g_signal_connect(
      (*o_fnumber).m_color_button,
      "clicked",
      G_CALLBACK(item_fnumber_color_button_cb),
      o_fnumber);

    (*o_fnumber).m_font_entry=
      GTK_ENTRY(gtk_builder_get_object(i_builder, "font_entry"));

    (*o_fnumber).m_font_button=
      GTK_BUTTON(gtk_builder_get_object(i_builder, "font_button"));

    g_signal_connect(
      (*o_fnumber).m_font_button,
      "clicked",
      G_CALLBACK(item_fnumber_font_button_cb),
      o_fnumber);

    (*o_fnumber).m_border_checkbutton=
      GTK_CHECK_BUTTON(gtk_builder_get_object(i_builder, "border_checkbutton"));

    (*o_fnumber).m_border_style_comboboxtext=
      GTK_COMBO_BOX_TEXT(gtk_builder_get_object(i_builder, "border_style_comboboxtext"));

    (*o_fnumber).m_border_thickness_spinbutton=
      GTK_SPIN_BUTTON(gtk_builder_get_object(i_builder, "border_thickness_spinbutton"));

    (*o_fnumber).m_border_color_entry=
      GTK_ENTRY(gtk_builder_get_object(i_builder, "border_color_entry"));

    (*o_fnumber).m_border_color_button=
      GTK_BUTTON(gtk_builder_get_object(i_builder, "border_color_button"));

    g_signal_connect(
      (*o_fnumber).m_border_color_button,
      "clicked",
      G_CALLBACK(item_fnumber_border_color_button_cb),
      o_fnumber);

    (*o_fnumber).m_fill_color_checkbutton=
      GTK_CHECK_BUTTON(gtk_builder_get_object(i_builder, "fill_color_checkbutton"));

    (*o_fnumber).m_fill_color_button=
      GTK_BUTTON(gtk_builder_get_object(i_builder, "fill_color_button"));

    g_signal_connect(
      (*o_fnumber).m_fill_color_button,
      "clicked",
      G_CALLBACK(item_fnumber_fill_color_button_cb),
      o_fnumber);

    (*o_fnumber).m_fill_color_entry=
      GTK_ENTRY(gtk_builder_get_object(i_builder, "fill_color_entry"));

    (*o_fnumber).m_type_comboboxtext=
      GTK_COMBO_BOX_TEXT(gtk_builder_get_object(i_builder, "type_comboboxtext"));

    (*o_fnumber).m_pattern_entry=
      GTK_ENTRY(gtk_builder_get_object(i_builder, "pattern_entry"));

    (*o_fnumber).m_locale_entry=                       
      GTK_ENTRY(gtk_builder_get_object(i_builder, "locale_entry"));

    (*o_fnumber).m_field_entry=
      GTK_ENTRY(gtk_builder_get_object(i_builder, "field_entry"));

    (*o_fnumber).m_field_button=
      GTK_BUTTON(gtk_builder_get_object(i_builder, "field_button"));

    g_signal_connect(
      (*o_fnumber).m_field_button,
      "clicked",
      G_CALLBACK(item_fnumber_field_button_cb),
      o_fnumber);

  }while(0);

  return;
}

static void
item_fnumber_set_values(
  struct fnumber_dialog*const           i_fnumberd,
  struct item_fnumber const*const       i_fnumber)
{
  gchar*                                l_color;
  gchar*                                l_font;

  l_color= gdk_rgba_to_string(&(*i_fnumber).m_color);
  gtk_entry_set_text((*i_fnumberd).m_color_entry, l_color);
  g_free(l_color);
  l_color= 0;

  l_font= pango_font_description_to_string((*i_fnumber).m_font);
  gtk_entry_set_text((*i_fnumberd).m_font_entry, l_font);
  g_free(l_font);

  gtk_toggle_button_set_active(
    GTK_TOGGLE_BUTTON((*i_fnumberd).m_border_checkbutton),
    (*i_fnumber).m_border);

  gtk_combo_box_set_active(
      GTK_COMBO_BOX((*i_fnumberd).m_border_style_comboboxtext), 
      (*i_fnumber).m_border_style);

  gtk_spin_button_set_value(
    GTK_SPIN_BUTTON((*i_fnumberd).m_border_thickness_spinbutton),
    (*i_fnumber).m_border_thickness);

  l_color= gdk_rgba_to_string(&(*i_fnumber).m_border_color);
  gtk_entry_set_text((*i_fnumberd).m_border_color_entry, l_color);
  g_free(l_color);
  l_color= 0;

  gtk_toggle_button_set_active(
    GTK_TOGGLE_BUTTON((*i_fnumberd).m_fill_color_checkbutton),
    (*i_fnumber).m_fill);

  l_color= gdk_rgba_to_string(&(*i_fnumber).m_fill_color);
  gtk_entry_set_text((*i_fnumberd).m_fill_color_entry, l_color);
  g_free(l_color);
  l_color= 0;

  gtk_combo_box_set_active(
      GTK_COMBO_BOX((*i_fnumberd).m_type_comboboxtext),
      (*i_fnumber).m_type);

  if ((*i_fnumber).m_pattern)
  {
    gtk_entry_set_text((*i_fnumberd).m_pattern_entry, (*i_fnumber).m_pattern);
  }

  if ((*i_fnumber).m_locale)
  {
    gtk_entry_set_text((*i_fnumberd).m_locale_entry, (*i_fnumber).m_locale);
  }


  gtk_entry_set_text((*i_fnumberd).m_field_entry, (*i_fnumber).m_tag);

  return;
}

static void
item_fnumber_copy_values(
  struct item_fnumber *const            io_fnumber,
  struct fnumber_dialog const*const     i_fnumberd)
{
  gchar const*                          l_text;
  gint                                  l_rc;

  l_text= gtk_entry_get_text(GTK_ENTRY((*i_fnumberd).m_color_entry));
  gdk_rgba_parse(&(*io_fnumber).m_color, l_text);

  l_text= gtk_entry_get_text(GTK_ENTRY((*i_fnumberd).m_font_entry));
  if ((*io_fnumber).m_font)
  {
    pango_font_description_free((*io_fnumber).m_font);
  }
  (*io_fnumber).m_font= pango_font_description_from_string(l_text);

  (*io_fnumber).m_border=
    gtk_toggle_button_get_active(
      GTK_TOGGLE_BUTTON((*i_fnumberd).m_border_checkbutton));

  l_rc = gtk_combo_box_get_active(
    GTK_COMBO_BOX((*i_fnumberd).m_border_style_comboboxtext));

  if ((0 <= l_rc) && (LINE_STYLE_SLOTS > l_rc))
  {
    (*io_fnumber).m_border_style= (enum line_style_type)l_rc;
  }
  else
  {
    (*io_fnumber).m_border_style= line_style_solid;
  }

  (*io_fnumber).m_border_thickness= gtk_spin_button_get_value_as_int(
    GTK_SPIN_BUTTON((*i_fnumberd).m_border_thickness_spinbutton));

  l_text= gtk_entry_get_text(GTK_ENTRY((*i_fnumberd).m_border_color_entry));
  gdk_rgba_parse(&(*io_fnumber).m_border_color, l_text);

  (*io_fnumber).m_fill=
    gtk_toggle_button_get_active(
      GTK_TOGGLE_BUTTON((*i_fnumberd).m_fill_color_checkbutton));

  l_text= gtk_entry_get_text(GTK_ENTRY((*i_fnumberd).m_fill_color_entry));
  gdk_rgba_parse(&(*io_fnumber).m_fill_color, l_text);

  l_rc = gtk_combo_box_get_active(
    GTK_COMBO_BOX((*i_fnumberd).m_type_comboboxtext));

  switch((enum number_type)l_rc)
  {
    case number_integer:
      (*io_fnumber).m_type= number_integer;
      break;
    case number_monetary:
      (*io_fnumber).m_type= number_monetary;
      break;
    default:
      (*io_fnumber).m_type= number_float;
      break;
  }

  if ((*io_fnumber).m_pattern)
  {
    g_free((*io_fnumber).m_pattern);
  }

  l_text= gtk_entry_get_text(GTK_ENTRY((*i_fnumberd).m_pattern_entry));
  (*io_fnumber).m_pattern= g_strdup(l_text);

  if ((*io_fnumber).m_locale)
  {
    g_free((*io_fnumber).m_locale);
  }

  l_text= gtk_entry_get_text(GTK_ENTRY((*i_fnumberd).m_locale_entry));
  (*io_fnumber).m_locale= g_strdup(l_text);

  l_text= gtk_entry_get_text(GTK_ENTRY((*i_fnumberd).m_field_entry));
  memset((*io_fnumber).m_tag, 0, sizeof((*io_fnumber).m_tag));
  strncpy((*io_fnumber).m_tag, l_text, sizeof((*io_fnumber).m_tag)-1);
  g_strstrip((*io_fnumber).m_tag);

  return;
}

extern int
item_fnumber_property(
  struct item_fnumber*const             io_fnumber)
{
  GtkBox*                               l_box;
  GtkBuilder*                           l_builder;
  GtkDialog*                            l_dialog;
  GtkGrid*                              l_grid;
  GError*                               l_error;
  int                                   l_exit;
  struct fnumber_dialog                 l_fnumber;
  int                                   l_rc;

  l_builder= 0;
  l_grid= 0;
  l_dialog= 0;
  l_error= 0;
  l_exit= 0;

  do
  {

    l_builder= gtk_builder_new();

    l_rc= wrap_gtk_builder_add_from_file(l_builder, "fnumber.glade", &l_error);

    if (0 == l_rc)
    {
      l_exit= -1;
      break;
    }
  
    l_grid= GTK_GRID(gtk_builder_get_object(l_builder, "fnumber_grid"));

    if (0 == l_grid)
    {
      l_error= g_error_new(
        GENERAL,
        GENERIC,
        "Unable to find dialog object: 'fnumber_grid'");
      l_exit= -1;
      break;
    }

    item_fnumber_bind(&l_fnumber, l_builder);

    item_fnumber_set_values(&l_fnumber, io_fnumber);

    l_dialog= GTK_DIALOG(gtk_dialog_new_with_buttons(
      "Field Edit",
      mainw(),
      GTK_DIALOG_MODAL,
      "Ok",
      GTK_RESPONSE_OK,
      "Cancel",
      GTK_RESPONSE_CANCEL,
      NULL));

    l_box= GTK_BOX(gtk_dialog_get_content_area(GTK_DIALOG(l_dialog)));

    gtk_box_pack_start(GTK_BOX(l_box), GTK_WIDGET(l_grid), 1, 1,0);

    gtk_widget_show(GTK_WIDGET(l_grid));

    gtk_widget_show_all(GTK_WIDGET(l_dialog));
    gtk_window_set_modal(GTK_WINDOW(l_dialog), 1);
    l_exit= gtk_dialog_run(l_dialog);

    if (GTK_RESPONSE_OK != l_exit)
    {
      break;
    }

    item_fnumber_copy_values(io_fnumber, &l_fnumber);

  }while(0);

  if (l_builder)
  {
    g_object_unref(l_builder);
  }

  if (l_error)
  {
    _error_log(l_error);
    _error_display_prompt(l_error);
  }

  g_clear_error(&l_error);

  if (l_grid)
  {
    gtk_widget_destroy((GtkWidget*)l_dialog);
  }

  return l_exit;
}

