/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015-2016, iwrite authors
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef __item_fnumber_h__

#include "item_common.h"
#include "item_method.h"

struct item_fnumber
{
  double                                m_pos_x;
  double                                m_pos_y;
  double                                m_len_x;
  double                                m_len_y;
  PangoFontDescription*                 m_font; 
  GdkRGBA                               m_color;
  int                                   m_border;
  enum line_style_type                  m_border_style;
  double                                m_border_thickness;
  GdkRGBA                               m_border_color;
  int                                   m_fill;
  GdkRGBA                               m_fill_color;
  enum number_type                      m_type;
  char*                                 m_pattern;
  char*                                 m_locale;
  char                                  m_tag[1+FIELD_NAME_MAX_LEN];
  char*                                 m_value;
};

extern void
item_fnumber_assign(
  struct item_fnumber*const             o_fnumber,
  struct item_method*const              o_method);

extern void
item_fnumber_extent_update(
  struct item_fnumber*const             io_fnumber);

extern void
item_fnumber_discharge(
  struct item_fnumber*const             io_fnumber);

extern void
item_fnumber_get_bbox(
  struct geom_rect*const                o_bbox,
  int*const                             o_overlay,
  void const*const                      i_object);

extern void
item_fnumber_in_event(
  enum event_type*const                 o_type,
  struct item_fnumber const*const       i_fnumber,
  struct item_in_event const*const      i_ctx);

extern void
item_fnumber_draw(
  struct item_fnumber*const             io_fnumber,
  struct item_draw_context const*const  i_ctx);

extern void
item_fnumber_move(
  struct item_fnumber*const             io_fnumber,
  struct geom_point const*const         i_event);

extern void
item_fnumber_normalize(
  struct item_fnumber*const             io_fnumber,
  double const                          i_bound_width,
  double const                          i_bound_height);

extern int
item_fnumber_property(
  struct item_fnumber*const             io_fnumber);

extern int
item_fnumber_read(
  GError**                              o_error,
  struct item_fnumber*const             io_fnumber,
  struct bson_node *const               i_element);

extern void
item_fnumber_resize(
  struct item_fnumber*const             io_fnumber,
  struct item_resize_event const*const  i_ctx);

extern int
item_fnumber_write(
  GError**                              o_error,
  FILE*const                            io_fp,
  struct item_fnumber const*const       io_fnumber);

#define __item_fnumber_h__
#endif
