/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015-2016, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "item_fimage.h"

extern void
item_fimage_assign(
  struct item_fimage*const              o_fimage,
  struct item_method*const              o_method)
{

  memset(o_fimage, 0, sizeof(*o_fimage));

  (*o_fimage).m_len_x= 30.0;
  (*o_fimage).m_len_y= 30.0;
  (*o_fimage).m_border_thickness= 1.0;

  ITEM_METHOD_ASSIGN(o_method, fimage);

  return;
}

extern void
item_fimage_destroy(
  struct item_fimage*const              io_fimage)
{

  if ((*io_fimage).m_value)
  {
    g_free((*io_fimage).m_value);
  }

  return;
}

extern void
item_fimage_discharge(
  struct item_fimage*const              io_fimage)
{

  item_fimage_destroy(io_fimage);
  memset(io_fimage, 0, sizeof(*io_fimage));

  return;
}

extern void
item_fimage_draw(
  struct item_fimage*const              i_fimage,
  struct item_draw_context const*const  i_ctx)
{
  int                                   l_exit;
  GdkPixbuf *                           l_pixbuf;

  l_pixbuf= 0;

  do
  {

    if ((*i_fimage).m_border)
    {
      item_common_cairo_dash_set((*i_ctx).m_cr, (*i_fimage).m_border_style);
      cairo_set_line_width((*i_ctx).m_cr, (*i_fimage).m_border_thickness);
      cairo_set_source_rgb(
        (*i_ctx).m_cr,
        (*i_fimage).m_border_color.red,
        (*i_fimage).m_border_color.green,
        (*i_fimage).m_border_color.blue);
      cairo_rectangle(
        (*i_ctx).m_cr,
        (*i_fimage).m_pos_x,
        (*i_fimage).m_pos_y,
        (*i_fimage).m_len_x,
        (*i_fimage).m_len_y);
      cairo_stroke((*i_ctx).m_cr);
    }
    else if (item_draw_design == (*i_ctx).m_option.m_type)
    {
      item_common_cairo_dash_set((*i_ctx).m_cr, line_style_dash);
      cairo_set_line_width((*i_ctx).m_cr, 1);
      cairo_set_source_rgb((*i_ctx).m_cr, 0.0, 0.0, 0.0);
      cairo_rectangle(
        (*i_ctx).m_cr,
        (*i_fimage).m_pos_x,
        (*i_fimage).m_pos_y,
        (*i_fimage).m_len_x,
        (*i_fimage).m_len_y);
      cairo_stroke((*i_ctx).m_cr);
    }

    if ((*i_fimage).m_value && (*i_fimage).m_value_size)
    {
      l_exit= pixbuf_new_from_blob(
        0,
        &l_pixbuf,
        (*i_fimage).m_value,
        (*i_fimage).m_value_size);

      if (l_exit || 0 == l_pixbuf)
      {
        break;
      }

      gdk_cairo_set_source_pixbuf(
        (*i_ctx).m_cr, 
        l_pixbuf,
        (*i_fimage).m_pos_x,
        (*i_fimage).m_pos_y);

      cairo_paint((*i_ctx).m_cr);
    }

    if (0 == (*i_ctx).m_selected)
    {
      if ((*i_ctx).m_option.m_highlight &&
        (item_draw_design == (*i_ctx).m_option.m_type))
      {
        item_common_box_draw_hightlight(
          (*i_ctx).m_cr, 
          (struct geom_rect*)i_fimage,
          (*i_fimage).m_border_thickness);
      }
      break;
    }

    item_common_box_draw_grips((*i_ctx).m_cr, (struct geom_rect*)i_fimage);

  }while(0);

  if (l_pixbuf)
  {
    g_object_unref(l_pixbuf);
  }

  return;
}

extern void
item_fimage_get_bbox(
  struct geom_rect*const                o_bbox,
  int*const                             o_overlay,
  void const*const                      i_object)
{
  struct item_fimage const*             l_image;
  l_image= (struct item_fimage*)i_object;
  (*o_bbox)= *(struct geom_rect*)i_object;
  (*o_overlay)= (*l_image).m_overlay;
  return;
}

extern void
item_fimage_in_event(
  enum event_type*const                 o_type,
  struct item_fimage const*const        i_fimage,
  struct item_in_event const*const i_ctx)
{

  item_common_box_in_event(o_type, i_ctx, (struct geom_rect*)i_fimage);

  return;
}

extern void
item_fimage_move(
  struct item_fimage*const              io_fimage,
  struct geom_point const*const         i_event)
{
  item_common_box_move((struct geom_rect*)io_fimage, i_event);
  return;
}

extern void
item_fimage_normalize(
  struct item_fimage*const              io_fimage,
  double const                          i_bound_width,
  double const                          i_bound_height)
{
  item_common_box_normalize(
    (struct geom_rect*)io_fimage, 
    i_bound_width,
    i_bound_height);
  return;
}

extern int
item_fimage_read(
  GError**                              o_error,
  struct item_fimage*const              io_fimage,
  struct bson_node *const               i_element)
{
  struct bson_node *                    l_element;
  int                                   l_found;
  enum element_tag_type                 l_type;

  l_element= i_element;

  do
  {

    if (0 == l_element)
    {
      break;
    }

    if (bson_type_end == (*l_element).m_type)
    {
      break;
    }

    item_common_lookup(&l_found, &l_type, (*l_element).m_ename);

    if (l_found)
    {
        switch(l_type)
        {
          case element_tag_border:
            if (bson_type_int32 == (*l_element).m_type)
            {
              (*io_fimage).m_border= (*l_element).m_object.m_int32;
            }
            break;
          case element_tag_border_color_blue:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_fimage).m_border_color.blue= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_border_color_green:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_fimage).m_border_color.green= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_border_color_red:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_fimage).m_border_color.red= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_border_style:
            if (bson_type_int32 == (*l_element).m_type)
            {
              (*io_fimage).m_border_style= (*l_element).m_object.m_int32;
            }
            break;
          case element_tag_border_thickness:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_fimage).m_border_thickness= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_len_x:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_fimage).m_len_x= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_len_y:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_fimage).m_len_y= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_pos_x:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_fimage).m_pos_x= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_pos_y:
            if (bson_type_float == (*l_element).m_type)
            {
              (*io_fimage).m_pos_y= (*l_element).m_object.m_float;
            }
            break;
          case element_tag_overlay:
            if (bson_type_int32 == (*l_element).m_type)
            {
              (*io_fimage).m_overlay= (*l_element).m_object.m_int32;
            }
            break; 
          case element_tag_name:
            if (bson_type_string == (*l_element).m_type)
            {
              strncpy(
                (*io_fimage).m_tag, 
                (*l_element).m_object.m_string.m_text, 
                sizeof((*io_fimage).m_tag));
            }
            break;
          default:
            break;
        }
    }

    l_element= (*l_element).m_next;

  }while(1);

  return 0;
}

extern void
item_fimage_resize(
  struct item_fimage*const              io_fimage,
  struct item_resize_event const*const  i_ctx)
{

  item_common_box_resize((struct geom_rect *)io_fimage, i_ctx);

  return;
}

extern int
item_fimage_write(
  GError**                              o_error,
  FILE*const                            io_fp,
  struct item_fimage const*const        i_fimage)
{
  int                                   l_exit;
  int32_t                               l_int32;
  char                                  l_octet;
  int32_t                               l_offset;
  int32_t                               l_size;

  l_exit= 0;

  /* array */
  l_octet= bson_type_array;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "fimage%c",0);

  /* document */
  l_offset= ftell(io_fp);
  l_size= 0;
  fwrite(&l_size, sizeof(int32_t), 1, io_fp); 

  /* pos_x */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "pos_x%c",0);
  fwrite(&(*i_fimage).m_pos_x, sizeof(double), 1, io_fp);

  /* pos_y */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "pos_y%c",0);
  fwrite(&(*i_fimage).m_pos_y, sizeof(double), 1, io_fp);

  /* len_x */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "len_x%c",0);
  fwrite(&(*i_fimage).m_len_x, sizeof(double), 1, io_fp);

  /* len_y */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "len_y%c",0);
  fwrite(&(*i_fimage).m_len_y, sizeof(double), 1, io_fp);

  /* border */
  l_octet= bson_type_int32;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "border%c",0);
  fwrite(&(*i_fimage).m_border, sizeof(int32_t), 1, io_fp);

  /* border_style */
  l_octet= bson_type_int32;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "border_style%c",0);
  fwrite(&(*i_fimage).m_border_style, sizeof(int32_t), 1, io_fp);

  /* border_thickness */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "border_thickness%c",0);
  fwrite(&(*i_fimage).m_border_thickness, sizeof(double), 1, io_fp);

  /* border_color - red */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "border_color_red%c",0);
  fwrite(&(*i_fimage).m_border_color.red, sizeof(double), 1, io_fp);

  /* border_color - green */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "border_color_green%c",0);
  fwrite(&(*i_fimage).m_border_color.green, sizeof(double), 1, io_fp);

  /* border_color - blue */
  l_octet= bson_type_float;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "border_color_blue%c",0);
  fwrite(&(*i_fimage).m_border_color.blue, sizeof(double), 1, io_fp);

  /* overlay */
  l_octet= bson_type_int32;
  fwrite(&l_octet, 1, 1, io_fp); 
  fprintf(io_fp, "overlay%c",0);
  fwrite(&(*i_fimage).m_overlay, sizeof(int32_t), 1, io_fp);

  /* tag */
  if ((*i_fimage).m_tag[0])
  {
    l_octet= bson_type_string;
    fwrite(&l_octet, 1, 1, io_fp); 
    fprintf(io_fp, "name%c",0);
    l_int32= 1+strlen((*i_fimage).m_tag);
    fwrite(&l_int32, sizeof(int32_t), 1, io_fp); 
    fwrite((*i_fimage).m_tag, 1, l_int32, io_fp);
  }

  /* end of document */
  l_octet= 0;
  fwrite(&l_octet, 1, 1, io_fp); 

  /* document */
  l_int32= ftell(io_fp);
  l_size= (l_int32 - l_offset);
  fseek(io_fp, l_offset, SEEK_SET);
  fwrite(&l_size, sizeof(l_size), 1, io_fp); 

  fseek(io_fp, 0, SEEK_END);

  return l_exit;
}
