/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler 
*/
/*
Copyright (c) 2015-2016, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "item_fbarcode.h"
#include "database_field.h"
#include "mainw.h"

struct fbarcode_dialog
{
  GtkComboBoxText*                      m_symbology_comboboxtext;
  GtkSpinButton*                        m_scale_spinbutton;
  GtkEntry*                             m_field_entry;
  GtkButton*                            m_field_button;
};

static void
item_fbarcode_field_button_cb(
  GtkWidget *                           i_widget,
  gpointer                              i_data)
{
  struct fbarcode_dialog*               l_dlg;
  char*                                 l_attribute;

  l_attribute= 0;

  l_dlg= (struct fbarcode_dialog*)i_data;

  database_field_property(
    &l_attribute, 
    &(*g_mainw).m_report.m_aspect,
    &(*g_mainw).m_report.m_query);

  if (l_attribute)
  {
    gtk_entry_set_text((*l_dlg).m_field_entry, l_attribute);
  }

  if (l_attribute)
  {
    g_free(l_attribute);
  }

  return;
}

static void
item_fbarcode_bind(
  struct fbarcode_dialog*const          o_dlg,
  GtkBuilder*const                      i_builder)
{
  unsigned                              l_slot;

  memset(o_dlg, 0, sizeof(*o_dlg));

  do
  {

    (*o_dlg).m_symbology_comboboxtext=
      GTK_COMBO_BOX_TEXT(gtk_builder_get_object(i_builder, "symbology_comboboxtext"));

    (*o_dlg).m_scale_spinbutton=
      GTK_SPIN_BUTTON(gtk_builder_get_object(i_builder, "scale_spinbutton"));

    (*o_dlg).m_field_entry=
      GTK_ENTRY(gtk_builder_get_object(i_builder, "field_entry"));

    (*o_dlg).m_field_button=
      GTK_BUTTON(gtk_builder_get_object(i_builder, "field_button"));

    g_signal_connect(
      (*o_dlg).m_field_button,
      "clicked",
      G_CALLBACK(item_fbarcode_field_button_cb),
      o_dlg);

    l_slot= 0;

    do
    {

      if (0 == g_symtab[l_slot].m_name)
      {
        break;
      }

      gtk_combo_box_text_append_text(
        (*o_dlg).m_symbology_comboboxtext,
        g_symtab[l_slot].m_name);

      l_slot++;

    }while(1);

  }while(0);

  return;
}

static void
item_fbarcode_set_values(
  struct fbarcode_dialog*const            io_dlg,
  struct item_fbarcode const*const        i_bc)
{
  int                                     l_index;

  l_index= symbology_lookup_by_type((*i_bc).m_barcode);

  if (-1 != l_index)
  {
    gtk_combo_box_set_active(GTK_COMBO_BOX((*io_dlg).m_symbology_comboboxtext), l_index);
  }

  gtk_spin_button_set_value((*io_dlg).m_scale_spinbutton, (*i_bc).m_scale);

  gtk_entry_set_text((*io_dlg).m_field_entry, (*i_bc).m_tag);

  return;
}

static void
item_fbarcode_copy_values(
  struct item_fbarcode *const              io_bc,
  struct fbarcode_dialog const*const       i_dlg)
{
  gchar const*                          l_text;
  gint                                  l_rc;

  l_rc= gtk_combo_box_get_active(
    GTK_COMBO_BOX((*i_dlg).m_symbology_comboboxtext));
  
  if (0 <= l_rc)
  {
    (*io_bc).m_barcode= g_symtab[l_rc].m_type;
  }
  else
  {
    (*io_bc).m_barcode= BARCODE_UNKOWN;
  }

  (*io_bc).m_scale= gtk_spin_button_get_value(
    GTK_SPIN_BUTTON((*i_dlg).m_scale_spinbutton));

  if (0.50 > (*io_bc).m_scale)
  {
    (*io_bc).m_scale= 0.50;
  }

  l_text= gtk_entry_get_text(GTK_ENTRY((*i_dlg).m_field_entry));
  memset((*io_bc).m_tag, 0, sizeof((*io_bc).m_tag));
  strncpy((*io_bc).m_tag, l_text, sizeof((*io_bc).m_tag)-1);
  g_strstrip((*io_bc).m_tag);

  return;
}

extern int
item_fbarcode_property(
  struct item_fbarcode*const            io_fbarcode)
{
  GtkBox*                               l_box;
  GtkBuilder*                           l_builder;
  GtkDialog*                            l_dialog;
  GtkGrid*                              l_grid;
  GError*                               l_error;
  int                                   l_exit;
  struct fbarcode_dialog                l_fbarcode;
  int                                   l_rc;

  l_builder= 0;
  l_grid= 0;
  l_dialog= 0;
  l_error= 0;
  l_exit= 0;

  do
  {

    l_builder= gtk_builder_new();

    l_rc= wrap_gtk_builder_add_from_file(l_builder, "fbarcode.glade", &l_error);

    if (0 == l_rc)
    {
      l_exit= -1;
      break;
    }
  
    l_grid= GTK_GRID(gtk_builder_get_object(l_builder, "fbarcode_grid"));

    if (0 == l_grid)
    {
      l_error= g_error_new(
        GENERAL,
        GENERIC,
        "Unable to find dialog object: 'fbarcode_grid'");
      l_exit= -1;
      break;
    }

    item_fbarcode_bind(&l_fbarcode, l_builder);

    item_fbarcode_set_values(&l_fbarcode, io_fbarcode);

    l_dialog= GTK_DIALOG(gtk_dialog_new_with_buttons(
      "Barcode Edit",
      mainw(),
      GTK_DIALOG_MODAL,
      "Ok",
      GTK_RESPONSE_OK,
      "Cancel",
      GTK_RESPONSE_CANCEL,
      NULL));

    l_box= GTK_BOX(gtk_dialog_get_content_area(GTK_DIALOG(l_dialog)));

    gtk_box_pack_start(GTK_BOX(l_box), GTK_WIDGET(l_grid), 1, 1,0);

    gtk_widget_show(GTK_WIDGET(l_grid));

    gtk_widget_show_all(GTK_WIDGET(l_dialog));
    gtk_window_set_modal(GTK_WINDOW(l_dialog), 1);
    l_exit= gtk_dialog_run(l_dialog);

    if (GTK_RESPONSE_OK != l_exit)
    {
      break;
    }

    item_fbarcode_copy_values(io_fbarcode, &l_fbarcode);

  }while(0);

  if (l_builder)
  {
    g_object_unref(l_builder);
  }

  if (l_error)
  {
    _error_log(l_error);
    _error_display_prompt(l_error);
  }

  g_clear_error(&l_error);

  if (l_grid)
  {
    gtk_widget_destroy((GtkWidget*)l_dialog);
  }

  return l_exit;
}

