/* 
vim:expandtab:softtabstop=2:tabstop=2:shiftwidth=2:nowrap:ruler
*/
/*
Copyright (c) 2015, iwrite authors 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "item_common_rectvect.h"

extern void
item_common_rectvect_draw_grips(
  cairo_t *const                        io_cr,
  rectvect_t const                      i_rect)
{
  double                                l_mid_x;
  double                                l_mid_y;

  item_common_cairo_dash_set(io_cr, line_style_solid);
  cairo_set_line_width(io_cr, 1.0);
  cairo_set_source_rgb(io_cr, 0.0, 1.0, 0.0);

  /* top left */
  cairo_rectangle(
    io_cr,
    i_rect[top_left_x]-4.0,
    i_rect[top_left_y]-4.0,
    8.0,
    8.0);
  cairo_fill(io_cr);

  /* top middle */
  l_mid_x= i_rect[top_right_x] + i_rect[top_left_x];
  l_mid_x/= 2.0;
  l_mid_y= i_rect[top_right_y] + i_rect[top_left_y]; 
  l_mid_y/= 2.0;
    
  cairo_rectangle(
    io_cr,
    l_mid_x-4.0,
    l_mid_y-4.0,
    8.0,
    8.0);
  cairo_fill(io_cr);

  /* top right */
  cairo_rectangle(
    io_cr,
    i_rect[top_right_x]-4.0,
    i_rect[top_right_y]-4.0,
    8.0,
    8.0);
  cairo_fill(io_cr);

  /* right middle */
  l_mid_x= i_rect[top_right_x] + i_rect[bottom_right_x];
  l_mid_x/= 2.0;
  l_mid_y= i_rect[bottom_right_y] + i_rect[top_right_y]; 
  l_mid_y/= 2.0;
    
  cairo_rectangle(
    io_cr,
    l_mid_x-4.0,
    l_mid_y-4.0,
    8.0,
    8.0);
  cairo_fill(io_cr);

  /* bottom right */
  cairo_rectangle(
    io_cr,
    i_rect[bottom_right_x]-4.0,
    i_rect[bottom_right_y]-4.0,
    8.0,
    8.0);
  cairo_fill(io_cr);

  /* bottom middle */
  l_mid_x= i_rect[bottom_right_x] + i_rect[bottom_left_x];
  l_mid_x/= 2.0;
  l_mid_y= i_rect[bottom_right_y] + i_rect[bottom_left_y]; 
  l_mid_y/= 2.0;
    
  cairo_rectangle(
    io_cr,
    l_mid_x-4.0,
    l_mid_y-4.0,
    8.0,
    8.0);
  cairo_fill(io_cr);

  /* bottom left */
  cairo_rectangle(
    io_cr,
    i_rect[bottom_left_x]-4.0,
    i_rect[bottom_left_y]-4.0,
    8.0,
    8.0);
  cairo_fill(io_cr);

  /* left middle */
  l_mid_x= i_rect[bottom_left_x] + i_rect[top_left_x];
  l_mid_x/= 2.0;
  l_mid_y= i_rect[bottom_left_y] + i_rect[top_left_y]; 
  l_mid_y/= 2.0;
    
  cairo_rectangle(
    io_cr,
    l_mid_x-4.0,
    l_mid_y-4.0,
    8.0,
    8.0);
  cairo_fill(io_cr);

  return;
}

extern void
item_common_rectvect_in_event(
  enum event_type*const                 o_type,
  struct item_in_event const*const      i_ctx,
  rectvect_t const                      i_rect)
{
  struct geom_rect                      l_bbox;
  int                                   l_hit;
  double                                l_mid_x;
  double                                l_mid_y;
  rectvect_t                            l_rect;
  double                                l_rect_x[4];
  double                                l_rect_y[4];

  (*o_type)= event_none;

  do
  {

    geom_rectvect_get_bounding_box(&l_bbox, i_rect);

    l_hit= item_common_event_inside(
      i_ctx,
      l_bbox.m_pos_x - 4.0,
      l_bbox.m_pos_y - 4.0,
      l_bbox.m_len_x + 8.0,
      l_bbox.m_len_y + 8.0);
  
    if (0 == l_hit)
    {
      break;
    } 

    if ((*i_ctx).m_selected)
    {

      /* top left */
      l_hit= item_common_event_inside(
        i_ctx,
        i_rect[top_left_x]-4.0,
        i_rect[top_left_y]-4.0,
        8.0,
        8.0);

      if (l_hit)
      {
        (*o_type)= event_resize_north_west;
        break;
      }

      /* top middle */
      l_mid_x= i_rect[top_right_x] + i_rect[top_left_x];
      l_mid_x/= 2.0;
      l_mid_y= i_rect[top_right_y] + i_rect[top_left_y]; 
      l_mid_y/= 2.0;
      
      l_hit= item_common_event_inside(
        i_ctx,
        l_mid_x-4.0,
        l_mid_y-4.0,
        8.0,
        8.0);

      if (l_hit)
      {
        (*o_type)= event_resize_north;
        break;
      }

      /* top right */
      l_hit= item_common_event_inside(
        i_ctx,
        i_rect[top_right_x]-4.0,
        i_rect[top_right_y]-4.0,
        8.0,
        8.0);

      if (l_hit)
      {
        (*o_type)= event_resize_north_east;
        break;
      }

      /* right middle */
      l_mid_x= i_rect[top_right_x] + i_rect[bottom_right_x];
      l_mid_x/= 2.0;
      l_mid_y= i_rect[bottom_right_y] + i_rect[top_right_y]; 
      l_mid_y/= 2.0;
      
      l_hit= item_common_event_inside(
        i_ctx,
        l_mid_x-4.0,
        l_mid_y-4.0,
        8.0,
        8.0);

      if (l_hit)
      {
        (*o_type)= event_resize_east;
        break;
      }

      /* bottom right */
      l_hit= item_common_event_inside(
        i_ctx,
        i_rect[bottom_right_x]-4.0,
        i_rect[bottom_right_y]-4.0,
        8.0,
        8.0);

      if (l_hit)
      {
        (*o_type)= event_resize_south_east;
        break;
      }

      /* bottom middle */
      l_mid_x= i_rect[bottom_right_x] + i_rect[bottom_left_x];
      l_mid_x/= 2.0;
      l_mid_y= i_rect[bottom_right_y] + i_rect[bottom_left_y]; 
      l_mid_y/= 2.0;
      
      l_hit= item_common_event_inside(
        i_ctx,
        l_mid_x-4.0,
        l_mid_y-4.0,
        8.0,
        8.0);

      if (l_hit)
      {
        (*o_type)= event_resize_south;
        break;
      }

      /* bottom left */
      l_hit= item_common_event_inside(
        i_ctx,
        i_rect[bottom_left_x]-4.0,
        i_rect[bottom_left_y]-4.0,
        8.0,
        8.0);

      if (l_hit)
      {
        (*o_type)= event_resize_south_west;
        break;
      }

      /* left middle */
      l_mid_x= i_rect[bottom_left_x] + i_rect[top_left_x];
      l_mid_x/= 2.0;
      l_mid_y= i_rect[bottom_left_y] + i_rect[top_left_y]; 
      l_mid_y/= 2.0;
      
      l_hit= item_common_event_inside(
        i_ctx,
        l_mid_x-4.0,
        l_mid_y-4.0,
        8.0,
        8.0);

      if (l_hit)
      {
        (*o_type)= event_resize_west;
        break;
      }

    }

    geom_rectvect_copy(l_rect, i_rect);

    if ((*i_ctx).m_selected)
    {
      geom_rectvect_grow(l_rect, 4.0);
    }

    l_rect_x[0]= l_rect[top_left_x];
    l_rect_x[1]= l_rect[top_right_x];
    l_rect_x[2]= l_rect[bottom_right_x];
    l_rect_x[3]= l_rect[bottom_left_x];

    l_rect_y[0]= l_rect[top_left_y];
    l_rect_y[1]= l_rect[top_right_y];
    l_rect_y[2]= l_rect[bottom_right_y];
    l_rect_y[3]= l_rect[bottom_left_y];

    l_rect_x[0]*= (*i_ctx).m_scale;
    l_rect_x[1]*= (*i_ctx).m_scale;
    l_rect_x[2]*= (*i_ctx).m_scale;
    l_rect_x[3]*= (*i_ctx).m_scale;

    l_rect_y[0]*= (*i_ctx).m_scale;
    l_rect_y[1]*= (*i_ctx).m_scale;
    l_rect_y[2]*= (*i_ctx).m_scale;
    l_rect_y[3]*= (*i_ctx).m_scale;

    l_hit= pnpoly(4, l_rect_x, l_rect_y, (*i_ctx).m_event.m_pos_x, (*i_ctx).m_event.m_pos_y);

    if (0 == l_hit)
    {
      break;
    }

    (*o_type)= event_move;


  }while(0);

  return;
}

extern void
item_common_rectvect_move(
  rectvect_t                            io_rect,
  struct geom_point const*const         i_event)
{

  io_rect[top_left_x]+= (*i_event).m_pos_x;
  io_rect[top_left_y]+= (*i_event).m_pos_y;
  io_rect[top_right_x]+= (*i_event).m_pos_x;
  io_rect[top_right_y]+= (*i_event).m_pos_y;
  io_rect[bottom_right_x]+= (*i_event).m_pos_x;
  io_rect[bottom_right_y]+= (*i_event).m_pos_y;
  io_rect[bottom_left_x]+= (*i_event).m_pos_x;
  io_rect[bottom_left_y]+= (*i_event).m_pos_y;

  return;
}

extern void
item_common_rectvect_resize(
  rectvect_t                            io_rect,
  struct item_resize_event const*const  i_ctx,
  int const                             i_rotate_shear)
{

  switch((*i_ctx).m_type)
  {
  case event_resize_east:
    io_rect[top_right_x]+= (*i_ctx).m_event.m_pos_x;
    io_rect[bottom_right_x]+= (*i_ctx).m_event.m_pos_x;
    if (i_rotate_shear)
    {
      io_rect[top_right_y]+= (*i_ctx).m_event.m_pos_y;
      io_rect[bottom_right_y]+= (*i_ctx).m_event.m_pos_y;
    }
    break;
  case event_resize_north:
    io_rect[top_left_y]+= (*i_ctx).m_event.m_pos_y;
    io_rect[top_right_y]+= (*i_ctx).m_event.m_pos_y;
    if (i_rotate_shear)
    {
      io_rect[top_left_x]+= (*i_ctx).m_event.m_pos_x;
      io_rect[top_right_x]+= (*i_ctx).m_event.m_pos_x;
    }
    break;
  case event_resize_north_east:
    io_rect[top_left_y]+= (*i_ctx).m_event.m_pos_y;
    io_rect[top_right_y]+= (*i_ctx).m_event.m_pos_y;
    io_rect[top_right_x]+= (*i_ctx).m_event.m_pos_x;
    io_rect[bottom_right_x]+= (*i_ctx).m_event.m_pos_x;
    break;
  case event_resize_north_west:
    io_rect[top_left_y]+= (*i_ctx).m_event.m_pos_y;
    io_rect[top_right_y]+= (*i_ctx).m_event.m_pos_y;
    io_rect[top_left_x]+= (*i_ctx).m_event.m_pos_x;
    io_rect[bottom_left_x]+= (*i_ctx).m_event.m_pos_x;
    break;
  case event_resize_south:
    io_rect[bottom_left_y]+= (*i_ctx).m_event.m_pos_y;
    io_rect[bottom_right_y]+= (*i_ctx).m_event.m_pos_y;
    if (i_rotate_shear)
    {
      io_rect[bottom_left_x]+= (*i_ctx).m_event.m_pos_x;
      io_rect[bottom_right_x]+= (*i_ctx).m_event.m_pos_x;
    }
    break;
  case event_resize_south_east:
    io_rect[bottom_left_y]+= (*i_ctx).m_event.m_pos_y;
    io_rect[bottom_right_y]+= (*i_ctx).m_event.m_pos_y;
    io_rect[top_right_x]+= (*i_ctx).m_event.m_pos_x;
    io_rect[bottom_right_x]+= (*i_ctx).m_event.m_pos_x;
    break;
  case event_resize_south_west:
    io_rect[bottom_left_y]+= (*i_ctx).m_event.m_pos_y;
    io_rect[bottom_right_y]+= (*i_ctx).m_event.m_pos_y;
    io_rect[top_left_x]+= (*i_ctx).m_event.m_pos_x;
    io_rect[bottom_left_x]+= (*i_ctx).m_event.m_pos_x;
    break;
  case event_resize_west:
    io_rect[top_left_x]+= (*i_ctx).m_event.m_pos_x;
    io_rect[bottom_left_x]+= (*i_ctx).m_event.m_pos_x;
    if (i_rotate_shear)
    {
      io_rect[top_left_y]+= (*i_ctx).m_event.m_pos_y;
      io_rect[bottom_left_y]+= (*i_ctx).m_event.m_pos_y;
    }
    break;
  default:
    break;
  }

  return;
}


